/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapToRoadsRequest extends GeoRoutesRequest implements
        ToCopyableBuilder<SnapToRoadsRequest.Builder, SnapToRoadsRequest> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(SnapToRoadsRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()).build();

    private static final SdkField<String> SNAPPED_GEOMETRY_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnappedGeometryFormat").getter(getter(SnapToRoadsRequest::snappedGeometryFormatAsString))
            .setter(setter(Builder::snappedGeometryFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedGeometryFormat").build())
            .build();

    private static final SdkField<Long> SNAP_RADIUS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SnapRadius").getter(getter(SnapToRoadsRequest::snapRadius)).setter(setter(Builder::snapRadius))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapRadius").build()).build();

    private static final SdkField<List<RoadSnapTracePoint>> TRACE_POINTS_FIELD = SdkField
            .<List<RoadSnapTracePoint>> builder(MarshallingType.LIST)
            .memberName("TracePoints")
            .getter(getter(SnapToRoadsRequest::tracePoints))
            .setter(setter(Builder::tracePoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracePoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoadSnapTracePoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoadSnapTracePoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TravelMode").getter(getter(SnapToRoadsRequest::travelModeAsString)).setter(setter(Builder::travelMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()).build();

    private static final SdkField<RoadSnapTravelModeOptions> TRAVEL_MODE_OPTIONS_FIELD = SdkField
            .<RoadSnapTravelModeOptions> builder(MarshallingType.SDK_POJO).memberName("TravelModeOptions")
            .getter(getter(SnapToRoadsRequest::travelModeOptions)).setter(setter(Builder::travelModeOptions))
            .constructor(RoadSnapTravelModeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelModeOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD,
            SNAPPED_GEOMETRY_FORMAT_FIELD, SNAP_RADIUS_FIELD, TRACE_POINTS_FIELD, TRAVEL_MODE_FIELD, TRAVEL_MODE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String key;

    private final String snappedGeometryFormat;

    private final Long snapRadius;

    private final List<RoadSnapTracePoint> tracePoints;

    private final String travelMode;

    private final RoadSnapTravelModeOptions travelModeOptions;

    private SnapToRoadsRequest(BuilderImpl builder) {
        super(builder);
        this.key = builder.key;
        this.snappedGeometryFormat = builder.snappedGeometryFormat;
        this.snapRadius = builder.snapRadius;
        this.tracePoints = builder.tracePoints;
        this.travelMode = builder.travelMode;
        this.travelModeOptions = builder.travelModeOptions;
    }

    /**
     * <p>
     * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be provided
     * when making a request.
     * </p>
     * 
     * @return Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
     *         provided when making a request.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * Chooses what the returned SnappedGeometry format should be.
     * </p>
     * <p>
     * Default Value: <code>FlexiblePolyline</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snappedGeometryFormat} will return {@link GeometryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #snappedGeometryFormatAsString}.
     * </p>
     * 
     * @return Chooses what the returned SnappedGeometry format should be.</p>
     *         <p>
     *         Default Value: <code>FlexiblePolyline</code>
     * @see GeometryFormat
     */
    public final GeometryFormat snappedGeometryFormat() {
        return GeometryFormat.fromValue(snappedGeometryFormat);
    }

    /**
     * <p>
     * Chooses what the returned SnappedGeometry format should be.
     * </p>
     * <p>
     * Default Value: <code>FlexiblePolyline</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snappedGeometryFormat} will return {@link GeometryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #snappedGeometryFormatAsString}.
     * </p>
     * 
     * @return Chooses what the returned SnappedGeometry format should be.</p>
     *         <p>
     *         Default Value: <code>FlexiblePolyline</code>
     * @see GeometryFormat
     */
    public final String snappedGeometryFormatAsString() {
        return snappedGeometryFormat;
    }

    /**
     * <p>
     * The radius around the provided tracepoint that is considered for snapping.
     * </p>
     * <p>
     * <b>Unit</b>: <code>meters</code>
     * </p>
     * <p>
     * Default value: <code>300</code>
     * </p>
     * 
     * @return The radius around the provided tracepoint that is considered for snapping.</p>
     *         <p>
     *         <b>Unit</b>: <code>meters</code>
     *         </p>
     *         <p>
     *         Default value: <code>300</code>
     */
    public final Long snapRadius() {
        return snapRadius;
    }

    /**
     * For responses, this returns true if the service returned a value for the TracePoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTracePoints() {
        return tracePoints != null && !(tracePoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of trace points to be snapped onto the road network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTracePoints} method.
     * </p>
     * 
     * @return List of trace points to be snapped onto the road network.
     */
    public final List<RoadSnapTracePoint> tracePoints() {
        return tracePoints;
    }

    /**
     * <p>
     * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     * compatibility.
     * </p>
     * <p>
     * Default Value: <code>Car</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #travelMode} will
     * return {@link RoadSnapTravelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #travelModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     *         compatibility.</p>
     *         <p>
     *         Default Value: <code>Car</code>
     * @see RoadSnapTravelMode
     */
    public final RoadSnapTravelMode travelMode() {
        return RoadSnapTravelMode.fromValue(travelMode);
    }

    /**
     * <p>
     * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     * compatibility.
     * </p>
     * <p>
     * Default Value: <code>Car</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #travelMode} will
     * return {@link RoadSnapTravelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #travelModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     *         compatibility.</p>
     *         <p>
     *         Default Value: <code>Car</code>
     * @see RoadSnapTravelMode
     */
    public final String travelModeAsString() {
        return travelMode;
    }

    /**
     * <p>
     * Travel mode related options for the provided travel mode.
     * </p>
     * 
     * @return Travel mode related options for the provided travel mode.
     */
    public final RoadSnapTravelModeOptions travelModeOptions() {
        return travelModeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(snappedGeometryFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snapRadius());
        hashCode = 31 * hashCode + Objects.hashCode(hasTracePoints() ? tracePoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(travelModeOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapToRoadsRequest)) {
            return false;
        }
        SnapToRoadsRequest other = (SnapToRoadsRequest) obj;
        return Objects.equals(key(), other.key())
                && Objects.equals(snappedGeometryFormatAsString(), other.snappedGeometryFormatAsString())
                && Objects.equals(snapRadius(), other.snapRadius()) && hasTracePoints() == other.hasTracePoints()
                && Objects.equals(tracePoints(), other.tracePoints())
                && Objects.equals(travelModeAsString(), other.travelModeAsString())
                && Objects.equals(travelModeOptions(), other.travelModeOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapToRoadsRequest").add("Key", key() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SnappedGeometryFormat", snappedGeometryFormatAsString())
                .add("SnapRadius", snapRadius() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TracePoints", hasTracePoints() ? tracePoints() : null).add("TravelMode", travelModeAsString())
                .add("TravelModeOptions", travelModeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "SnappedGeometryFormat":
            return Optional.ofNullable(clazz.cast(snappedGeometryFormatAsString()));
        case "SnapRadius":
            return Optional.ofNullable(clazz.cast(snapRadius()));
        case "TracePoints":
            return Optional.ofNullable(clazz.cast(tracePoints()));
        case "TravelMode":
            return Optional.ofNullable(clazz.cast(travelModeAsString()));
        case "TravelModeOptions":
            return Optional.ofNullable(clazz.cast(travelModeOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("key", KEY_FIELD);
        map.put("SnappedGeometryFormat", SNAPPED_GEOMETRY_FORMAT_FIELD);
        map.put("SnapRadius", SNAP_RADIUS_FIELD);
        map.put("TracePoints", TRACE_POINTS_FIELD);
        map.put("TravelMode", TRAVEL_MODE_FIELD);
        map.put("TravelModeOptions", TRAVEL_MODE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapToRoadsRequest, T> g) {
        return obj -> g.apply((SnapToRoadsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GeoRoutesRequest.Builder, SdkPojo, CopyableBuilder<Builder, SnapToRoadsRequest> {
        /**
         * <p>
         * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         * provided when making a request.
         * </p>
         * 
         * @param key
         *        Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         *        provided when making a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Chooses what the returned SnappedGeometry format should be.
         * </p>
         * <p>
         * Default Value: <code>FlexiblePolyline</code>
         * </p>
         * 
         * @param snappedGeometryFormat
         *        Chooses what the returned SnappedGeometry format should be.</p>
         *        <p>
         *        Default Value: <code>FlexiblePolyline</code>
         * @see GeometryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeometryFormat
         */
        Builder snappedGeometryFormat(String snappedGeometryFormat);

        /**
         * <p>
         * Chooses what the returned SnappedGeometry format should be.
         * </p>
         * <p>
         * Default Value: <code>FlexiblePolyline</code>
         * </p>
         * 
         * @param snappedGeometryFormat
         *        Chooses what the returned SnappedGeometry format should be.</p>
         *        <p>
         *        Default Value: <code>FlexiblePolyline</code>
         * @see GeometryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeometryFormat
         */
        Builder snappedGeometryFormat(GeometryFormat snappedGeometryFormat);

        /**
         * <p>
         * The radius around the provided tracepoint that is considered for snapping.
         * </p>
         * <p>
         * <b>Unit</b>: <code>meters</code>
         * </p>
         * <p>
         * Default value: <code>300</code>
         * </p>
         * 
         * @param snapRadius
         *        The radius around the provided tracepoint that is considered for snapping.</p>
         *        <p>
         *        <b>Unit</b>: <code>meters</code>
         *        </p>
         *        <p>
         *        Default value: <code>300</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapRadius(Long snapRadius);

        /**
         * <p>
         * List of trace points to be snapped onto the road network.
         * </p>
         * 
         * @param tracePoints
         *        List of trace points to be snapped onto the road network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracePoints(Collection<RoadSnapTracePoint> tracePoints);

        /**
         * <p>
         * List of trace points to be snapped onto the road network.
         * </p>
         * 
         * @param tracePoints
         *        List of trace points to be snapped onto the road network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracePoints(RoadSnapTracePoint... tracePoints);

        /**
         * <p>
         * List of trace points to be snapped onto the road network.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RoadSnapTracePoint.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.georoutes.model.RoadSnapTracePoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RoadSnapTracePoint.Builder#build()} is called
         * immediately and its result is passed to {@link #tracePoints(List<RoadSnapTracePoint>)}.
         * 
         * @param tracePoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RoadSnapTracePoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tracePoints(java.util.Collection<RoadSnapTracePoint>)
         */
        Builder tracePoints(Consumer<RoadSnapTracePoint.Builder>... tracePoints);

        /**
         * <p>
         * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
         * compatibility.
         * </p>
         * <p>
         * Default Value: <code>Car</code>
         * </p>
         * 
         * @param travelMode
         *        Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and
         *        road compatibility.</p>
         *        <p>
         *        Default Value: <code>Car</code>
         * @see RoadSnapTravelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoadSnapTravelMode
         */
        Builder travelMode(String travelMode);

        /**
         * <p>
         * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
         * compatibility.
         * </p>
         * <p>
         * Default Value: <code>Car</code>
         * </p>
         * 
         * @param travelMode
         *        Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and
         *        road compatibility.</p>
         *        <p>
         *        Default Value: <code>Car</code>
         * @see RoadSnapTravelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoadSnapTravelMode
         */
        Builder travelMode(RoadSnapTravelMode travelMode);

        /**
         * <p>
         * Travel mode related options for the provided travel mode.
         * </p>
         * 
         * @param travelModeOptions
         *        Travel mode related options for the provided travel mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelModeOptions(RoadSnapTravelModeOptions travelModeOptions);

        /**
         * <p>
         * Travel mode related options for the provided travel mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoadSnapTravelModeOptions.Builder}
         * avoiding the need to create one manually via {@link RoadSnapTravelModeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoadSnapTravelModeOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #travelModeOptions(RoadSnapTravelModeOptions)}.
         * 
         * @param travelModeOptions
         *        a consumer that will call methods on {@link RoadSnapTravelModeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #travelModeOptions(RoadSnapTravelModeOptions)
         */
        default Builder travelModeOptions(Consumer<RoadSnapTravelModeOptions.Builder> travelModeOptions) {
            return travelModeOptions(RoadSnapTravelModeOptions.builder().applyMutation(travelModeOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GeoRoutesRequest.BuilderImpl implements Builder {
        private String key;

        private String snappedGeometryFormat;

        private Long snapRadius;

        private List<RoadSnapTracePoint> tracePoints = DefaultSdkAutoConstructList.getInstance();

        private String travelMode;

        private RoadSnapTravelModeOptions travelModeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapToRoadsRequest model) {
            super(model);
            key(model.key);
            snappedGeometryFormat(model.snappedGeometryFormat);
            snapRadius(model.snapRadius);
            tracePoints(model.tracePoints);
            travelMode(model.travelMode);
            travelModeOptions(model.travelModeOptions);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getSnappedGeometryFormat() {
            return snappedGeometryFormat;
        }

        public final void setSnappedGeometryFormat(String snappedGeometryFormat) {
            this.snappedGeometryFormat = snappedGeometryFormat;
        }

        @Override
        public final Builder snappedGeometryFormat(String snappedGeometryFormat) {
            this.snappedGeometryFormat = snappedGeometryFormat;
            return this;
        }

        @Override
        public final Builder snappedGeometryFormat(GeometryFormat snappedGeometryFormat) {
            this.snappedGeometryFormat(snappedGeometryFormat == null ? null : snappedGeometryFormat.toString());
            return this;
        }

        public final Long getSnapRadius() {
            return snapRadius;
        }

        public final void setSnapRadius(Long snapRadius) {
            this.snapRadius = snapRadius;
        }

        @Override
        public final Builder snapRadius(Long snapRadius) {
            this.snapRadius = snapRadius;
            return this;
        }

        public final List<RoadSnapTracePoint.Builder> getTracePoints() {
            List<RoadSnapTracePoint.Builder> result = SnapToRoadsRequestTracePointsListCopier.copyToBuilder(this.tracePoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTracePoints(Collection<RoadSnapTracePoint.BuilderImpl> tracePoints) {
            this.tracePoints = SnapToRoadsRequestTracePointsListCopier.copyFromBuilder(tracePoints);
        }

        @Override
        public final Builder tracePoints(Collection<RoadSnapTracePoint> tracePoints) {
            this.tracePoints = SnapToRoadsRequestTracePointsListCopier.copy(tracePoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracePoints(RoadSnapTracePoint... tracePoints) {
            tracePoints(Arrays.asList(tracePoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracePoints(Consumer<RoadSnapTracePoint.Builder>... tracePoints) {
            tracePoints(Stream.of(tracePoints).map(c -> RoadSnapTracePoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTravelMode() {
            return travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        public final Builder travelMode(RoadSnapTravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final RoadSnapTravelModeOptions.Builder getTravelModeOptions() {
            return travelModeOptions != null ? travelModeOptions.toBuilder() : null;
        }

        public final void setTravelModeOptions(RoadSnapTravelModeOptions.BuilderImpl travelModeOptions) {
            this.travelModeOptions = travelModeOptions != null ? travelModeOptions.build() : null;
        }

        @Override
        public final Builder travelModeOptions(RoadSnapTravelModeOptions travelModeOptions) {
            this.travelModeOptions = travelModeOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SnapToRoadsRequest build() {
            return new SnapToRoadsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
