/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The failed constraint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationFailedConstraint implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationFailedConstraint.Builder, WaypointOptimizationFailedConstraint> {
    private static final SdkField<String> CONSTRAINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Constraint").getter(getter(WaypointOptimizationFailedConstraint::constraintAsString))
            .setter(setter(Builder::constraint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraint").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(WaypointOptimizationFailedConstraint::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONSTRAINT_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String constraint;

    private final String reason;

    private WaypointOptimizationFailedConstraint(BuilderImpl builder) {
        this.constraint = builder.constraint;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The failed constraint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #constraint} will
     * return {@link WaypointOptimizationConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #constraintAsString}.
     * </p>
     * 
     * @return The failed constraint.
     * @see WaypointOptimizationConstraint
     */
    public final WaypointOptimizationConstraint constraint() {
        return WaypointOptimizationConstraint.fromValue(constraint);
    }

    /**
     * <p>
     * The failed constraint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #constraint} will
     * return {@link WaypointOptimizationConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #constraintAsString}.
     * </p>
     * 
     * @return The failed constraint.
     * @see WaypointOptimizationConstraint
     */
    public final String constraintAsString() {
        return constraint;
    }

    /**
     * <p>
     * Reason for the failed constraint.
     * </p>
     * 
     * @return Reason for the failed constraint.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationFailedConstraint)) {
            return false;
        }
        WaypointOptimizationFailedConstraint other = (WaypointOptimizationFailedConstraint) obj;
        return Objects.equals(constraintAsString(), other.constraintAsString()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationFailedConstraint")
                .add("Constraint", constraintAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Reason", reason() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Constraint":
            return Optional.ofNullable(clazz.cast(constraintAsString()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Constraint", CONSTRAINT_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationFailedConstraint, T> g) {
        return obj -> g.apply((WaypointOptimizationFailedConstraint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationFailedConstraint> {
        /**
         * <p>
         * The failed constraint.
         * </p>
         * 
         * @param constraint
         *        The failed constraint.
         * @see WaypointOptimizationConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaypointOptimizationConstraint
         */
        Builder constraint(String constraint);

        /**
         * <p>
         * The failed constraint.
         * </p>
         * 
         * @param constraint
         *        The failed constraint.
         * @see WaypointOptimizationConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaypointOptimizationConstraint
         */
        Builder constraint(WaypointOptimizationConstraint constraint);

        /**
         * <p>
         * Reason for the failed constraint.
         * </p>
         * 
         * @param reason
         *        Reason for the failed constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String constraint;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationFailedConstraint model) {
            constraint(model.constraint);
            reason(model.reason);
        }

        public final String getConstraint() {
            return constraint;
        }

        public final void setConstraint(String constraint) {
            this.constraint = constraint;
        }

        @Override
        public final Builder constraint(String constraint) {
            this.constraint = constraint;
            return this;
        }

        @Override
        public final Builder constraint(WaypointOptimizationConstraint constraint) {
            this.constraint(constraint == null ? null : constraint.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public WaypointOptimizationFailedConstraint build() {
            return new WaypointOptimizationFailedConstraint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
