/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The optimized waypoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationOptimizedWaypoint implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationOptimizedWaypoint.Builder, WaypointOptimizationOptimizedWaypoint> {
    private static final SdkField<String> ARRIVAL_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArrivalTime").getter(getter(WaypointOptimizationOptimizedWaypoint::arrivalTime))
            .setter(setter(Builder::arrivalTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrivalTime").build()).build();

    private static final SdkField<Integer> CLUSTER_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClusterIndex").getter(getter(WaypointOptimizationOptimizedWaypoint::clusterIndex))
            .setter(setter(Builder::clusterIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIndex").build()).build();

    private static final SdkField<String> DEPARTURE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DepartureTime").getter(getter(WaypointOptimizationOptimizedWaypoint::departureTime))
            .setter(setter(Builder::departureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(WaypointOptimizationOptimizedWaypoint::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(WaypointOptimizationOptimizedWaypoint::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRIVAL_TIME_FIELD,
            CLUSTER_INDEX_FIELD, DEPARTURE_TIME_FIELD, ID_FIELD, POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arrivalTime;

    private final Integer clusterIndex;

    private final String departureTime;

    private final String id;

    private final List<Double> position;

    private WaypointOptimizationOptimizedWaypoint(BuilderImpl builder) {
        this.arrivalTime = builder.arrivalTime;
        this.clusterIndex = builder.clusterIndex;
        this.departureTime = builder.departureTime;
        this.id = builder.id;
        this.position = builder.position;
    }

    /**
     * <p>
     * Estimated time of arrival at the destination.
     * </p>
     * <p>
     * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     * </p>
     * <p>
     * Examples:
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24Z</code>
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24+02:00</code>
     * </p>
     * 
     * @return Estimated time of arrival at the destination.</p>
     *         <p>
     *         Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     *         </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24Z</code>
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24+02:00</code>
     */
    public final String arrivalTime() {
        return arrivalTime;
    }

    /**
     * <p>
     * Index of the cluster the waypoint is associated with. The index is included in the response only if clustering
     * was performed while processing the request.
     * </p>
     * 
     * @return Index of the cluster the waypoint is associated with. The index is included in the response only if
     *         clustering was performed while processing the request.
     */
    public final Integer clusterIndex() {
        return clusterIndex;
    }

    /**
     * <p>
     * Estimated time of departure from thr origin.
     * </p>
     * <p>
     * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     * </p>
     * <p>
     * Examples:
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24Z</code>
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24+02:00</code>
     * </p>
     * 
     * @return Estimated time of departure from thr origin.</p>
     *         <p>
     *         Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     *         </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24Z</code>
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24+02:00</code>
     */
    public final String departureTime() {
        return departureTime;
    }

    /**
     * <p>
     * The waypoint Id.
     * </p>
     * 
     * @return The waypoint Id.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Position defined as <code>[longitude, latitude]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return Position defined as <code>[longitude, latitude]</code>.
     */
    public final List<Double> position() {
        return position;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arrivalTime());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIndex());
        hashCode = 31 * hashCode + Objects.hashCode(departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationOptimizedWaypoint)) {
            return false;
        }
        WaypointOptimizationOptimizedWaypoint other = (WaypointOptimizationOptimizedWaypoint) obj;
        return Objects.equals(arrivalTime(), other.arrivalTime()) && Objects.equals(clusterIndex(), other.clusterIndex())
                && Objects.equals(departureTime(), other.departureTime()) && Objects.equals(id(), other.id())
                && hasPosition() == other.hasPosition() && Objects.equals(position(), other.position());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationOptimizedWaypoint")
                .add("ArrivalTime", arrivalTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClusterIndex", clusterIndex())
                .add("DepartureTime", departureTime() == null ? null : "*** Sensitive Data Redacted ***").add("Id", id())
                .add("Position", position() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArrivalTime":
            return Optional.ofNullable(clazz.cast(arrivalTime()));
        case "ClusterIndex":
            return Optional.ofNullable(clazz.cast(clusterIndex()));
        case "DepartureTime":
            return Optional.ofNullable(clazz.cast(departureTime()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArrivalTime", ARRIVAL_TIME_FIELD);
        map.put("ClusterIndex", CLUSTER_INDEX_FIELD);
        map.put("DepartureTime", DEPARTURE_TIME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Position", POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationOptimizedWaypoint, T> g) {
        return obj -> g.apply((WaypointOptimizationOptimizedWaypoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationOptimizedWaypoint> {
        /**
         * <p>
         * Estimated time of arrival at the destination.
         * </p>
         * <p>
         * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         * </p>
         * <p>
         * Examples:
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24Z</code>
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24+02:00</code>
         * </p>
         * 
         * @param arrivalTime
         *        Estimated time of arrival at the destination.</p>
         *        <p>
         *        Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         *        </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24Z</code>
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24+02:00</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrivalTime(String arrivalTime);

        /**
         * <p>
         * Index of the cluster the waypoint is associated with. The index is included in the response only if
         * clustering was performed while processing the request.
         * </p>
         * 
         * @param clusterIndex
         *        Index of the cluster the waypoint is associated with. The index is included in the response only if
         *        clustering was performed while processing the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIndex(Integer clusterIndex);

        /**
         * <p>
         * Estimated time of departure from thr origin.
         * </p>
         * <p>
         * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         * </p>
         * <p>
         * Examples:
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24Z</code>
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24+02:00</code>
         * </p>
         * 
         * @param departureTime
         *        Estimated time of departure from thr origin.</p>
         *        <p>
         *        Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         *        </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24Z</code>
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24+02:00</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder departureTime(String departureTime);

        /**
         * <p>
         * The waypoint Id.
         * </p>
         * 
         * @param id
         *        The waypoint Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);
    }

    static final class BuilderImpl implements Builder {
        private String arrivalTime;

        private Integer clusterIndex;

        private String departureTime;

        private String id;

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationOptimizedWaypoint model) {
            arrivalTime(model.arrivalTime);
            clusterIndex(model.clusterIndex);
            departureTime(model.departureTime);
            id(model.id);
            position(model.position);
        }

        public final String getArrivalTime() {
            return arrivalTime;
        }

        public final void setArrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
        }

        @Override
        public final Builder arrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
            return this;
        }

        public final Integer getClusterIndex() {
            return clusterIndex;
        }

        public final void setClusterIndex(Integer clusterIndex) {
            this.clusterIndex = clusterIndex;
        }

        @Override
        public final Builder clusterIndex(Integer clusterIndex) {
            this.clusterIndex = clusterIndex;
            return this;
        }

        public final String getDepartureTime() {
            return departureTime;
        }

        public final void setDepartureTime(String departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(String departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        @Override
        public WaypointOptimizationOptimizedWaypoint build() {
            return new WaypointOptimizationOptimizedWaypoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
