/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the total weight for the specified axle group. Meant for usage in countries that have different regulations
 * based on the axle group type.
 * </p>
 * <p>
 * <b>Unit</b>: <code>Kilograms</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WeightPerAxleGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<WeightPerAxleGroup.Builder, WeightPerAxleGroup> {
    private static final SdkField<Long> SINGLE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Single")
            .getter(getter(WeightPerAxleGroup::single)).setter(setter(Builder::single))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Single").build()).build();

    private static final SdkField<Long> TANDEM_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Tandem")
            .getter(getter(WeightPerAxleGroup::tandem)).setter(setter(Builder::tandem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tandem").build()).build();

    private static final SdkField<Long> TRIPLE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Triple")
            .getter(getter(WeightPerAxleGroup::triple)).setter(setter(Builder::triple))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Triple").build()).build();

    private static final SdkField<Long> QUAD_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Quad")
            .getter(getter(WeightPerAxleGroup::quad)).setter(setter(Builder::quad))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quad").build()).build();

    private static final SdkField<Long> QUINT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Quint")
            .getter(getter(WeightPerAxleGroup::quint)).setter(setter(Builder::quint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SINGLE_FIELD, TANDEM_FIELD,
            TRIPLE_FIELD, QUAD_FIELD, QUINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long single;

    private final Long tandem;

    private final Long triple;

    private final Long quad;

    private final Long quint;

    private WeightPerAxleGroup(BuilderImpl builder) {
        this.single = builder.single;
        this.tandem = builder.tandem;
        this.triple = builder.triple;
        this.quad = builder.quad;
        this.quint = builder.quint;
    }

    /**
     * <p>
     * Weight for single axle group.
     * </p>
     * <p>
     * <b>Unit</b>: <code>Kilograms</code>
     * </p>
     * 
     * @return Weight for single axle group.</p>
     *         <p>
     *         <b>Unit</b>: <code>Kilograms</code>
     */
    public final Long single() {
        return single;
    }

    /**
     * <p>
     * Weight for tandem axle group.
     * </p>
     * <p>
     * <b>Unit</b>: <code>Kilograms</code>
     * </p>
     * 
     * @return Weight for tandem axle group.</p>
     *         <p>
     *         <b>Unit</b>: <code>Kilograms</code>
     */
    public final Long tandem() {
        return tandem;
    }

    /**
     * <p>
     * Weight for triple axle group.
     * </p>
     * <p>
     * <b>Unit</b>: <code>Kilograms</code>
     * </p>
     * 
     * @return Weight for triple axle group.</p>
     *         <p>
     *         <b>Unit</b>: <code>Kilograms</code>
     */
    public final Long triple() {
        return triple;
    }

    /**
     * <p>
     * Weight for quad axle group.
     * </p>
     * <p>
     * <b>Unit</b>: <code>Kilograms</code>
     * </p>
     * 
     * @return Weight for quad axle group.</p>
     *         <p>
     *         <b>Unit</b>: <code>Kilograms</code>
     */
    public final Long quad() {
        return quad;
    }

    /**
     * <p>
     * Weight for quad quint group.
     * </p>
     * <p>
     * <b>Unit</b>: <code>Kilograms</code>
     * </p>
     * 
     * @return Weight for quad quint group.</p>
     *         <p>
     *         <b>Unit</b>: <code>Kilograms</code>
     */
    public final Long quint() {
        return quint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(single());
        hashCode = 31 * hashCode + Objects.hashCode(tandem());
        hashCode = 31 * hashCode + Objects.hashCode(triple());
        hashCode = 31 * hashCode + Objects.hashCode(quad());
        hashCode = 31 * hashCode + Objects.hashCode(quint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeightPerAxleGroup)) {
            return false;
        }
        WeightPerAxleGroup other = (WeightPerAxleGroup) obj;
        return Objects.equals(single(), other.single()) && Objects.equals(tandem(), other.tandem())
                && Objects.equals(triple(), other.triple()) && Objects.equals(quad(), other.quad())
                && Objects.equals(quint(), other.quint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WeightPerAxleGroup").add("Single", single() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tandem", tandem() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Triple", triple() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Quad", quad() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Quint", quint() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Single":
            return Optional.ofNullable(clazz.cast(single()));
        case "Tandem":
            return Optional.ofNullable(clazz.cast(tandem()));
        case "Triple":
            return Optional.ofNullable(clazz.cast(triple()));
        case "Quad":
            return Optional.ofNullable(clazz.cast(quad()));
        case "Quint":
            return Optional.ofNullable(clazz.cast(quint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Single", SINGLE_FIELD);
        map.put("Tandem", TANDEM_FIELD);
        map.put("Triple", TRIPLE_FIELD);
        map.put("Quad", QUAD_FIELD);
        map.put("Quint", QUINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WeightPerAxleGroup, T> g) {
        return obj -> g.apply((WeightPerAxleGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WeightPerAxleGroup> {
        /**
         * <p>
         * Weight for single axle group.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Kilograms</code>
         * </p>
         * 
         * @param single
         *        Weight for single axle group.</p>
         *        <p>
         *        <b>Unit</b>: <code>Kilograms</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder single(Long single);

        /**
         * <p>
         * Weight for tandem axle group.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Kilograms</code>
         * </p>
         * 
         * @param tandem
         *        Weight for tandem axle group.</p>
         *        <p>
         *        <b>Unit</b>: <code>Kilograms</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tandem(Long tandem);

        /**
         * <p>
         * Weight for triple axle group.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Kilograms</code>
         * </p>
         * 
         * @param triple
         *        Weight for triple axle group.</p>
         *        <p>
         *        <b>Unit</b>: <code>Kilograms</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triple(Long triple);

        /**
         * <p>
         * Weight for quad axle group.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Kilograms</code>
         * </p>
         * 
         * @param quad
         *        Weight for quad axle group.</p>
         *        <p>
         *        <b>Unit</b>: <code>Kilograms</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quad(Long quad);

        /**
         * <p>
         * Weight for quad quint group.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Kilograms</code>
         * </p>
         * 
         * @param quint
         *        Weight for quad quint group.</p>
         *        <p>
         *        <b>Unit</b>: <code>Kilograms</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quint(Long quint);
    }

    static final class BuilderImpl implements Builder {
        private Long single;

        private Long tandem;

        private Long triple;

        private Long quad;

        private Long quint;

        private BuilderImpl() {
        }

        private BuilderImpl(WeightPerAxleGroup model) {
            single(model.single);
            tandem(model.tandem);
            triple(model.triple);
            quad(model.quad);
            quint(model.quint);
        }

        public final Long getSingle() {
            return single;
        }

        public final void setSingle(Long single) {
            this.single = single;
        }

        @Override
        public final Builder single(Long single) {
            this.single = single;
            return this;
        }

        public final Long getTandem() {
            return tandem;
        }

        public final void setTandem(Long tandem) {
            this.tandem = tandem;
        }

        @Override
        public final Builder tandem(Long tandem) {
            this.tandem = tandem;
            return this;
        }

        public final Long getTriple() {
            return triple;
        }

        public final void setTriple(Long triple) {
            this.triple = triple;
        }

        @Override
        public final Builder triple(Long triple) {
            this.triple = triple;
            return this;
        }

        public final Long getQuad() {
            return quad;
        }

        public final void setQuad(Long quad) {
            this.quad = quad;
        }

        @Override
        public final Builder quad(Long quad) {
            this.quad = quad;
            return this;
        }

        public final Long getQuint() {
            return quint;
        }

        public final void setQuint(Long quint) {
            this.quint = quint;
        }

        @Override
        public final Builder quint(Long quint) {
            this.quint = quint;
            return this;
        }

        @Override
        public WeightPerAxleGroup build() {
            return new WeightPerAxleGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
