/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.LocalizedString;
import software.amazon.awssdk.services.georoutes.model.LocalizedStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteFerrySpan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteFerrySpan> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(RouteFerrySpan.getter(RouteFerrySpan::country)).setter(RouteFerrySpan.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Distance").getter(RouteFerrySpan.getter(RouteFerrySpan::distance)).setter(RouteFerrySpan.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(RouteFerrySpan.getter(RouteFerrySpan::duration)).setter(RouteFerrySpan.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Integer> GEOMETRY_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GeometryOffset").getter(RouteFerrySpan.getter(RouteFerrySpan::geometryOffset)).setter(RouteFerrySpan.setter(Builder::geometryOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeometryOffset").build()}).build();
    private static final SdkField<List<LocalizedString>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(RouteFerrySpan.getter(RouteFerrySpan::names)).setter(RouteFerrySpan.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalizedString::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(RouteFerrySpan.getter(RouteFerrySpan::region)).setter(RouteFerrySpan.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, DISTANCE_FIELD, DURATION_FIELD, GEOMETRY_OFFSET_FIELD, NAMES_FIELD, REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteFerrySpan.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String country;
    private final Long distance;
    private final Long duration;
    private final Integer geometryOffset;
    private final List<LocalizedString> names;
    private final String region;

    private RouteFerrySpan(BuilderImpl builder) {
        this.country = builder.country;
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.geometryOffset = builder.geometryOffset;
        this.names = builder.names;
        this.region = builder.region;
    }

    public final String country() {
        return this.country;
    }

    public final Long distance() {
        return this.distance;
    }

    public final Long duration() {
        return this.duration;
    }

    public final Integer geometryOffset() {
        return this.geometryOffset;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<LocalizedString> names() {
        return this.names;
    }

    public final String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometryOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteFerrySpan)) {
            return false;
        }
        RouteFerrySpan other = (RouteFerrySpan)obj;
        return Objects.equals(this.country(), other.country()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.geometryOffset(), other.geometryOffset()) && this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && Objects.equals(this.region(), other.region());
    }

    public final String toString() {
        return ToString.builder((String)"RouteFerrySpan").add("Country", (Object)(this.country() == null ? null : "*** Sensitive Data Redacted ***")).add("Distance", (Object)(this.distance() == null ? null : "*** Sensitive Data Redacted ***")).add("Duration", (Object)(this.duration() == null ? null : "*** Sensitive Data Redacted ***")).add("GeometryOffset", (Object)this.geometryOffset()).add("Names", this.hasNames() ? this.names() : null).add("Region", (Object)(this.region() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "GeometryOffset": {
                return Optional.ofNullable(clazz.cast(this.geometryOffset()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Country", COUNTRY_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("GeometryOffset", GEOMETRY_OFFSET_FIELD);
        map.put("Names", NAMES_FIELD);
        map.put("Region", REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteFerrySpan, T> g) {
        return obj -> g.apply((RouteFerrySpan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String country;
        private Long distance;
        private Long duration;
        private Integer geometryOffset;
        private List<LocalizedString> names = DefaultSdkAutoConstructList.getInstance();
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteFerrySpan model) {
            this.country(model.country);
            this.distance(model.distance);
            this.duration(model.duration);
            this.geometryOffset(model.geometryOffset);
            this.names(model.names);
            this.region(model.region);
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final Long getDistance() {
            return this.distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final Integer getGeometryOffset() {
            return this.geometryOffset;
        }

        public final void setGeometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
        }

        @Override
        public final Builder geometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
            return this;
        }

        public final List<LocalizedString.Builder> getNames() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.names);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNames(Collection<LocalizedString.BuilderImpl> names) {
            this.names = LocalizedStringListCopier.copyFromBuilder(names);
        }

        @Override
        public final Builder names(Collection<LocalizedString> names) {
            this.names = LocalizedStringListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(LocalizedString ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(Consumer<LocalizedString.Builder> ... names) {
            this.names(Stream.of(names).map(c -> (LocalizedString)((LocalizedString.Builder)LocalizedString.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public RouteFerrySpan build() {
            return new RouteFerrySpan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteFerrySpan> {
        public Builder country(String var1);

        public Builder distance(Long var1);

        public Builder duration(Long var1);

        public Builder geometryOffset(Integer var1);

        public Builder names(Collection<LocalizedString> var1);

        public Builder names(LocalizedString ... var1);

        public Builder names(Consumer<LocalizedString.Builder> ... var1);

        public Builder region(String var1);
    }
}

