/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.RouteFerryTravelStepType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteFerryTravelStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteFerryTravelStep> {
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Distance").getter(RouteFerryTravelStep.getter(RouteFerryTravelStep::distance)).setter(RouteFerryTravelStep.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(RouteFerryTravelStep.getter(RouteFerryTravelStep::duration)).setter(RouteFerryTravelStep.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Integer> GEOMETRY_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GeometryOffset").getter(RouteFerryTravelStep.getter(RouteFerryTravelStep::geometryOffset)).setter(RouteFerryTravelStep.setter(Builder::geometryOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeometryOffset").build()}).build();
    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Instruction").getter(RouteFerryTravelStep.getter(RouteFerryTravelStep::instruction)).setter(RouteFerryTravelStep.setter(Builder::instruction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instruction").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RouteFerryTravelStep.getter(RouteFerryTravelStep::typeAsString)).setter(RouteFerryTravelStep.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTANCE_FIELD, DURATION_FIELD, GEOMETRY_OFFSET_FIELD, INSTRUCTION_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteFerryTravelStep.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long distance;
    private final Long duration;
    private final Integer geometryOffset;
    private final String instruction;
    private final String type;

    private RouteFerryTravelStep(BuilderImpl builder) {
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.geometryOffset = builder.geometryOffset;
        this.instruction = builder.instruction;
        this.type = builder.type;
    }

    public final Long distance() {
        return this.distance;
    }

    public final Long duration() {
        return this.duration;
    }

    public final Integer geometryOffset() {
        return this.geometryOffset;
    }

    public final String instruction() {
        return this.instruction;
    }

    public final RouteFerryTravelStepType type() {
        return RouteFerryTravelStepType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometryOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.instruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteFerryTravelStep)) {
            return false;
        }
        RouteFerryTravelStep other = (RouteFerryTravelStep)obj;
        return Objects.equals(this.distance(), other.distance()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.geometryOffset(), other.geometryOffset()) && Objects.equals(this.instruction(), other.instruction()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteFerryTravelStep").add("Distance", (Object)(this.distance() == null ? null : "*** Sensitive Data Redacted ***")).add("Duration", (Object)(this.duration() == null ? null : "*** Sensitive Data Redacted ***")).add("GeometryOffset", (Object)this.geometryOffset()).add("Instruction", (Object)(this.instruction() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)(this.typeAsString() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "GeometryOffset": {
                return Optional.ofNullable(clazz.cast(this.geometryOffset()));
            }
            case "Instruction": {
                return Optional.ofNullable(clazz.cast(this.instruction()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("GeometryOffset", GEOMETRY_OFFSET_FIELD);
        map.put("Instruction", INSTRUCTION_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteFerryTravelStep, T> g) {
        return obj -> g.apply((RouteFerryTravelStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long distance;
        private Long duration;
        private Integer geometryOffset;
        private String instruction;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteFerryTravelStep model) {
            this.distance(model.distance);
            this.duration(model.duration);
            this.geometryOffset(model.geometryOffset);
            this.instruction(model.instruction);
            this.type(model.type);
        }

        public final Long getDistance() {
            return this.distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final Integer getGeometryOffset() {
            return this.geometryOffset;
        }

        public final void setGeometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
        }

        @Override
        public final Builder geometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
            return this;
        }

        public final String getInstruction() {
            return this.instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RouteFerryTravelStepType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RouteFerryTravelStep build() {
            return new RouteFerryTravelStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteFerryTravelStep> {
        public Builder distance(Long var1);

        public Builder duration(Long var1);

        public Builder geometryOffset(Integer var1);

        public Builder instruction(String var1);

        public Builder type(String var1);

        public Builder type(RouteFerryTravelStepType var1);
    }
}

