/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.RouteCarOptions;
import software.amazon.awssdk.services.georoutes.model.RoutePedestrianOptions;
import software.amazon.awssdk.services.georoutes.model.RouteScooterOptions;
import software.amazon.awssdk.services.georoutes.model.RouteTruckOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteTravelModeOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteTravelModeOptions> {
    private static final SdkField<RouteCarOptions> CAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Car").getter(RouteTravelModeOptions.getter(RouteTravelModeOptions::car)).setter(RouteTravelModeOptions.setter(Builder::car)).constructor(RouteCarOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Car").build()}).build();
    private static final SdkField<RoutePedestrianOptions> PEDESTRIAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Pedestrian").getter(RouteTravelModeOptions.getter(RouteTravelModeOptions::pedestrian)).setter(RouteTravelModeOptions.setter(Builder::pedestrian)).constructor(RoutePedestrianOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pedestrian").build()}).build();
    private static final SdkField<RouteScooterOptions> SCOOTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Scooter").getter(RouteTravelModeOptions.getter(RouteTravelModeOptions::scooter)).setter(RouteTravelModeOptions.setter(Builder::scooter)).constructor(RouteScooterOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scooter").build()}).build();
    private static final SdkField<RouteTruckOptions> TRUCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Truck").getter(RouteTravelModeOptions.getter(RouteTravelModeOptions::truck)).setter(RouteTravelModeOptions.setter(Builder::truck)).constructor(RouteTruckOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAR_FIELD, PEDESTRIAN_FIELD, SCOOTER_FIELD, TRUCK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteTravelModeOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RouteCarOptions car;
    private final RoutePedestrianOptions pedestrian;
    private final RouteScooterOptions scooter;
    private final RouteTruckOptions truck;

    private RouteTravelModeOptions(BuilderImpl builder) {
        this.car = builder.car;
        this.pedestrian = builder.pedestrian;
        this.scooter = builder.scooter;
        this.truck = builder.truck;
    }

    public final RouteCarOptions car() {
        return this.car;
    }

    public final RoutePedestrianOptions pedestrian() {
        return this.pedestrian;
    }

    public final RouteScooterOptions scooter() {
        return this.scooter;
    }

    public final RouteTruckOptions truck() {
        return this.truck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.car());
        hashCode = 31 * hashCode + Objects.hashCode(this.pedestrian());
        hashCode = 31 * hashCode + Objects.hashCode(this.scooter());
        hashCode = 31 * hashCode + Objects.hashCode(this.truck());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTravelModeOptions)) {
            return false;
        }
        RouteTravelModeOptions other = (RouteTravelModeOptions)obj;
        return Objects.equals(this.car(), other.car()) && Objects.equals(this.pedestrian(), other.pedestrian()) && Objects.equals(this.scooter(), other.scooter()) && Objects.equals(this.truck(), other.truck());
    }

    public final String toString() {
        return ToString.builder((String)"RouteTravelModeOptions").add("Car", (Object)this.car()).add("Pedestrian", (Object)this.pedestrian()).add("Scooter", (Object)this.scooter()).add("Truck", (Object)this.truck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Car": {
                return Optional.ofNullable(clazz.cast(this.car()));
            }
            case "Pedestrian": {
                return Optional.ofNullable(clazz.cast(this.pedestrian()));
            }
            case "Scooter": {
                return Optional.ofNullable(clazz.cast(this.scooter()));
            }
            case "Truck": {
                return Optional.ofNullable(clazz.cast(this.truck()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Car", CAR_FIELD);
        map.put("Pedestrian", PEDESTRIAN_FIELD);
        map.put("Scooter", SCOOTER_FIELD);
        map.put("Truck", TRUCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTravelModeOptions, T> g) {
        return obj -> g.apply((RouteTravelModeOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RouteCarOptions car;
        private RoutePedestrianOptions pedestrian;
        private RouteScooterOptions scooter;
        private RouteTruckOptions truck;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTravelModeOptions model) {
            this.car(model.car);
            this.pedestrian(model.pedestrian);
            this.scooter(model.scooter);
            this.truck(model.truck);
        }

        public final RouteCarOptions.Builder getCar() {
            return this.car != null ? this.car.toBuilder() : null;
        }

        public final void setCar(RouteCarOptions.BuilderImpl car) {
            this.car = car != null ? car.build() : null;
        }

        @Override
        public final Builder car(RouteCarOptions car) {
            this.car = car;
            return this;
        }

        public final RoutePedestrianOptions.Builder getPedestrian() {
            return this.pedestrian != null ? this.pedestrian.toBuilder() : null;
        }

        public final void setPedestrian(RoutePedestrianOptions.BuilderImpl pedestrian) {
            this.pedestrian = pedestrian != null ? pedestrian.build() : null;
        }

        @Override
        public final Builder pedestrian(RoutePedestrianOptions pedestrian) {
            this.pedestrian = pedestrian;
            return this;
        }

        public final RouteScooterOptions.Builder getScooter() {
            return this.scooter != null ? this.scooter.toBuilder() : null;
        }

        public final void setScooter(RouteScooterOptions.BuilderImpl scooter) {
            this.scooter = scooter != null ? scooter.build() : null;
        }

        @Override
        public final Builder scooter(RouteScooterOptions scooter) {
            this.scooter = scooter;
            return this;
        }

        public final RouteTruckOptions.Builder getTruck() {
            return this.truck != null ? this.truck.toBuilder() : null;
        }

        public final void setTruck(RouteTruckOptions.BuilderImpl truck) {
            this.truck = truck != null ? truck.build() : null;
        }

        @Override
        public final Builder truck(RouteTruckOptions truck) {
            this.truck = truck;
            return this;
        }

        public RouteTravelModeOptions build() {
            return new RouteTravelModeOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteTravelModeOptions> {
        public Builder car(RouteCarOptions var1);

        default public Builder car(Consumer<RouteCarOptions.Builder> car) {
            return this.car((RouteCarOptions)((RouteCarOptions.Builder)RouteCarOptions.builder().applyMutation(car)).build());
        }

        public Builder pedestrian(RoutePedestrianOptions var1);

        default public Builder pedestrian(Consumer<RoutePedestrianOptions.Builder> pedestrian) {
            return this.pedestrian((RoutePedestrianOptions)((RoutePedestrianOptions.Builder)RoutePedestrianOptions.builder().applyMutation(pedestrian)).build());
        }

        public Builder scooter(RouteScooterOptions var1);

        default public Builder scooter(Consumer<RouteScooterOptions.Builder> scooter) {
            return this.scooter((RouteScooterOptions)((RouteScooterOptions.Builder)RouteScooterOptions.builder().applyMutation(scooter)).build());
        }

        public Builder truck(RouteTruckOptions var1);

        default public Builder truck(Consumer<RouteTruckOptions.Builder> truck) {
            return this.truck((RouteTruckOptions)((RouteTruckOptions.Builder)RouteTruckOptions.builder().applyMutation(truck)).build());
        }
    }
}

