/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.RouteEngineType;
import software.amazon.awssdk.services.georoutes.model.RouteHazardousCargoType;
import software.amazon.awssdk.services.georoutes.model.RouteHazardousCargoTypeListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteTrailerOptions;
import software.amazon.awssdk.services.georoutes.model.RouteTruckType;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleLicensePlate;
import software.amazon.awssdk.services.georoutes.model.WeightPerAxleGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteTruckOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteTruckOptions> {
    private static final SdkField<Integer> AXLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AxleCount").getter(RouteTruckOptions.getter(RouteTruckOptions::axleCount)).setter(RouteTruckOptions.setter(Builder::axleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxleCount").build()}).build();
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineType").getter(RouteTruckOptions.getter(RouteTruckOptions::engineTypeAsString)).setter(RouteTruckOptions.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineType").build()}).build();
    private static final SdkField<Long> GROSS_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("GrossWeight").getter(RouteTruckOptions.getter(RouteTruckOptions::grossWeight)).setter(RouteTruckOptions.setter(Builder::grossWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrossWeight").build()}).build();
    private static final SdkField<List<String>> HAZARDOUS_CARGOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HazardousCargos").getter(RouteTruckOptions.getter(RouteTruckOptions::hazardousCargosAsStrings)).setter(RouteTruckOptions.setter(Builder::hazardousCargosWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HazardousCargos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Height").getter(RouteTruckOptions.getter(RouteTruckOptions::height)).setter(RouteTruckOptions.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()}).build();
    private static final SdkField<Long> HEIGHT_ABOVE_FIRST_AXLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("HeightAboveFirstAxle").getter(RouteTruckOptions.getter(RouteTruckOptions::heightAboveFirstAxle)).setter(RouteTruckOptions.setter(Builder::heightAboveFirstAxle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeightAboveFirstAxle").build()}).build();
    private static final SdkField<Long> KPRA_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("KpraLength").getter(RouteTruckOptions.getter(RouteTruckOptions::kpraLength)).setter(RouteTruckOptions.setter(Builder::kpraLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KpraLength").build()}).build();
    private static final SdkField<Long> LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Length").getter(RouteTruckOptions.getter(RouteTruckOptions::length)).setter(RouteTruckOptions.setter(Builder::length)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Length").build()}).build();
    private static final SdkField<RouteVehicleLicensePlate> LICENSE_PLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LicensePlate").getter(RouteTruckOptions.getter(RouteTruckOptions::licensePlate)).setter(RouteTruckOptions.setter(Builder::licensePlate)).constructor(RouteVehicleLicensePlate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicensePlate").build()}).build();
    private static final SdkField<Double> MAX_SPEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxSpeed").getter(RouteTruckOptions.getter(RouteTruckOptions::maxSpeed)).setter(RouteTruckOptions.setter(Builder::maxSpeed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSpeed").build()}).build();
    private static final SdkField<Integer> OCCUPANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Occupancy").getter(RouteTruckOptions.getter(RouteTruckOptions::occupancy)).setter(RouteTruckOptions.setter(Builder::occupancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Occupancy").build()}).build();
    private static final SdkField<Long> PAYLOAD_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PayloadCapacity").getter(RouteTruckOptions.getter(RouteTruckOptions::payloadCapacity)).setter(RouteTruckOptions.setter(Builder::payloadCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadCapacity").build()}).build();
    private static final SdkField<Integer> TIRE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TireCount").getter(RouteTruckOptions.getter(RouteTruckOptions::tireCount)).setter(RouteTruckOptions.setter(Builder::tireCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TireCount").build()}).build();
    private static final SdkField<RouteTrailerOptions> TRAILER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Trailer").getter(RouteTruckOptions.getter(RouteTruckOptions::trailer)).setter(RouteTruckOptions.setter(Builder::trailer)).constructor(RouteTrailerOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trailer").build()}).build();
    private static final SdkField<String> TRUCK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TruckType").getter(RouteTruckOptions.getter(RouteTruckOptions::truckTypeAsString)).setter(RouteTruckOptions.setter(Builder::truckType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckType").build()}).build();
    private static final SdkField<String> TUNNEL_RESTRICTION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TunnelRestrictionCode").getter(RouteTruckOptions.getter(RouteTruckOptions::tunnelRestrictionCode)).setter(RouteTruckOptions.setter(Builder::tunnelRestrictionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelRestrictionCode").build()}).build();
    private static final SdkField<Long> WEIGHT_PER_AXLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("WeightPerAxle").getter(RouteTruckOptions.getter(RouteTruckOptions::weightPerAxle)).setter(RouteTruckOptions.setter(Builder::weightPerAxle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightPerAxle").build()}).build();
    private static final SdkField<WeightPerAxleGroup> WEIGHT_PER_AXLE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WeightPerAxleGroup").getter(RouteTruckOptions.getter(RouteTruckOptions::weightPerAxleGroup)).setter(RouteTruckOptions.setter(Builder::weightPerAxleGroup)).constructor(WeightPerAxleGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightPerAxleGroup").build()}).build();
    private static final SdkField<Long> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Width").getter(RouteTruckOptions.getter(RouteTruckOptions::width)).setter(RouteTruckOptions.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AXLE_COUNT_FIELD, ENGINE_TYPE_FIELD, GROSS_WEIGHT_FIELD, HAZARDOUS_CARGOS_FIELD, HEIGHT_FIELD, HEIGHT_ABOVE_FIRST_AXLE_FIELD, KPRA_LENGTH_FIELD, LENGTH_FIELD, LICENSE_PLATE_FIELD, MAX_SPEED_FIELD, OCCUPANCY_FIELD, PAYLOAD_CAPACITY_FIELD, TIRE_COUNT_FIELD, TRAILER_FIELD, TRUCK_TYPE_FIELD, TUNNEL_RESTRICTION_CODE_FIELD, WEIGHT_PER_AXLE_FIELD, WEIGHT_PER_AXLE_GROUP_FIELD, WIDTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteTruckOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer axleCount;
    private final String engineType;
    private final Long grossWeight;
    private final List<String> hazardousCargos;
    private final Long height;
    private final Long heightAboveFirstAxle;
    private final Long kpraLength;
    private final Long length;
    private final RouteVehicleLicensePlate licensePlate;
    private final Double maxSpeed;
    private final Integer occupancy;
    private final Long payloadCapacity;
    private final Integer tireCount;
    private final RouteTrailerOptions trailer;
    private final String truckType;
    private final String tunnelRestrictionCode;
    private final Long weightPerAxle;
    private final WeightPerAxleGroup weightPerAxleGroup;
    private final Long width;

    private RouteTruckOptions(BuilderImpl builder) {
        this.axleCount = builder.axleCount;
        this.engineType = builder.engineType;
        this.grossWeight = builder.grossWeight;
        this.hazardousCargos = builder.hazardousCargos;
        this.height = builder.height;
        this.heightAboveFirstAxle = builder.heightAboveFirstAxle;
        this.kpraLength = builder.kpraLength;
        this.length = builder.length;
        this.licensePlate = builder.licensePlate;
        this.maxSpeed = builder.maxSpeed;
        this.occupancy = builder.occupancy;
        this.payloadCapacity = builder.payloadCapacity;
        this.tireCount = builder.tireCount;
        this.trailer = builder.trailer;
        this.truckType = builder.truckType;
        this.tunnelRestrictionCode = builder.tunnelRestrictionCode;
        this.weightPerAxle = builder.weightPerAxle;
        this.weightPerAxleGroup = builder.weightPerAxleGroup;
        this.width = builder.width;
    }

    public final Integer axleCount() {
        return this.axleCount;
    }

    public final RouteEngineType engineType() {
        return RouteEngineType.fromValue(this.engineType);
    }

    public final String engineTypeAsString() {
        return this.engineType;
    }

    public final Long grossWeight() {
        return this.grossWeight;
    }

    public final List<RouteHazardousCargoType> hazardousCargos() {
        return RouteHazardousCargoTypeListCopier.copyStringToEnum(this.hazardousCargos);
    }

    public final boolean hasHazardousCargos() {
        return this.hazardousCargos != null && !(this.hazardousCargos instanceof SdkAutoConstructList);
    }

    public final List<String> hazardousCargosAsStrings() {
        return this.hazardousCargos;
    }

    public final Long height() {
        return this.height;
    }

    public final Long heightAboveFirstAxle() {
        return this.heightAboveFirstAxle;
    }

    public final Long kpraLength() {
        return this.kpraLength;
    }

    public final Long length() {
        return this.length;
    }

    public final RouteVehicleLicensePlate licensePlate() {
        return this.licensePlate;
    }

    public final Double maxSpeed() {
        return this.maxSpeed;
    }

    public final Integer occupancy() {
        return this.occupancy;
    }

    public final Long payloadCapacity() {
        return this.payloadCapacity;
    }

    public final Integer tireCount() {
        return this.tireCount;
    }

    public final RouteTrailerOptions trailer() {
        return this.trailer;
    }

    public final RouteTruckType truckType() {
        return RouteTruckType.fromValue(this.truckType);
    }

    public final String truckTypeAsString() {
        return this.truckType;
    }

    public final String tunnelRestrictionCode() {
        return this.tunnelRestrictionCode;
    }

    public final Long weightPerAxle() {
        return this.weightPerAxle;
    }

    public final WeightPerAxleGroup weightPerAxleGroup() {
        return this.weightPerAxleGroup;
    }

    public final Long width() {
        return this.width;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.axleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.grossWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHazardousCargos() ? this.hazardousCargosAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.heightAboveFirstAxle());
        hashCode = 31 * hashCode + Objects.hashCode(this.kpraLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.length());
        hashCode = 31 * hashCode + Objects.hashCode(this.licensePlate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSpeed());
        hashCode = 31 * hashCode + Objects.hashCode(this.occupancy());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.tireCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.trailer());
        hashCode = 31 * hashCode + Objects.hashCode(this.truckTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelRestrictionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightPerAxle());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightPerAxleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTruckOptions)) {
            return false;
        }
        RouteTruckOptions other = (RouteTruckOptions)obj;
        return Objects.equals(this.axleCount(), other.axleCount()) && Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && Objects.equals(this.grossWeight(), other.grossWeight()) && this.hasHazardousCargos() == other.hasHazardousCargos() && Objects.equals(this.hazardousCargosAsStrings(), other.hazardousCargosAsStrings()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.heightAboveFirstAxle(), other.heightAboveFirstAxle()) && Objects.equals(this.kpraLength(), other.kpraLength()) && Objects.equals(this.length(), other.length()) && Objects.equals(this.licensePlate(), other.licensePlate()) && Objects.equals(this.maxSpeed(), other.maxSpeed()) && Objects.equals(this.occupancy(), other.occupancy()) && Objects.equals(this.payloadCapacity(), other.payloadCapacity()) && Objects.equals(this.tireCount(), other.tireCount()) && Objects.equals(this.trailer(), other.trailer()) && Objects.equals(this.truckTypeAsString(), other.truckTypeAsString()) && Objects.equals(this.tunnelRestrictionCode(), other.tunnelRestrictionCode()) && Objects.equals(this.weightPerAxle(), other.weightPerAxle()) && Objects.equals(this.weightPerAxleGroup(), other.weightPerAxleGroup()) && Objects.equals(this.width(), other.width());
    }

    public final String toString() {
        return ToString.builder((String)"RouteTruckOptions").add("AxleCount", (Object)(this.axleCount() == null ? null : "*** Sensitive Data Redacted ***")).add("EngineType", (Object)(this.engineTypeAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("GrossWeight", (Object)(this.grossWeight() == null ? null : "*** Sensitive Data Redacted ***")).add("HazardousCargos", (Object)(this.hazardousCargosAsStrings() == null ? null : "*** Sensitive Data Redacted ***")).add("Height", (Object)(this.height() == null ? null : "*** Sensitive Data Redacted ***")).add("HeightAboveFirstAxle", (Object)(this.heightAboveFirstAxle() == null ? null : "*** Sensitive Data Redacted ***")).add("KpraLength", (Object)(this.kpraLength() == null ? null : "*** Sensitive Data Redacted ***")).add("Length", (Object)(this.length() == null ? null : "*** Sensitive Data Redacted ***")).add("LicensePlate", (Object)this.licensePlate()).add("MaxSpeed", (Object)(this.maxSpeed() == null ? null : "*** Sensitive Data Redacted ***")).add("Occupancy", (Object)(this.occupancy() == null ? null : "*** Sensitive Data Redacted ***")).add("PayloadCapacity", (Object)(this.payloadCapacity() == null ? null : "*** Sensitive Data Redacted ***")).add("TireCount", (Object)(this.tireCount() == null ? null : "*** Sensitive Data Redacted ***")).add("Trailer", (Object)this.trailer()).add("TruckType", (Object)(this.truckTypeAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("TunnelRestrictionCode", (Object)(this.tunnelRestrictionCode() == null ? null : "*** Sensitive Data Redacted ***")).add("WeightPerAxle", (Object)(this.weightPerAxle() == null ? null : "*** Sensitive Data Redacted ***")).add("WeightPerAxleGroup", (Object)this.weightPerAxleGroup()).add("Width", (Object)(this.width() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AxleCount": {
                return Optional.ofNullable(clazz.cast(this.axleCount()));
            }
            case "EngineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "GrossWeight": {
                return Optional.ofNullable(clazz.cast(this.grossWeight()));
            }
            case "HazardousCargos": {
                return Optional.ofNullable(clazz.cast(this.hazardousCargosAsStrings()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "HeightAboveFirstAxle": {
                return Optional.ofNullable(clazz.cast(this.heightAboveFirstAxle()));
            }
            case "KpraLength": {
                return Optional.ofNullable(clazz.cast(this.kpraLength()));
            }
            case "Length": {
                return Optional.ofNullable(clazz.cast(this.length()));
            }
            case "LicensePlate": {
                return Optional.ofNullable(clazz.cast(this.licensePlate()));
            }
            case "MaxSpeed": {
                return Optional.ofNullable(clazz.cast(this.maxSpeed()));
            }
            case "Occupancy": {
                return Optional.ofNullable(clazz.cast(this.occupancy()));
            }
            case "PayloadCapacity": {
                return Optional.ofNullable(clazz.cast(this.payloadCapacity()));
            }
            case "TireCount": {
                return Optional.ofNullable(clazz.cast(this.tireCount()));
            }
            case "Trailer": {
                return Optional.ofNullable(clazz.cast(this.trailer()));
            }
            case "TruckType": {
                return Optional.ofNullable(clazz.cast(this.truckTypeAsString()));
            }
            case "TunnelRestrictionCode": {
                return Optional.ofNullable(clazz.cast(this.tunnelRestrictionCode()));
            }
            case "WeightPerAxle": {
                return Optional.ofNullable(clazz.cast(this.weightPerAxle()));
            }
            case "WeightPerAxleGroup": {
                return Optional.ofNullable(clazz.cast(this.weightPerAxleGroup()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AxleCount", AXLE_COUNT_FIELD);
        map.put("EngineType", ENGINE_TYPE_FIELD);
        map.put("GrossWeight", GROSS_WEIGHT_FIELD);
        map.put("HazardousCargos", HAZARDOUS_CARGOS_FIELD);
        map.put("Height", HEIGHT_FIELD);
        map.put("HeightAboveFirstAxle", HEIGHT_ABOVE_FIRST_AXLE_FIELD);
        map.put("KpraLength", KPRA_LENGTH_FIELD);
        map.put("Length", LENGTH_FIELD);
        map.put("LicensePlate", LICENSE_PLATE_FIELD);
        map.put("MaxSpeed", MAX_SPEED_FIELD);
        map.put("Occupancy", OCCUPANCY_FIELD);
        map.put("PayloadCapacity", PAYLOAD_CAPACITY_FIELD);
        map.put("TireCount", TIRE_COUNT_FIELD);
        map.put("Trailer", TRAILER_FIELD);
        map.put("TruckType", TRUCK_TYPE_FIELD);
        map.put("TunnelRestrictionCode", TUNNEL_RESTRICTION_CODE_FIELD);
        map.put("WeightPerAxle", WEIGHT_PER_AXLE_FIELD);
        map.put("WeightPerAxleGroup", WEIGHT_PER_AXLE_GROUP_FIELD);
        map.put("Width", WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTruckOptions, T> g) {
        return obj -> g.apply((RouteTruckOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer axleCount;
        private String engineType;
        private Long grossWeight;
        private List<String> hazardousCargos = DefaultSdkAutoConstructList.getInstance();
        private Long height;
        private Long heightAboveFirstAxle;
        private Long kpraLength;
        private Long length;
        private RouteVehicleLicensePlate licensePlate;
        private Double maxSpeed;
        private Integer occupancy;
        private Long payloadCapacity;
        private Integer tireCount;
        private RouteTrailerOptions trailer;
        private String truckType;
        private String tunnelRestrictionCode;
        private Long weightPerAxle;
        private WeightPerAxleGroup weightPerAxleGroup;
        private Long width;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTruckOptions model) {
            this.axleCount(model.axleCount);
            this.engineType(model.engineType);
            this.grossWeight(model.grossWeight);
            this.hazardousCargosWithStrings(model.hazardousCargos);
            this.height(model.height);
            this.heightAboveFirstAxle(model.heightAboveFirstAxle);
            this.kpraLength(model.kpraLength);
            this.length(model.length);
            this.licensePlate(model.licensePlate);
            this.maxSpeed(model.maxSpeed);
            this.occupancy(model.occupancy);
            this.payloadCapacity(model.payloadCapacity);
            this.tireCount(model.tireCount);
            this.trailer(model.trailer);
            this.truckType(model.truckType);
            this.tunnelRestrictionCode(model.tunnelRestrictionCode);
            this.weightPerAxle(model.weightPerAxle);
            this.weightPerAxleGroup(model.weightPerAxleGroup);
            this.width(model.width);
        }

        public final Integer getAxleCount() {
            return this.axleCount;
        }

        public final void setAxleCount(Integer axleCount) {
            this.axleCount = axleCount;
        }

        @Override
        public final Builder axleCount(Integer axleCount) {
            this.axleCount = axleCount;
            return this;
        }

        public final String getEngineType() {
            return this.engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(RouteEngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final Long getGrossWeight() {
            return this.grossWeight;
        }

        public final void setGrossWeight(Long grossWeight) {
            this.grossWeight = grossWeight;
        }

        @Override
        public final Builder grossWeight(Long grossWeight) {
            this.grossWeight = grossWeight;
            return this;
        }

        public final Collection<String> getHazardousCargos() {
            if (this.hazardousCargos instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hazardousCargos;
        }

        public final void setHazardousCargos(Collection<String> hazardousCargos) {
            this.hazardousCargos = RouteHazardousCargoTypeListCopier.copy(hazardousCargos);
        }

        @Override
        public final Builder hazardousCargosWithStrings(Collection<String> hazardousCargos) {
            this.hazardousCargos = RouteHazardousCargoTypeListCopier.copy(hazardousCargos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hazardousCargosWithStrings(String ... hazardousCargos) {
            this.hazardousCargosWithStrings(Arrays.asList(hazardousCargos));
            return this;
        }

        @Override
        public final Builder hazardousCargos(Collection<RouteHazardousCargoType> hazardousCargos) {
            this.hazardousCargos = RouteHazardousCargoTypeListCopier.copyEnumToString(hazardousCargos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hazardousCargos(RouteHazardousCargoType ... hazardousCargos) {
            this.hazardousCargos(Arrays.asList(hazardousCargos));
            return this;
        }

        public final Long getHeight() {
            return this.height;
        }

        public final void setHeight(Long height) {
            this.height = height;
        }

        @Override
        public final Builder height(Long height) {
            this.height = height;
            return this;
        }

        public final Long getHeightAboveFirstAxle() {
            return this.heightAboveFirstAxle;
        }

        public final void setHeightAboveFirstAxle(Long heightAboveFirstAxle) {
            this.heightAboveFirstAxle = heightAboveFirstAxle;
        }

        @Override
        public final Builder heightAboveFirstAxle(Long heightAboveFirstAxle) {
            this.heightAboveFirstAxle = heightAboveFirstAxle;
            return this;
        }

        public final Long getKpraLength() {
            return this.kpraLength;
        }

        public final void setKpraLength(Long kpraLength) {
            this.kpraLength = kpraLength;
        }

        @Override
        public final Builder kpraLength(Long kpraLength) {
            this.kpraLength = kpraLength;
            return this;
        }

        public final Long getLength() {
            return this.length;
        }

        public final void setLength(Long length) {
            this.length = length;
        }

        @Override
        public final Builder length(Long length) {
            this.length = length;
            return this;
        }

        public final RouteVehicleLicensePlate.Builder getLicensePlate() {
            return this.licensePlate != null ? this.licensePlate.toBuilder() : null;
        }

        public final void setLicensePlate(RouteVehicleLicensePlate.BuilderImpl licensePlate) {
            this.licensePlate = licensePlate != null ? licensePlate.build() : null;
        }

        @Override
        public final Builder licensePlate(RouteVehicleLicensePlate licensePlate) {
            this.licensePlate = licensePlate;
            return this;
        }

        public final Double getMaxSpeed() {
            return this.maxSpeed;
        }

        public final void setMaxSpeed(Double maxSpeed) {
            this.maxSpeed = maxSpeed;
        }

        @Override
        public final Builder maxSpeed(Double maxSpeed) {
            this.maxSpeed = maxSpeed;
            return this;
        }

        public final Integer getOccupancy() {
            return this.occupancy;
        }

        public final void setOccupancy(Integer occupancy) {
            this.occupancy = occupancy;
        }

        @Override
        public final Builder occupancy(Integer occupancy) {
            this.occupancy = occupancy;
            return this;
        }

        public final Long getPayloadCapacity() {
            return this.payloadCapacity;
        }

        public final void setPayloadCapacity(Long payloadCapacity) {
            this.payloadCapacity = payloadCapacity;
        }

        @Override
        public final Builder payloadCapacity(Long payloadCapacity) {
            this.payloadCapacity = payloadCapacity;
            return this;
        }

        public final Integer getTireCount() {
            return this.tireCount;
        }

        public final void setTireCount(Integer tireCount) {
            this.tireCount = tireCount;
        }

        @Override
        public final Builder tireCount(Integer tireCount) {
            this.tireCount = tireCount;
            return this;
        }

        public final RouteTrailerOptions.Builder getTrailer() {
            return this.trailer != null ? this.trailer.toBuilder() : null;
        }

        public final void setTrailer(RouteTrailerOptions.BuilderImpl trailer) {
            this.trailer = trailer != null ? trailer.build() : null;
        }

        @Override
        public final Builder trailer(RouteTrailerOptions trailer) {
            this.trailer = trailer;
            return this;
        }

        public final String getTruckType() {
            return this.truckType;
        }

        public final void setTruckType(String truckType) {
            this.truckType = truckType;
        }

        @Override
        public final Builder truckType(String truckType) {
            this.truckType = truckType;
            return this;
        }

        @Override
        public final Builder truckType(RouteTruckType truckType) {
            this.truckType(truckType == null ? null : truckType.toString());
            return this;
        }

        public final String getTunnelRestrictionCode() {
            return this.tunnelRestrictionCode;
        }

        public final void setTunnelRestrictionCode(String tunnelRestrictionCode) {
            this.tunnelRestrictionCode = tunnelRestrictionCode;
        }

        @Override
        public final Builder tunnelRestrictionCode(String tunnelRestrictionCode) {
            this.tunnelRestrictionCode = tunnelRestrictionCode;
            return this;
        }

        public final Long getWeightPerAxle() {
            return this.weightPerAxle;
        }

        public final void setWeightPerAxle(Long weightPerAxle) {
            this.weightPerAxle = weightPerAxle;
        }

        @Override
        public final Builder weightPerAxle(Long weightPerAxle) {
            this.weightPerAxle = weightPerAxle;
            return this;
        }

        public final WeightPerAxleGroup.Builder getWeightPerAxleGroup() {
            return this.weightPerAxleGroup != null ? this.weightPerAxleGroup.toBuilder() : null;
        }

        public final void setWeightPerAxleGroup(WeightPerAxleGroup.BuilderImpl weightPerAxleGroup) {
            this.weightPerAxleGroup = weightPerAxleGroup != null ? weightPerAxleGroup.build() : null;
        }

        @Override
        public final Builder weightPerAxleGroup(WeightPerAxleGroup weightPerAxleGroup) {
            this.weightPerAxleGroup = weightPerAxleGroup;
            return this;
        }

        public final Long getWidth() {
            return this.width;
        }

        public final void setWidth(Long width) {
            this.width = width;
        }

        @Override
        public final Builder width(Long width) {
            this.width = width;
            return this;
        }

        public RouteTruckOptions build() {
            return new RouteTruckOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteTruckOptions> {
        public Builder axleCount(Integer var1);

        public Builder engineType(String var1);

        public Builder engineType(RouteEngineType var1);

        public Builder grossWeight(Long var1);

        public Builder hazardousCargosWithStrings(Collection<String> var1);

        public Builder hazardousCargosWithStrings(String ... var1);

        public Builder hazardousCargos(Collection<RouteHazardousCargoType> var1);

        public Builder hazardousCargos(RouteHazardousCargoType ... var1);

        public Builder height(Long var1);

        public Builder heightAboveFirstAxle(Long var1);

        public Builder kpraLength(Long var1);

        public Builder length(Long var1);

        public Builder licensePlate(RouteVehicleLicensePlate var1);

        default public Builder licensePlate(Consumer<RouteVehicleLicensePlate.Builder> licensePlate) {
            return this.licensePlate((RouteVehicleLicensePlate)((RouteVehicleLicensePlate.Builder)RouteVehicleLicensePlate.builder().applyMutation(licensePlate)).build());
        }

        public Builder maxSpeed(Double var1);

        public Builder occupancy(Integer var1);

        public Builder payloadCapacity(Long var1);

        public Builder tireCount(Integer var1);

        public Builder trailer(RouteTrailerOptions var1);

        default public Builder trailer(Consumer<RouteTrailerOptions.Builder> trailer) {
            return this.trailer((RouteTrailerOptions)((RouteTrailerOptions.Builder)RouteTrailerOptions.builder().applyMutation(trailer)).build());
        }

        public Builder truckType(String var1);

        public Builder truckType(RouteTruckType var1);

        public Builder tunnelRestrictionCode(String var1);

        public Builder weightPerAxle(Long var1);

        public Builder weightPerAxleGroup(WeightPerAxleGroup var1);

        default public Builder weightPerAxleGroup(Consumer<WeightPerAxleGroup.Builder> weightPerAxleGroup) {
            return this.weightPerAxleGroup((WeightPerAxleGroup)((WeightPerAxleGroup.Builder)WeightPerAxleGroup.builder().applyMutation(weightPerAxleGroup)).build());
        }

        public Builder width(Long var1);
    }
}

