/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculateIsolinesResponse extends GeoRoutesResponse implements
        ToCopyableBuilder<CalculateIsolinesResponse.Builder, CalculateIsolinesResponse> {
    private static final SdkField<String> ARRIVAL_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArrivalTime").getter(getter(CalculateIsolinesResponse::arrivalTime))
            .setter(setter(Builder::arrivalTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrivalTime").build()).build();

    private static final SdkField<String> DEPARTURE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DepartureTime").getter(getter(CalculateIsolinesResponse::departureTime))
            .setter(setter(Builder::departureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build()).build();

    private static final SdkField<String> ISOLINE_GEOMETRY_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsolineGeometryFormat").getter(getter(CalculateIsolinesResponse::isolineGeometryFormatAsString))
            .setter(setter(Builder::isolineGeometryFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsolineGeometryFormat").build())
            .build();

    private static final SdkField<List<Isoline>> ISOLINES_FIELD = SdkField
            .<List<Isoline>> builder(MarshallingType.LIST)
            .memberName("Isolines")
            .getter(getter(CalculateIsolinesResponse::isolines))
            .setter(setter(Builder::isolines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Isolines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Isoline> builder(MarshallingType.SDK_POJO)
                                            .constructor(Isoline::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingBucket").getter(getter(CalculateIsolinesResponse::pricingBucket))
            .setter(setter(Builder::pricingBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build())
            .build();

    private static final SdkField<List<Double>> SNAPPED_DESTINATION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("SnappedDestination")
            .getter(getter(CalculateIsolinesResponse::snappedDestination))
            .setter(setter(Builder::snappedDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedDestination").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> SNAPPED_ORIGIN_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("SnappedOrigin")
            .getter(getter(CalculateIsolinesResponse::snappedOrigin))
            .setter(setter(Builder::snappedOrigin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedOrigin").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRIVAL_TIME_FIELD,
            DEPARTURE_TIME_FIELD, ISOLINE_GEOMETRY_FORMAT_FIELD, ISOLINES_FIELD, PRICING_BUCKET_FIELD, SNAPPED_DESTINATION_FIELD,
            SNAPPED_ORIGIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arrivalTime;

    private final String departureTime;

    private final String isolineGeometryFormat;

    private final List<Isoline> isolines;

    private final String pricingBucket;

    private final List<Double> snappedDestination;

    private final List<Double> snappedOrigin;

    private CalculateIsolinesResponse(BuilderImpl builder) {
        super(builder);
        this.arrivalTime = builder.arrivalTime;
        this.departureTime = builder.departureTime;
        this.isolineGeometryFormat = builder.isolineGeometryFormat;
        this.isolines = builder.isolines;
        this.pricingBucket = builder.pricingBucket;
        this.snappedDestination = builder.snappedDestination;
        this.snappedOrigin = builder.snappedOrigin;
    }

    /**
     * <p>
     * Time of arrival at the destination. This parameter is returned only if the Destination parameters was provided in
     * the request.
     * </p>
     * <p>
     * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     * </p>
     * <p>
     * Examples:
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24Z</code>
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24+02:00</code>
     * </p>
     * 
     * @return Time of arrival at the destination. This parameter is returned only if the Destination parameters was
     *         provided in the request. </p>
     *         <p>
     *         Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     *         </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24Z</code>
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24+02:00</code>
     */
    public final String arrivalTime() {
        return arrivalTime;
    }

    /**
     * <p>
     * Time of departure from thr origin.
     * </p>
     * <p>
     * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     * </p>
     * <p>
     * Examples:
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24Z</code>
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24+02:00</code>
     * </p>
     * 
     * @return Time of departure from thr origin.</p>
     *         <p>
     *         Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     *         </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24Z</code>
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24+02:00</code>
     */
    public final String departureTime() {
        return departureTime;
    }

    /**
     * <p>
     * The format of the returned IsolineGeometry.
     * </p>
     * <p>
     * Default Value:<code>FlexiblePolyline</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #isolineGeometryFormat} will return {@link GeometryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #isolineGeometryFormatAsString}.
     * </p>
     * 
     * @return The format of the returned IsolineGeometry. </p>
     *         <p>
     *         Default Value:<code>FlexiblePolyline</code>
     * @see GeometryFormat
     */
    public final GeometryFormat isolineGeometryFormat() {
        return GeometryFormat.fromValue(isolineGeometryFormat);
    }

    /**
     * <p>
     * The format of the returned IsolineGeometry.
     * </p>
     * <p>
     * Default Value:<code>FlexiblePolyline</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #isolineGeometryFormat} will return {@link GeometryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #isolineGeometryFormatAsString}.
     * </p>
     * 
     * @return The format of the returned IsolineGeometry. </p>
     *         <p>
     *         Default Value:<code>FlexiblePolyline</code>
     * @see GeometryFormat
     */
    public final String isolineGeometryFormatAsString() {
        return isolineGeometryFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the Isolines property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIsolines() {
        return isolines != null && !(isolines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Calculated isolines and associated properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIsolines} method.
     * </p>
     * 
     * @return Calculated isolines and associated properties.
     */
    public final List<Isoline> isolines() {
        return isolines;
    }

    /**
     * <p>
     * The pricing bucket for which the query is charged at.
     * </p>
     * 
     * @return The pricing bucket for which the query is charged at.
     */
    public final String pricingBucket() {
        return pricingBucket;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnappedDestination property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnappedDestination() {
        return snappedDestination != null && !(snappedDestination instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Snapped destination that was used for the Isoline calculation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnappedDestination} method.
     * </p>
     * 
     * @return Snapped destination that was used for the Isoline calculation.
     */
    public final List<Double> snappedDestination() {
        return snappedDestination;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnappedOrigin property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnappedOrigin() {
        return snappedOrigin != null && !(snappedOrigin instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Snapped origin that was used for the Isoline calculation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnappedOrigin} method.
     * </p>
     * 
     * @return Snapped origin that was used for the Isoline calculation.
     */
    public final List<Double> snappedOrigin() {
        return snappedOrigin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arrivalTime());
        hashCode = 31 * hashCode + Objects.hashCode(departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(isolineGeometryFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIsolines() ? isolines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnappedDestination() ? snappedDestination() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSnappedOrigin() ? snappedOrigin() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateIsolinesResponse)) {
            return false;
        }
        CalculateIsolinesResponse other = (CalculateIsolinesResponse) obj;
        return Objects.equals(arrivalTime(), other.arrivalTime()) && Objects.equals(departureTime(), other.departureTime())
                && Objects.equals(isolineGeometryFormatAsString(), other.isolineGeometryFormatAsString())
                && hasIsolines() == other.hasIsolines() && Objects.equals(isolines(), other.isolines())
                && Objects.equals(pricingBucket(), other.pricingBucket())
                && hasSnappedDestination() == other.hasSnappedDestination()
                && Objects.equals(snappedDestination(), other.snappedDestination())
                && hasSnappedOrigin() == other.hasSnappedOrigin() && Objects.equals(snappedOrigin(), other.snappedOrigin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculateIsolinesResponse")
                .add("ArrivalTime", arrivalTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DepartureTime", departureTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IsolineGeometryFormat", isolineGeometryFormatAsString()).add("Isolines", hasIsolines() ? isolines() : null)
                .add("PricingBucket", pricingBucket())
                .add("SnappedDestination", snappedDestination() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SnappedOrigin", snappedOrigin() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArrivalTime":
            return Optional.ofNullable(clazz.cast(arrivalTime()));
        case "DepartureTime":
            return Optional.ofNullable(clazz.cast(departureTime()));
        case "IsolineGeometryFormat":
            return Optional.ofNullable(clazz.cast(isolineGeometryFormatAsString()));
        case "Isolines":
            return Optional.ofNullable(clazz.cast(isolines()));
        case "PricingBucket":
            return Optional.ofNullable(clazz.cast(pricingBucket()));
        case "SnappedDestination":
            return Optional.ofNullable(clazz.cast(snappedDestination()));
        case "SnappedOrigin":
            return Optional.ofNullable(clazz.cast(snappedOrigin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArrivalTime", ARRIVAL_TIME_FIELD);
        map.put("DepartureTime", DEPARTURE_TIME_FIELD);
        map.put("IsolineGeometryFormat", ISOLINE_GEOMETRY_FORMAT_FIELD);
        map.put("Isolines", ISOLINES_FIELD);
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("SnappedDestination", SNAPPED_DESTINATION_FIELD);
        map.put("SnappedOrigin", SNAPPED_ORIGIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateIsolinesResponse, T> g) {
        return obj -> g.apply((CalculateIsolinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GeoRoutesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CalculateIsolinesResponse> {
        /**
         * <p>
         * Time of arrival at the destination. This parameter is returned only if the Destination parameters was
         * provided in the request.
         * </p>
         * <p>
         * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         * </p>
         * <p>
         * Examples:
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24Z</code>
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24+02:00</code>
         * </p>
         * 
         * @param arrivalTime
         *        Time of arrival at the destination. This parameter is returned only if the Destination parameters was
         *        provided in the request. </p>
         *        <p>
         *        Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         *        </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24Z</code>
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24+02:00</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrivalTime(String arrivalTime);

        /**
         * <p>
         * Time of departure from thr origin.
         * </p>
         * <p>
         * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         * </p>
         * <p>
         * Examples:
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24Z</code>
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24+02:00</code>
         * </p>
         * 
         * @param departureTime
         *        Time of departure from thr origin.</p>
         *        <p>
         *        Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         *        </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24Z</code>
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24+02:00</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder departureTime(String departureTime);

        /**
         * <p>
         * The format of the returned IsolineGeometry.
         * </p>
         * <p>
         * Default Value:<code>FlexiblePolyline</code>
         * </p>
         * 
         * @param isolineGeometryFormat
         *        The format of the returned IsolineGeometry. </p>
         *        <p>
         *        Default Value:<code>FlexiblePolyline</code>
         * @see GeometryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeometryFormat
         */
        Builder isolineGeometryFormat(String isolineGeometryFormat);

        /**
         * <p>
         * The format of the returned IsolineGeometry.
         * </p>
         * <p>
         * Default Value:<code>FlexiblePolyline</code>
         * </p>
         * 
         * @param isolineGeometryFormat
         *        The format of the returned IsolineGeometry. </p>
         *        <p>
         *        Default Value:<code>FlexiblePolyline</code>
         * @see GeometryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeometryFormat
         */
        Builder isolineGeometryFormat(GeometryFormat isolineGeometryFormat);

        /**
         * <p>
         * Calculated isolines and associated properties.
         * </p>
         * 
         * @param isolines
         *        Calculated isolines and associated properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isolines(Collection<Isoline> isolines);

        /**
         * <p>
         * Calculated isolines and associated properties.
         * </p>
         * 
         * @param isolines
         *        Calculated isolines and associated properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isolines(Isoline... isolines);

        /**
         * <p>
         * Calculated isolines and associated properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.Isoline.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.georoutes.model.Isoline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.Isoline.Builder#build()} is called immediately and its
         * result is passed to {@link #isolines(List<Isoline>)}.
         * 
         * @param isolines
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.Isoline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #isolines(java.util.Collection<Isoline>)
         */
        Builder isolines(Consumer<Isoline.Builder>... isolines);

        /**
         * <p>
         * The pricing bucket for which the query is charged at.
         * </p>
         * 
         * @param pricingBucket
         *        The pricing bucket for which the query is charged at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingBucket(String pricingBucket);

        /**
         * <p>
         * Snapped destination that was used for the Isoline calculation.
         * </p>
         * 
         * @param snappedDestination
         *        Snapped destination that was used for the Isoline calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedDestination(Collection<Double> snappedDestination);

        /**
         * <p>
         * Snapped destination that was used for the Isoline calculation.
         * </p>
         * 
         * @param snappedDestination
         *        Snapped destination that was used for the Isoline calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedDestination(Double... snappedDestination);

        /**
         * <p>
         * Snapped origin that was used for the Isoline calculation.
         * </p>
         * 
         * @param snappedOrigin
         *        Snapped origin that was used for the Isoline calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedOrigin(Collection<Double> snappedOrigin);

        /**
         * <p>
         * Snapped origin that was used for the Isoline calculation.
         * </p>
         * 
         * @param snappedOrigin
         *        Snapped origin that was used for the Isoline calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedOrigin(Double... snappedOrigin);
    }

    static final class BuilderImpl extends GeoRoutesResponse.BuilderImpl implements Builder {
        private String arrivalTime;

        private String departureTime;

        private String isolineGeometryFormat;

        private List<Isoline> isolines = DefaultSdkAutoConstructList.getInstance();

        private String pricingBucket;

        private List<Double> snappedDestination = DefaultSdkAutoConstructList.getInstance();

        private List<Double> snappedOrigin = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateIsolinesResponse model) {
            super(model);
            arrivalTime(model.arrivalTime);
            departureTime(model.departureTime);
            isolineGeometryFormat(model.isolineGeometryFormat);
            isolines(model.isolines);
            pricingBucket(model.pricingBucket);
            snappedDestination(model.snappedDestination);
            snappedOrigin(model.snappedOrigin);
        }

        public final String getArrivalTime() {
            return arrivalTime;
        }

        public final void setArrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
        }

        @Override
        public final Builder arrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
            return this;
        }

        public final String getDepartureTime() {
            return departureTime;
        }

        public final void setDepartureTime(String departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(String departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final String getIsolineGeometryFormat() {
            return isolineGeometryFormat;
        }

        public final void setIsolineGeometryFormat(String isolineGeometryFormat) {
            this.isolineGeometryFormat = isolineGeometryFormat;
        }

        @Override
        public final Builder isolineGeometryFormat(String isolineGeometryFormat) {
            this.isolineGeometryFormat = isolineGeometryFormat;
            return this;
        }

        @Override
        public final Builder isolineGeometryFormat(GeometryFormat isolineGeometryFormat) {
            this.isolineGeometryFormat(isolineGeometryFormat == null ? null : isolineGeometryFormat.toString());
            return this;
        }

        public final List<Isoline.Builder> getIsolines() {
            List<Isoline.Builder> result = IsolineListCopier.copyToBuilder(this.isolines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIsolines(Collection<Isoline.BuilderImpl> isolines) {
            this.isolines = IsolineListCopier.copyFromBuilder(isolines);
        }

        @Override
        public final Builder isolines(Collection<Isoline> isolines) {
            this.isolines = IsolineListCopier.copy(isolines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder isolines(Isoline... isolines) {
            isolines(Arrays.asList(isolines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder isolines(Consumer<Isoline.Builder>... isolines) {
            isolines(Stream.of(isolines).map(c -> Isoline.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPricingBucket() {
            return pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final Collection<Double> getSnappedDestination() {
            if (snappedDestination instanceof SdkAutoConstructList) {
                return null;
            }
            return snappedDestination;
        }

        public final void setSnappedDestination(Collection<Double> snappedDestination) {
            this.snappedDestination = PositionCopier.copy(snappedDestination);
        }

        @Override
        public final Builder snappedDestination(Collection<Double> snappedDestination) {
            this.snappedDestination = PositionCopier.copy(snappedDestination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedDestination(Double... snappedDestination) {
            snappedDestination(Arrays.asList(snappedDestination));
            return this;
        }

        public final Collection<Double> getSnappedOrigin() {
            if (snappedOrigin instanceof SdkAutoConstructList) {
                return null;
            }
            return snappedOrigin;
        }

        public final void setSnappedOrigin(Collection<Double> snappedOrigin) {
            this.snappedOrigin = PositionCopier.copy(snappedOrigin);
        }

        @Override
        public final Builder snappedOrigin(Collection<Double> snappedOrigin) {
            this.snappedOrigin = PositionCopier.copy(snappedOrigin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedOrigin(Double... snappedOrigin) {
            snappedOrigin(Arrays.asList(snappedOrigin));
            return this;
        }

        @Override
        public CalculateIsolinesResponse build() {
            return new CalculateIsolinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
