/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculateRouteMatrixResponse extends GeoRoutesResponse implements
        ToCopyableBuilder<CalculateRouteMatrixResponse.Builder, CalculateRouteMatrixResponse> {
    private static final SdkField<Integer> ERROR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ErrorCount").getter(getter(CalculateRouteMatrixResponse::errorCount))
            .setter(setter(Builder::errorCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCount").build()).build();

    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingBucket").getter(getter(CalculateRouteMatrixResponse::pricingBucket))
            .setter(setter(Builder::pricingBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build())
            .build();

    private static final SdkField<List<List<RouteMatrixEntry>>> ROUTE_MATRIX_FIELD = SdkField
            .<List<List<RouteMatrixEntry>>> builder(MarshallingType.LIST)
            .memberName("RouteMatrix")
            .getter(getter(CalculateRouteMatrixResponse::routeMatrix))
            .setter(setter(Builder::routeMatrix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteMatrix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<RouteMatrixEntry>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<RouteMatrixEntry> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(RouteMatrixEntry::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<RouteMatrixBoundary> ROUTING_BOUNDARY_FIELD = SdkField
            .<RouteMatrixBoundary> builder(MarshallingType.SDK_POJO).memberName("RoutingBoundary")
            .getter(getter(CalculateRouteMatrixResponse::routingBoundary)).setter(setter(Builder::routingBoundary))
            .constructor(RouteMatrixBoundary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingBoundary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_COUNT_FIELD,
            PRICING_BUCKET_FIELD, ROUTE_MATRIX_FIELD, ROUTING_BOUNDARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer errorCount;

    private final String pricingBucket;

    private final List<List<RouteMatrixEntry>> routeMatrix;

    private final RouteMatrixBoundary routingBoundary;

    private CalculateRouteMatrixResponse(BuilderImpl builder) {
        super(builder);
        this.errorCount = builder.errorCount;
        this.pricingBucket = builder.pricingBucket;
        this.routeMatrix = builder.routeMatrix;
        this.routingBoundary = builder.routingBoundary;
    }

    /**
     * <p>
     * The count of error results in the route matrix. If this number is 0, all routes were calculated successfully.
     * </p>
     * 
     * @return The count of error results in the route matrix. If this number is 0, all routes were calculated
     *         successfully.
     */
    public final Integer errorCount() {
        return errorCount;
    }

    /**
     * <p>
     * The pricing bucket for which the query is charged at.
     * </p>
     * 
     * @return The pricing bucket for which the query is charged at.
     */
    public final String pricingBucket() {
        return pricingBucket;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteMatrix property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteMatrix() {
        return routeMatrix != null && !(routeMatrix instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The calculated route matrix containing the results for all pairs of Origins to Destination positions. Each row
     * corresponds to one entry in Origins. Each entry in the row corresponds to the route from that entry in Origins to
     * an entry in Destination positions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteMatrix} method.
     * </p>
     * 
     * @return The calculated route matrix containing the results for all pairs of Origins to Destination positions.
     *         Each row corresponds to one entry in Origins. Each entry in the row corresponds to the route from that
     *         entry in Origins to an entry in Destination positions.
     */
    public final List<List<RouteMatrixEntry>> routeMatrix() {
        return routeMatrix;
    }

    /**
     * <p>
     * Boundary within which the matrix is to be calculated. All data, origins and destinations outside the boundary are
     * considered invalid.
     * </p>
     * <note>
     * <p>
     * When request routing boundary was set as AutoCircle, the response routing boundary will return Circle derived
     * from the AutoCircle settings.
     * </p>
     * </note>
     * 
     * @return Boundary within which the matrix is to be calculated. All data, origins and destinations outside the
     *         boundary are considered invalid.</p> <note>
     *         <p>
     *         When request routing boundary was set as AutoCircle, the response routing boundary will return Circle
     *         derived from the AutoCircle settings.
     *         </p>
     */
    public final RouteMatrixBoundary routingBoundary() {
        return routingBoundary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(errorCount());
        hashCode = 31 * hashCode + Objects.hashCode(pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteMatrix() ? routeMatrix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(routingBoundary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteMatrixResponse)) {
            return false;
        }
        CalculateRouteMatrixResponse other = (CalculateRouteMatrixResponse) obj;
        return Objects.equals(errorCount(), other.errorCount()) && Objects.equals(pricingBucket(), other.pricingBucket())
                && hasRouteMatrix() == other.hasRouteMatrix() && Objects.equals(routeMatrix(), other.routeMatrix())
                && Objects.equals(routingBoundary(), other.routingBoundary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculateRouteMatrixResponse").add("ErrorCount", errorCount())
                .add("PricingBucket", pricingBucket()).add("RouteMatrix", hasRouteMatrix() ? routeMatrix() : null)
                .add("RoutingBoundary", routingBoundary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ErrorCount":
            return Optional.ofNullable(clazz.cast(errorCount()));
        case "PricingBucket":
            return Optional.ofNullable(clazz.cast(pricingBucket()));
        case "RouteMatrix":
            return Optional.ofNullable(clazz.cast(routeMatrix()));
        case "RoutingBoundary":
            return Optional.ofNullable(clazz.cast(routingBoundary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ErrorCount", ERROR_COUNT_FIELD);
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("RouteMatrix", ROUTE_MATRIX_FIELD);
        map.put("RoutingBoundary", ROUTING_BOUNDARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteMatrixResponse, T> g) {
        return obj -> g.apply((CalculateRouteMatrixResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GeoRoutesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CalculateRouteMatrixResponse> {
        /**
         * <p>
         * The count of error results in the route matrix. If this number is 0, all routes were calculated successfully.
         * </p>
         * 
         * @param errorCount
         *        The count of error results in the route matrix. If this number is 0, all routes were calculated
         *        successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCount(Integer errorCount);

        /**
         * <p>
         * The pricing bucket for which the query is charged at.
         * </p>
         * 
         * @param pricingBucket
         *        The pricing bucket for which the query is charged at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingBucket(String pricingBucket);

        /**
         * <p>
         * The calculated route matrix containing the results for all pairs of Origins to Destination positions. Each
         * row corresponds to one entry in Origins. Each entry in the row corresponds to the route from that entry in
         * Origins to an entry in Destination positions.
         * </p>
         * 
         * @param routeMatrix
         *        The calculated route matrix containing the results for all pairs of Origins to Destination positions.
         *        Each row corresponds to one entry in Origins. Each entry in the row corresponds to the route from that
         *        entry in Origins to an entry in Destination positions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeMatrix(Collection<? extends Collection<RouteMatrixEntry>> routeMatrix);

        /**
         * <p>
         * The calculated route matrix containing the results for all pairs of Origins to Destination positions. Each
         * row corresponds to one entry in Origins. Each entry in the row corresponds to the route from that entry in
         * Origins to an entry in Destination positions.
         * </p>
         * 
         * @param routeMatrix
         *        The calculated route matrix containing the results for all pairs of Origins to Destination positions.
         *        Each row corresponds to one entry in Origins. Each entry in the row corresponds to the route from that
         *        entry in Origins to an entry in Destination positions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeMatrix(Collection<RouteMatrixEntry>... routeMatrix);

        /**
         * <p>
         * Boundary within which the matrix is to be calculated. All data, origins and destinations outside the boundary
         * are considered invalid.
         * </p>
         * <note>
         * <p>
         * When request routing boundary was set as AutoCircle, the response routing boundary will return Circle derived
         * from the AutoCircle settings.
         * </p>
         * </note>
         * 
         * @param routingBoundary
         *        Boundary within which the matrix is to be calculated. All data, origins and destinations outside the
         *        boundary are considered invalid.</p> <note>
         *        <p>
         *        When request routing boundary was set as AutoCircle, the response routing boundary will return Circle
         *        derived from the AutoCircle settings.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingBoundary(RouteMatrixBoundary routingBoundary);

        /**
         * <p>
         * Boundary within which the matrix is to be calculated. All data, origins and destinations outside the boundary
         * are considered invalid.
         * </p>
         * <note>
         * <p>
         * When request routing boundary was set as AutoCircle, the response routing boundary will return Circle derived
         * from the AutoCircle settings.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link RouteMatrixBoundary.Builder}
         * avoiding the need to create one manually via {@link RouteMatrixBoundary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteMatrixBoundary.Builder#build()} is called immediately and
         * its result is passed to {@link #routingBoundary(RouteMatrixBoundary)}.
         * 
         * @param routingBoundary
         *        a consumer that will call methods on {@link RouteMatrixBoundary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingBoundary(RouteMatrixBoundary)
         */
        default Builder routingBoundary(Consumer<RouteMatrixBoundary.Builder> routingBoundary) {
            return routingBoundary(RouteMatrixBoundary.builder().applyMutation(routingBoundary).build());
        }
    }

    static final class BuilderImpl extends GeoRoutesResponse.BuilderImpl implements Builder {
        private Integer errorCount;

        private String pricingBucket;

        private List<List<RouteMatrixEntry>> routeMatrix = DefaultSdkAutoConstructList.getInstance();

        private RouteMatrixBoundary routingBoundary;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteMatrixResponse model) {
            super(model);
            errorCount(model.errorCount);
            pricingBucket(model.pricingBucket);
            routeMatrix(model.routeMatrix);
            routingBoundary(model.routingBoundary);
        }

        public final Integer getErrorCount() {
            return errorCount;
        }

        public final void setErrorCount(Integer errorCount) {
            this.errorCount = errorCount;
        }

        @Override
        public final Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final String getPricingBucket() {
            return pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final List<List<RouteMatrixEntry.Builder>> getRouteMatrix() {
            List<List<RouteMatrixEntry.Builder>> result = RouteMatrixCopier.copyToBuilder(this.routeMatrix);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteMatrix(Collection<? extends Collection<RouteMatrixEntry.BuilderImpl>> routeMatrix) {
            this.routeMatrix = RouteMatrixCopier.copyFromBuilder(routeMatrix);
        }

        @Override
        public final Builder routeMatrix(Collection<? extends Collection<RouteMatrixEntry>> routeMatrix) {
            this.routeMatrix = RouteMatrixCopier.copy(routeMatrix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeMatrix(Collection<RouteMatrixEntry>... routeMatrix) {
            routeMatrix(Arrays.asList(routeMatrix));
            return this;
        }

        public final RouteMatrixBoundary.Builder getRoutingBoundary() {
            return routingBoundary != null ? routingBoundary.toBuilder() : null;
        }

        public final void setRoutingBoundary(RouteMatrixBoundary.BuilderImpl routingBoundary) {
            this.routingBoundary = routingBoundary != null ? routingBoundary.build() : null;
        }

        @Override
        public final Builder routingBoundary(RouteMatrixBoundary routingBoundary) {
            this.routingBoundary = routingBoundary;
            return this;
        }

        @Override
        public CalculateRouteMatrixResponse build() {
            return new CalculateRouteMatrixResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
