/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Geometry defined as a corridor - a LineString with a radius that defines the width of the corridor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Corridor implements SdkPojo, Serializable, ToCopyableBuilder<Corridor.Builder, Corridor> {
    private static final SdkField<List<List<Double>>> LINE_STRING_FIELD = SdkField
            .<List<List<Double>>> builder(MarshallingType.LIST)
            .memberName("LineString")
            .getter(getter(Corridor::lineString))
            .setter(setter(Builder::lineString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineString").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<Double>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Integer> RADIUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Radius").getter(getter(Corridor::radius)).setter(setter(Builder::radius))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Radius").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_STRING_FIELD,
            RADIUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<List<Double>> lineString;

    private final Integer radius;

    private Corridor(BuilderImpl builder) {
        this.lineString = builder.lineString;
        this.radius = builder.radius;
    }

    /**
     * For responses, this returns true if the service returned a value for the LineString property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLineString() {
        return lineString != null && !(lineString instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An ordered list of positions used to plot a route on a map.
     * </p>
     * <note>
     * <p>
     * LineString and Polyline are mutually exclusive properties.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineString} method.
     * </p>
     * 
     * @return An ordered list of positions used to plot a route on a map.</p> <note>
     *         <p>
     *         LineString and Polyline are mutually exclusive properties.
     *         </p>
     */
    public final List<List<Double>> lineString() {
        return lineString;
    }

    /**
     * <p>
     * Radius that defines the width of the corridor.
     * </p>
     * 
     * @return Radius that defines the width of the corridor.
     */
    public final Integer radius() {
        return radius;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLineString() ? lineString() : null);
        hashCode = 31 * hashCode + Objects.hashCode(radius());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Corridor)) {
            return false;
        }
        Corridor other = (Corridor) obj;
        return hasLineString() == other.hasLineString() && Objects.equals(lineString(), other.lineString())
                && Objects.equals(radius(), other.radius());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Corridor").add("LineString", lineString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Radius", radius()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LineString":
            return Optional.ofNullable(clazz.cast(lineString()));
        case "Radius":
            return Optional.ofNullable(clazz.cast(radius()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LineString", LINE_STRING_FIELD);
        map.put("Radius", RADIUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Corridor, T> g) {
        return obj -> g.apply((Corridor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Corridor> {
        /**
         * <p>
         * An ordered list of positions used to plot a route on a map.
         * </p>
         * <note>
         * <p>
         * LineString and Polyline are mutually exclusive properties.
         * </p>
         * </note>
         * 
         * @param lineString
         *        An ordered list of positions used to plot a route on a map.</p> <note>
         *        <p>
         *        LineString and Polyline are mutually exclusive properties.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineString(Collection<? extends Collection<Double>> lineString);

        /**
         * <p>
         * An ordered list of positions used to plot a route on a map.
         * </p>
         * <note>
         * <p>
         * LineString and Polyline are mutually exclusive properties.
         * </p>
         * </note>
         * 
         * @param lineString
         *        An ordered list of positions used to plot a route on a map.</p> <note>
         *        <p>
         *        LineString and Polyline are mutually exclusive properties.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineString(Collection<Double>... lineString);

        /**
         * <p>
         * Radius that defines the width of the corridor.
         * </p>
         * 
         * @param radius
         *        Radius that defines the width of the corridor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radius(Integer radius);
    }

    static final class BuilderImpl implements Builder {
        private List<List<Double>> lineString = DefaultSdkAutoConstructList.getInstance();

        private Integer radius;

        private BuilderImpl() {
        }

        private BuilderImpl(Corridor model) {
            lineString(model.lineString);
            radius(model.radius);
        }

        public final Collection<? extends Collection<Double>> getLineString() {
            if (lineString instanceof SdkAutoConstructList) {
                return null;
            }
            return lineString;
        }

        public final void setLineString(Collection<? extends Collection<Double>> lineString) {
            this.lineString = LineStringCopier.copy(lineString);
        }

        @Override
        public final Builder lineString(Collection<? extends Collection<Double>> lineString) {
            this.lineString = LineStringCopier.copy(lineString);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineString(Collection<Double>... lineString) {
            lineString(Arrays.asList(lineString));
            return this;
        }

        public final Integer getRadius() {
            return radius;
        }

        public final void setRadius(Integer radius) {
            this.radius = radius;
        }

        @Override
        public final Builder radius(Integer radius) {
            this.radius = radius;
            return this;
        }

        @Override
        public Corridor build() {
            return new Corridor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
