/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The area to be avoided.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IsolineAvoidanceArea implements SdkPojo, Serializable,
        ToCopyableBuilder<IsolineAvoidanceArea.Builder, IsolineAvoidanceArea> {
    private static final SdkField<List<IsolineAvoidanceAreaGeometry>> EXCEPT_FIELD = SdkField
            .<List<IsolineAvoidanceAreaGeometry>> builder(MarshallingType.LIST)
            .memberName("Except")
            .getter(getter(IsolineAvoidanceArea::except))
            .setter(setter(Builder::except))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Except").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IsolineAvoidanceAreaGeometry> builder(MarshallingType.SDK_POJO)
                                            .constructor(IsolineAvoidanceAreaGeometry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IsolineAvoidanceAreaGeometry> GEOMETRY_FIELD = SdkField
            .<IsolineAvoidanceAreaGeometry> builder(MarshallingType.SDK_POJO).memberName("Geometry")
            .getter(getter(IsolineAvoidanceArea::geometry)).setter(setter(Builder::geometry))
            .constructor(IsolineAvoidanceAreaGeometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPT_FIELD, GEOMETRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<IsolineAvoidanceAreaGeometry> except;

    private final IsolineAvoidanceAreaGeometry geometry;

    private IsolineAvoidanceArea(BuilderImpl builder) {
        this.except = builder.except;
        this.geometry = builder.geometry;
    }

    /**
     * For responses, this returns true if the service returned a value for the Except property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExcept() {
        return except != null && !(except instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Exceptions to the provided avoidance geometry, to be included while calculating an isoline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcept} method.
     * </p>
     * 
     * @return Exceptions to the provided avoidance geometry, to be included while calculating an isoline.
     */
    public final List<IsolineAvoidanceAreaGeometry> except() {
        return except;
    }

    /**
     * <p>
     * Geometry of the area to be avoided.
     * </p>
     * 
     * @return Geometry of the area to be avoided.
     */
    public final IsolineAvoidanceAreaGeometry geometry() {
        return geometry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExcept() ? except() : null);
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsolineAvoidanceArea)) {
            return false;
        }
        IsolineAvoidanceArea other = (IsolineAvoidanceArea) obj;
        return hasExcept() == other.hasExcept() && Objects.equals(except(), other.except())
                && Objects.equals(geometry(), other.geometry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IsolineAvoidanceArea").add("Except", hasExcept() ? except() : null).add("Geometry", geometry())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Except":
            return Optional.ofNullable(clazz.cast(except()));
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Except", EXCEPT_FIELD);
        map.put("Geometry", GEOMETRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IsolineAvoidanceArea, T> g) {
        return obj -> g.apply((IsolineAvoidanceArea) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IsolineAvoidanceArea> {
        /**
         * <p>
         * Exceptions to the provided avoidance geometry, to be included while calculating an isoline.
         * </p>
         * 
         * @param except
         *        Exceptions to the provided avoidance geometry, to be included while calculating an isoline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder except(Collection<IsolineAvoidanceAreaGeometry> except);

        /**
         * <p>
         * Exceptions to the provided avoidance geometry, to be included while calculating an isoline.
         * </p>
         * 
         * @param except
         *        Exceptions to the provided avoidance geometry, to be included while calculating an isoline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder except(IsolineAvoidanceAreaGeometry... except);

        /**
         * <p>
         * Exceptions to the provided avoidance geometry, to be included while calculating an isoline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.IsolineAvoidanceAreaGeometry.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.IsolineAvoidanceAreaGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.IsolineAvoidanceAreaGeometry.Builder#build()} is
         * called immediately and its result is passed to {@link #except(List<IsolineAvoidanceAreaGeometry>)}.
         * 
         * @param except
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.IsolineAvoidanceAreaGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #except(java.util.Collection<IsolineAvoidanceAreaGeometry>)
         */
        Builder except(Consumer<IsolineAvoidanceAreaGeometry.Builder>... except);

        /**
         * <p>
         * Geometry of the area to be avoided.
         * </p>
         * 
         * @param geometry
         *        Geometry of the area to be avoided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(IsolineAvoidanceAreaGeometry geometry);

        /**
         * <p>
         * Geometry of the area to be avoided.
         * </p>
         * This is a convenience method that creates an instance of the {@link IsolineAvoidanceAreaGeometry.Builder}
         * avoiding the need to create one manually via {@link IsolineAvoidanceAreaGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IsolineAvoidanceAreaGeometry.Builder#build()} is called
         * immediately and its result is passed to {@link #geometry(IsolineAvoidanceAreaGeometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link IsolineAvoidanceAreaGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(IsolineAvoidanceAreaGeometry)
         */
        default Builder geometry(Consumer<IsolineAvoidanceAreaGeometry.Builder> geometry) {
            return geometry(IsolineAvoidanceAreaGeometry.builder().applyMutation(geometry).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<IsolineAvoidanceAreaGeometry> except = DefaultSdkAutoConstructList.getInstance();

        private IsolineAvoidanceAreaGeometry geometry;

        private BuilderImpl() {
        }

        private BuilderImpl(IsolineAvoidanceArea model) {
            except(model.except);
            geometry(model.geometry);
        }

        public final List<IsolineAvoidanceAreaGeometry.Builder> getExcept() {
            List<IsolineAvoidanceAreaGeometry.Builder> result = IsolineAvoidanceAreaGeometryListCopier.copyToBuilder(this.except);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcept(Collection<IsolineAvoidanceAreaGeometry.BuilderImpl> except) {
            this.except = IsolineAvoidanceAreaGeometryListCopier.copyFromBuilder(except);
        }

        @Override
        public final Builder except(Collection<IsolineAvoidanceAreaGeometry> except) {
            this.except = IsolineAvoidanceAreaGeometryListCopier.copy(except);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder except(IsolineAvoidanceAreaGeometry... except) {
            except(Arrays.asList(except));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder except(Consumer<IsolineAvoidanceAreaGeometry.Builder>... except) {
            except(Stream.of(except).map(c -> IsolineAvoidanceAreaGeometry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final IsolineAvoidanceAreaGeometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(IsolineAvoidanceAreaGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(IsolineAvoidanceAreaGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        @Override
        public IsolineAvoidanceArea build() {
            return new IsolineAvoidanceArea(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
