/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Isoline granularity related options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IsolineGranularityOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<IsolineGranularityOptions.Builder, IsolineGranularityOptions> {
    private static final SdkField<Integer> MAX_POINTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxPoints").getter(getter(IsolineGranularityOptions::maxPoints)).setter(setter(Builder::maxPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPoints").build()).build();

    private static final SdkField<Long> MAX_RESOLUTION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxResolution").getter(getter(IsolineGranularityOptions::maxResolution))
            .setter(setter(Builder::maxResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResolution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_POINTS_FIELD,
            MAX_RESOLUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxPoints;

    private final Long maxResolution;

    private IsolineGranularityOptions(BuilderImpl builder) {
        this.maxPoints = builder.maxPoints;
        this.maxResolution = builder.maxResolution;
    }

    /**
     * <p>
     * Maximum number of points of returned Isoline.
     * </p>
     * 
     * @return Maximum number of points of returned Isoline.
     */
    public final Integer maxPoints() {
        return maxPoints;
    }

    /**
     * <p>
     * Maximum resolution of the returned isoline.
     * </p>
     * <p>
     * <b>Unit</b>: <code>meters</code>
     * </p>
     * 
     * @return Maximum resolution of the returned isoline.</p>
     *         <p>
     *         <b>Unit</b>: <code>meters</code>
     */
    public final Long maxResolution() {
        return maxResolution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxPoints());
        hashCode = 31 * hashCode + Objects.hashCode(maxResolution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsolineGranularityOptions)) {
            return false;
        }
        IsolineGranularityOptions other = (IsolineGranularityOptions) obj;
        return Objects.equals(maxPoints(), other.maxPoints()) && Objects.equals(maxResolution(), other.maxResolution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IsolineGranularityOptions").add("MaxPoints", maxPoints())
                .add("MaxResolution", maxResolution() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxPoints":
            return Optional.ofNullable(clazz.cast(maxPoints()));
        case "MaxResolution":
            return Optional.ofNullable(clazz.cast(maxResolution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxPoints", MAX_POINTS_FIELD);
        map.put("MaxResolution", MAX_RESOLUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IsolineGranularityOptions, T> g) {
        return obj -> g.apply((IsolineGranularityOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IsolineGranularityOptions> {
        /**
         * <p>
         * Maximum number of points of returned Isoline.
         * </p>
         * 
         * @param maxPoints
         *        Maximum number of points of returned Isoline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPoints(Integer maxPoints);

        /**
         * <p>
         * Maximum resolution of the returned isoline.
         * </p>
         * <p>
         * <b>Unit</b>: <code>meters</code>
         * </p>
         * 
         * @param maxResolution
         *        Maximum resolution of the returned isoline.</p>
         *        <p>
         *        <b>Unit</b>: <code>meters</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResolution(Long maxResolution);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxPoints;

        private Long maxResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(IsolineGranularityOptions model) {
            maxPoints(model.maxPoints);
            maxResolution(model.maxResolution);
        }

        public final Integer getMaxPoints() {
            return maxPoints;
        }

        public final void setMaxPoints(Integer maxPoints) {
            this.maxPoints = maxPoints;
        }

        @Override
        public final Builder maxPoints(Integer maxPoints) {
            this.maxPoints = maxPoints;
            return this;
        }

        public final Long getMaxResolution() {
            return maxResolution;
        }

        public final void setMaxResolution(Long maxResolution) {
            this.maxResolution = maxResolution;
        }

        @Override
        public final Builder maxResolution(Long maxResolution) {
            this.maxResolution = maxResolution;
            return this;
        }

        @Override
        public IsolineGranularityOptions build() {
            return new IsolineGranularityOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
