/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The vehicle license plate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IsolineVehicleLicensePlate implements SdkPojo, Serializable,
        ToCopyableBuilder<IsolineVehicleLicensePlate.Builder, IsolineVehicleLicensePlate> {
    private static final SdkField<String> LAST_CHARACTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastCharacter").getter(getter(IsolineVehicleLicensePlate::lastCharacter))
            .setter(setter(Builder::lastCharacter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCharacter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_CHARACTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lastCharacter;

    private IsolineVehicleLicensePlate(BuilderImpl builder) {
        this.lastCharacter = builder.lastCharacter;
    }

    /**
     * <p>
     * The last character of the License Plate.
     * </p>
     * 
     * @return The last character of the License Plate.
     */
    public final String lastCharacter() {
        return lastCharacter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastCharacter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsolineVehicleLicensePlate)) {
            return false;
        }
        IsolineVehicleLicensePlate other = (IsolineVehicleLicensePlate) obj;
        return Objects.equals(lastCharacter(), other.lastCharacter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IsolineVehicleLicensePlate").add("LastCharacter", lastCharacter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastCharacter":
            return Optional.ofNullable(clazz.cast(lastCharacter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LastCharacter", LAST_CHARACTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IsolineVehicleLicensePlate, T> g) {
        return obj -> g.apply((IsolineVehicleLicensePlate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IsolineVehicleLicensePlate> {
        /**
         * <p>
         * The last character of the License Plate.
         * </p>
         * 
         * @param lastCharacter
         *        The last character of the License Plate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastCharacter(String lastCharacter);
    }

    static final class BuilderImpl implements Builder {
        private String lastCharacter;

        private BuilderImpl() {
        }

        private BuilderImpl(IsolineVehicleLicensePlate model) {
            lastCharacter(model.lastCharacter);
        }

        public final String getLastCharacter() {
            return lastCharacter;
        }

        public final void setLastCharacter(String lastCharacter) {
            this.lastCharacter = lastCharacter;
        }

        @Override
        public final Builder lastCharacter(String lastCharacter) {
            this.lastCharacter = lastCharacter;
            return this;
        }

        @Override
        public IsolineVehicleLicensePlate build() {
            return new IsolineVehicleLicensePlate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
