/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptimizeWaypointsRequest extends GeoRoutesRequest implements
        ToCopyableBuilder<OptimizeWaypointsRequest.Builder, OptimizeWaypointsRequest> {
    private static final SdkField<WaypointOptimizationAvoidanceOptions> AVOID_FIELD = SdkField
            .<WaypointOptimizationAvoidanceOptions> builder(MarshallingType.SDK_POJO).memberName("Avoid")
            .getter(getter(OptimizeWaypointsRequest::avoid)).setter(setter(Builder::avoid))
            .constructor(WaypointOptimizationAvoidanceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Avoid").build()).build();

    private static final SdkField<WaypointOptimizationClusteringOptions> CLUSTERING_FIELD = SdkField
            .<WaypointOptimizationClusteringOptions> builder(MarshallingType.SDK_POJO).memberName("Clustering")
            .getter(getter(OptimizeWaypointsRequest::clustering)).setter(setter(Builder::clustering))
            .constructor(WaypointOptimizationClusteringOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clustering").build()).build();

    private static final SdkField<String> DEPARTURE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DepartureTime").getter(getter(OptimizeWaypointsRequest::departureTime))
            .setter(setter(Builder::departureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build()).build();

    private static final SdkField<List<Double>> DESTINATION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Destination")
            .getter(getter(OptimizeWaypointsRequest::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<WaypointOptimizationDestinationOptions> DESTINATION_OPTIONS_FIELD = SdkField
            .<WaypointOptimizationDestinationOptions> builder(MarshallingType.SDK_POJO).memberName("DestinationOptions")
            .getter(getter(OptimizeWaypointsRequest::destinationOptions)).setter(setter(Builder::destinationOptions))
            .constructor(WaypointOptimizationDestinationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationOptions").build())
            .build();

    private static final SdkField<WaypointOptimizationDriverOptions> DRIVER_FIELD = SdkField
            .<WaypointOptimizationDriverOptions> builder(MarshallingType.SDK_POJO).memberName("Driver")
            .getter(getter(OptimizeWaypointsRequest::driver)).setter(setter(Builder::driver))
            .constructor(WaypointOptimizationDriverOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Driver").build()).build();

    private static final SdkField<WaypointOptimizationExclusionOptions> EXCLUDE_FIELD = SdkField
            .<WaypointOptimizationExclusionOptions> builder(MarshallingType.SDK_POJO).memberName("Exclude")
            .getter(getter(OptimizeWaypointsRequest::exclude)).setter(setter(Builder::exclude))
            .constructor(WaypointOptimizationExclusionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(OptimizeWaypointsRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()).build();

    private static final SdkField<String> OPTIMIZE_SEQUENCING_FOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizeSequencingFor").getter(getter(OptimizeWaypointsRequest::optimizeSequencingForAsString))
            .setter(setter(Builder::optimizeSequencingFor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeSequencingFor").build())
            .build();

    private static final SdkField<List<Double>> ORIGIN_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Origin")
            .getter(getter(OptimizeWaypointsRequest::origin))
            .setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<WaypointOptimizationOriginOptions> ORIGIN_OPTIONS_FIELD = SdkField
            .<WaypointOptimizationOriginOptions> builder(MarshallingType.SDK_POJO).memberName("OriginOptions")
            .getter(getter(OptimizeWaypointsRequest::originOptions)).setter(setter(Builder::originOptions))
            .constructor(WaypointOptimizationOriginOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginOptions").build()).build();

    private static final SdkField<WaypointOptimizationTrafficOptions> TRAFFIC_FIELD = SdkField
            .<WaypointOptimizationTrafficOptions> builder(MarshallingType.SDK_POJO).memberName("Traffic")
            .getter(getter(OptimizeWaypointsRequest::traffic)).setter(setter(Builder::traffic))
            .constructor(WaypointOptimizationTrafficOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traffic").build()).build();

    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TravelMode").getter(getter(OptimizeWaypointsRequest::travelModeAsString))
            .setter(setter(Builder::travelMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()).build();

    private static final SdkField<WaypointOptimizationTravelModeOptions> TRAVEL_MODE_OPTIONS_FIELD = SdkField
            .<WaypointOptimizationTravelModeOptions> builder(MarshallingType.SDK_POJO).memberName("TravelModeOptions")
            .getter(getter(OptimizeWaypointsRequest::travelModeOptions)).setter(setter(Builder::travelModeOptions))
            .constructor(WaypointOptimizationTravelModeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelModeOptions").build()).build();

    private static final SdkField<List<WaypointOptimizationWaypoint>> WAYPOINTS_FIELD = SdkField
            .<List<WaypointOptimizationWaypoint>> builder(MarshallingType.LIST)
            .memberName("Waypoints")
            .getter(getter(OptimizeWaypointsRequest::waypoints))
            .setter(setter(Builder::waypoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Waypoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WaypointOptimizationWaypoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(WaypointOptimizationWaypoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVOID_FIELD, CLUSTERING_FIELD,
            DEPARTURE_TIME_FIELD, DESTINATION_FIELD, DESTINATION_OPTIONS_FIELD, DRIVER_FIELD, EXCLUDE_FIELD, KEY_FIELD,
            OPTIMIZE_SEQUENCING_FOR_FIELD, ORIGIN_FIELD, ORIGIN_OPTIONS_FIELD, TRAFFIC_FIELD, TRAVEL_MODE_FIELD,
            TRAVEL_MODE_OPTIONS_FIELD, WAYPOINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WaypointOptimizationAvoidanceOptions avoid;

    private final WaypointOptimizationClusteringOptions clustering;

    private final String departureTime;

    private final List<Double> destination;

    private final WaypointOptimizationDestinationOptions destinationOptions;

    private final WaypointOptimizationDriverOptions driver;

    private final WaypointOptimizationExclusionOptions exclude;

    private final String key;

    private final String optimizeSequencingFor;

    private final List<Double> origin;

    private final WaypointOptimizationOriginOptions originOptions;

    private final WaypointOptimizationTrafficOptions traffic;

    private final String travelMode;

    private final WaypointOptimizationTravelModeOptions travelModeOptions;

    private final List<WaypointOptimizationWaypoint> waypoints;

    private OptimizeWaypointsRequest(BuilderImpl builder) {
        super(builder);
        this.avoid = builder.avoid;
        this.clustering = builder.clustering;
        this.departureTime = builder.departureTime;
        this.destination = builder.destination;
        this.destinationOptions = builder.destinationOptions;
        this.driver = builder.driver;
        this.exclude = builder.exclude;
        this.key = builder.key;
        this.optimizeSequencingFor = builder.optimizeSequencingFor;
        this.origin = builder.origin;
        this.originOptions = builder.originOptions;
        this.traffic = builder.traffic;
        this.travelMode = builder.travelMode;
        this.travelModeOptions = builder.travelModeOptions;
        this.waypoints = builder.waypoints;
    }

    /**
     * <p>
     * Features that are avoided. Avoidance is on a best-case basis. If an avoidance can't be satisfied for a particular
     * case, this setting is ignored.
     * </p>
     * 
     * @return Features that are avoided. Avoidance is on a best-case basis. If an avoidance can't be satisfied for a
     *         particular case, this setting is ignored.
     */
    public final WaypointOptimizationAvoidanceOptions avoid() {
        return avoid;
    }

    /**
     * <p>
     * Clustering allows you to specify how nearby waypoints can be clustered to improve the optimized sequence.
     * </p>
     * 
     * @return Clustering allows you to specify how nearby waypoints can be clustered to improve the optimized sequence.
     */
    public final WaypointOptimizationClusteringOptions clustering() {
        return clustering;
    }

    /**
     * <p>
     * Departure time from the waypoint.
     * </p>
     * <p>
     * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     * </p>
     * <p>
     * Examples:
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24Z</code>
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24+02:00</code>
     * </p>
     * 
     * @return Departure time from the waypoint.</p>
     *         <p>
     *         Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     *         </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24Z</code>
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24+02:00</code>
     */
    public final String departureTime() {
        return departureTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destination property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestination() {
        return destination != null && !(destination instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The final position for the route in the World Geodetic System (WGS 84) format: <code>[longitude, latitude]</code>
     * .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestination} method.
     * </p>
     * 
     * @return The final position for the route in the World Geodetic System (WGS 84) format:
     *         <code>[longitude, latitude]</code>.
     */
    public final List<Double> destination() {
        return destination;
    }

    /**
     * <p>
     * Destination related options.
     * </p>
     * 
     * @return Destination related options.
     */
    public final WaypointOptimizationDestinationOptions destinationOptions() {
        return destinationOptions;
    }

    /**
     * <p>
     * Driver related options.
     * </p>
     * 
     * @return Driver related options.
     */
    public final WaypointOptimizationDriverOptions driver() {
        return driver;
    }

    /**
     * <p>
     * Features to be strictly excluded while calculating the route.
     * </p>
     * 
     * @return Features to be strictly excluded while calculating the route.
     */
    public final WaypointOptimizationExclusionOptions exclude() {
        return exclude;
    }

    /**
     * <p>
     * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be provided
     * when making a request.
     * </p>
     * 
     * @return Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
     *         provided when making a request.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * Specifies the optimization criteria for the calculated sequence.
     * </p>
     * <p>
     * Default Value: <code>FastestRoute</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizeSequencingFor} will return {@link WaypointOptimizationSequencingObjective#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #optimizeSequencingForAsString}.
     * </p>
     * 
     * @return Specifies the optimization criteria for the calculated sequence.</p>
     *         <p>
     *         Default Value: <code>FastestRoute</code>.
     * @see WaypointOptimizationSequencingObjective
     */
    public final WaypointOptimizationSequencingObjective optimizeSequencingFor() {
        return WaypointOptimizationSequencingObjective.fromValue(optimizeSequencingFor);
    }

    /**
     * <p>
     * Specifies the optimization criteria for the calculated sequence.
     * </p>
     * <p>
     * Default Value: <code>FastestRoute</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizeSequencingFor} will return {@link WaypointOptimizationSequencingObjective#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #optimizeSequencingForAsString}.
     * </p>
     * 
     * @return Specifies the optimization criteria for the calculated sequence.</p>
     *         <p>
     *         Default Value: <code>FastestRoute</code>.
     * @see WaypointOptimizationSequencingObjective
     */
    public final String optimizeSequencingForAsString() {
        return optimizeSequencingFor;
    }

    /**
     * For responses, this returns true if the service returned a value for the Origin property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOrigin() {
        return origin != null && !(origin instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The start position for the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrigin} method.
     * </p>
     * 
     * @return The start position for the route.
     */
    public final List<Double> origin() {
        return origin;
    }

    /**
     * <p>
     * Origin related options.
     * </p>
     * 
     * @return Origin related options.
     */
    public final WaypointOptimizationOriginOptions originOptions() {
        return originOptions;
    }

    /**
     * <p>
     * Traffic-related options.
     * </p>
     * 
     * @return Traffic-related options.
     */
    public final WaypointOptimizationTrafficOptions traffic() {
        return traffic;
    }

    /**
     * <p>
     * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     * compatibility.
     * </p>
     * <p>
     * Default Value: <code>Car</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #travelMode} will
     * return {@link WaypointOptimizationTravelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #travelModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     *         compatibility.</p>
     *         <p>
     *         Default Value: <code>Car</code>
     * @see WaypointOptimizationTravelMode
     */
    public final WaypointOptimizationTravelMode travelMode() {
        return WaypointOptimizationTravelMode.fromValue(travelMode);
    }

    /**
     * <p>
     * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     * compatibility.
     * </p>
     * <p>
     * Default Value: <code>Car</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #travelMode} will
     * return {@link WaypointOptimizationTravelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #travelModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     *         compatibility.</p>
     *         <p>
     *         Default Value: <code>Car</code>
     * @see WaypointOptimizationTravelMode
     */
    public final String travelModeAsString() {
        return travelMode;
    }

    /**
     * <p>
     * Travel mode related options for the provided travel mode.
     * </p>
     * 
     * @return Travel mode related options for the provided travel mode.
     */
    public final WaypointOptimizationTravelModeOptions travelModeOptions() {
        return travelModeOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Waypoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWaypoints() {
        return waypoints != null && !(waypoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of waypoints between the <code>Origin</code> and <code>Destination</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWaypoints} method.
     * </p>
     * 
     * @return List of waypoints between the <code>Origin</code> and <code>Destination</code>.
     */
    public final List<WaypointOptimizationWaypoint> waypoints() {
        return waypoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(avoid());
        hashCode = 31 * hashCode + Objects.hashCode(clustering());
        hashCode = 31 * hashCode + Objects.hashCode(departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestination() ? destination() : null);
        hashCode = 31 * hashCode + Objects.hashCode(destinationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(driver());
        hashCode = 31 * hashCode + Objects.hashCode(exclude());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(optimizeSequencingForAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrigin() ? origin() : null);
        hashCode = 31 * hashCode + Objects.hashCode(originOptions());
        hashCode = 31 * hashCode + Objects.hashCode(traffic());
        hashCode = 31 * hashCode + Objects.hashCode(travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(travelModeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasWaypoints() ? waypoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizeWaypointsRequest)) {
            return false;
        }
        OptimizeWaypointsRequest other = (OptimizeWaypointsRequest) obj;
        return Objects.equals(avoid(), other.avoid()) && Objects.equals(clustering(), other.clustering())
                && Objects.equals(departureTime(), other.departureTime()) && hasDestination() == other.hasDestination()
                && Objects.equals(destination(), other.destination())
                && Objects.equals(destinationOptions(), other.destinationOptions()) && Objects.equals(driver(), other.driver())
                && Objects.equals(exclude(), other.exclude()) && Objects.equals(key(), other.key())
                && Objects.equals(optimizeSequencingForAsString(), other.optimizeSequencingForAsString())
                && hasOrigin() == other.hasOrigin() && Objects.equals(origin(), other.origin())
                && Objects.equals(originOptions(), other.originOptions()) && Objects.equals(traffic(), other.traffic())
                && Objects.equals(travelModeAsString(), other.travelModeAsString())
                && Objects.equals(travelModeOptions(), other.travelModeOptions()) && hasWaypoints() == other.hasWaypoints()
                && Objects.equals(waypoints(), other.waypoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptimizeWaypointsRequest").add("Avoid", avoid()).add("Clustering", clustering())
                .add("DepartureTime", departureTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Destination", destination() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DestinationOptions", destinationOptions()).add("Driver", driver()).add("Exclude", exclude())
                .add("Key", key() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OptimizeSequencingFor", optimizeSequencingForAsString())
                .add("Origin", origin() == null ? null : "*** Sensitive Data Redacted ***").add("OriginOptions", originOptions())
                .add("Traffic", traffic()).add("TravelMode", travelModeAsString()).add("TravelModeOptions", travelModeOptions())
                .add("Waypoints", hasWaypoints() ? waypoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Avoid":
            return Optional.ofNullable(clazz.cast(avoid()));
        case "Clustering":
            return Optional.ofNullable(clazz.cast(clustering()));
        case "DepartureTime":
            return Optional.ofNullable(clazz.cast(departureTime()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationOptions":
            return Optional.ofNullable(clazz.cast(destinationOptions()));
        case "Driver":
            return Optional.ofNullable(clazz.cast(driver()));
        case "Exclude":
            return Optional.ofNullable(clazz.cast(exclude()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "OptimizeSequencingFor":
            return Optional.ofNullable(clazz.cast(optimizeSequencingForAsString()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(origin()));
        case "OriginOptions":
            return Optional.ofNullable(clazz.cast(originOptions()));
        case "Traffic":
            return Optional.ofNullable(clazz.cast(traffic()));
        case "TravelMode":
            return Optional.ofNullable(clazz.cast(travelModeAsString()));
        case "TravelModeOptions":
            return Optional.ofNullable(clazz.cast(travelModeOptions()));
        case "Waypoints":
            return Optional.ofNullable(clazz.cast(waypoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Avoid", AVOID_FIELD);
        map.put("Clustering", CLUSTERING_FIELD);
        map.put("DepartureTime", DEPARTURE_TIME_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("DestinationOptions", DESTINATION_OPTIONS_FIELD);
        map.put("Driver", DRIVER_FIELD);
        map.put("Exclude", EXCLUDE_FIELD);
        map.put("key", KEY_FIELD);
        map.put("OptimizeSequencingFor", OPTIMIZE_SEQUENCING_FOR_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("OriginOptions", ORIGIN_OPTIONS_FIELD);
        map.put("Traffic", TRAFFIC_FIELD);
        map.put("TravelMode", TRAVEL_MODE_FIELD);
        map.put("TravelModeOptions", TRAVEL_MODE_OPTIONS_FIELD);
        map.put("Waypoints", WAYPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizeWaypointsRequest, T> g) {
        return obj -> g.apply((OptimizeWaypointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GeoRoutesRequest.Builder, SdkPojo, CopyableBuilder<Builder, OptimizeWaypointsRequest> {
        /**
         * <p>
         * Features that are avoided. Avoidance is on a best-case basis. If an avoidance can't be satisfied for a
         * particular case, this setting is ignored.
         * </p>
         * 
         * @param avoid
         *        Features that are avoided. Avoidance is on a best-case basis. If an avoidance can't be satisfied for a
         *        particular case, this setting is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avoid(WaypointOptimizationAvoidanceOptions avoid);

        /**
         * <p>
         * Features that are avoided. Avoidance is on a best-case basis. If an avoidance can't be satisfied for a
         * particular case, this setting is ignored.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationAvoidanceOptions.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationAvoidanceOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationAvoidanceOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #avoid(WaypointOptimizationAvoidanceOptions)}.
         * 
         * @param avoid
         *        a consumer that will call methods on {@link WaypointOptimizationAvoidanceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #avoid(WaypointOptimizationAvoidanceOptions)
         */
        default Builder avoid(Consumer<WaypointOptimizationAvoidanceOptions.Builder> avoid) {
            return avoid(WaypointOptimizationAvoidanceOptions.builder().applyMutation(avoid).build());
        }

        /**
         * <p>
         * Clustering allows you to specify how nearby waypoints can be clustered to improve the optimized sequence.
         * </p>
         * 
         * @param clustering
         *        Clustering allows you to specify how nearby waypoints can be clustered to improve the optimized
         *        sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clustering(WaypointOptimizationClusteringOptions clustering);

        /**
         * <p>
         * Clustering allows you to specify how nearby waypoints can be clustered to improve the optimized sequence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationClusteringOptions.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationClusteringOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationClusteringOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #clustering(WaypointOptimizationClusteringOptions)}.
         * 
         * @param clustering
         *        a consumer that will call methods on {@link WaypointOptimizationClusteringOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clustering(WaypointOptimizationClusteringOptions)
         */
        default Builder clustering(Consumer<WaypointOptimizationClusteringOptions.Builder> clustering) {
            return clustering(WaypointOptimizationClusteringOptions.builder().applyMutation(clustering).build());
        }

        /**
         * <p>
         * Departure time from the waypoint.
         * </p>
         * <p>
         * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         * </p>
         * <p>
         * Examples:
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24Z</code>
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24+02:00</code>
         * </p>
         * 
         * @param departureTime
         *        Departure time from the waypoint.</p>
         *        <p>
         *        Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         *        </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24Z</code>
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24+02:00</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder departureTime(String departureTime);

        /**
         * <p>
         * The final position for the route in the World Geodetic System (WGS 84) format:
         * <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param destination
         *        The final position for the route in the World Geodetic System (WGS 84) format:
         *        <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Collection<Double> destination);

        /**
         * <p>
         * The final position for the route in the World Geodetic System (WGS 84) format:
         * <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param destination
         *        The final position for the route in the World Geodetic System (WGS 84) format:
         *        <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Double... destination);

        /**
         * <p>
         * Destination related options.
         * </p>
         * 
         * @param destinationOptions
         *        Destination related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationOptions(WaypointOptimizationDestinationOptions destinationOptions);

        /**
         * <p>
         * Destination related options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationDestinationOptions.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationDestinationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationDestinationOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationOptions(WaypointOptimizationDestinationOptions)}.
         * 
         * @param destinationOptions
         *        a consumer that will call methods on {@link WaypointOptimizationDestinationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationOptions(WaypointOptimizationDestinationOptions)
         */
        default Builder destinationOptions(Consumer<WaypointOptimizationDestinationOptions.Builder> destinationOptions) {
            return destinationOptions(WaypointOptimizationDestinationOptions.builder().applyMutation(destinationOptions).build());
        }

        /**
         * <p>
         * Driver related options.
         * </p>
         * 
         * @param driver
         *        Driver related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driver(WaypointOptimizationDriverOptions driver);

        /**
         * <p>
         * Driver related options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationDriverOptions.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationDriverOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationDriverOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #driver(WaypointOptimizationDriverOptions)}.
         * 
         * @param driver
         *        a consumer that will call methods on {@link WaypointOptimizationDriverOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #driver(WaypointOptimizationDriverOptions)
         */
        default Builder driver(Consumer<WaypointOptimizationDriverOptions.Builder> driver) {
            return driver(WaypointOptimizationDriverOptions.builder().applyMutation(driver).build());
        }

        /**
         * <p>
         * Features to be strictly excluded while calculating the route.
         * </p>
         * 
         * @param exclude
         *        Features to be strictly excluded while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclude(WaypointOptimizationExclusionOptions exclude);

        /**
         * <p>
         * Features to be strictly excluded while calculating the route.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationExclusionOptions.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationExclusionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationExclusionOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #exclude(WaypointOptimizationExclusionOptions)}.
         * 
         * @param exclude
         *        a consumer that will call methods on {@link WaypointOptimizationExclusionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exclude(WaypointOptimizationExclusionOptions)
         */
        default Builder exclude(Consumer<WaypointOptimizationExclusionOptions.Builder> exclude) {
            return exclude(WaypointOptimizationExclusionOptions.builder().applyMutation(exclude).build());
        }

        /**
         * <p>
         * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         * provided when making a request.
         * </p>
         * 
         * @param key
         *        Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         *        provided when making a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Specifies the optimization criteria for the calculated sequence.
         * </p>
         * <p>
         * Default Value: <code>FastestRoute</code>.
         * </p>
         * 
         * @param optimizeSequencingFor
         *        Specifies the optimization criteria for the calculated sequence.</p>
         *        <p>
         *        Default Value: <code>FastestRoute</code>.
         * @see WaypointOptimizationSequencingObjective
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaypointOptimizationSequencingObjective
         */
        Builder optimizeSequencingFor(String optimizeSequencingFor);

        /**
         * <p>
         * Specifies the optimization criteria for the calculated sequence.
         * </p>
         * <p>
         * Default Value: <code>FastestRoute</code>.
         * </p>
         * 
         * @param optimizeSequencingFor
         *        Specifies the optimization criteria for the calculated sequence.</p>
         *        <p>
         *        Default Value: <code>FastestRoute</code>.
         * @see WaypointOptimizationSequencingObjective
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaypointOptimizationSequencingObjective
         */
        Builder optimizeSequencingFor(WaypointOptimizationSequencingObjective optimizeSequencingFor);

        /**
         * <p>
         * The start position for the route.
         * </p>
         * 
         * @param origin
         *        The start position for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(Collection<Double> origin);

        /**
         * <p>
         * The start position for the route.
         * </p>
         * 
         * @param origin
         *        The start position for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(Double... origin);

        /**
         * <p>
         * Origin related options.
         * </p>
         * 
         * @param originOptions
         *        Origin related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originOptions(WaypointOptimizationOriginOptions originOptions);

        /**
         * <p>
         * Origin related options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationOriginOptions.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationOriginOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationOriginOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #originOptions(WaypointOptimizationOriginOptions)}.
         * 
         * @param originOptions
         *        a consumer that will call methods on {@link WaypointOptimizationOriginOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originOptions(WaypointOptimizationOriginOptions)
         */
        default Builder originOptions(Consumer<WaypointOptimizationOriginOptions.Builder> originOptions) {
            return originOptions(WaypointOptimizationOriginOptions.builder().applyMutation(originOptions).build());
        }

        /**
         * <p>
         * Traffic-related options.
         * </p>
         * 
         * @param traffic
         *        Traffic-related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traffic(WaypointOptimizationTrafficOptions traffic);

        /**
         * <p>
         * Traffic-related options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationTrafficOptions.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationTrafficOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationTrafficOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #traffic(WaypointOptimizationTrafficOptions)}.
         * 
         * @param traffic
         *        a consumer that will call methods on {@link WaypointOptimizationTrafficOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traffic(WaypointOptimizationTrafficOptions)
         */
        default Builder traffic(Consumer<WaypointOptimizationTrafficOptions.Builder> traffic) {
            return traffic(WaypointOptimizationTrafficOptions.builder().applyMutation(traffic).build());
        }

        /**
         * <p>
         * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
         * compatibility.
         * </p>
         * <p>
         * Default Value: <code>Car</code>
         * </p>
         * 
         * @param travelMode
         *        Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and
         *        road compatibility.</p>
         *        <p>
         *        Default Value: <code>Car</code>
         * @see WaypointOptimizationTravelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaypointOptimizationTravelMode
         */
        Builder travelMode(String travelMode);

        /**
         * <p>
         * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
         * compatibility.
         * </p>
         * <p>
         * Default Value: <code>Car</code>
         * </p>
         * 
         * @param travelMode
         *        Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and
         *        road compatibility.</p>
         *        <p>
         *        Default Value: <code>Car</code>
         * @see WaypointOptimizationTravelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaypointOptimizationTravelMode
         */
        Builder travelMode(WaypointOptimizationTravelMode travelMode);

        /**
         * <p>
         * Travel mode related options for the provided travel mode.
         * </p>
         * 
         * @param travelModeOptions
         *        Travel mode related options for the provided travel mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelModeOptions(WaypointOptimizationTravelModeOptions travelModeOptions);

        /**
         * <p>
         * Travel mode related options for the provided travel mode.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationTravelModeOptions.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationTravelModeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationTravelModeOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #travelModeOptions(WaypointOptimizationTravelModeOptions)}.
         * 
         * @param travelModeOptions
         *        a consumer that will call methods on {@link WaypointOptimizationTravelModeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #travelModeOptions(WaypointOptimizationTravelModeOptions)
         */
        default Builder travelModeOptions(Consumer<WaypointOptimizationTravelModeOptions.Builder> travelModeOptions) {
            return travelModeOptions(WaypointOptimizationTravelModeOptions.builder().applyMutation(travelModeOptions).build());
        }

        /**
         * <p>
         * List of waypoints between the <code>Origin</code> and <code>Destination</code>.
         * </p>
         * 
         * @param waypoints
         *        List of waypoints between the <code>Origin</code> and <code>Destination</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waypoints(Collection<WaypointOptimizationWaypoint> waypoints);

        /**
         * <p>
         * List of waypoints between the <code>Origin</code> and <code>Destination</code>.
         * </p>
         * 
         * @param waypoints
         *        List of waypoints between the <code>Origin</code> and <code>Destination</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waypoints(WaypointOptimizationWaypoint... waypoints);

        /**
         * <p>
         * List of waypoints between the <code>Origin</code> and <code>Destination</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationWaypoint.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationWaypoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationWaypoint.Builder#build()} is
         * called immediately and its result is passed to {@link #waypoints(List<WaypointOptimizationWaypoint>)}.
         * 
         * @param waypoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationWaypoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waypoints(java.util.Collection<WaypointOptimizationWaypoint>)
         */
        Builder waypoints(Consumer<WaypointOptimizationWaypoint.Builder>... waypoints);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GeoRoutesRequest.BuilderImpl implements Builder {
        private WaypointOptimizationAvoidanceOptions avoid;

        private WaypointOptimizationClusteringOptions clustering;

        private String departureTime;

        private List<Double> destination = DefaultSdkAutoConstructList.getInstance();

        private WaypointOptimizationDestinationOptions destinationOptions;

        private WaypointOptimizationDriverOptions driver;

        private WaypointOptimizationExclusionOptions exclude;

        private String key;

        private String optimizeSequencingFor;

        private List<Double> origin = DefaultSdkAutoConstructList.getInstance();

        private WaypointOptimizationOriginOptions originOptions;

        private WaypointOptimizationTrafficOptions traffic;

        private String travelMode;

        private WaypointOptimizationTravelModeOptions travelModeOptions;

        private List<WaypointOptimizationWaypoint> waypoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizeWaypointsRequest model) {
            super(model);
            avoid(model.avoid);
            clustering(model.clustering);
            departureTime(model.departureTime);
            destination(model.destination);
            destinationOptions(model.destinationOptions);
            driver(model.driver);
            exclude(model.exclude);
            key(model.key);
            optimizeSequencingFor(model.optimizeSequencingFor);
            origin(model.origin);
            originOptions(model.originOptions);
            traffic(model.traffic);
            travelMode(model.travelMode);
            travelModeOptions(model.travelModeOptions);
            waypoints(model.waypoints);
        }

        public final WaypointOptimizationAvoidanceOptions.Builder getAvoid() {
            return avoid != null ? avoid.toBuilder() : null;
        }

        public final void setAvoid(WaypointOptimizationAvoidanceOptions.BuilderImpl avoid) {
            this.avoid = avoid != null ? avoid.build() : null;
        }

        @Override
        public final Builder avoid(WaypointOptimizationAvoidanceOptions avoid) {
            this.avoid = avoid;
            return this;
        }

        public final WaypointOptimizationClusteringOptions.Builder getClustering() {
            return clustering != null ? clustering.toBuilder() : null;
        }

        public final void setClustering(WaypointOptimizationClusteringOptions.BuilderImpl clustering) {
            this.clustering = clustering != null ? clustering.build() : null;
        }

        @Override
        public final Builder clustering(WaypointOptimizationClusteringOptions clustering) {
            this.clustering = clustering;
            return this;
        }

        public final String getDepartureTime() {
            return departureTime;
        }

        public final void setDepartureTime(String departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(String departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final Collection<Double> getDestination() {
            if (destination instanceof SdkAutoConstructList) {
                return null;
            }
            return destination;
        }

        public final void setDestination(Collection<Double> destination) {
            this.destination = PositionCopier.copy(destination);
        }

        @Override
        public final Builder destination(Collection<Double> destination) {
            this.destination = PositionCopier.copy(destination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destination(Double... destination) {
            destination(Arrays.asList(destination));
            return this;
        }

        public final WaypointOptimizationDestinationOptions.Builder getDestinationOptions() {
            return destinationOptions != null ? destinationOptions.toBuilder() : null;
        }

        public final void setDestinationOptions(WaypointOptimizationDestinationOptions.BuilderImpl destinationOptions) {
            this.destinationOptions = destinationOptions != null ? destinationOptions.build() : null;
        }

        @Override
        public final Builder destinationOptions(WaypointOptimizationDestinationOptions destinationOptions) {
            this.destinationOptions = destinationOptions;
            return this;
        }

        public final WaypointOptimizationDriverOptions.Builder getDriver() {
            return driver != null ? driver.toBuilder() : null;
        }

        public final void setDriver(WaypointOptimizationDriverOptions.BuilderImpl driver) {
            this.driver = driver != null ? driver.build() : null;
        }

        @Override
        public final Builder driver(WaypointOptimizationDriverOptions driver) {
            this.driver = driver;
            return this;
        }

        public final WaypointOptimizationExclusionOptions.Builder getExclude() {
            return exclude != null ? exclude.toBuilder() : null;
        }

        public final void setExclude(WaypointOptimizationExclusionOptions.BuilderImpl exclude) {
            this.exclude = exclude != null ? exclude.build() : null;
        }

        @Override
        public final Builder exclude(WaypointOptimizationExclusionOptions exclude) {
            this.exclude = exclude;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getOptimizeSequencingFor() {
            return optimizeSequencingFor;
        }

        public final void setOptimizeSequencingFor(String optimizeSequencingFor) {
            this.optimizeSequencingFor = optimizeSequencingFor;
        }

        @Override
        public final Builder optimizeSequencingFor(String optimizeSequencingFor) {
            this.optimizeSequencingFor = optimizeSequencingFor;
            return this;
        }

        @Override
        public final Builder optimizeSequencingFor(WaypointOptimizationSequencingObjective optimizeSequencingFor) {
            this.optimizeSequencingFor(optimizeSequencingFor == null ? null : optimizeSequencingFor.toString());
            return this;
        }

        public final Collection<Double> getOrigin() {
            if (origin instanceof SdkAutoConstructList) {
                return null;
            }
            return origin;
        }

        public final void setOrigin(Collection<Double> origin) {
            this.origin = PositionCopier.copy(origin);
        }

        @Override
        public final Builder origin(Collection<Double> origin) {
            this.origin = PositionCopier.copy(origin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder origin(Double... origin) {
            origin(Arrays.asList(origin));
            return this;
        }

        public final WaypointOptimizationOriginOptions.Builder getOriginOptions() {
            return originOptions != null ? originOptions.toBuilder() : null;
        }

        public final void setOriginOptions(WaypointOptimizationOriginOptions.BuilderImpl originOptions) {
            this.originOptions = originOptions != null ? originOptions.build() : null;
        }

        @Override
        public final Builder originOptions(WaypointOptimizationOriginOptions originOptions) {
            this.originOptions = originOptions;
            return this;
        }

        public final WaypointOptimizationTrafficOptions.Builder getTraffic() {
            return traffic != null ? traffic.toBuilder() : null;
        }

        public final void setTraffic(WaypointOptimizationTrafficOptions.BuilderImpl traffic) {
            this.traffic = traffic != null ? traffic.build() : null;
        }

        @Override
        public final Builder traffic(WaypointOptimizationTrafficOptions traffic) {
            this.traffic = traffic;
            return this;
        }

        public final String getTravelMode() {
            return travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        public final Builder travelMode(WaypointOptimizationTravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final WaypointOptimizationTravelModeOptions.Builder getTravelModeOptions() {
            return travelModeOptions != null ? travelModeOptions.toBuilder() : null;
        }

        public final void setTravelModeOptions(WaypointOptimizationTravelModeOptions.BuilderImpl travelModeOptions) {
            this.travelModeOptions = travelModeOptions != null ? travelModeOptions.build() : null;
        }

        @Override
        public final Builder travelModeOptions(WaypointOptimizationTravelModeOptions travelModeOptions) {
            this.travelModeOptions = travelModeOptions;
            return this;
        }

        public final List<WaypointOptimizationWaypoint.Builder> getWaypoints() {
            List<WaypointOptimizationWaypoint.Builder> result = WaypointOptimizationWaypointListCopier
                    .copyToBuilder(this.waypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWaypoints(Collection<WaypointOptimizationWaypoint.BuilderImpl> waypoints) {
            this.waypoints = WaypointOptimizationWaypointListCopier.copyFromBuilder(waypoints);
        }

        @Override
        public final Builder waypoints(Collection<WaypointOptimizationWaypoint> waypoints) {
            this.waypoints = WaypointOptimizationWaypointListCopier.copy(waypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waypoints(WaypointOptimizationWaypoint... waypoints) {
            waypoints(Arrays.asList(waypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waypoints(Consumer<WaypointOptimizationWaypoint.Builder>... waypoints) {
            waypoints(Stream.of(waypoints).map(c -> WaypointOptimizationWaypoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OptimizeWaypointsRequest build() {
            return new OptimizeWaypointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
