/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Notices provide information around factors that may have influenced snapping in a manner atypical to the standard use
 * cases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoadSnapNotice implements SdkPojo, Serializable, ToCopyableBuilder<RoadSnapNotice.Builder, RoadSnapNotice> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(RoadSnapNotice::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(RoadSnapNotice::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<List<Integer>> TRACE_POINT_INDEXES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("TracePointIndexes")
            .getter(getter(RoadSnapNotice::tracePointIndexes))
            .setter(setter(Builder::tracePointIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracePointIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, TITLE_FIELD,
            TRACE_POINT_INDEXES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String title;

    private final List<Integer> tracePointIndexes;

    private RoadSnapNotice(BuilderImpl builder) {
        this.code = builder.code;
        this.title = builder.title;
        this.tracePointIndexes = builder.tracePointIndexes;
    }

    /**
     * <p>
     * Code corresponding to the issue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link RoadSnapNoticeCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return Code corresponding to the issue.
     * @see RoadSnapNoticeCode
     */
    public final RoadSnapNoticeCode code() {
        return RoadSnapNoticeCode.fromValue(code);
    }

    /**
     * <p>
     * Code corresponding to the issue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link RoadSnapNoticeCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return Code corresponding to the issue.
     * @see RoadSnapNoticeCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * The notice title.
     * </p>
     * 
     * @return The notice title.
     */
    public final String title() {
        return title;
    }

    /**
     * For responses, this returns true if the service returned a value for the TracePointIndexes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTracePointIndexes() {
        return tracePointIndexes != null && !(tracePointIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * TracePoint indices for which the provided notice code corresponds to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTracePointIndexes} method.
     * </p>
     * 
     * @return TracePoint indices for which the provided notice code corresponds to.
     */
    public final List<Integer> tracePointIndexes() {
        return tracePointIndexes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(hasTracePointIndexes() ? tracePointIndexes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoadSnapNotice)) {
            return false;
        }
        RoadSnapNotice other = (RoadSnapNotice) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(title(), other.title())
                && hasTracePointIndexes() == other.hasTracePointIndexes()
                && Objects.equals(tracePointIndexes(), other.tracePointIndexes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoadSnapNotice").add("Code", codeAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TracePointIndexes", tracePointIndexes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "TracePointIndexes":
            return Optional.ofNullable(clazz.cast(tracePointIndexes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Code", CODE_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("TracePointIndexes", TRACE_POINT_INDEXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoadSnapNotice, T> g) {
        return obj -> g.apply((RoadSnapNotice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoadSnapNotice> {
        /**
         * <p>
         * Code corresponding to the issue.
         * </p>
         * 
         * @param code
         *        Code corresponding to the issue.
         * @see RoadSnapNoticeCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoadSnapNoticeCode
         */
        Builder code(String code);

        /**
         * <p>
         * Code corresponding to the issue.
         * </p>
         * 
         * @param code
         *        Code corresponding to the issue.
         * @see RoadSnapNoticeCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoadSnapNoticeCode
         */
        Builder code(RoadSnapNoticeCode code);

        /**
         * <p>
         * The notice title.
         * </p>
         * 
         * @param title
         *        The notice title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * TracePoint indices for which the provided notice code corresponds to.
         * </p>
         * 
         * @param tracePointIndexes
         *        TracePoint indices for which the provided notice code corresponds to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracePointIndexes(Collection<Integer> tracePointIndexes);

        /**
         * <p>
         * TracePoint indices for which the provided notice code corresponds to.
         * </p>
         * 
         * @param tracePointIndexes
         *        TracePoint indices for which the provided notice code corresponds to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracePointIndexes(Integer... tracePointIndexes);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String title;

        private List<Integer> tracePointIndexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoadSnapNotice model) {
            code(model.code);
            title(model.title);
            tracePointIndexes(model.tracePointIndexes);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(RoadSnapNoticeCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Collection<Integer> getTracePointIndexes() {
            if (tracePointIndexes instanceof SdkAutoConstructList) {
                return null;
            }
            return tracePointIndexes;
        }

        public final void setTracePointIndexes(Collection<Integer> tracePointIndexes) {
            this.tracePointIndexes = RoadSnapTracePointIndexListCopier.copy(tracePointIndexes);
        }

        @Override
        public final Builder tracePointIndexes(Collection<Integer> tracePointIndexes) {
            this.tracePointIndexes = RoadSnapTracePointIndexListCopier.copy(tracePointIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracePointIndexes(Integer... tracePointIndexes) {
            tracePointIndexes(Arrays.asList(tracePointIndexes));
            return this;
        }

        @Override
        public RoadSnapNotice build() {
            return new RoadSnapNotice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
