/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Type of the emission.
 * </p>
 * <p>
 * <b>Valid values</b>: <code>Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteEmissionType implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteEmissionType.Builder, RouteEmissionType> {
    private static final SdkField<String> CO2_EMISSION_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Co2EmissionClass").getter(getter(RouteEmissionType::co2EmissionClass))
            .setter(setter(Builder::co2EmissionClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Co2EmissionClass").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RouteEmissionType::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CO2_EMISSION_CLASS_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String co2EmissionClass;

    private final String type;

    private RouteEmissionType(BuilderImpl builder) {
        this.co2EmissionClass = builder.co2EmissionClass;
        this.type = builder.type;
    }

    /**
     * <p>
     * The CO 2 emission classes.
     * </p>
     * 
     * @return The CO 2 emission classes.
     */
    public final String co2EmissionClass() {
        return co2EmissionClass;
    }

    /**
     * <p>
     * Type of the emission.
     * </p>
     * <p>
     * <b>Valid values</b>: <code>Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev</code>
     * </p>
     * 
     * @return Type of the emission.</p>
     *         <p>
     *         <b>Valid values</b>: <code>Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev</code>
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(co2EmissionClass());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteEmissionType)) {
            return false;
        }
        RouteEmissionType other = (RouteEmissionType) obj;
        return Objects.equals(co2EmissionClass(), other.co2EmissionClass()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteEmissionType")
                .add("Co2EmissionClass", co2EmissionClass() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", type() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Co2EmissionClass":
            return Optional.ofNullable(clazz.cast(co2EmissionClass()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Co2EmissionClass", CO2_EMISSION_CLASS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteEmissionType, T> g) {
        return obj -> g.apply((RouteEmissionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteEmissionType> {
        /**
         * <p>
         * The CO 2 emission classes.
         * </p>
         * 
         * @param co2EmissionClass
         *        The CO 2 emission classes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder co2EmissionClass(String co2EmissionClass);

        /**
         * <p>
         * Type of the emission.
         * </p>
         * <p>
         * <b>Valid values</b>: <code>Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev</code>
         * </p>
         * 
         * @param type
         *        Type of the emission.</p>
         *        <p>
         *        <b>Valid values</b>: <code>Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String co2EmissionClass;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteEmissionType model) {
            co2EmissionClass(model.co2EmissionClass);
            type(model.type);
        }

        public final String getCo2EmissionClass() {
            return co2EmissionClass;
        }

        public final void setCo2EmissionClass(String co2EmissionClass) {
            this.co2EmissionClass = co2EmissionClass;
        }

        @Override
        public final Builder co2EmissionClass(String co2EmissionClass) {
            this.co2EmissionClass = co2EmissionClass;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public RouteEmissionType build() {
            return new RouteEmissionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
