/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Steps of a leg that must be performed before the travel portion of the leg.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteFerryBeforeTravelStep implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteFerryBeforeTravelStep.Builder, RouteFerryBeforeTravelStep> {
    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Duration")
            .getter(getter(RouteFerryBeforeTravelStep::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Instruction").getter(getter(RouteFerryBeforeTravelStep::instruction))
            .setter(setter(Builder::instruction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instruction").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RouteFerryBeforeTravelStep::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD,
            INSTRUCTION_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long duration;

    private final String instruction;

    private final String type;

    private RouteFerryBeforeTravelStep(BuilderImpl builder) {
        this.duration = builder.duration;
        this.instruction = builder.instruction;
        this.type = builder.type;
    }

    /**
     * <p>
     * Duration of the step.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Duration of the step.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * Brief description of the step in the requested language.
     * </p>
     * <note>
     * <p>
     * Only available when the TravelStepType is Default.
     * </p>
     * </note>
     * 
     * @return Brief description of the step in the requested language.</p> <note>
     *         <p>
     *         Only available when the TravelStepType is Default.
     *         </p>
     */
    public final String instruction() {
        return instruction;
    }

    /**
     * <p>
     * Type of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteFerryBeforeTravelStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the step.
     * @see RouteFerryBeforeTravelStepType
     */
    public final RouteFerryBeforeTravelStepType type() {
        return RouteFerryBeforeTravelStepType.fromValue(type);
    }

    /**
     * <p>
     * Type of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteFerryBeforeTravelStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the step.
     * @see RouteFerryBeforeTravelStepType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(instruction());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteFerryBeforeTravelStep)) {
            return false;
        }
        RouteFerryBeforeTravelStep other = (RouteFerryBeforeTravelStep) obj;
        return Objects.equals(duration(), other.duration()) && Objects.equals(instruction(), other.instruction())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteFerryBeforeTravelStep")
                .add("Duration", duration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Instruction", instruction() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", typeAsString() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Instruction":
            return Optional.ofNullable(clazz.cast(instruction()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Duration", DURATION_FIELD);
        map.put("Instruction", INSTRUCTION_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteFerryBeforeTravelStep, T> g) {
        return obj -> g.apply((RouteFerryBeforeTravelStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteFerryBeforeTravelStep> {
        /**
         * <p>
         * Duration of the step.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param duration
         *        Duration of the step.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * Brief description of the step in the requested language.
         * </p>
         * <note>
         * <p>
         * Only available when the TravelStepType is Default.
         * </p>
         * </note>
         * 
         * @param instruction
         *        Brief description of the step in the requested language.</p> <note>
         *        <p>
         *        Only available when the TravelStepType is Default.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instruction(String instruction);

        /**
         * <p>
         * Type of the step.
         * </p>
         * 
         * @param type
         *        Type of the step.
         * @see RouteFerryBeforeTravelStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteFerryBeforeTravelStepType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the step.
         * </p>
         * 
         * @param type
         *        Type of the step.
         * @see RouteFerryBeforeTravelStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteFerryBeforeTravelStepType
         */
        Builder type(RouteFerryBeforeTravelStepType type);
    }

    static final class BuilderImpl implements Builder {
        private Long duration;

        private String instruction;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteFerryBeforeTravelStep model) {
            duration(model.duration);
            instruction(model.instruction);
            type(model.type);
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final String getInstruction() {
            return instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RouteFerryBeforeTravelStepType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RouteFerryBeforeTravelStep build() {
            return new RouteFerryBeforeTravelStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
