/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A leg is a section of a route from one waypoint to the next. A leg could be of type Vehicle, Pedestrian or Ferry.
 * Legs of different types could occur together within a single route. For example, a car employing the use of a Ferry
 * will contain Vehicle legs corresponding to journey on land, and Ferry legs corresponding to the journey via Ferry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteLeg implements SdkPojo, Serializable, ToCopyableBuilder<RouteLeg.Builder, RouteLeg> {
    private static final SdkField<RouteFerryLegDetails> FERRY_LEG_DETAILS_FIELD = SdkField
            .<RouteFerryLegDetails> builder(MarshallingType.SDK_POJO).memberName("FerryLegDetails")
            .getter(getter(RouteLeg::ferryLegDetails)).setter(setter(Builder::ferryLegDetails))
            .constructor(RouteFerryLegDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FerryLegDetails").build()).build();

    private static final SdkField<RouteLegGeometry> GEOMETRY_FIELD = SdkField
            .<RouteLegGeometry> builder(MarshallingType.SDK_POJO).memberName("Geometry").getter(getter(RouteLeg::geometry))
            .setter(setter(Builder::geometry)).constructor(RouteLegGeometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(RouteLeg::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<RoutePedestrianLegDetails> PEDESTRIAN_LEG_DETAILS_FIELD = SdkField
            .<RoutePedestrianLegDetails> builder(MarshallingType.SDK_POJO).memberName("PedestrianLegDetails")
            .getter(getter(RouteLeg::pedestrianLegDetails)).setter(setter(Builder::pedestrianLegDetails))
            .constructor(RoutePedestrianLegDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PedestrianLegDetails").build())
            .build();

    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TravelMode").getter(getter(RouteLeg::travelModeAsString)).setter(setter(Builder::travelMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RouteLeg::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<RouteVehicleLegDetails> VEHICLE_LEG_DETAILS_FIELD = SdkField
            .<RouteVehicleLegDetails> builder(MarshallingType.SDK_POJO).memberName("VehicleLegDetails")
            .getter(getter(RouteLeg::vehicleLegDetails)).setter(setter(Builder::vehicleLegDetails))
            .constructor(RouteVehicleLegDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VehicleLegDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FERRY_LEG_DETAILS_FIELD,
            GEOMETRY_FIELD, LANGUAGE_FIELD, PEDESTRIAN_LEG_DETAILS_FIELD, TRAVEL_MODE_FIELD, TYPE_FIELD,
            VEHICLE_LEG_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RouteFerryLegDetails ferryLegDetails;

    private final RouteLegGeometry geometry;

    private final String language;

    private final RoutePedestrianLegDetails pedestrianLegDetails;

    private final String travelMode;

    private final String type;

    private final RouteVehicleLegDetails vehicleLegDetails;

    private RouteLeg(BuilderImpl builder) {
        this.ferryLegDetails = builder.ferryLegDetails;
        this.geometry = builder.geometry;
        this.language = builder.language;
        this.pedestrianLegDetails = builder.pedestrianLegDetails;
        this.travelMode = builder.travelMode;
        this.type = builder.type;
        this.vehicleLegDetails = builder.vehicleLegDetails;
    }

    /**
     * <p>
     * FerryLegDetails is populated when the Leg type is Ferry, and provides additional information that is specific
     * </p>
     * 
     * @return FerryLegDetails is populated when the Leg type is Ferry, and provides additional information that is
     *         specific
     */
    public final RouteFerryLegDetails ferryLegDetails() {
        return ferryLegDetails;
    }

    /**
     * <p>
     * Geometry of the area to be avoided.
     * </p>
     * 
     * @return Geometry of the area to be avoided.
     */
    public final RouteLegGeometry geometry() {
        return geometry;
    }

    /**
     * <p>
     * List of languages for instructions within steps in the response.
     * </p>
     * 
     * @return List of languages for instructions within steps in the response.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * Details related to the pedestrian leg.
     * </p>
     * 
     * @return Details related to the pedestrian leg.
     */
    public final RoutePedestrianLegDetails pedestrianLegDetails() {
        return pedestrianLegDetails;
    }

    /**
     * <p>
     * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     * compatibility.
     * </p>
     * <p>
     * Default Value: <code>Car</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #travelMode} will
     * return {@link RouteLegTravelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #travelModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     *         compatibility.</p>
     *         <p>
     *         Default Value: <code>Car</code>
     * @see RouteLegTravelMode
     */
    public final RouteLegTravelMode travelMode() {
        return RouteLegTravelMode.fromValue(travelMode);
    }

    /**
     * <p>
     * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     * compatibility.
     * </p>
     * <p>
     * Default Value: <code>Car</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #travelMode} will
     * return {@link RouteLegTravelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #travelModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     *         compatibility.</p>
     *         <p>
     *         Default Value: <code>Car</code>
     * @see RouteLegTravelMode
     */
    public final String travelModeAsString() {
        return travelMode;
    }

    /**
     * <p>
     * Type of the leg.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteLegType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the leg.
     * @see RouteLegType
     */
    public final RouteLegType type() {
        return RouteLegType.fromValue(type);
    }

    /**
     * <p>
     * Type of the leg.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteLegType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the leg.
     * @see RouteLegType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Details related to the vehicle leg.
     * </p>
     * 
     * @return Details related to the vehicle leg.
     */
    public final RouteVehicleLegDetails vehicleLegDetails() {
        return vehicleLegDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ferryLegDetails());
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(pedestrianLegDetails());
        hashCode = 31 * hashCode + Objects.hashCode(travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vehicleLegDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteLeg)) {
            return false;
        }
        RouteLeg other = (RouteLeg) obj;
        return Objects.equals(ferryLegDetails(), other.ferryLegDetails()) && Objects.equals(geometry(), other.geometry())
                && Objects.equals(language(), other.language())
                && Objects.equals(pedestrianLegDetails(), other.pedestrianLegDetails())
                && Objects.equals(travelModeAsString(), other.travelModeAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(vehicleLegDetails(), other.vehicleLegDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteLeg").add("FerryLegDetails", ferryLegDetails()).add("Geometry", geometry())
                .add("Language", language()).add("PedestrianLegDetails", pedestrianLegDetails())
                .add("TravelMode", travelModeAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", typeAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VehicleLegDetails", vehicleLegDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FerryLegDetails":
            return Optional.ofNullable(clazz.cast(ferryLegDetails()));
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "PedestrianLegDetails":
            return Optional.ofNullable(clazz.cast(pedestrianLegDetails()));
        case "TravelMode":
            return Optional.ofNullable(clazz.cast(travelModeAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "VehicleLegDetails":
            return Optional.ofNullable(clazz.cast(vehicleLegDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FerryLegDetails", FERRY_LEG_DETAILS_FIELD);
        map.put("Geometry", GEOMETRY_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("PedestrianLegDetails", PEDESTRIAN_LEG_DETAILS_FIELD);
        map.put("TravelMode", TRAVEL_MODE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("VehicleLegDetails", VEHICLE_LEG_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteLeg, T> g) {
        return obj -> g.apply((RouteLeg) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteLeg> {
        /**
         * <p>
         * FerryLegDetails is populated when the Leg type is Ferry, and provides additional information that is specific
         * </p>
         * 
         * @param ferryLegDetails
         *        FerryLegDetails is populated when the Leg type is Ferry, and provides additional information that is
         *        specific
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ferryLegDetails(RouteFerryLegDetails ferryLegDetails);

        /**
         * <p>
         * FerryLegDetails is populated when the Leg type is Ferry, and provides additional information that is specific
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteFerryLegDetails.Builder} avoiding
         * the need to create one manually via {@link RouteFerryLegDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteFerryLegDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #ferryLegDetails(RouteFerryLegDetails)}.
         * 
         * @param ferryLegDetails
         *        a consumer that will call methods on {@link RouteFerryLegDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ferryLegDetails(RouteFerryLegDetails)
         */
        default Builder ferryLegDetails(Consumer<RouteFerryLegDetails.Builder> ferryLegDetails) {
            return ferryLegDetails(RouteFerryLegDetails.builder().applyMutation(ferryLegDetails).build());
        }

        /**
         * <p>
         * Geometry of the area to be avoided.
         * </p>
         * 
         * @param geometry
         *        Geometry of the area to be avoided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(RouteLegGeometry geometry);

        /**
         * <p>
         * Geometry of the area to be avoided.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteLegGeometry.Builder} avoiding the
         * need to create one manually via {@link RouteLegGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteLegGeometry.Builder#build()} is called immediately and its
         * result is passed to {@link #geometry(RouteLegGeometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link RouteLegGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(RouteLegGeometry)
         */
        default Builder geometry(Consumer<RouteLegGeometry.Builder> geometry) {
            return geometry(RouteLegGeometry.builder().applyMutation(geometry).build());
        }

        /**
         * <p>
         * List of languages for instructions within steps in the response.
         * </p>
         * 
         * @param language
         *        List of languages for instructions within steps in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * Details related to the pedestrian leg.
         * </p>
         * 
         * @param pedestrianLegDetails
         *        Details related to the pedestrian leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pedestrianLegDetails(RoutePedestrianLegDetails pedestrianLegDetails);

        /**
         * <p>
         * Details related to the pedestrian leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutePedestrianLegDetails.Builder}
         * avoiding the need to create one manually via {@link RoutePedestrianLegDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutePedestrianLegDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #pedestrianLegDetails(RoutePedestrianLegDetails)}.
         * 
         * @param pedestrianLegDetails
         *        a consumer that will call methods on {@link RoutePedestrianLegDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pedestrianLegDetails(RoutePedestrianLegDetails)
         */
        default Builder pedestrianLegDetails(Consumer<RoutePedestrianLegDetails.Builder> pedestrianLegDetails) {
            return pedestrianLegDetails(RoutePedestrianLegDetails.builder().applyMutation(pedestrianLegDetails).build());
        }

        /**
         * <p>
         * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
         * compatibility.
         * </p>
         * <p>
         * Default Value: <code>Car</code>
         * </p>
         * 
         * @param travelMode
         *        Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and
         *        road compatibility.</p>
         *        <p>
         *        Default Value: <code>Car</code>
         * @see RouteLegTravelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteLegTravelMode
         */
        Builder travelMode(String travelMode);

        /**
         * <p>
         * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
         * compatibility.
         * </p>
         * <p>
         * Default Value: <code>Car</code>
         * </p>
         * 
         * @param travelMode
         *        Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and
         *        road compatibility.</p>
         *        <p>
         *        Default Value: <code>Car</code>
         * @see RouteLegTravelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteLegTravelMode
         */
        Builder travelMode(RouteLegTravelMode travelMode);

        /**
         * <p>
         * Type of the leg.
         * </p>
         * 
         * @param type
         *        Type of the leg.
         * @see RouteLegType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteLegType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the leg.
         * </p>
         * 
         * @param type
         *        Type of the leg.
         * @see RouteLegType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteLegType
         */
        Builder type(RouteLegType type);

        /**
         * <p>
         * Details related to the vehicle leg.
         * </p>
         * 
         * @param vehicleLegDetails
         *        Details related to the vehicle leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicleLegDetails(RouteVehicleLegDetails vehicleLegDetails);

        /**
         * <p>
         * Details related to the vehicle leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteVehicleLegDetails.Builder} avoiding
         * the need to create one manually via {@link RouteVehicleLegDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteVehicleLegDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #vehicleLegDetails(RouteVehicleLegDetails)}.
         * 
         * @param vehicleLegDetails
         *        a consumer that will call methods on {@link RouteVehicleLegDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vehicleLegDetails(RouteVehicleLegDetails)
         */
        default Builder vehicleLegDetails(Consumer<RouteVehicleLegDetails.Builder> vehicleLegDetails) {
            return vehicleLegDetails(RouteVehicleLegDetails.builder().applyMutation(vehicleLegDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RouteFerryLegDetails ferryLegDetails;

        private RouteLegGeometry geometry;

        private String language;

        private RoutePedestrianLegDetails pedestrianLegDetails;

        private String travelMode;

        private String type;

        private RouteVehicleLegDetails vehicleLegDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteLeg model) {
            ferryLegDetails(model.ferryLegDetails);
            geometry(model.geometry);
            language(model.language);
            pedestrianLegDetails(model.pedestrianLegDetails);
            travelMode(model.travelMode);
            type(model.type);
            vehicleLegDetails(model.vehicleLegDetails);
        }

        public final RouteFerryLegDetails.Builder getFerryLegDetails() {
            return ferryLegDetails != null ? ferryLegDetails.toBuilder() : null;
        }

        public final void setFerryLegDetails(RouteFerryLegDetails.BuilderImpl ferryLegDetails) {
            this.ferryLegDetails = ferryLegDetails != null ? ferryLegDetails.build() : null;
        }

        @Override
        public final Builder ferryLegDetails(RouteFerryLegDetails ferryLegDetails) {
            this.ferryLegDetails = ferryLegDetails;
            return this;
        }

        public final RouteLegGeometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(RouteLegGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(RouteLegGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final RoutePedestrianLegDetails.Builder getPedestrianLegDetails() {
            return pedestrianLegDetails != null ? pedestrianLegDetails.toBuilder() : null;
        }

        public final void setPedestrianLegDetails(RoutePedestrianLegDetails.BuilderImpl pedestrianLegDetails) {
            this.pedestrianLegDetails = pedestrianLegDetails != null ? pedestrianLegDetails.build() : null;
        }

        @Override
        public final Builder pedestrianLegDetails(RoutePedestrianLegDetails pedestrianLegDetails) {
            this.pedestrianLegDetails = pedestrianLegDetails;
            return this;
        }

        public final String getTravelMode() {
            return travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        public final Builder travelMode(RouteLegTravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RouteLegType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final RouteVehicleLegDetails.Builder getVehicleLegDetails() {
            return vehicleLegDetails != null ? vehicleLegDetails.toBuilder() : null;
        }

        public final void setVehicleLegDetails(RouteVehicleLegDetails.BuilderImpl vehicleLegDetails) {
            this.vehicleLegDetails = vehicleLegDetails != null ? vehicleLegDetails.build() : null;
        }

        @Override
        public final Builder vehicleLegDetails(RouteVehicleLegDetails vehicleLegDetails) {
            this.vehicleLegDetails = vehicleLegDetails;
            return this;
        }

        @Override
        public RouteLeg build() {
            return new RouteLeg(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
