/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the dynamic speed.
 * </p>
 * <p>
 * <b>Unit</b>: <code>KilometersPerHour</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteSpanDynamicSpeedDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteSpanDynamicSpeedDetails.Builder, RouteSpanDynamicSpeedDetails> {
    private static final SdkField<Double> BEST_CASE_SPEED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("BestCaseSpeed").getter(getter(RouteSpanDynamicSpeedDetails::bestCaseSpeed))
            .setter(setter(Builder::bestCaseSpeed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestCaseSpeed").build()).build();

    private static final SdkField<Long> TURN_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TurnDuration").getter(getter(RouteSpanDynamicSpeedDetails::turnDuration))
            .setter(setter(Builder::turnDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TurnDuration").build()).build();

    private static final SdkField<Double> TYPICAL_SPEED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TypicalSpeed").getter(getter(RouteSpanDynamicSpeedDetails::typicalSpeed))
            .setter(setter(Builder::typicalSpeed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypicalSpeed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEST_CASE_SPEED_FIELD,
            TURN_DURATION_FIELD, TYPICAL_SPEED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double bestCaseSpeed;

    private final Long turnDuration;

    private final Double typicalSpeed;

    private RouteSpanDynamicSpeedDetails(BuilderImpl builder) {
        this.bestCaseSpeed = builder.bestCaseSpeed;
        this.turnDuration = builder.turnDuration;
        this.typicalSpeed = builder.typicalSpeed;
    }

    /**
     * <p>
     * Estimated speed while traversing the span without traffic congestion.
     * </p>
     * <p>
     * <b>Unit</b>: <code>KilometersPerHour</code>
     * </p>
     * 
     * @return Estimated speed while traversing the span without traffic congestion.</p>
     *         <p>
     *         <b>Unit</b>: <code>KilometersPerHour</code>
     */
    public final Double bestCaseSpeed() {
        return bestCaseSpeed;
    }

    /**
     * <p>
     * Estimated time to turn from this span into the next.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Estimated time to turn from this span into the next. </p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long turnDuration() {
        return turnDuration;
    }

    /**
     * <p>
     * Estimated speed while traversing the span under typical traffic congestion.
     * </p>
     * <p>
     * <b>Unit</b>: <code>KilometersPerHour</code>
     * </p>
     * 
     * @return Estimated speed while traversing the span under typical traffic congestion.</p>
     *         <p>
     *         <b>Unit</b>: <code>KilometersPerHour</code>
     */
    public final Double typicalSpeed() {
        return typicalSpeed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bestCaseSpeed());
        hashCode = 31 * hashCode + Objects.hashCode(turnDuration());
        hashCode = 31 * hashCode + Objects.hashCode(typicalSpeed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSpanDynamicSpeedDetails)) {
            return false;
        }
        RouteSpanDynamicSpeedDetails other = (RouteSpanDynamicSpeedDetails) obj;
        return Objects.equals(bestCaseSpeed(), other.bestCaseSpeed()) && Objects.equals(turnDuration(), other.turnDuration())
                && Objects.equals(typicalSpeed(), other.typicalSpeed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteSpanDynamicSpeedDetails")
                .add("BestCaseSpeed", bestCaseSpeed() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TurnDuration", turnDuration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TypicalSpeed", typicalSpeed() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BestCaseSpeed":
            return Optional.ofNullable(clazz.cast(bestCaseSpeed()));
        case "TurnDuration":
            return Optional.ofNullable(clazz.cast(turnDuration()));
        case "TypicalSpeed":
            return Optional.ofNullable(clazz.cast(typicalSpeed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BestCaseSpeed", BEST_CASE_SPEED_FIELD);
        map.put("TurnDuration", TURN_DURATION_FIELD);
        map.put("TypicalSpeed", TYPICAL_SPEED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteSpanDynamicSpeedDetails, T> g) {
        return obj -> g.apply((RouteSpanDynamicSpeedDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteSpanDynamicSpeedDetails> {
        /**
         * <p>
         * Estimated speed while traversing the span without traffic congestion.
         * </p>
         * <p>
         * <b>Unit</b>: <code>KilometersPerHour</code>
         * </p>
         * 
         * @param bestCaseSpeed
         *        Estimated speed while traversing the span without traffic congestion.</p>
         *        <p>
         *        <b>Unit</b>: <code>KilometersPerHour</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bestCaseSpeed(Double bestCaseSpeed);

        /**
         * <p>
         * Estimated time to turn from this span into the next.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param turnDuration
         *        Estimated time to turn from this span into the next. </p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turnDuration(Long turnDuration);

        /**
         * <p>
         * Estimated speed while traversing the span under typical traffic congestion.
         * </p>
         * <p>
         * <b>Unit</b>: <code>KilometersPerHour</code>
         * </p>
         * 
         * @param typicalSpeed
         *        Estimated speed while traversing the span under typical traffic congestion.</p>
         *        <p>
         *        <b>Unit</b>: <code>KilometersPerHour</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typicalSpeed(Double typicalSpeed);
    }

    static final class BuilderImpl implements Builder {
        private Double bestCaseSpeed;

        private Long turnDuration;

        private Double typicalSpeed;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSpanDynamicSpeedDetails model) {
            bestCaseSpeed(model.bestCaseSpeed);
            turnDuration(model.turnDuration);
            typicalSpeed(model.typicalSpeed);
        }

        public final Double getBestCaseSpeed() {
            return bestCaseSpeed;
        }

        public final void setBestCaseSpeed(Double bestCaseSpeed) {
            this.bestCaseSpeed = bestCaseSpeed;
        }

        @Override
        public final Builder bestCaseSpeed(Double bestCaseSpeed) {
            this.bestCaseSpeed = bestCaseSpeed;
            return this;
        }

        public final Long getTurnDuration() {
            return turnDuration;
        }

        public final void setTurnDuration(Long turnDuration) {
            this.turnDuration = turnDuration;
        }

        @Override
        public final Builder turnDuration(Long turnDuration) {
            this.turnDuration = turnDuration;
            return this;
        }

        public final Double getTypicalSpeed() {
            return typicalSpeed;
        }

        public final void setTypicalSpeed(Double typicalSpeed) {
            this.typicalSpeed = typicalSpeed;
        }

        @Override
        public final Builder typicalSpeed(Double typicalSpeed) {
            this.typicalSpeed = typicalSpeed;
            return this;
        }

        @Override
        public RouteSpanDynamicSpeedDetails build() {
            return new RouteSpanDynamicSpeedDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
