/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarized details for the leg including travel steps only. The Distance for the travel only portion of the journey
 * is the same as the Distance within the Overview summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteSummary implements SdkPojo, Serializable, ToCopyableBuilder<RouteSummary.Builder, RouteSummary> {
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Distance")
            .getter(getter(RouteSummary::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Duration")
            .getter(getter(RouteSummary::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<RouteTollSummary> TOLLS_FIELD = SdkField.<RouteTollSummary> builder(MarshallingType.SDK_POJO)
            .memberName("Tolls").getter(getter(RouteSummary::tolls)).setter(setter(Builder::tolls))
            .constructor(RouteTollSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tolls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTANCE_FIELD,
            DURATION_FIELD, TOLLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long distance;

    private final Long duration;

    private final RouteTollSummary tolls;

    private RouteSummary(BuilderImpl builder) {
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.tolls = builder.tolls;
    }

    /**
     * <p>
     * Distance of the route.
     * </p>
     * 
     * @return Distance of the route.
     */
    public final Long distance() {
        return distance;
    }

    /**
     * <p>
     * Duration of the route.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Duration of the route.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * Toll summary for the complete route.
     * </p>
     * 
     * @return Toll summary for the complete route.
     */
    public final RouteTollSummary tolls() {
        return tolls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(tolls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSummary)) {
            return false;
        }
        RouteSummary other = (RouteSummary) obj;
        return Objects.equals(distance(), other.distance()) && Objects.equals(duration(), other.duration())
                && Objects.equals(tolls(), other.tolls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteSummary").add("Distance", distance() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Duration", duration() == null ? null : "*** Sensitive Data Redacted ***").add("Tolls", tolls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Tolls":
            return Optional.ofNullable(clazz.cast(tolls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("Tolls", TOLLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteSummary, T> g) {
        return obj -> g.apply((RouteSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteSummary> {
        /**
         * <p>
         * Distance of the route.
         * </p>
         * 
         * @param distance
         *        Distance of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Long distance);

        /**
         * <p>
         * Duration of the route.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param duration
         *        Duration of the route.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * Toll summary for the complete route.
         * </p>
         * 
         * @param tolls
         *        Toll summary for the complete route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tolls(RouteTollSummary tolls);

        /**
         * <p>
         * Toll summary for the complete route.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTollSummary.Builder} avoiding the
         * need to create one manually via {@link RouteTollSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTollSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #tolls(RouteTollSummary)}.
         * 
         * @param tolls
         *        a consumer that will call methods on {@link RouteTollSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tolls(RouteTollSummary)
         */
        default Builder tolls(Consumer<RouteTollSummary.Builder> tolls) {
            return tolls(RouteTollSummary.builder().applyMutation(tolls).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long distance;

        private Long duration;

        private RouteTollSummary tolls;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSummary model) {
            distance(model.distance);
            duration(model.duration);
            tolls(model.tolls);
        }

        public final Long getDistance() {
            return distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final RouteTollSummary.Builder getTolls() {
            return tolls != null ? tolls.toBuilder() : null;
        }

        public final void setTolls(RouteTollSummary.BuilderImpl tolls) {
            this.tolls = tolls != null ? tolls.build() : null;
        }

        @Override
        public final Builder tolls(RouteTollSummary tolls) {
            this.tolls = tolls;
            return this;
        }

        @Override
        public RouteSummary build() {
            return new RouteSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
