/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options related to Tolls on a route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteTollOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteTollOptions.Builder, RouteTollOptions> {
    private static final SdkField<Boolean> ALL_TRANSPONDERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllTransponders").getter(getter(RouteTollOptions::allTransponders))
            .setter(setter(Builder::allTransponders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllTransponders").build()).build();

    private static final SdkField<Boolean> ALL_VIGNETTES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllVignettes").getter(getter(RouteTollOptions::allVignettes)).setter(setter(Builder::allVignettes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllVignettes").build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Currency").getter(getter(RouteTollOptions::currency)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()).build();

    private static final SdkField<RouteEmissionType> EMISSION_TYPE_FIELD = SdkField
            .<RouteEmissionType> builder(MarshallingType.SDK_POJO).memberName("EmissionType")
            .getter(getter(RouteTollOptions::emissionType)).setter(setter(Builder::emissionType))
            .constructor(RouteEmissionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmissionType").build()).build();

    private static final SdkField<String> VEHICLE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VehicleCategory").getter(getter(RouteTollOptions::vehicleCategoryAsString))
            .setter(setter(Builder::vehicleCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VehicleCategory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_TRANSPONDERS_FIELD,
            ALL_VIGNETTES_FIELD, CURRENCY_FIELD, EMISSION_TYPE_FIELD, VEHICLE_CATEGORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean allTransponders;

    private final Boolean allVignettes;

    private final String currency;

    private final RouteEmissionType emissionType;

    private final String vehicleCategory;

    private RouteTollOptions(BuilderImpl builder) {
        this.allTransponders = builder.allTransponders;
        this.allVignettes = builder.allVignettes;
        this.currency = builder.currency;
        this.emissionType = builder.emissionType;
        this.vehicleCategory = builder.vehicleCategory;
    }

    /**
     * <p>
     * Specifies if the user has valid transponder with access to all toll systems. This impacts toll calculation, and
     * if true the price with transponders is used.
     * </p>
     * 
     * @return Specifies if the user has valid transponder with access to all toll systems. This impacts toll
     *         calculation, and if true the price with transponders is used.
     */
    public final Boolean allTransponders() {
        return allTransponders;
    }

    /**
     * <p>
     * Specifies if the user has valid vignettes with access for all toll roads. If a user has a vignette for a toll
     * road, then toll cost for that road is omitted since no further payment is necessary.
     * </p>
     * 
     * @return Specifies if the user has valid vignettes with access for all toll roads. If a user has a vignette for a
     *         toll road, then toll cost for that road is omitted since no further payment is necessary.
     */
    public final Boolean allVignettes() {
        return allVignettes;
    }

    /**
     * <p>
     * Currency code corresponding to the price. This is the same as Currency specified in the request.
     * </p>
     * 
     * @return Currency code corresponding to the price. This is the same as Currency specified in the request.
     */
    public final String currency() {
        return currency;
    }

    /**
     * <p>
     * Emission type of the vehicle for toll cost calculation.
     * </p>
     * <p>
     * <b>Valid values</b>: <code>Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev</code>
     * </p>
     * 
     * @return Emission type of the vehicle for toll cost calculation.</p>
     *         <p>
     *         <b>Valid values</b>: <code>Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev</code>
     */
    public final RouteEmissionType emissionType() {
        return emissionType;
    }

    /**
     * <p>
     * Vehicle category for toll cost calculation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vehicleCategory}
     * will return {@link RouteTollVehicleCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #vehicleCategoryAsString}.
     * </p>
     * 
     * @return Vehicle category for toll cost calculation.
     * @see RouteTollVehicleCategory
     */
    public final RouteTollVehicleCategory vehicleCategory() {
        return RouteTollVehicleCategory.fromValue(vehicleCategory);
    }

    /**
     * <p>
     * Vehicle category for toll cost calculation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vehicleCategory}
     * will return {@link RouteTollVehicleCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #vehicleCategoryAsString}.
     * </p>
     * 
     * @return Vehicle category for toll cost calculation.
     * @see RouteTollVehicleCategory
     */
    public final String vehicleCategoryAsString() {
        return vehicleCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allTransponders());
        hashCode = 31 * hashCode + Objects.hashCode(allVignettes());
        hashCode = 31 * hashCode + Objects.hashCode(currency());
        hashCode = 31 * hashCode + Objects.hashCode(emissionType());
        hashCode = 31 * hashCode + Objects.hashCode(vehicleCategoryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTollOptions)) {
            return false;
        }
        RouteTollOptions other = (RouteTollOptions) obj;
        return Objects.equals(allTransponders(), other.allTransponders()) && Objects.equals(allVignettes(), other.allVignettes())
                && Objects.equals(currency(), other.currency()) && Objects.equals(emissionType(), other.emissionType())
                && Objects.equals(vehicleCategoryAsString(), other.vehicleCategoryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteTollOptions")
                .add("AllTransponders", allTransponders() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AllVignettes", allVignettes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Currency", currency()).add("EmissionType", emissionType())
                .add("VehicleCategory", vehicleCategoryAsString() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllTransponders":
            return Optional.ofNullable(clazz.cast(allTransponders()));
        case "AllVignettes":
            return Optional.ofNullable(clazz.cast(allVignettes()));
        case "Currency":
            return Optional.ofNullable(clazz.cast(currency()));
        case "EmissionType":
            return Optional.ofNullable(clazz.cast(emissionType()));
        case "VehicleCategory":
            return Optional.ofNullable(clazz.cast(vehicleCategoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllTransponders", ALL_TRANSPONDERS_FIELD);
        map.put("AllVignettes", ALL_VIGNETTES_FIELD);
        map.put("Currency", CURRENCY_FIELD);
        map.put("EmissionType", EMISSION_TYPE_FIELD);
        map.put("VehicleCategory", VEHICLE_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTollOptions, T> g) {
        return obj -> g.apply((RouteTollOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteTollOptions> {
        /**
         * <p>
         * Specifies if the user has valid transponder with access to all toll systems. This impacts toll calculation,
         * and if true the price with transponders is used.
         * </p>
         * 
         * @param allTransponders
         *        Specifies if the user has valid transponder with access to all toll systems. This impacts toll
         *        calculation, and if true the price with transponders is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allTransponders(Boolean allTransponders);

        /**
         * <p>
         * Specifies if the user has valid vignettes with access for all toll roads. If a user has a vignette for a toll
         * road, then toll cost for that road is omitted since no further payment is necessary.
         * </p>
         * 
         * @param allVignettes
         *        Specifies if the user has valid vignettes with access for all toll roads. If a user has a vignette for
         *        a toll road, then toll cost for that road is omitted since no further payment is necessary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allVignettes(Boolean allVignettes);

        /**
         * <p>
         * Currency code corresponding to the price. This is the same as Currency specified in the request.
         * </p>
         * 
         * @param currency
         *        Currency code corresponding to the price. This is the same as Currency specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currency(String currency);

        /**
         * <p>
         * Emission type of the vehicle for toll cost calculation.
         * </p>
         * <p>
         * <b>Valid values</b>: <code>Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev</code>
         * </p>
         * 
         * @param emissionType
         *        Emission type of the vehicle for toll cost calculation.</p>
         *        <p>
         *        <b>Valid values</b>: <code>Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emissionType(RouteEmissionType emissionType);

        /**
         * <p>
         * Emission type of the vehicle for toll cost calculation.
         * </p>
         * <p>
         * <b>Valid values</b>: <code>Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteEmissionType.Builder} avoiding the
         * need to create one manually via {@link RouteEmissionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteEmissionType.Builder#build()} is called immediately and its
         * result is passed to {@link #emissionType(RouteEmissionType)}.
         * 
         * @param emissionType
         *        a consumer that will call methods on {@link RouteEmissionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emissionType(RouteEmissionType)
         */
        default Builder emissionType(Consumer<RouteEmissionType.Builder> emissionType) {
            return emissionType(RouteEmissionType.builder().applyMutation(emissionType).build());
        }

        /**
         * <p>
         * Vehicle category for toll cost calculation.
         * </p>
         * 
         * @param vehicleCategory
         *        Vehicle category for toll cost calculation.
         * @see RouteTollVehicleCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTollVehicleCategory
         */
        Builder vehicleCategory(String vehicleCategory);

        /**
         * <p>
         * Vehicle category for toll cost calculation.
         * </p>
         * 
         * @param vehicleCategory
         *        Vehicle category for toll cost calculation.
         * @see RouteTollVehicleCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTollVehicleCategory
         */
        Builder vehicleCategory(RouteTollVehicleCategory vehicleCategory);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allTransponders;

        private Boolean allVignettes;

        private String currency;

        private RouteEmissionType emissionType;

        private String vehicleCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTollOptions model) {
            allTransponders(model.allTransponders);
            allVignettes(model.allVignettes);
            currency(model.currency);
            emissionType(model.emissionType);
            vehicleCategory(model.vehicleCategory);
        }

        public final Boolean getAllTransponders() {
            return allTransponders;
        }

        public final void setAllTransponders(Boolean allTransponders) {
            this.allTransponders = allTransponders;
        }

        @Override
        public final Builder allTransponders(Boolean allTransponders) {
            this.allTransponders = allTransponders;
            return this;
        }

        public final Boolean getAllVignettes() {
            return allVignettes;
        }

        public final void setAllVignettes(Boolean allVignettes) {
            this.allVignettes = allVignettes;
        }

        @Override
        public final Builder allVignettes(Boolean allVignettes) {
            this.allVignettes = allVignettes;
            return this;
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public final RouteEmissionType.Builder getEmissionType() {
            return emissionType != null ? emissionType.toBuilder() : null;
        }

        public final void setEmissionType(RouteEmissionType.BuilderImpl emissionType) {
            this.emissionType = emissionType != null ? emissionType.build() : null;
        }

        @Override
        public final Builder emissionType(RouteEmissionType emissionType) {
            this.emissionType = emissionType;
            return this;
        }

        public final String getVehicleCategory() {
            return vehicleCategory;
        }

        public final void setVehicleCategory(String vehicleCategory) {
            this.vehicleCategory = vehicleCategory;
        }

        @Override
        public final Builder vehicleCategory(String vehicleCategory) {
            this.vehicleCategory = vehicleCategory;
            return this;
        }

        @Override
        public final Builder vehicleCategory(RouteTollVehicleCategory vehicleCategory) {
            this.vehicleCategory(vehicleCategory == null ? null : vehicleCategory.toString());
            return this;
        }

        @Override
        public RouteTollOptions build() {
            return new RouteTollOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
