/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Notices are additional information returned that indicate issues that occurred during route calculation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteVehicleNotice implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteVehicleNotice.Builder, RouteVehicleNotice> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(RouteVehicleNotice::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<List<RouteVehicleNoticeDetail>> DETAILS_FIELD = SdkField
            .<List<RouteVehicleNoticeDetail>> builder(MarshallingType.LIST)
            .memberName("Details")
            .getter(getter(RouteVehicleNotice::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteVehicleNoticeDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteVehicleNoticeDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMPACT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Impact")
            .getter(getter(RouteVehicleNotice::impactAsString)).setter(setter(Builder::impact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Impact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, DETAILS_FIELD,
            IMPACT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final List<RouteVehicleNoticeDetail> details;

    private final String impact;

    private RouteVehicleNotice(BuilderImpl builder) {
        this.code = builder.code;
        this.details = builder.details;
        this.impact = builder.impact;
    }

    /**
     * <p>
     * Code corresponding to the issue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link RouteVehicleNoticeCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return Code corresponding to the issue.
     * @see RouteVehicleNoticeCode
     */
    public final RouteVehicleNoticeCode code() {
        return RouteVehicleNoticeCode.fromValue(code);
    }

    /**
     * <p>
     * Code corresponding to the issue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link RouteVehicleNoticeCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return Code corresponding to the issue.
     * @see RouteVehicleNoticeCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * For responses, this returns true if the service returned a value for the Details property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDetails() {
        return details != null && !(details instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional details of the notice.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetails} method.
     * </p>
     * 
     * @return Additional details of the notice.
     */
    public final List<RouteVehicleNoticeDetail> details() {
        return details;
    }

    /**
     * <p>
     * Impact corresponding to the issue. While Low impact notices can be safely ignored, High impact notices must be
     * evaluated further to determine the impact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #impact} will
     * return {@link RouteNoticeImpact#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #impactAsString}.
     * </p>
     * 
     * @return Impact corresponding to the issue. While Low impact notices can be safely ignored, High impact notices
     *         must be evaluated further to determine the impact.
     * @see RouteNoticeImpact
     */
    public final RouteNoticeImpact impact() {
        return RouteNoticeImpact.fromValue(impact);
    }

    /**
     * <p>
     * Impact corresponding to the issue. While Low impact notices can be safely ignored, High impact notices must be
     * evaluated further to determine the impact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #impact} will
     * return {@link RouteNoticeImpact#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #impactAsString}.
     * </p>
     * 
     * @return Impact corresponding to the issue. While Low impact notices can be safely ignored, High impact notices
     *         must be evaluated further to determine the impact.
     * @see RouteNoticeImpact
     */
    public final String impactAsString() {
        return impact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDetails() ? details() : null);
        hashCode = 31 * hashCode + Objects.hashCode(impactAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleNotice)) {
            return false;
        }
        RouteVehicleNotice other = (RouteVehicleNotice) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && hasDetails() == other.hasDetails()
                && Objects.equals(details(), other.details()) && Objects.equals(impactAsString(), other.impactAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteVehicleNotice").add("Code", codeAsString()).add("Details", hasDetails() ? details() : null)
                .add("Impact", impactAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        case "Impact":
            return Optional.ofNullable(clazz.cast(impactAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Code", CODE_FIELD);
        map.put("Details", DETAILS_FIELD);
        map.put("Impact", IMPACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleNotice, T> g) {
        return obj -> g.apply((RouteVehicleNotice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteVehicleNotice> {
        /**
         * <p>
         * Code corresponding to the issue.
         * </p>
         * 
         * @param code
         *        Code corresponding to the issue.
         * @see RouteVehicleNoticeCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteVehicleNoticeCode
         */
        Builder code(String code);

        /**
         * <p>
         * Code corresponding to the issue.
         * </p>
         * 
         * @param code
         *        Code corresponding to the issue.
         * @see RouteVehicleNoticeCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteVehicleNoticeCode
         */
        Builder code(RouteVehicleNoticeCode code);

        /**
         * <p>
         * Additional details of the notice.
         * </p>
         * 
         * @param details
         *        Additional details of the notice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<RouteVehicleNoticeDetail> details);

        /**
         * <p>
         * Additional details of the notice.
         * </p>
         * 
         * @param details
         *        Additional details of the notice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(RouteVehicleNoticeDetail... details);

        /**
         * <p>
         * Additional details of the notice.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleNoticeDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleNoticeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleNoticeDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #details(List<RouteVehicleNoticeDetail>)}.
         * 
         * @param details
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleNoticeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(java.util.Collection<RouteVehicleNoticeDetail>)
         */
        Builder details(Consumer<RouteVehicleNoticeDetail.Builder>... details);

        /**
         * <p>
         * Impact corresponding to the issue. While Low impact notices can be safely ignored, High impact notices must
         * be evaluated further to determine the impact.
         * </p>
         * 
         * @param impact
         *        Impact corresponding to the issue. While Low impact notices can be safely ignored, High impact notices
         *        must be evaluated further to determine the impact.
         * @see RouteNoticeImpact
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteNoticeImpact
         */
        Builder impact(String impact);

        /**
         * <p>
         * Impact corresponding to the issue. While Low impact notices can be safely ignored, High impact notices must
         * be evaluated further to determine the impact.
         * </p>
         * 
         * @param impact
         *        Impact corresponding to the issue. While Low impact notices can be safely ignored, High impact notices
         *        must be evaluated further to determine the impact.
         * @see RouteNoticeImpact
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteNoticeImpact
         */
        Builder impact(RouteNoticeImpact impact);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private List<RouteVehicleNoticeDetail> details = DefaultSdkAutoConstructList.getInstance();

        private String impact;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleNotice model) {
            code(model.code);
            details(model.details);
            impact(model.impact);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(RouteVehicleNoticeCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final List<RouteVehicleNoticeDetail.Builder> getDetails() {
            List<RouteVehicleNoticeDetail.Builder> result = RouteVehicleNoticeDetailListCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetails(Collection<RouteVehicleNoticeDetail.BuilderImpl> details) {
            this.details = RouteVehicleNoticeDetailListCopier.copyFromBuilder(details);
        }

        @Override
        public final Builder details(Collection<RouteVehicleNoticeDetail> details) {
            this.details = RouteVehicleNoticeDetailListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(RouteVehicleNoticeDetail... details) {
            details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<RouteVehicleNoticeDetail.Builder>... details) {
            details(Stream.of(details).map(c -> RouteVehicleNoticeDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getImpact() {
            return impact;
        }

        public final void setImpact(String impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(String impact) {
            this.impact = impact;
            return this;
        }

        @Override
        public final Builder impact(RouteNoticeImpact impact) {
            this.impact(impact == null ? null : impact.toString());
            return this;
        }

        @Override
        public RouteVehicleNotice build() {
            return new RouteVehicleNotice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
