/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum RouteVehicleNoticeCode {
    ACCURATE_POLYLINE_UNAVAILABLE("AccuratePolylineUnavailable"),

    OTHER("Other"),

    POTENTIAL_VIOLATED_AVOID_TOLL_ROAD_USAGE("PotentialViolatedAvoidTollRoadUsage"),

    POTENTIAL_VIOLATED_CARPOOL_USAGE("PotentialViolatedCarpoolUsage"),

    POTENTIAL_VIOLATED_TURN_RESTRICTION_USAGE("PotentialViolatedTurnRestrictionUsage"),

    POTENTIAL_VIOLATED_VEHICLE_RESTRICTION_USAGE("PotentialViolatedVehicleRestrictionUsage"),

    POTENTIAL_VIOLATED_ZONE_RESTRICTION_USAGE("PotentialViolatedZoneRestrictionUsage"),

    SEASONAL_CLOSURE("SeasonalClosure"),

    TOLLS_DATA_TEMPORARILY_UNAVAILABLE("TollsDataTemporarilyUnavailable"),

    TOLLS_DATA_UNAVAILABLE("TollsDataUnavailable"),

    TOLL_TRANSPONDER("TollTransponder"),

    VIOLATED_AVOID_CONTROLLED_ACCESS_HIGHWAY("ViolatedAvoidControlledAccessHighway"),

    VIOLATED_AVOID_DIFFICULT_TURNS("ViolatedAvoidDifficultTurns"),

    VIOLATED_AVOID_DIRT_ROAD("ViolatedAvoidDirtRoad"),

    VIOLATED_AVOID_SEASONAL_CLOSURE("ViolatedAvoidSeasonalClosure"),

    VIOLATED_AVOID_TOLL_ROAD("ViolatedAvoidTollRoad"),

    VIOLATED_AVOID_TOLL_TRANSPONDER("ViolatedAvoidTollTransponder"),

    VIOLATED_AVOID_TRUCK_ROAD_TYPE("ViolatedAvoidTruckRoadType"),

    VIOLATED_AVOID_TUNNEL("ViolatedAvoidTunnel"),

    VIOLATED_AVOID_U_TURNS("ViolatedAvoidUTurns"),

    VIOLATED_BLOCKED_ROAD("ViolatedBlockedRoad"),

    VIOLATED_CARPOOL("ViolatedCarpool"),

    VIOLATED_EMERGENCY_GATE("ViolatedEmergencyGate"),

    VIOLATED_START_DIRECTION("ViolatedStartDirection"),

    VIOLATED_TURN_RESTRICTION("ViolatedTurnRestriction"),

    VIOLATED_VEHICLE_RESTRICTION("ViolatedVehicleRestriction"),

    VIOLATED_ZONE_RESTRICTION("ViolatedZoneRestriction"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteVehicleNoticeCode> VALUE_MAP = EnumUtils.uniqueIndex(RouteVehicleNoticeCode.class,
            RouteVehicleNoticeCode::toString);

    private final String value;

    private RouteVehicleNoticeCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return RouteVehicleNoticeCode corresponding to the value
     */
    public static RouteVehicleNoticeCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link RouteVehicleNoticeCode}s
     */
    public static Set<RouteVehicleNoticeCode> knownValues() {
        Set<RouteVehicleNoticeCode> knownValues = EnumSet.allOf(RouteVehicleNoticeCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
