/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Place details corresponding to the arrival or departure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteVehiclePlace implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteVehiclePlace.Builder, RouteVehiclePlace> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RouteVehiclePlace::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<Double>> ORIGINAL_POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("OriginalPosition")
            .getter(getter(RouteVehiclePlace::originalPosition))
            .setter(setter(Builder::originalPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalPosition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(RouteVehiclePlace::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SIDE_OF_STREET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SideOfStreet").getter(getter(RouteVehiclePlace::sideOfStreetAsString))
            .setter(setter(Builder::sideOfStreet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SideOfStreet").build()).build();

    private static final SdkField<Integer> WAYPOINT_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WaypointIndex").getter(getter(RouteVehiclePlace::waypointIndex)).setter(setter(Builder::waypointIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaypointIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ORIGINAL_POSITION_FIELD, POSITION_FIELD, SIDE_OF_STREET_FIELD, WAYPOINT_INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<Double> originalPosition;

    private final List<Double> position;

    private final String sideOfStreet;

    private final Integer waypointIndex;

    private RouteVehiclePlace(BuilderImpl builder) {
        this.name = builder.name;
        this.originalPosition = builder.originalPosition;
        this.position = builder.position;
        this.sideOfStreet = builder.sideOfStreet;
        this.waypointIndex = builder.waypointIndex;
    }

    /**
     * <p>
     * The name of the place.
     * </p>
     * 
     * @return The name of the place.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the OriginalPosition property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOriginalPosition() {
        return originalPosition != null && !(originalPosition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Position provided in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOriginalPosition} method.
     * </p>
     * 
     * @return Position provided in the request.
     */
    public final List<Double> originalPosition() {
        return originalPosition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Position defined as <code>[longitude, latitude]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return Position defined as <code>[longitude, latitude]</code>.
     */
    public final List<Double> position() {
        return position;
    }

    /**
     * <p>
     * Options to configure matching the provided position to a side of the street.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sideOfStreet} will
     * return {@link RouteSideOfStreet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sideOfStreetAsString}.
     * </p>
     * 
     * @return Options to configure matching the provided position to a side of the street.
     * @see RouteSideOfStreet
     */
    public final RouteSideOfStreet sideOfStreet() {
        return RouteSideOfStreet.fromValue(sideOfStreet);
    }

    /**
     * <p>
     * Options to configure matching the provided position to a side of the street.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sideOfStreet} will
     * return {@link RouteSideOfStreet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sideOfStreetAsString}.
     * </p>
     * 
     * @return Options to configure matching the provided position to a side of the street.
     * @see RouteSideOfStreet
     */
    public final String sideOfStreetAsString() {
        return sideOfStreet;
    }

    /**
     * <p>
     * Index of the waypoint in the request.
     * </p>
     * 
     * @return Index of the waypoint in the request.
     */
    public final Integer waypointIndex() {
        return waypointIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasOriginalPosition() ? originalPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sideOfStreetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(waypointIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehiclePlace)) {
            return false;
        }
        RouteVehiclePlace other = (RouteVehiclePlace) obj;
        return Objects.equals(name(), other.name()) && hasOriginalPosition() == other.hasOriginalPosition()
                && Objects.equals(originalPosition(), other.originalPosition()) && hasPosition() == other.hasPosition()
                && Objects.equals(position(), other.position())
                && Objects.equals(sideOfStreetAsString(), other.sideOfStreetAsString())
                && Objects.equals(waypointIndex(), other.waypointIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteVehiclePlace").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OriginalPosition", originalPosition() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Position", position() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SideOfStreet", sideOfStreetAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WaypointIndex", waypointIndex() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OriginalPosition":
            return Optional.ofNullable(clazz.cast(originalPosition()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        case "SideOfStreet":
            return Optional.ofNullable(clazz.cast(sideOfStreetAsString()));
        case "WaypointIndex":
            return Optional.ofNullable(clazz.cast(waypointIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("OriginalPosition", ORIGINAL_POSITION_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("SideOfStreet", SIDE_OF_STREET_FIELD);
        map.put("WaypointIndex", WAYPOINT_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehiclePlace, T> g) {
        return obj -> g.apply((RouteVehiclePlace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteVehiclePlace> {
        /**
         * <p>
         * The name of the place.
         * </p>
         * 
         * @param name
         *        The name of the place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Position provided in the request.
         * </p>
         * 
         * @param originalPosition
         *        Position provided in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalPosition(Collection<Double> originalPosition);

        /**
         * <p>
         * Position provided in the request.
         * </p>
         * 
         * @param originalPosition
         *        Position provided in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalPosition(Double... originalPosition);

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);

        /**
         * <p>
         * Options to configure matching the provided position to a side of the street.
         * </p>
         * 
         * @param sideOfStreet
         *        Options to configure matching the provided position to a side of the street.
         * @see RouteSideOfStreet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteSideOfStreet
         */
        Builder sideOfStreet(String sideOfStreet);

        /**
         * <p>
         * Options to configure matching the provided position to a side of the street.
         * </p>
         * 
         * @param sideOfStreet
         *        Options to configure matching the provided position to a side of the street.
         * @see RouteSideOfStreet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteSideOfStreet
         */
        Builder sideOfStreet(RouteSideOfStreet sideOfStreet);

        /**
         * <p>
         * Index of the waypoint in the request.
         * </p>
         * 
         * @param waypointIndex
         *        Index of the waypoint in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waypointIndex(Integer waypointIndex);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<Double> originalPosition = DefaultSdkAutoConstructList.getInstance();

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private String sideOfStreet;

        private Integer waypointIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehiclePlace model) {
            name(model.name);
            originalPosition(model.originalPosition);
            position(model.position);
            sideOfStreet(model.sideOfStreet);
            waypointIndex(model.waypointIndex);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<Double> getOriginalPosition() {
            if (originalPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return originalPosition;
        }

        public final void setOriginalPosition(Collection<Double> originalPosition) {
            this.originalPosition = Position23Copier.copy(originalPosition);
        }

        @Override
        public final Builder originalPosition(Collection<Double> originalPosition) {
            this.originalPosition = Position23Copier.copy(originalPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originalPosition(Double... originalPosition) {
            originalPosition(Arrays.asList(originalPosition));
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = Position23Copier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = Position23Copier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        public final String getSideOfStreet() {
            return sideOfStreet;
        }

        public final void setSideOfStreet(String sideOfStreet) {
            this.sideOfStreet = sideOfStreet;
        }

        @Override
        public final Builder sideOfStreet(String sideOfStreet) {
            this.sideOfStreet = sideOfStreet;
            return this;
        }

        @Override
        public final Builder sideOfStreet(RouteSideOfStreet sideOfStreet) {
            this.sideOfStreet(sideOfStreet == null ? null : sideOfStreet.toString());
            return this;
        }

        public final Integer getWaypointIndex() {
            return waypointIndex;
        }

        public final void setWaypointIndex(Integer waypointIndex) {
            this.waypointIndex = waypointIndex;
        }

        @Override
        public final Builder waypointIndex(Integer waypointIndex) {
            this.waypointIndex = waypointIndex;
            return this;
        }

        @Override
        public RouteVehiclePlace build() {
            return new RouteVehiclePlace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
