/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This property contains a summary of violated constraints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteViolatedConstraints implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteViolatedConstraints.Builder, RouteViolatedConstraints> {
    private static final SdkField<Boolean> ALL_HAZARDS_RESTRICTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllHazardsRestricted").getter(getter(RouteViolatedConstraints::allHazardsRestricted))
            .setter(setter(Builder::allHazardsRestricted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllHazardsRestricted").build())
            .build();

    private static final SdkField<RouteNoticeDetailRange> AXLE_COUNT_FIELD = SdkField
            .<RouteNoticeDetailRange> builder(MarshallingType.SDK_POJO).memberName("AxleCount")
            .getter(getter(RouteViolatedConstraints::axleCount)).setter(setter(Builder::axleCount))
            .constructor(RouteNoticeDetailRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxleCount").build()).build();

    private static final SdkField<List<String>> HAZARDOUS_CARGOS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HazardousCargos")
            .getter(getter(RouteViolatedConstraints::hazardousCargosAsStrings))
            .setter(setter(Builder::hazardousCargosWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HazardousCargos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> MAX_HEIGHT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("MaxHeight")
            .getter(getter(RouteViolatedConstraints::maxHeight)).setter(setter(Builder::maxHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHeight").build()).build();

    private static final SdkField<Long> MAX_KPRA_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxKpraLength").getter(getter(RouteViolatedConstraints::maxKpraLength))
            .setter(setter(Builder::maxKpraLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxKpraLength").build()).build();

    private static final SdkField<Long> MAX_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("MaxLength")
            .getter(getter(RouteViolatedConstraints::maxLength)).setter(setter(Builder::maxLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLength").build()).build();

    private static final SdkField<Long> MAX_PAYLOAD_CAPACITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxPayloadCapacity").getter(getter(RouteViolatedConstraints::maxPayloadCapacity))
            .setter(setter(Builder::maxPayloadCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPayloadCapacity").build())
            .build();

    private static final SdkField<RouteWeightConstraint> MAX_WEIGHT_FIELD = SdkField
            .<RouteWeightConstraint> builder(MarshallingType.SDK_POJO).memberName("MaxWeight")
            .getter(getter(RouteViolatedConstraints::maxWeight)).setter(setter(Builder::maxWeight))
            .constructor(RouteWeightConstraint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWeight").build()).build();

    private static final SdkField<Long> MAX_WEIGHT_PER_AXLE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxWeightPerAxle").getter(getter(RouteViolatedConstraints::maxWeightPerAxle))
            .setter(setter(Builder::maxWeightPerAxle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWeightPerAxle").build()).build();

    private static final SdkField<WeightPerAxleGroup> MAX_WEIGHT_PER_AXLE_GROUP_FIELD = SdkField
            .<WeightPerAxleGroup> builder(MarshallingType.SDK_POJO).memberName("MaxWeightPerAxleGroup")
            .getter(getter(RouteViolatedConstraints::maxWeightPerAxleGroup)).setter(setter(Builder::maxWeightPerAxleGroup))
            .constructor(WeightPerAxleGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWeightPerAxleGroup").build())
            .build();

    private static final SdkField<Long> MAX_WIDTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("MaxWidth")
            .getter(getter(RouteViolatedConstraints::maxWidth)).setter(setter(Builder::maxWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWidth").build()).build();

    private static final SdkField<RouteNoticeDetailRange> OCCUPANCY_FIELD = SdkField
            .<RouteNoticeDetailRange> builder(MarshallingType.SDK_POJO).memberName("Occupancy")
            .getter(getter(RouteViolatedConstraints::occupancy)).setter(setter(Builder::occupancy))
            .constructor(RouteNoticeDetailRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Occupancy").build()).build();

    private static final SdkField<String> RESTRICTED_TIMES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestrictedTimes").getter(getter(RouteViolatedConstraints::restrictedTimes))
            .setter(setter(Builder::restrictedTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictedTimes").build()).build();

    private static final SdkField<Boolean> TIME_DEPENDENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TimeDependent").getter(getter(RouteViolatedConstraints::timeDependent))
            .setter(setter(Builder::timeDependent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeDependent").build()).build();

    private static final SdkField<RouteNoticeDetailRange> TRAILER_COUNT_FIELD = SdkField
            .<RouteNoticeDetailRange> builder(MarshallingType.SDK_POJO).memberName("TrailerCount")
            .getter(getter(RouteViolatedConstraints::trailerCount)).setter(setter(Builder::trailerCount))
            .constructor(RouteNoticeDetailRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailerCount").build()).build();

    private static final SdkField<Boolean> TRAVEL_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TravelMode").getter(getter(RouteViolatedConstraints::travelMode)).setter(setter(Builder::travelMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()).build();

    private static final SdkField<String> TRUCK_ROAD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TruckRoadType").getter(getter(RouteViolatedConstraints::truckRoadType))
            .setter(setter(Builder::truckRoadType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckRoadType").build()).build();

    private static final SdkField<String> TRUCK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TruckType").getter(getter(RouteViolatedConstraints::truckTypeAsString))
            .setter(setter(Builder::truckType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckType").build()).build();

    private static final SdkField<String> TUNNEL_RESTRICTION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TunnelRestrictionCode").getter(getter(RouteViolatedConstraints::tunnelRestrictionCode))
            .setter(setter(Builder::tunnelRestrictionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelRestrictionCode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_HAZARDS_RESTRICTED_FIELD,
            AXLE_COUNT_FIELD, HAZARDOUS_CARGOS_FIELD, MAX_HEIGHT_FIELD, MAX_KPRA_LENGTH_FIELD, MAX_LENGTH_FIELD,
            MAX_PAYLOAD_CAPACITY_FIELD, MAX_WEIGHT_FIELD, MAX_WEIGHT_PER_AXLE_FIELD, MAX_WEIGHT_PER_AXLE_GROUP_FIELD,
            MAX_WIDTH_FIELD, OCCUPANCY_FIELD, RESTRICTED_TIMES_FIELD, TIME_DEPENDENT_FIELD, TRAILER_COUNT_FIELD,
            TRAVEL_MODE_FIELD, TRUCK_ROAD_TYPE_FIELD, TRUCK_TYPE_FIELD, TUNNEL_RESTRICTION_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean allHazardsRestricted;

    private final RouteNoticeDetailRange axleCount;

    private final List<String> hazardousCargos;

    private final Long maxHeight;

    private final Long maxKpraLength;

    private final Long maxLength;

    private final Long maxPayloadCapacity;

    private final RouteWeightConstraint maxWeight;

    private final Long maxWeightPerAxle;

    private final WeightPerAxleGroup maxWeightPerAxleGroup;

    private final Long maxWidth;

    private final RouteNoticeDetailRange occupancy;

    private final String restrictedTimes;

    private final Boolean timeDependent;

    private final RouteNoticeDetailRange trailerCount;

    private final Boolean travelMode;

    private final String truckRoadType;

    private final String truckType;

    private final String tunnelRestrictionCode;

    private RouteViolatedConstraints(BuilderImpl builder) {
        this.allHazardsRestricted = builder.allHazardsRestricted;
        this.axleCount = builder.axleCount;
        this.hazardousCargos = builder.hazardousCargos;
        this.maxHeight = builder.maxHeight;
        this.maxKpraLength = builder.maxKpraLength;
        this.maxLength = builder.maxLength;
        this.maxPayloadCapacity = builder.maxPayloadCapacity;
        this.maxWeight = builder.maxWeight;
        this.maxWeightPerAxle = builder.maxWeightPerAxle;
        this.maxWeightPerAxleGroup = builder.maxWeightPerAxleGroup;
        this.maxWidth = builder.maxWidth;
        this.occupancy = builder.occupancy;
        this.restrictedTimes = builder.restrictedTimes;
        this.timeDependent = builder.timeDependent;
        this.trailerCount = builder.trailerCount;
        this.travelMode = builder.travelMode;
        this.truckRoadType = builder.truckRoadType;
        this.truckType = builder.truckType;
        this.tunnelRestrictionCode = builder.tunnelRestrictionCode;
    }

    /**
     * <p>
     * This restriction applies to truck cargo, where the resulting route excludes roads on which hazardous materials
     * are prohibited from being transported.
     * </p>
     * 
     * @return This restriction applies to truck cargo, where the resulting route excludes roads on which hazardous
     *         materials are prohibited from being transported.
     */
    public final Boolean allHazardsRestricted() {
        return allHazardsRestricted;
    }

    /**
     * <p>
     * Total number of axles of the vehicle.
     * </p>
     * 
     * @return Total number of axles of the vehicle.
     */
    public final RouteNoticeDetailRange axleCount() {
        return axleCount;
    }

    /**
     * <p>
     * List of Hazardous cargo contained in the vehicle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHazardousCargos} method.
     * </p>
     * 
     * @return List of Hazardous cargo contained in the vehicle.
     */
    public final List<RouteHazardousCargoType> hazardousCargos() {
        return RouteHazardousCargoTypeListCopier.copyStringToEnum(hazardousCargos);
    }

    /**
     * For responses, this returns true if the service returned a value for the HazardousCargos property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHazardousCargos() {
        return hazardousCargos != null && !(hazardousCargos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Hazardous cargo contained in the vehicle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHazardousCargos} method.
     * </p>
     * 
     * @return List of Hazardous cargo contained in the vehicle.
     */
    public final List<String> hazardousCargosAsStrings() {
        return hazardousCargos;
    }

    /**
     * <p>
     * The maximum height of the vehicle.
     * </p>
     * 
     * @return The maximum height of the vehicle.
     */
    public final Long maxHeight() {
        return maxHeight;
    }

    /**
     * <p>
     * The maximum Kpra length of the vehicle.
     * </p>
     * <p>
     * <b>Unit</b>: <code>centimeters</code>
     * </p>
     * 
     * @return The maximum Kpra length of the vehicle.</p>
     *         <p>
     *         <b>Unit</b>: <code>centimeters</code>
     */
    public final Long maxKpraLength() {
        return maxKpraLength;
    }

    /**
     * <p>
     * The maximum length of the vehicle.
     * </p>
     * 
     * @return The maximum length of the vehicle.
     */
    public final Long maxLength() {
        return maxLength;
    }

    /**
     * <p>
     * The maximum load capacity of the vehicle.
     * </p>
     * <p>
     * <b>Unit</b>: <code>kilograms</code>
     * </p>
     * 
     * @return The maximum load capacity of the vehicle.</p>
     *         <p>
     *         <b>Unit</b>: <code>kilograms</code>
     */
    public final Long maxPayloadCapacity() {
        return maxPayloadCapacity;
    }

    /**
     * <p>
     * The maximum weight of the route.
     * </p>
     * <p>
     * <b>Unit</b>: <code>Kilograms</code>
     * </p>
     * 
     * @return The maximum weight of the route.</p>
     *         <p>
     *         <b>Unit</b>: <code>Kilograms</code>
     */
    public final RouteWeightConstraint maxWeight() {
        return maxWeight;
    }

    /**
     * <p>
     * The maximum weight per axle of the vehicle.
     * </p>
     * <p>
     * <b>Unit</b>: <code>Kilograms</code>
     * </p>
     * 
     * @return The maximum weight per axle of the vehicle.</p>
     *         <p>
     *         <b>Unit</b>: <code>Kilograms</code>
     */
    public final Long maxWeightPerAxle() {
        return maxWeightPerAxle;
    }

    /**
     * <p>
     * The maximum weight per axle group of the vehicle.
     * </p>
     * <p>
     * <b>Unit</b>: <code>Kilograms</code>
     * </p>
     * 
     * @return The maximum weight per axle group of the vehicle.</p>
     *         <p>
     *         <b>Unit</b>: <code>Kilograms</code>
     */
    public final WeightPerAxleGroup maxWeightPerAxleGroup() {
        return maxWeightPerAxleGroup;
    }

    /**
     * <p>
     * The maximum width of the vehicle.
     * </p>
     * 
     * @return The maximum width of the vehicle.
     */
    public final Long maxWidth() {
        return maxWidth;
    }

    /**
     * <p>
     * The number of occupants in the vehicle.
     * </p>
     * <p>
     * Default Value: <code>1</code>
     * </p>
     * 
     * @return The number of occupants in the vehicle.</p>
     *         <p>
     *         Default Value: <code>1</code>
     */
    public final RouteNoticeDetailRange occupancy() {
        return occupancy;
    }

    /**
     * <p>
     * Access radius restrictions based on time.
     * </p>
     * 
     * @return Access radius restrictions based on time.
     */
    public final String restrictedTimes() {
        return restrictedTimes;
    }

    /**
     * <p>
     * The time dependent constraint.
     * </p>
     * 
     * @return The time dependent constraint.
     */
    public final Boolean timeDependent() {
        return timeDependent;
    }

    /**
     * <p>
     * Number of trailers attached to the vehicle.
     * </p>
     * <p>
     * Default Value: <code>0</code>
     * </p>
     * 
     * @return Number of trailers attached to the vehicle.</p>
     *         <p>
     *         Default Value: <code>0</code>
     */
    public final RouteNoticeDetailRange trailerCount() {
        return trailerCount;
    }

    /**
     * <p>
     * Travel mode corresponding to the leg.
     * </p>
     * 
     * @return Travel mode corresponding to the leg.
     */
    public final Boolean travelMode() {
        return travelMode;
    }

    /**
     * <p>
     * Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
     * <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.
     * </p>
     * <note>
     * <p>
     * There are currently no other supported values as of 26th April 2024.
     * </p>
     * </note>
     * 
     * @return Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
     *         <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.</p> <note>
     *         <p>
     *         There are currently no other supported values as of 26th April 2024.
     *         </p>
     */
    public final String truckRoadType() {
        return truckRoadType;
    }

    /**
     * <p>
     * Type of the truck.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #truckType} will
     * return {@link RouteTruckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #truckTypeAsString}.
     * </p>
     * 
     * @return Type of the truck.
     * @see RouteTruckType
     */
    public final RouteTruckType truckType() {
        return RouteTruckType.fromValue(truckType);
    }

    /**
     * <p>
     * Type of the truck.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #truckType} will
     * return {@link RouteTruckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #truckTypeAsString}.
     * </p>
     * 
     * @return Type of the truck.
     * @see RouteTruckType
     */
    public final String truckTypeAsString() {
        return truckType;
    }

    /**
     * <p>
     * The tunnel restriction code.
     * </p>
     * <p>
     * Tunnel categories in this list indicate the restrictions which apply to certain tunnels in Great Britain. They
     * relate to the types of dangerous goods that can be transported through them.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Tunnel Category B</i>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Risk Level</i>: Limited risk
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Restrictions</i>: Few restrictions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <i>Tunnel Category C</i>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Risk Level</i>: Medium risk
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Restrictions</i>: Some restrictions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <i>Tunnel Category D</i>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Risk Level</i>: High risk
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Restrictions</i>: Many restrictions occur
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <i>Tunnel Category E</i>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Risk Level</i>: Very high risk
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Restrictions</i>: Restricted tunnel
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The tunnel restriction code.</p>
     *         <p>
     *         Tunnel categories in this list indicate the restrictions which apply to certain tunnels in Great Britain.
     *         They relate to the types of dangerous goods that can be transported through them.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Tunnel Category B</i>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Risk Level</i>: Limited risk
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Restrictions</i>: Few restrictions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Tunnel Category C</i>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Risk Level</i>: Medium risk
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Restrictions</i>: Some restrictions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Tunnel Category D</i>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Risk Level</i>: High risk
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Restrictions</i>: Many restrictions occur
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Tunnel Category E</i>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Risk Level</i>: Very high risk
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Restrictions</i>: Restricted tunnel
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String tunnelRestrictionCode() {
        return tunnelRestrictionCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allHazardsRestricted());
        hashCode = 31 * hashCode + Objects.hashCode(axleCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasHazardousCargos() ? hazardousCargosAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxHeight());
        hashCode = 31 * hashCode + Objects.hashCode(maxKpraLength());
        hashCode = 31 * hashCode + Objects.hashCode(maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(maxPayloadCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxWeight());
        hashCode = 31 * hashCode + Objects.hashCode(maxWeightPerAxle());
        hashCode = 31 * hashCode + Objects.hashCode(maxWeightPerAxleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(maxWidth());
        hashCode = 31 * hashCode + Objects.hashCode(occupancy());
        hashCode = 31 * hashCode + Objects.hashCode(restrictedTimes());
        hashCode = 31 * hashCode + Objects.hashCode(timeDependent());
        hashCode = 31 * hashCode + Objects.hashCode(trailerCount());
        hashCode = 31 * hashCode + Objects.hashCode(travelMode());
        hashCode = 31 * hashCode + Objects.hashCode(truckRoadType());
        hashCode = 31 * hashCode + Objects.hashCode(truckTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelRestrictionCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteViolatedConstraints)) {
            return false;
        }
        RouteViolatedConstraints other = (RouteViolatedConstraints) obj;
        return Objects.equals(allHazardsRestricted(), other.allHazardsRestricted())
                && Objects.equals(axleCount(), other.axleCount()) && hasHazardousCargos() == other.hasHazardousCargos()
                && Objects.equals(hazardousCargosAsStrings(), other.hazardousCargosAsStrings())
                && Objects.equals(maxHeight(), other.maxHeight()) && Objects.equals(maxKpraLength(), other.maxKpraLength())
                && Objects.equals(maxLength(), other.maxLength())
                && Objects.equals(maxPayloadCapacity(), other.maxPayloadCapacity())
                && Objects.equals(maxWeight(), other.maxWeight()) && Objects.equals(maxWeightPerAxle(), other.maxWeightPerAxle())
                && Objects.equals(maxWeightPerAxleGroup(), other.maxWeightPerAxleGroup())
                && Objects.equals(maxWidth(), other.maxWidth()) && Objects.equals(occupancy(), other.occupancy())
                && Objects.equals(restrictedTimes(), other.restrictedTimes())
                && Objects.equals(timeDependent(), other.timeDependent()) && Objects.equals(trailerCount(), other.trailerCount())
                && Objects.equals(travelMode(), other.travelMode()) && Objects.equals(truckRoadType(), other.truckRoadType())
                && Objects.equals(truckTypeAsString(), other.truckTypeAsString())
                && Objects.equals(tunnelRestrictionCode(), other.tunnelRestrictionCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteViolatedConstraints")
                .add("AllHazardsRestricted", allHazardsRestricted() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AxleCount", axleCount())
                .add("HazardousCargos", hazardousCargosAsStrings() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxHeight", maxHeight() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxKpraLength", maxKpraLength() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxLength", maxLength() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxPayloadCapacity", maxPayloadCapacity() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxWeight", maxWeight())
                .add("MaxWeightPerAxle", maxWeightPerAxle() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxWeightPerAxleGroup", maxWeightPerAxleGroup())
                .add("MaxWidth", maxWidth() == null ? null : "*** Sensitive Data Redacted ***").add("Occupancy", occupancy())
                .add("RestrictedTimes", restrictedTimes())
                .add("TimeDependent", timeDependent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TrailerCount", trailerCount())
                .add("TravelMode", travelMode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TruckRoadType", truckRoadType())
                .add("TruckType", truckTypeAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TunnelRestrictionCode", tunnelRestrictionCode() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllHazardsRestricted":
            return Optional.ofNullable(clazz.cast(allHazardsRestricted()));
        case "AxleCount":
            return Optional.ofNullable(clazz.cast(axleCount()));
        case "HazardousCargos":
            return Optional.ofNullable(clazz.cast(hazardousCargosAsStrings()));
        case "MaxHeight":
            return Optional.ofNullable(clazz.cast(maxHeight()));
        case "MaxKpraLength":
            return Optional.ofNullable(clazz.cast(maxKpraLength()));
        case "MaxLength":
            return Optional.ofNullable(clazz.cast(maxLength()));
        case "MaxPayloadCapacity":
            return Optional.ofNullable(clazz.cast(maxPayloadCapacity()));
        case "MaxWeight":
            return Optional.ofNullable(clazz.cast(maxWeight()));
        case "MaxWeightPerAxle":
            return Optional.ofNullable(clazz.cast(maxWeightPerAxle()));
        case "MaxWeightPerAxleGroup":
            return Optional.ofNullable(clazz.cast(maxWeightPerAxleGroup()));
        case "MaxWidth":
            return Optional.ofNullable(clazz.cast(maxWidth()));
        case "Occupancy":
            return Optional.ofNullable(clazz.cast(occupancy()));
        case "RestrictedTimes":
            return Optional.ofNullable(clazz.cast(restrictedTimes()));
        case "TimeDependent":
            return Optional.ofNullable(clazz.cast(timeDependent()));
        case "TrailerCount":
            return Optional.ofNullable(clazz.cast(trailerCount()));
        case "TravelMode":
            return Optional.ofNullable(clazz.cast(travelMode()));
        case "TruckRoadType":
            return Optional.ofNullable(clazz.cast(truckRoadType()));
        case "TruckType":
            return Optional.ofNullable(clazz.cast(truckTypeAsString()));
        case "TunnelRestrictionCode":
            return Optional.ofNullable(clazz.cast(tunnelRestrictionCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllHazardsRestricted", ALL_HAZARDS_RESTRICTED_FIELD);
        map.put("AxleCount", AXLE_COUNT_FIELD);
        map.put("HazardousCargos", HAZARDOUS_CARGOS_FIELD);
        map.put("MaxHeight", MAX_HEIGHT_FIELD);
        map.put("MaxKpraLength", MAX_KPRA_LENGTH_FIELD);
        map.put("MaxLength", MAX_LENGTH_FIELD);
        map.put("MaxPayloadCapacity", MAX_PAYLOAD_CAPACITY_FIELD);
        map.put("MaxWeight", MAX_WEIGHT_FIELD);
        map.put("MaxWeightPerAxle", MAX_WEIGHT_PER_AXLE_FIELD);
        map.put("MaxWeightPerAxleGroup", MAX_WEIGHT_PER_AXLE_GROUP_FIELD);
        map.put("MaxWidth", MAX_WIDTH_FIELD);
        map.put("Occupancy", OCCUPANCY_FIELD);
        map.put("RestrictedTimes", RESTRICTED_TIMES_FIELD);
        map.put("TimeDependent", TIME_DEPENDENT_FIELD);
        map.put("TrailerCount", TRAILER_COUNT_FIELD);
        map.put("TravelMode", TRAVEL_MODE_FIELD);
        map.put("TruckRoadType", TRUCK_ROAD_TYPE_FIELD);
        map.put("TruckType", TRUCK_TYPE_FIELD);
        map.put("TunnelRestrictionCode", TUNNEL_RESTRICTION_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteViolatedConstraints, T> g) {
        return obj -> g.apply((RouteViolatedConstraints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteViolatedConstraints> {
        /**
         * <p>
         * This restriction applies to truck cargo, where the resulting route excludes roads on which hazardous
         * materials are prohibited from being transported.
         * </p>
         * 
         * @param allHazardsRestricted
         *        This restriction applies to truck cargo, where the resulting route excludes roads on which hazardous
         *        materials are prohibited from being transported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allHazardsRestricted(Boolean allHazardsRestricted);

        /**
         * <p>
         * Total number of axles of the vehicle.
         * </p>
         * 
         * @param axleCount
         *        Total number of axles of the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder axleCount(RouteNoticeDetailRange axleCount);

        /**
         * <p>
         * Total number of axles of the vehicle.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteNoticeDetailRange.Builder} avoiding
         * the need to create one manually via {@link RouteNoticeDetailRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteNoticeDetailRange.Builder#build()} is called immediately and
         * its result is passed to {@link #axleCount(RouteNoticeDetailRange)}.
         * 
         * @param axleCount
         *        a consumer that will call methods on {@link RouteNoticeDetailRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #axleCount(RouteNoticeDetailRange)
         */
        default Builder axleCount(Consumer<RouteNoticeDetailRange.Builder> axleCount) {
            return axleCount(RouteNoticeDetailRange.builder().applyMutation(axleCount).build());
        }

        /**
         * <p>
         * List of Hazardous cargo contained in the vehicle.
         * </p>
         * 
         * @param hazardousCargos
         *        List of Hazardous cargo contained in the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hazardousCargosWithStrings(Collection<String> hazardousCargos);

        /**
         * <p>
         * List of Hazardous cargo contained in the vehicle.
         * </p>
         * 
         * @param hazardousCargos
         *        List of Hazardous cargo contained in the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hazardousCargosWithStrings(String... hazardousCargos);

        /**
         * <p>
         * List of Hazardous cargo contained in the vehicle.
         * </p>
         * 
         * @param hazardousCargos
         *        List of Hazardous cargo contained in the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hazardousCargos(Collection<RouteHazardousCargoType> hazardousCargos);

        /**
         * <p>
         * List of Hazardous cargo contained in the vehicle.
         * </p>
         * 
         * @param hazardousCargos
         *        List of Hazardous cargo contained in the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hazardousCargos(RouteHazardousCargoType... hazardousCargos);

        /**
         * <p>
         * The maximum height of the vehicle.
         * </p>
         * 
         * @param maxHeight
         *        The maximum height of the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxHeight(Long maxHeight);

        /**
         * <p>
         * The maximum Kpra length of the vehicle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>centimeters</code>
         * </p>
         * 
         * @param maxKpraLength
         *        The maximum Kpra length of the vehicle.</p>
         *        <p>
         *        <b>Unit</b>: <code>centimeters</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxKpraLength(Long maxKpraLength);

        /**
         * <p>
         * The maximum length of the vehicle.
         * </p>
         * 
         * @param maxLength
         *        The maximum length of the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLength(Long maxLength);

        /**
         * <p>
         * The maximum load capacity of the vehicle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>kilograms</code>
         * </p>
         * 
         * @param maxPayloadCapacity
         *        The maximum load capacity of the vehicle.</p>
         *        <p>
         *        <b>Unit</b>: <code>kilograms</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPayloadCapacity(Long maxPayloadCapacity);

        /**
         * <p>
         * The maximum weight of the route.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Kilograms</code>
         * </p>
         * 
         * @param maxWeight
         *        The maximum weight of the route.</p>
         *        <p>
         *        <b>Unit</b>: <code>Kilograms</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWeight(RouteWeightConstraint maxWeight);

        /**
         * <p>
         * The maximum weight of the route.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Kilograms</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteWeightConstraint.Builder} avoiding
         * the need to create one manually via {@link RouteWeightConstraint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteWeightConstraint.Builder#build()} is called immediately and
         * its result is passed to {@link #maxWeight(RouteWeightConstraint)}.
         * 
         * @param maxWeight
         *        a consumer that will call methods on {@link RouteWeightConstraint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maxWeight(RouteWeightConstraint)
         */
        default Builder maxWeight(Consumer<RouteWeightConstraint.Builder> maxWeight) {
            return maxWeight(RouteWeightConstraint.builder().applyMutation(maxWeight).build());
        }

        /**
         * <p>
         * The maximum weight per axle of the vehicle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Kilograms</code>
         * </p>
         * 
         * @param maxWeightPerAxle
         *        The maximum weight per axle of the vehicle.</p>
         *        <p>
         *        <b>Unit</b>: <code>Kilograms</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWeightPerAxle(Long maxWeightPerAxle);

        /**
         * <p>
         * The maximum weight per axle group of the vehicle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Kilograms</code>
         * </p>
         * 
         * @param maxWeightPerAxleGroup
         *        The maximum weight per axle group of the vehicle.</p>
         *        <p>
         *        <b>Unit</b>: <code>Kilograms</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWeightPerAxleGroup(WeightPerAxleGroup maxWeightPerAxleGroup);

        /**
         * <p>
         * The maximum weight per axle group of the vehicle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Kilograms</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link WeightPerAxleGroup.Builder} avoiding the
         * need to create one manually via {@link WeightPerAxleGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WeightPerAxleGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #maxWeightPerAxleGroup(WeightPerAxleGroup)}.
         * 
         * @param maxWeightPerAxleGroup
         *        a consumer that will call methods on {@link WeightPerAxleGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maxWeightPerAxleGroup(WeightPerAxleGroup)
         */
        default Builder maxWeightPerAxleGroup(Consumer<WeightPerAxleGroup.Builder> maxWeightPerAxleGroup) {
            return maxWeightPerAxleGroup(WeightPerAxleGroup.builder().applyMutation(maxWeightPerAxleGroup).build());
        }

        /**
         * <p>
         * The maximum width of the vehicle.
         * </p>
         * 
         * @param maxWidth
         *        The maximum width of the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWidth(Long maxWidth);

        /**
         * <p>
         * The number of occupants in the vehicle.
         * </p>
         * <p>
         * Default Value: <code>1</code>
         * </p>
         * 
         * @param occupancy
         *        The number of occupants in the vehicle.</p>
         *        <p>
         *        Default Value: <code>1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occupancy(RouteNoticeDetailRange occupancy);

        /**
         * <p>
         * The number of occupants in the vehicle.
         * </p>
         * <p>
         * Default Value: <code>1</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteNoticeDetailRange.Builder} avoiding
         * the need to create one manually via {@link RouteNoticeDetailRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteNoticeDetailRange.Builder#build()} is called immediately and
         * its result is passed to {@link #occupancy(RouteNoticeDetailRange)}.
         * 
         * @param occupancy
         *        a consumer that will call methods on {@link RouteNoticeDetailRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #occupancy(RouteNoticeDetailRange)
         */
        default Builder occupancy(Consumer<RouteNoticeDetailRange.Builder> occupancy) {
            return occupancy(RouteNoticeDetailRange.builder().applyMutation(occupancy).build());
        }

        /**
         * <p>
         * Access radius restrictions based on time.
         * </p>
         * 
         * @param restrictedTimes
         *        Access radius restrictions based on time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictedTimes(String restrictedTimes);

        /**
         * <p>
         * The time dependent constraint.
         * </p>
         * 
         * @param timeDependent
         *        The time dependent constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeDependent(Boolean timeDependent);

        /**
         * <p>
         * Number of trailers attached to the vehicle.
         * </p>
         * <p>
         * Default Value: <code>0</code>
         * </p>
         * 
         * @param trailerCount
         *        Number of trailers attached to the vehicle.</p>
         *        <p>
         *        Default Value: <code>0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailerCount(RouteNoticeDetailRange trailerCount);

        /**
         * <p>
         * Number of trailers attached to the vehicle.
         * </p>
         * <p>
         * Default Value: <code>0</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteNoticeDetailRange.Builder} avoiding
         * the need to create one manually via {@link RouteNoticeDetailRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteNoticeDetailRange.Builder#build()} is called immediately and
         * its result is passed to {@link #trailerCount(RouteNoticeDetailRange)}.
         * 
         * @param trailerCount
         *        a consumer that will call methods on {@link RouteNoticeDetailRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trailerCount(RouteNoticeDetailRange)
         */
        default Builder trailerCount(Consumer<RouteNoticeDetailRange.Builder> trailerCount) {
            return trailerCount(RouteNoticeDetailRange.builder().applyMutation(trailerCount).build());
        }

        /**
         * <p>
         * Travel mode corresponding to the leg.
         * </p>
         * 
         * @param travelMode
         *        Travel mode corresponding to the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelMode(Boolean travelMode);

        /**
         * <p>
         * Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         * <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.
         * </p>
         * <note>
         * <p>
         * There are currently no other supported values as of 26th April 2024.
         * </p>
         * </note>
         * 
         * @param truckRoadType
         *        Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         *        <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.</p> <note>
         *        <p>
         *        There are currently no other supported values as of 26th April 2024.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truckRoadType(String truckRoadType);

        /**
         * <p>
         * Type of the truck.
         * </p>
         * 
         * @param truckType
         *        Type of the truck.
         * @see RouteTruckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTruckType
         */
        Builder truckType(String truckType);

        /**
         * <p>
         * Type of the truck.
         * </p>
         * 
         * @param truckType
         *        Type of the truck.
         * @see RouteTruckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTruckType
         */
        Builder truckType(RouteTruckType truckType);

        /**
         * <p>
         * The tunnel restriction code.
         * </p>
         * <p>
         * Tunnel categories in this list indicate the restrictions which apply to certain tunnels in Great Britain.
         * They relate to the types of dangerous goods that can be transported through them.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Tunnel Category B</i>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Risk Level</i>: Limited risk
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Restrictions</i>: Few restrictions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <i>Tunnel Category C</i>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Risk Level</i>: Medium risk
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Restrictions</i>: Some restrictions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <i>Tunnel Category D</i>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Risk Level</i>: High risk
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Restrictions</i>: Many restrictions occur
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <i>Tunnel Category E</i>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Risk Level</i>: Very high risk
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Restrictions</i>: Restricted tunnel
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param tunnelRestrictionCode
         *        The tunnel restriction code.</p>
         *        <p>
         *        Tunnel categories in this list indicate the restrictions which apply to certain tunnels in Great
         *        Britain. They relate to the types of dangerous goods that can be transported through them.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Tunnel Category B</i>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Risk Level</i>: Limited risk
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Restrictions</i>: Few restrictions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Tunnel Category C</i>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Risk Level</i>: Medium risk
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Restrictions</i>: Some restrictions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Tunnel Category D</i>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Risk Level</i>: High risk
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Restrictions</i>: Many restrictions occur
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Tunnel Category E</i>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Risk Level</i>: Very high risk
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Restrictions</i>: Restricted tunnel
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelRestrictionCode(String tunnelRestrictionCode);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allHazardsRestricted;

        private RouteNoticeDetailRange axleCount;

        private List<String> hazardousCargos = DefaultSdkAutoConstructList.getInstance();

        private Long maxHeight;

        private Long maxKpraLength;

        private Long maxLength;

        private Long maxPayloadCapacity;

        private RouteWeightConstraint maxWeight;

        private Long maxWeightPerAxle;

        private WeightPerAxleGroup maxWeightPerAxleGroup;

        private Long maxWidth;

        private RouteNoticeDetailRange occupancy;

        private String restrictedTimes;

        private Boolean timeDependent;

        private RouteNoticeDetailRange trailerCount;

        private Boolean travelMode;

        private String truckRoadType;

        private String truckType;

        private String tunnelRestrictionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteViolatedConstraints model) {
            allHazardsRestricted(model.allHazardsRestricted);
            axleCount(model.axleCount);
            hazardousCargosWithStrings(model.hazardousCargos);
            maxHeight(model.maxHeight);
            maxKpraLength(model.maxKpraLength);
            maxLength(model.maxLength);
            maxPayloadCapacity(model.maxPayloadCapacity);
            maxWeight(model.maxWeight);
            maxWeightPerAxle(model.maxWeightPerAxle);
            maxWeightPerAxleGroup(model.maxWeightPerAxleGroup);
            maxWidth(model.maxWidth);
            occupancy(model.occupancy);
            restrictedTimes(model.restrictedTimes);
            timeDependent(model.timeDependent);
            trailerCount(model.trailerCount);
            travelMode(model.travelMode);
            truckRoadType(model.truckRoadType);
            truckType(model.truckType);
            tunnelRestrictionCode(model.tunnelRestrictionCode);
        }

        public final Boolean getAllHazardsRestricted() {
            return allHazardsRestricted;
        }

        public final void setAllHazardsRestricted(Boolean allHazardsRestricted) {
            this.allHazardsRestricted = allHazardsRestricted;
        }

        @Override
        public final Builder allHazardsRestricted(Boolean allHazardsRestricted) {
            this.allHazardsRestricted = allHazardsRestricted;
            return this;
        }

        public final RouteNoticeDetailRange.Builder getAxleCount() {
            return axleCount != null ? axleCount.toBuilder() : null;
        }

        public final void setAxleCount(RouteNoticeDetailRange.BuilderImpl axleCount) {
            this.axleCount = axleCount != null ? axleCount.build() : null;
        }

        @Override
        public final Builder axleCount(RouteNoticeDetailRange axleCount) {
            this.axleCount = axleCount;
            return this;
        }

        public final Collection<String> getHazardousCargos() {
            if (hazardousCargos instanceof SdkAutoConstructList) {
                return null;
            }
            return hazardousCargos;
        }

        public final void setHazardousCargos(Collection<String> hazardousCargos) {
            this.hazardousCargos = RouteHazardousCargoTypeListCopier.copy(hazardousCargos);
        }

        @Override
        public final Builder hazardousCargosWithStrings(Collection<String> hazardousCargos) {
            this.hazardousCargos = RouteHazardousCargoTypeListCopier.copy(hazardousCargos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hazardousCargosWithStrings(String... hazardousCargos) {
            hazardousCargosWithStrings(Arrays.asList(hazardousCargos));
            return this;
        }

        @Override
        public final Builder hazardousCargos(Collection<RouteHazardousCargoType> hazardousCargos) {
            this.hazardousCargos = RouteHazardousCargoTypeListCopier.copyEnumToString(hazardousCargos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hazardousCargos(RouteHazardousCargoType... hazardousCargos) {
            hazardousCargos(Arrays.asList(hazardousCargos));
            return this;
        }

        public final Long getMaxHeight() {
            return maxHeight;
        }

        public final void setMaxHeight(Long maxHeight) {
            this.maxHeight = maxHeight;
        }

        @Override
        public final Builder maxHeight(Long maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public final Long getMaxKpraLength() {
            return maxKpraLength;
        }

        public final void setMaxKpraLength(Long maxKpraLength) {
            this.maxKpraLength = maxKpraLength;
        }

        @Override
        public final Builder maxKpraLength(Long maxKpraLength) {
            this.maxKpraLength = maxKpraLength;
            return this;
        }

        public final Long getMaxLength() {
            return maxLength;
        }

        public final void setMaxLength(Long maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public final Builder maxLength(Long maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final Long getMaxPayloadCapacity() {
            return maxPayloadCapacity;
        }

        public final void setMaxPayloadCapacity(Long maxPayloadCapacity) {
            this.maxPayloadCapacity = maxPayloadCapacity;
        }

        @Override
        public final Builder maxPayloadCapacity(Long maxPayloadCapacity) {
            this.maxPayloadCapacity = maxPayloadCapacity;
            return this;
        }

        public final RouteWeightConstraint.Builder getMaxWeight() {
            return maxWeight != null ? maxWeight.toBuilder() : null;
        }

        public final void setMaxWeight(RouteWeightConstraint.BuilderImpl maxWeight) {
            this.maxWeight = maxWeight != null ? maxWeight.build() : null;
        }

        @Override
        public final Builder maxWeight(RouteWeightConstraint maxWeight) {
            this.maxWeight = maxWeight;
            return this;
        }

        public final Long getMaxWeightPerAxle() {
            return maxWeightPerAxle;
        }

        public final void setMaxWeightPerAxle(Long maxWeightPerAxle) {
            this.maxWeightPerAxle = maxWeightPerAxle;
        }

        @Override
        public final Builder maxWeightPerAxle(Long maxWeightPerAxle) {
            this.maxWeightPerAxle = maxWeightPerAxle;
            return this;
        }

        public final WeightPerAxleGroup.Builder getMaxWeightPerAxleGroup() {
            return maxWeightPerAxleGroup != null ? maxWeightPerAxleGroup.toBuilder() : null;
        }

        public final void setMaxWeightPerAxleGroup(WeightPerAxleGroup.BuilderImpl maxWeightPerAxleGroup) {
            this.maxWeightPerAxleGroup = maxWeightPerAxleGroup != null ? maxWeightPerAxleGroup.build() : null;
        }

        @Override
        public final Builder maxWeightPerAxleGroup(WeightPerAxleGroup maxWeightPerAxleGroup) {
            this.maxWeightPerAxleGroup = maxWeightPerAxleGroup;
            return this;
        }

        public final Long getMaxWidth() {
            return maxWidth;
        }

        public final void setMaxWidth(Long maxWidth) {
            this.maxWidth = maxWidth;
        }

        @Override
        public final Builder maxWidth(Long maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public final RouteNoticeDetailRange.Builder getOccupancy() {
            return occupancy != null ? occupancy.toBuilder() : null;
        }

        public final void setOccupancy(RouteNoticeDetailRange.BuilderImpl occupancy) {
            this.occupancy = occupancy != null ? occupancy.build() : null;
        }

        @Override
        public final Builder occupancy(RouteNoticeDetailRange occupancy) {
            this.occupancy = occupancy;
            return this;
        }

        public final String getRestrictedTimes() {
            return restrictedTimes;
        }

        public final void setRestrictedTimes(String restrictedTimes) {
            this.restrictedTimes = restrictedTimes;
        }

        @Override
        public final Builder restrictedTimes(String restrictedTimes) {
            this.restrictedTimes = restrictedTimes;
            return this;
        }

        public final Boolean getTimeDependent() {
            return timeDependent;
        }

        public final void setTimeDependent(Boolean timeDependent) {
            this.timeDependent = timeDependent;
        }

        @Override
        public final Builder timeDependent(Boolean timeDependent) {
            this.timeDependent = timeDependent;
            return this;
        }

        public final RouteNoticeDetailRange.Builder getTrailerCount() {
            return trailerCount != null ? trailerCount.toBuilder() : null;
        }

        public final void setTrailerCount(RouteNoticeDetailRange.BuilderImpl trailerCount) {
            this.trailerCount = trailerCount != null ? trailerCount.build() : null;
        }

        @Override
        public final Builder trailerCount(RouteNoticeDetailRange trailerCount) {
            this.trailerCount = trailerCount;
            return this;
        }

        public final Boolean getTravelMode() {
            return travelMode;
        }

        public final void setTravelMode(Boolean travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(Boolean travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        public final String getTruckRoadType() {
            return truckRoadType;
        }

        public final void setTruckRoadType(String truckRoadType) {
            this.truckRoadType = truckRoadType;
        }

        @Override
        public final Builder truckRoadType(String truckRoadType) {
            this.truckRoadType = truckRoadType;
            return this;
        }

        public final String getTruckType() {
            return truckType;
        }

        public final void setTruckType(String truckType) {
            this.truckType = truckType;
        }

        @Override
        public final Builder truckType(String truckType) {
            this.truckType = truckType;
            return this;
        }

        @Override
        public final Builder truckType(RouteTruckType truckType) {
            this.truckType(truckType == null ? null : truckType.toString());
            return this;
        }

        public final String getTunnelRestrictionCode() {
            return tunnelRestrictionCode;
        }

        public final void setTunnelRestrictionCode(String tunnelRestrictionCode) {
            this.tunnelRestrictionCode = tunnelRestrictionCode;
        }

        @Override
        public final Builder tunnelRestrictionCode(String tunnelRestrictionCode) {
            this.tunnelRestrictionCode = tunnelRestrictionCode;
            return this;
        }

        @Override
        public RouteViolatedConstraints build() {
            return new RouteViolatedConstraints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
