/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteZone implements SdkPojo, Serializable, ToCopyableBuilder<RouteZone.Builder, RouteZone> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(RouteZone::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RouteZone::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String category;

    private final String name;

    private RouteZone(BuilderImpl builder) {
        this.category = builder.category;
        this.name = builder.name;
    }

    /**
     * <p>
     * The zone category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link RouteZoneCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The zone category.
     * @see RouteZoneCategory
     */
    public final RouteZoneCategory category() {
        return RouteZoneCategory.fromValue(category);
    }

    /**
     * <p>
     * The zone category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link RouteZoneCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The zone category.
     * @see RouteZoneCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The name of the zone.
     * </p>
     * 
     * @return The name of the zone.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteZone)) {
            return false;
        }
        RouteZone other = (RouteZone) obj;
        return Objects.equals(categoryAsString(), other.categoryAsString()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteZone")
                .add("Category", categoryAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Category", CATEGORY_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteZone, T> g) {
        return obj -> g.apply((RouteZone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteZone> {
        /**
         * <p>
         * The zone category.
         * </p>
         * 
         * @param category
         *        The zone category.
         * @see RouteZoneCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteZoneCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The zone category.
         * </p>
         * 
         * @param category
         *        The zone category.
         * @see RouteZoneCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteZoneCategory
         */
        Builder category(RouteZoneCategory category);

        /**
         * <p>
         * The name of the zone.
         * </p>
         * 
         * @param name
         *        The name of the zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteZone model) {
            category(model.category);
            name(model.name);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(RouteZoneCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public RouteZone build() {
            return new RouteZone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
