/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Access hours corresponding to when a destination can be visited.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationAccessHours implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationAccessHours.Builder, WaypointOptimizationAccessHours> {
    private static final SdkField<WaypointOptimizationAccessHoursEntry> FROM_FIELD = SdkField
            .<WaypointOptimizationAccessHoursEntry> builder(MarshallingType.SDK_POJO).memberName("From")
            .getter(getter(WaypointOptimizationAccessHours::from)).setter(setter(Builder::from))
            .constructor(WaypointOptimizationAccessHoursEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()).build();

    private static final SdkField<WaypointOptimizationAccessHoursEntry> TO_FIELD = SdkField
            .<WaypointOptimizationAccessHoursEntry> builder(MarshallingType.SDK_POJO).memberName("To")
            .getter(getter(WaypointOptimizationAccessHours::to)).setter(setter(Builder::to))
            .constructor(WaypointOptimizationAccessHoursEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, TO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WaypointOptimizationAccessHoursEntry from;

    private final WaypointOptimizationAccessHoursEntry to;

    private WaypointOptimizationAccessHours(BuilderImpl builder) {
        this.from = builder.from;
        this.to = builder.to;
    }

    /**
     * <p>
     * Contains the ID of the starting waypoint in this connection.
     * </p>
     * 
     * @return Contains the ID of the starting waypoint in this connection.
     */
    public final WaypointOptimizationAccessHoursEntry from() {
        return from;
    }

    /**
     * <p>
     * Contains the ID of the ending waypoint in this connection.
     * </p>
     * 
     * @return Contains the ID of the ending waypoint in this connection.
     */
    public final WaypointOptimizationAccessHoursEntry to() {
        return to;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationAccessHours)) {
            return false;
        }
        WaypointOptimizationAccessHours other = (WaypointOptimizationAccessHours) obj;
        return Objects.equals(from(), other.from()) && Objects.equals(to(), other.to());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationAccessHours").add("From", from()).add("To", to()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "From":
            return Optional.ofNullable(clazz.cast(from()));
        case "To":
            return Optional.ofNullable(clazz.cast(to()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("From", FROM_FIELD);
        map.put("To", TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationAccessHours, T> g) {
        return obj -> g.apply((WaypointOptimizationAccessHours) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationAccessHours> {
        /**
         * <p>
         * Contains the ID of the starting waypoint in this connection.
         * </p>
         * 
         * @param from
         *        Contains the ID of the starting waypoint in this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(WaypointOptimizationAccessHoursEntry from);

        /**
         * <p>
         * Contains the ID of the starting waypoint in this connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationAccessHoursEntry.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationAccessHoursEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationAccessHoursEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #from(WaypointOptimizationAccessHoursEntry)}.
         * 
         * @param from
         *        a consumer that will call methods on {@link WaypointOptimizationAccessHoursEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #from(WaypointOptimizationAccessHoursEntry)
         */
        default Builder from(Consumer<WaypointOptimizationAccessHoursEntry.Builder> from) {
            return from(WaypointOptimizationAccessHoursEntry.builder().applyMutation(from).build());
        }

        /**
         * <p>
         * Contains the ID of the ending waypoint in this connection.
         * </p>
         * 
         * @param to
         *        Contains the ID of the ending waypoint in this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(WaypointOptimizationAccessHoursEntry to);

        /**
         * <p>
         * Contains the ID of the ending waypoint in this connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationAccessHoursEntry.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationAccessHoursEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationAccessHoursEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #to(WaypointOptimizationAccessHoursEntry)}.
         * 
         * @param to
         *        a consumer that will call methods on {@link WaypointOptimizationAccessHoursEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #to(WaypointOptimizationAccessHoursEntry)
         */
        default Builder to(Consumer<WaypointOptimizationAccessHoursEntry.Builder> to) {
            return to(WaypointOptimizationAccessHoursEntry.builder().applyMutation(to).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WaypointOptimizationAccessHoursEntry from;

        private WaypointOptimizationAccessHoursEntry to;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationAccessHours model) {
            from(model.from);
            to(model.to);
        }

        public final WaypointOptimizationAccessHoursEntry.Builder getFrom() {
            return from != null ? from.toBuilder() : null;
        }

        public final void setFrom(WaypointOptimizationAccessHoursEntry.BuilderImpl from) {
            this.from = from != null ? from.build() : null;
        }

        @Override
        public final Builder from(WaypointOptimizationAccessHoursEntry from) {
            this.from = from;
            return this;
        }

        public final WaypointOptimizationAccessHoursEntry.Builder getTo() {
            return to != null ? to.toBuilder() : null;
        }

        public final void setTo(WaypointOptimizationAccessHoursEntry.BuilderImpl to) {
            this.to = to != null ? to.build() : null;
        }

        @Override
        public final Builder to(WaypointOptimizationAccessHoursEntry to) {
            this.to = to;
            return this;
        }

        @Override
        public WaypointOptimizationAccessHours build() {
            return new WaypointOptimizationAccessHours(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
