/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Geometry of the area to be avoided.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationAvoidanceAreaGeometry implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationAvoidanceAreaGeometry.Builder, WaypointOptimizationAvoidanceAreaGeometry> {
    private static final SdkField<List<Double>> BOUNDING_BOX_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("BoundingBox")
            .getter(getter(WaypointOptimizationAvoidanceAreaGeometry::boundingBox))
            .setter(setter(Builder::boundingBox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Double> boundingBox;

    private WaypointOptimizationAvoidanceAreaGeometry(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
    }

    /**
     * For responses, this returns true if the service returned a value for the BoundingBox property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBoundingBox() {
        return boundingBox != null && !(boundingBox instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and latitude,)
     * of the southwest corner of the bounding box; the second pair represents the X and Y coordinates (longitude and
     * latitude) of the northeast corner.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBoundingBox} method.
     * </p>
     * 
     * @return Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and
     *         latitude,) of the southwest corner of the bounding box; the second pair represents the X and Y
     *         coordinates (longitude and latitude) of the northeast corner.
     */
    public final List<Double> boundingBox() {
        return boundingBox;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBoundingBox() ? boundingBox() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationAvoidanceAreaGeometry)) {
            return false;
        }
        WaypointOptimizationAvoidanceAreaGeometry other = (WaypointOptimizationAvoidanceAreaGeometry) obj;
        return hasBoundingBox() == other.hasBoundingBox() && Objects.equals(boundingBox(), other.boundingBox());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationAvoidanceAreaGeometry")
                .add("BoundingBox", boundingBox() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationAvoidanceAreaGeometry, T> g) {
        return obj -> g.apply((WaypointOptimizationAvoidanceAreaGeometry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationAvoidanceAreaGeometry> {
        /**
         * <p>
         * Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and
         * latitude,) of the southwest corner of the bounding box; the second pair represents the X and Y coordinates
         * (longitude and latitude) of the northeast corner.
         * </p>
         * 
         * @param boundingBox
         *        Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and
         *        latitude,) of the southwest corner of the bounding box; the second pair represents the X and Y
         *        coordinates (longitude and latitude) of the northeast corner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(Collection<Double> boundingBox);

        /**
         * <p>
         * Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and
         * latitude,) of the southwest corner of the bounding box; the second pair represents the X and Y coordinates
         * (longitude and latitude) of the northeast corner.
         * </p>
         * 
         * @param boundingBox
         *        Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and
         *        latitude,) of the southwest corner of the bounding box; the second pair represents the X and Y
         *        coordinates (longitude and latitude) of the northeast corner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(Double... boundingBox);
    }

    static final class BuilderImpl implements Builder {
        private List<Double> boundingBox = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationAvoidanceAreaGeometry model) {
            boundingBox(model.boundingBox);
        }

        public final Collection<Double> getBoundingBox() {
            if (boundingBox instanceof SdkAutoConstructList) {
                return null;
            }
            return boundingBox;
        }

        public final void setBoundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
        }

        @Override
        public final Builder boundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder boundingBox(Double... boundingBox) {
            boundingBox(Arrays.asList(boundingBox));
            return this;
        }

        @Override
        public WaypointOptimizationAvoidanceAreaGeometry build() {
            return new WaypointOptimizationAvoidanceAreaGeometry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
