/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains information such as distance and duration from one waypoint to the next waypoint in the sequence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationConnection.Builder, WaypointOptimizationConnection> {
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Distance")
            .getter(getter(WaypointOptimizationConnection::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()).build();

    private static final SdkField<String> FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("From")
            .getter(getter(WaypointOptimizationConnection::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()).build();

    private static final SdkField<Long> REST_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RestDuration").getter(getter(WaypointOptimizationConnection::restDuration))
            .setter(setter(Builder::restDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestDuration").build()).build();

    private static final SdkField<String> TO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("To")
            .getter(getter(WaypointOptimizationConnection::to)).setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build()).build();

    private static final SdkField<Long> TRAVEL_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TravelDuration").getter(getter(WaypointOptimizationConnection::travelDuration))
            .setter(setter(Builder::travelDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelDuration").build()).build();

    private static final SdkField<Long> WAIT_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WaitDuration").getter(getter(WaypointOptimizationConnection::waitDuration))
            .setter(setter(Builder::waitDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitDuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTANCE_FIELD, FROM_FIELD,
            REST_DURATION_FIELD, TO_FIELD, TRAVEL_DURATION_FIELD, WAIT_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long distance;

    private final String from;

    private final Long restDuration;

    private final String to;

    private final Long travelDuration;

    private final Long waitDuration;

    private WaypointOptimizationConnection(BuilderImpl builder) {
        this.distance = builder.distance;
        this.from = builder.from;
        this.restDuration = builder.restDuration;
        this.to = builder.to;
        this.travelDuration = builder.travelDuration;
        this.waitDuration = builder.waitDuration;
    }

    /**
     * <p>
     * Distance of the step.
     * </p>
     * 
     * @return Distance of the step.
     */
    public final Long distance() {
        return distance;
    }

    /**
     * <p>
     * contains the ID of the starting waypoint in this connection.
     * </p>
     * 
     * @return contains the ID of the starting waypoint in this connection.
     */
    public final String from() {
        return from;
    }

    /**
     * <p>
     * Resting time before the driver can continue driving.
     * </p>
     * 
     * @return Resting time before the driver can continue driving.
     */
    public final Long restDuration() {
        return restDuration;
    }

    /**
     * <p>
     * Contains the ID of the ending waypoint in this connection.
     * </p>
     * 
     * @return Contains the ID of the ending waypoint in this connection.
     */
    public final String to() {
        return to;
    }

    /**
     * <p>
     * Total duration.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Total duration.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long travelDuration() {
        return travelDuration;
    }

    /**
     * <p>
     * Duration of a wait step.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Duration of a wait step.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long waitDuration() {
        return waitDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(restDuration());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        hashCode = 31 * hashCode + Objects.hashCode(travelDuration());
        hashCode = 31 * hashCode + Objects.hashCode(waitDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationConnection)) {
            return false;
        }
        WaypointOptimizationConnection other = (WaypointOptimizationConnection) obj;
        return Objects.equals(distance(), other.distance()) && Objects.equals(from(), other.from())
                && Objects.equals(restDuration(), other.restDuration()) && Objects.equals(to(), other.to())
                && Objects.equals(travelDuration(), other.travelDuration())
                && Objects.equals(waitDuration(), other.waitDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationConnection")
                .add("Distance", distance() == null ? null : "*** Sensitive Data Redacted ***").add("From", from())
                .add("RestDuration", restDuration() == null ? null : "*** Sensitive Data Redacted ***").add("To", to())
                .add("TravelDuration", travelDuration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WaitDuration", waitDuration() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "From":
            return Optional.ofNullable(clazz.cast(from()));
        case "RestDuration":
            return Optional.ofNullable(clazz.cast(restDuration()));
        case "To":
            return Optional.ofNullable(clazz.cast(to()));
        case "TravelDuration":
            return Optional.ofNullable(clazz.cast(travelDuration()));
        case "WaitDuration":
            return Optional.ofNullable(clazz.cast(waitDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Distance", DISTANCE_FIELD);
        map.put("From", FROM_FIELD);
        map.put("RestDuration", REST_DURATION_FIELD);
        map.put("To", TO_FIELD);
        map.put("TravelDuration", TRAVEL_DURATION_FIELD);
        map.put("WaitDuration", WAIT_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationConnection, T> g) {
        return obj -> g.apply((WaypointOptimizationConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationConnection> {
        /**
         * <p>
         * Distance of the step.
         * </p>
         * 
         * @param distance
         *        Distance of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Long distance);

        /**
         * <p>
         * contains the ID of the starting waypoint in this connection.
         * </p>
         * 
         * @param from
         *        contains the ID of the starting waypoint in this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(String from);

        /**
         * <p>
         * Resting time before the driver can continue driving.
         * </p>
         * 
         * @param restDuration
         *        Resting time before the driver can continue driving.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restDuration(Long restDuration);

        /**
         * <p>
         * Contains the ID of the ending waypoint in this connection.
         * </p>
         * 
         * @param to
         *        Contains the ID of the ending waypoint in this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(String to);

        /**
         * <p>
         * Total duration.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param travelDuration
         *        Total duration.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelDuration(Long travelDuration);

        /**
         * <p>
         * Duration of a wait step.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param waitDuration
         *        Duration of a wait step.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitDuration(Long waitDuration);
    }

    static final class BuilderImpl implements Builder {
        private Long distance;

        private String from;

        private Long restDuration;

        private String to;

        private Long travelDuration;

        private Long waitDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationConnection model) {
            distance(model.distance);
            from(model.from);
            restDuration(model.restDuration);
            to(model.to);
            travelDuration(model.travelDuration);
            waitDuration(model.waitDuration);
        }

        public final Long getDistance() {
            return distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final String getFrom() {
            return from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final Long getRestDuration() {
            return restDuration;
        }

        public final void setRestDuration(Long restDuration) {
            this.restDuration = restDuration;
        }

        @Override
        public final Builder restDuration(Long restDuration) {
            this.restDuration = restDuration;
            return this;
        }

        public final String getTo() {
            return to;
        }

        public final void setTo(String to) {
            this.to = to;
        }

        @Override
        public final Builder to(String to) {
            this.to = to;
            return this;
        }

        public final Long getTravelDuration() {
            return travelDuration;
        }

        public final void setTravelDuration(Long travelDuration) {
            this.travelDuration = travelDuration;
        }

        @Override
        public final Builder travelDuration(Long travelDuration) {
            this.travelDuration = travelDuration;
            return this;
        }

        public final Long getWaitDuration() {
            return waitDuration;
        }

        public final void setWaitDuration(Long waitDuration) {
            this.waitDuration = waitDuration;
        }

        @Override
        public final Builder waitDuration(Long waitDuration) {
            this.waitDuration = waitDuration;
            return this;
        }

        @Override
        public WaypointOptimizationConnection build() {
            return new WaypointOptimizationConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
