/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Destination related options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationDestinationOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationDestinationOptions.Builder, WaypointOptimizationDestinationOptions> {
    private static final SdkField<WaypointOptimizationAccessHours> ACCESS_HOURS_FIELD = SdkField
            .<WaypointOptimizationAccessHours> builder(MarshallingType.SDK_POJO).memberName("AccessHours")
            .getter(getter(WaypointOptimizationDestinationOptions::accessHours)).setter(setter(Builder::accessHours))
            .constructor(WaypointOptimizationAccessHours::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessHours").build()).build();

    private static final SdkField<String> APPOINTMENT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppointmentTime").getter(getter(WaypointOptimizationDestinationOptions::appointmentTime))
            .setter(setter(Builder::appointmentTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppointmentTime").build()).build();

    private static final SdkField<Double> HEADING_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Heading")
            .getter(getter(WaypointOptimizationDestinationOptions::heading)).setter(setter(Builder::heading))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Heading").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(WaypointOptimizationDestinationOptions::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Long> SERVICE_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ServiceDuration").getter(getter(WaypointOptimizationDestinationOptions::serviceDuration))
            .setter(setter(Builder::serviceDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceDuration").build()).build();

    private static final SdkField<WaypointOptimizationSideOfStreetOptions> SIDE_OF_STREET_FIELD = SdkField
            .<WaypointOptimizationSideOfStreetOptions> builder(MarshallingType.SDK_POJO).memberName("SideOfStreet")
            .getter(getter(WaypointOptimizationDestinationOptions::sideOfStreet)).setter(setter(Builder::sideOfStreet))
            .constructor(WaypointOptimizationSideOfStreetOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SideOfStreet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_HOURS_FIELD,
            APPOINTMENT_TIME_FIELD, HEADING_FIELD, ID_FIELD, SERVICE_DURATION_FIELD, SIDE_OF_STREET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WaypointOptimizationAccessHours accessHours;

    private final String appointmentTime;

    private final Double heading;

    private final String id;

    private final Long serviceDuration;

    private final WaypointOptimizationSideOfStreetOptions sideOfStreet;

    private WaypointOptimizationDestinationOptions(BuilderImpl builder) {
        this.accessHours = builder.accessHours;
        this.appointmentTime = builder.appointmentTime;
        this.heading = builder.heading;
        this.id = builder.id;
        this.serviceDuration = builder.serviceDuration;
        this.sideOfStreet = builder.sideOfStreet;
    }

    /**
     * <p>
     * Access hours corresponding to when a waypoint can be visited.
     * </p>
     * 
     * @return Access hours corresponding to when a waypoint can be visited.
     */
    public final WaypointOptimizationAccessHours accessHours() {
        return accessHours;
    }

    /**
     * <p>
     * Appointment time at the destination.
     * </p>
     * 
     * @return Appointment time at the destination.
     */
    public final String appointmentTime() {
        return appointmentTime;
    }

    /**
     * <p>
     * GPS Heading at the position.
     * </p>
     * 
     * @return GPS Heading at the position.
     */
    public final Double heading() {
        return heading;
    }

    /**
     * <p>
     * The waypoint Id.
     * </p>
     * 
     * @return The waypoint Id.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Service time spent at the destination. At an appointment, the service time should be the appointment duration.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Service time spent at the destination. At an appointment, the service time should be the appointment
     *         duration.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long serviceDuration() {
        return serviceDuration;
    }

    /**
     * <p>
     * Options to configure matching the provided position to a side of the street.
     * </p>
     * 
     * @return Options to configure matching the provided position to a side of the street.
     */
    public final WaypointOptimizationSideOfStreetOptions sideOfStreet() {
        return sideOfStreet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessHours());
        hashCode = 31 * hashCode + Objects.hashCode(appointmentTime());
        hashCode = 31 * hashCode + Objects.hashCode(heading());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(serviceDuration());
        hashCode = 31 * hashCode + Objects.hashCode(sideOfStreet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationDestinationOptions)) {
            return false;
        }
        WaypointOptimizationDestinationOptions other = (WaypointOptimizationDestinationOptions) obj;
        return Objects.equals(accessHours(), other.accessHours()) && Objects.equals(appointmentTime(), other.appointmentTime())
                && Objects.equals(heading(), other.heading()) && Objects.equals(id(), other.id())
                && Objects.equals(serviceDuration(), other.serviceDuration())
                && Objects.equals(sideOfStreet(), other.sideOfStreet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationDestinationOptions").add("AccessHours", accessHours())
                .add("AppointmentTime", appointmentTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Heading", heading() == null ? null : "*** Sensitive Data Redacted ***").add("Id", id())
                .add("ServiceDuration", serviceDuration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SideOfStreet", sideOfStreet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessHours":
            return Optional.ofNullable(clazz.cast(accessHours()));
        case "AppointmentTime":
            return Optional.ofNullable(clazz.cast(appointmentTime()));
        case "Heading":
            return Optional.ofNullable(clazz.cast(heading()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ServiceDuration":
            return Optional.ofNullable(clazz.cast(serviceDuration()));
        case "SideOfStreet":
            return Optional.ofNullable(clazz.cast(sideOfStreet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessHours", ACCESS_HOURS_FIELD);
        map.put("AppointmentTime", APPOINTMENT_TIME_FIELD);
        map.put("Heading", HEADING_FIELD);
        map.put("Id", ID_FIELD);
        map.put("ServiceDuration", SERVICE_DURATION_FIELD);
        map.put("SideOfStreet", SIDE_OF_STREET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationDestinationOptions, T> g) {
        return obj -> g.apply((WaypointOptimizationDestinationOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationDestinationOptions> {
        /**
         * <p>
         * Access hours corresponding to when a waypoint can be visited.
         * </p>
         * 
         * @param accessHours
         *        Access hours corresponding to when a waypoint can be visited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessHours(WaypointOptimizationAccessHours accessHours);

        /**
         * <p>
         * Access hours corresponding to when a waypoint can be visited.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaypointOptimizationAccessHours.Builder}
         * avoiding the need to create one manually via {@link WaypointOptimizationAccessHours#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationAccessHours.Builder#build()} is called
         * immediately and its result is passed to {@link #accessHours(WaypointOptimizationAccessHours)}.
         * 
         * @param accessHours
         *        a consumer that will call methods on {@link WaypointOptimizationAccessHours.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessHours(WaypointOptimizationAccessHours)
         */
        default Builder accessHours(Consumer<WaypointOptimizationAccessHours.Builder> accessHours) {
            return accessHours(WaypointOptimizationAccessHours.builder().applyMutation(accessHours).build());
        }

        /**
         * <p>
         * Appointment time at the destination.
         * </p>
         * 
         * @param appointmentTime
         *        Appointment time at the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appointmentTime(String appointmentTime);

        /**
         * <p>
         * GPS Heading at the position.
         * </p>
         * 
         * @param heading
         *        GPS Heading at the position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heading(Double heading);

        /**
         * <p>
         * The waypoint Id.
         * </p>
         * 
         * @param id
         *        The waypoint Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Service time spent at the destination. At an appointment, the service time should be the appointment
         * duration.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param serviceDuration
         *        Service time spent at the destination. At an appointment, the service time should be the appointment
         *        duration.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDuration(Long serviceDuration);

        /**
         * <p>
         * Options to configure matching the provided position to a side of the street.
         * </p>
         * 
         * @param sideOfStreet
         *        Options to configure matching the provided position to a side of the street.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sideOfStreet(WaypointOptimizationSideOfStreetOptions sideOfStreet);

        /**
         * <p>
         * Options to configure matching the provided position to a side of the street.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationSideOfStreetOptions.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationSideOfStreetOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationSideOfStreetOptions.Builder#build()} is
         * called immediately and its result is passed to {@link #sideOfStreet(WaypointOptimizationSideOfStreetOptions)}.
         * 
         * @param sideOfStreet
         *        a consumer that will call methods on {@link WaypointOptimizationSideOfStreetOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sideOfStreet(WaypointOptimizationSideOfStreetOptions)
         */
        default Builder sideOfStreet(Consumer<WaypointOptimizationSideOfStreetOptions.Builder> sideOfStreet) {
            return sideOfStreet(WaypointOptimizationSideOfStreetOptions.builder().applyMutation(sideOfStreet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WaypointOptimizationAccessHours accessHours;

        private String appointmentTime;

        private Double heading;

        private String id;

        private Long serviceDuration;

        private WaypointOptimizationSideOfStreetOptions sideOfStreet;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationDestinationOptions model) {
            accessHours(model.accessHours);
            appointmentTime(model.appointmentTime);
            heading(model.heading);
            id(model.id);
            serviceDuration(model.serviceDuration);
            sideOfStreet(model.sideOfStreet);
        }

        public final WaypointOptimizationAccessHours.Builder getAccessHours() {
            return accessHours != null ? accessHours.toBuilder() : null;
        }

        public final void setAccessHours(WaypointOptimizationAccessHours.BuilderImpl accessHours) {
            this.accessHours = accessHours != null ? accessHours.build() : null;
        }

        @Override
        public final Builder accessHours(WaypointOptimizationAccessHours accessHours) {
            this.accessHours = accessHours;
            return this;
        }

        public final String getAppointmentTime() {
            return appointmentTime;
        }

        public final void setAppointmentTime(String appointmentTime) {
            this.appointmentTime = appointmentTime;
        }

        @Override
        public final Builder appointmentTime(String appointmentTime) {
            this.appointmentTime = appointmentTime;
            return this;
        }

        public final Double getHeading() {
            return heading;
        }

        public final void setHeading(Double heading) {
            this.heading = heading;
        }

        @Override
        public final Builder heading(Double heading) {
            this.heading = heading;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Long getServiceDuration() {
            return serviceDuration;
        }

        public final void setServiceDuration(Long serviceDuration) {
            this.serviceDuration = serviceDuration;
        }

        @Override
        public final Builder serviceDuration(Long serviceDuration) {
            this.serviceDuration = serviceDuration;
            return this;
        }

        public final WaypointOptimizationSideOfStreetOptions.Builder getSideOfStreet() {
            return sideOfStreet != null ? sideOfStreet.toBuilder() : null;
        }

        public final void setSideOfStreet(WaypointOptimizationSideOfStreetOptions.BuilderImpl sideOfStreet) {
            this.sideOfStreet = sideOfStreet != null ? sideOfStreet.build() : null;
        }

        @Override
        public final Builder sideOfStreet(WaypointOptimizationSideOfStreetOptions sideOfStreet) {
            this.sideOfStreet = sideOfStreet;
            return this;
        }

        @Override
        public WaypointOptimizationDestinationOptions build() {
            return new WaypointOptimizationDestinationOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
