/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Driver related options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationDriverOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationDriverOptions.Builder, WaypointOptimizationDriverOptions> {
    private static final SdkField<WaypointOptimizationRestCycles> REST_CYCLES_FIELD = SdkField
            .<WaypointOptimizationRestCycles> builder(MarshallingType.SDK_POJO).memberName("RestCycles")
            .getter(getter(WaypointOptimizationDriverOptions::restCycles)).setter(setter(Builder::restCycles))
            .constructor(WaypointOptimizationRestCycles::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestCycles").build()).build();

    private static final SdkField<WaypointOptimizationRestProfile> REST_PROFILE_FIELD = SdkField
            .<WaypointOptimizationRestProfile> builder(MarshallingType.SDK_POJO).memberName("RestProfile")
            .getter(getter(WaypointOptimizationDriverOptions::restProfile)).setter(setter(Builder::restProfile))
            .constructor(WaypointOptimizationRestProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestProfile").build()).build();

    private static final SdkField<String> TREAT_SERVICE_TIME_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatServiceTimeAs").getter(getter(WaypointOptimizationDriverOptions::treatServiceTimeAsAsString))
            .setter(setter(Builder::treatServiceTimeAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatServiceTimeAs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_CYCLES_FIELD,
            REST_PROFILE_FIELD, TREAT_SERVICE_TIME_AS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WaypointOptimizationRestCycles restCycles;

    private final WaypointOptimizationRestProfile restProfile;

    private final String treatServiceTimeAs;

    private WaypointOptimizationDriverOptions(BuilderImpl builder) {
        this.restCycles = builder.restCycles;
        this.restProfile = builder.restProfile;
        this.treatServiceTimeAs = builder.treatServiceTimeAs;
    }

    /**
     * <p>
     * Driver work-rest schedules defined by a short and long cycle. A rest needs to be taken after the short work
     * duration. The short cycle can be repeated until you hit the long work duration, at which point the long rest
     * duration should be taken before restarting.
     * </p>
     * 
     * @return Driver work-rest schedules defined by a short and long cycle. A rest needs to be taken after the short
     *         work duration. The short cycle can be repeated until you hit the long work duration, at which point the
     *         long rest duration should be taken before restarting.
     */
    public final WaypointOptimizationRestCycles restCycles() {
        return restCycles;
    }

    /**
     * <p>
     * Pre defined rest profiles for a driver schedule. The only currently supported profile is EU.
     * </p>
     * 
     * @return Pre defined rest profiles for a driver schedule. The only currently supported profile is EU.
     */
    public final WaypointOptimizationRestProfile restProfile() {
        return restProfile;
    }

    /**
     * <p>
     * If the service time provided at a waypoint/destination should be considered as rest or work. This contributes to
     * the total time breakdown returned within the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #treatServiceTimeAs} will return {@link WaypointOptimizationServiceTimeTreatment#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #treatServiceTimeAsAsString}.
     * </p>
     * 
     * @return If the service time provided at a waypoint/destination should be considered as rest or work. This
     *         contributes to the total time breakdown returned within the response.
     * @see WaypointOptimizationServiceTimeTreatment
     */
    public final WaypointOptimizationServiceTimeTreatment treatServiceTimeAs() {
        return WaypointOptimizationServiceTimeTreatment.fromValue(treatServiceTimeAs);
    }

    /**
     * <p>
     * If the service time provided at a waypoint/destination should be considered as rest or work. This contributes to
     * the total time breakdown returned within the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #treatServiceTimeAs} will return {@link WaypointOptimizationServiceTimeTreatment#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #treatServiceTimeAsAsString}.
     * </p>
     * 
     * @return If the service time provided at a waypoint/destination should be considered as rest or work. This
     *         contributes to the total time breakdown returned within the response.
     * @see WaypointOptimizationServiceTimeTreatment
     */
    public final String treatServiceTimeAsAsString() {
        return treatServiceTimeAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restCycles());
        hashCode = 31 * hashCode + Objects.hashCode(restProfile());
        hashCode = 31 * hashCode + Objects.hashCode(treatServiceTimeAsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationDriverOptions)) {
            return false;
        }
        WaypointOptimizationDriverOptions other = (WaypointOptimizationDriverOptions) obj;
        return Objects.equals(restCycles(), other.restCycles()) && Objects.equals(restProfile(), other.restProfile())
                && Objects.equals(treatServiceTimeAsAsString(), other.treatServiceTimeAsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationDriverOptions").add("RestCycles", restCycles())
                .add("RestProfile", restProfile())
                .add("TreatServiceTimeAs", treatServiceTimeAsAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestCycles":
            return Optional.ofNullable(clazz.cast(restCycles()));
        case "RestProfile":
            return Optional.ofNullable(clazz.cast(restProfile()));
        case "TreatServiceTimeAs":
            return Optional.ofNullable(clazz.cast(treatServiceTimeAsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestCycles", REST_CYCLES_FIELD);
        map.put("RestProfile", REST_PROFILE_FIELD);
        map.put("TreatServiceTimeAs", TREAT_SERVICE_TIME_AS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationDriverOptions, T> g) {
        return obj -> g.apply((WaypointOptimizationDriverOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationDriverOptions> {
        /**
         * <p>
         * Driver work-rest schedules defined by a short and long cycle. A rest needs to be taken after the short work
         * duration. The short cycle can be repeated until you hit the long work duration, at which point the long rest
         * duration should be taken before restarting.
         * </p>
         * 
         * @param restCycles
         *        Driver work-rest schedules defined by a short and long cycle. A rest needs to be taken after the short
         *        work duration. The short cycle can be repeated until you hit the long work duration, at which point
         *        the long rest duration should be taken before restarting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restCycles(WaypointOptimizationRestCycles restCycles);

        /**
         * <p>
         * Driver work-rest schedules defined by a short and long cycle. A rest needs to be taken after the short work
         * duration. The short cycle can be repeated until you hit the long work duration, at which point the long rest
         * duration should be taken before restarting.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaypointOptimizationRestCycles.Builder}
         * avoiding the need to create one manually via {@link WaypointOptimizationRestCycles#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationRestCycles.Builder#build()} is called
         * immediately and its result is passed to {@link #restCycles(WaypointOptimizationRestCycles)}.
         * 
         * @param restCycles
         *        a consumer that will call methods on {@link WaypointOptimizationRestCycles.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restCycles(WaypointOptimizationRestCycles)
         */
        default Builder restCycles(Consumer<WaypointOptimizationRestCycles.Builder> restCycles) {
            return restCycles(WaypointOptimizationRestCycles.builder().applyMutation(restCycles).build());
        }

        /**
         * <p>
         * Pre defined rest profiles for a driver schedule. The only currently supported profile is EU.
         * </p>
         * 
         * @param restProfile
         *        Pre defined rest profiles for a driver schedule. The only currently supported profile is EU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restProfile(WaypointOptimizationRestProfile restProfile);

        /**
         * <p>
         * Pre defined rest profiles for a driver schedule. The only currently supported profile is EU.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaypointOptimizationRestProfile.Builder}
         * avoiding the need to create one manually via {@link WaypointOptimizationRestProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationRestProfile.Builder#build()} is called
         * immediately and its result is passed to {@link #restProfile(WaypointOptimizationRestProfile)}.
         * 
         * @param restProfile
         *        a consumer that will call methods on {@link WaypointOptimizationRestProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restProfile(WaypointOptimizationRestProfile)
         */
        default Builder restProfile(Consumer<WaypointOptimizationRestProfile.Builder> restProfile) {
            return restProfile(WaypointOptimizationRestProfile.builder().applyMutation(restProfile).build());
        }

        /**
         * <p>
         * If the service time provided at a waypoint/destination should be considered as rest or work. This contributes
         * to the total time breakdown returned within the response.
         * </p>
         * 
         * @param treatServiceTimeAs
         *        If the service time provided at a waypoint/destination should be considered as rest or work. This
         *        contributes to the total time breakdown returned within the response.
         * @see WaypointOptimizationServiceTimeTreatment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaypointOptimizationServiceTimeTreatment
         */
        Builder treatServiceTimeAs(String treatServiceTimeAs);

        /**
         * <p>
         * If the service time provided at a waypoint/destination should be considered as rest or work. This contributes
         * to the total time breakdown returned within the response.
         * </p>
         * 
         * @param treatServiceTimeAs
         *        If the service time provided at a waypoint/destination should be considered as rest or work. This
         *        contributes to the total time breakdown returned within the response.
         * @see WaypointOptimizationServiceTimeTreatment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaypointOptimizationServiceTimeTreatment
         */
        Builder treatServiceTimeAs(WaypointOptimizationServiceTimeTreatment treatServiceTimeAs);
    }

    static final class BuilderImpl implements Builder {
        private WaypointOptimizationRestCycles restCycles;

        private WaypointOptimizationRestProfile restProfile;

        private String treatServiceTimeAs;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationDriverOptions model) {
            restCycles(model.restCycles);
            restProfile(model.restProfile);
            treatServiceTimeAs(model.treatServiceTimeAs);
        }

        public final WaypointOptimizationRestCycles.Builder getRestCycles() {
            return restCycles != null ? restCycles.toBuilder() : null;
        }

        public final void setRestCycles(WaypointOptimizationRestCycles.BuilderImpl restCycles) {
            this.restCycles = restCycles != null ? restCycles.build() : null;
        }

        @Override
        public final Builder restCycles(WaypointOptimizationRestCycles restCycles) {
            this.restCycles = restCycles;
            return this;
        }

        public final WaypointOptimizationRestProfile.Builder getRestProfile() {
            return restProfile != null ? restProfile.toBuilder() : null;
        }

        public final void setRestProfile(WaypointOptimizationRestProfile.BuilderImpl restProfile) {
            this.restProfile = restProfile != null ? restProfile.build() : null;
        }

        @Override
        public final Builder restProfile(WaypointOptimizationRestProfile restProfile) {
            this.restProfile = restProfile;
            return this;
        }

        public final String getTreatServiceTimeAs() {
            return treatServiceTimeAs;
        }

        public final void setTreatServiceTimeAs(String treatServiceTimeAs) {
            this.treatServiceTimeAs = treatServiceTimeAs;
        }

        @Override
        public final Builder treatServiceTimeAs(String treatServiceTimeAs) {
            this.treatServiceTimeAs = treatServiceTimeAs;
            return this;
        }

        @Override
        public final Builder treatServiceTimeAs(WaypointOptimizationServiceTimeTreatment treatServiceTimeAs) {
            this.treatServiceTimeAs(treatServiceTimeAs == null ? null : treatServiceTimeAs.toString());
            return this;
        }

        @Override
        public WaypointOptimizationDriverOptions build() {
            return new WaypointOptimizationDriverOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
