/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The impeding waypoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationImpedingWaypoint implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationImpedingWaypoint.Builder, WaypointOptimizationImpedingWaypoint> {
    private static final SdkField<List<WaypointOptimizationFailedConstraint>> FAILED_CONSTRAINTS_FIELD = SdkField
            .<List<WaypointOptimizationFailedConstraint>> builder(MarshallingType.LIST)
            .memberName("FailedConstraints")
            .getter(getter(WaypointOptimizationImpedingWaypoint::failedConstraints))
            .setter(setter(Builder::failedConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WaypointOptimizationFailedConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(WaypointOptimizationFailedConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(WaypointOptimizationImpedingWaypoint::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(WaypointOptimizationImpedingWaypoint::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_CONSTRAINTS_FIELD,
            ID_FIELD, POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<WaypointOptimizationFailedConstraint> failedConstraints;

    private final String id;

    private final List<Double> position;

    private WaypointOptimizationImpedingWaypoint(BuilderImpl builder) {
        this.failedConstraints = builder.failedConstraints;
        this.id = builder.id;
        this.position = builder.position;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedConstraints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedConstraints() {
        return failedConstraints != null && !(failedConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Failed constraints for an impeding waypoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedConstraints} method.
     * </p>
     * 
     * @return Failed constraints for an impeding waypoint.
     */
    public final List<WaypointOptimizationFailedConstraint> failedConstraints() {
        return failedConstraints;
    }

    /**
     * <p>
     * The waypoint Id.
     * </p>
     * 
     * @return The waypoint Id.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Position defined as <code>[longitude, latitude]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return Position defined as <code>[longitude, latitude]</code>.
     */
    public final List<Double> position() {
        return position;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedConstraints() ? failedConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationImpedingWaypoint)) {
            return false;
        }
        WaypointOptimizationImpedingWaypoint other = (WaypointOptimizationImpedingWaypoint) obj;
        return hasFailedConstraints() == other.hasFailedConstraints()
                && Objects.equals(failedConstraints(), other.failedConstraints()) && Objects.equals(id(), other.id())
                && hasPosition() == other.hasPosition() && Objects.equals(position(), other.position());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationImpedingWaypoint")
                .add("FailedConstraints", hasFailedConstraints() ? failedConstraints() : null).add("Id", id())
                .add("Position", position() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedConstraints":
            return Optional.ofNullable(clazz.cast(failedConstraints()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FailedConstraints", FAILED_CONSTRAINTS_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Position", POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationImpedingWaypoint, T> g) {
        return obj -> g.apply((WaypointOptimizationImpedingWaypoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationImpedingWaypoint> {
        /**
         * <p>
         * Failed constraints for an impeding waypoint.
         * </p>
         * 
         * @param failedConstraints
         *        Failed constraints for an impeding waypoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedConstraints(Collection<WaypointOptimizationFailedConstraint> failedConstraints);

        /**
         * <p>
         * Failed constraints for an impeding waypoint.
         * </p>
         * 
         * @param failedConstraints
         *        Failed constraints for an impeding waypoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedConstraints(WaypointOptimizationFailedConstraint... failedConstraints);

        /**
         * <p>
         * Failed constraints for an impeding waypoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationFailedConstraint.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationFailedConstraint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationFailedConstraint.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #failedConstraints(List<WaypointOptimizationFailedConstraint>)}.
         * 
         * @param failedConstraints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationFailedConstraint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedConstraints(java.util.Collection<WaypointOptimizationFailedConstraint>)
         */
        Builder failedConstraints(Consumer<WaypointOptimizationFailedConstraint.Builder>... failedConstraints);

        /**
         * <p>
         * The waypoint Id.
         * </p>
         * 
         * @param id
         *        The waypoint Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);
    }

    static final class BuilderImpl implements Builder {
        private List<WaypointOptimizationFailedConstraint> failedConstraints = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationImpedingWaypoint model) {
            failedConstraints(model.failedConstraints);
            id(model.id);
            position(model.position);
        }

        public final List<WaypointOptimizationFailedConstraint.Builder> getFailedConstraints() {
            List<WaypointOptimizationFailedConstraint.Builder> result = WaypointOptimizationFailedConstraintListCopier
                    .copyToBuilder(this.failedConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedConstraints(Collection<WaypointOptimizationFailedConstraint.BuilderImpl> failedConstraints) {
            this.failedConstraints = WaypointOptimizationFailedConstraintListCopier.copyFromBuilder(failedConstraints);
        }

        @Override
        public final Builder failedConstraints(Collection<WaypointOptimizationFailedConstraint> failedConstraints) {
            this.failedConstraints = WaypointOptimizationFailedConstraintListCopier.copy(failedConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedConstraints(WaypointOptimizationFailedConstraint... failedConstraints) {
            failedConstraints(Arrays.asList(failedConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedConstraints(Consumer<WaypointOptimizationFailedConstraint.Builder>... failedConstraints) {
            failedConstraints(Stream.of(failedConstraints)
                    .map(c -> WaypointOptimizationFailedConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        @Override
        public WaypointOptimizationImpedingWaypoint build() {
            return new WaypointOptimizationImpedingWaypoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
