/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Resting phase of the cycle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationRestCycles implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationRestCycles.Builder, WaypointOptimizationRestCycles> {
    private static final SdkField<WaypointOptimizationRestCycleDurations> LONG_CYCLE_FIELD = SdkField
            .<WaypointOptimizationRestCycleDurations> builder(MarshallingType.SDK_POJO).memberName("LongCycle")
            .getter(getter(WaypointOptimizationRestCycles::longCycle)).setter(setter(Builder::longCycle))
            .constructor(WaypointOptimizationRestCycleDurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongCycle").build()).build();

    private static final SdkField<WaypointOptimizationRestCycleDurations> SHORT_CYCLE_FIELD = SdkField
            .<WaypointOptimizationRestCycleDurations> builder(MarshallingType.SDK_POJO).memberName("ShortCycle")
            .getter(getter(WaypointOptimizationRestCycles::shortCycle)).setter(setter(Builder::shortCycle))
            .constructor(WaypointOptimizationRestCycleDurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortCycle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LONG_CYCLE_FIELD,
            SHORT_CYCLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WaypointOptimizationRestCycleDurations longCycle;

    private final WaypointOptimizationRestCycleDurations shortCycle;

    private WaypointOptimizationRestCycles(BuilderImpl builder) {
        this.longCycle = builder.longCycle;
        this.shortCycle = builder.shortCycle;
    }

    /**
     * <p>
     * Long cycle for a driver work-rest schedule.
     * </p>
     * 
     * @return Long cycle for a driver work-rest schedule.
     */
    public final WaypointOptimizationRestCycleDurations longCycle() {
        return longCycle;
    }

    /**
     * <p>
     * Short cycle for a driver work-rest schedule
     * </p>
     * 
     * @return Short cycle for a driver work-rest schedule
     */
    public final WaypointOptimizationRestCycleDurations shortCycle() {
        return shortCycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(longCycle());
        hashCode = 31 * hashCode + Objects.hashCode(shortCycle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationRestCycles)) {
            return false;
        }
        WaypointOptimizationRestCycles other = (WaypointOptimizationRestCycles) obj;
        return Objects.equals(longCycle(), other.longCycle()) && Objects.equals(shortCycle(), other.shortCycle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationRestCycles").add("LongCycle", longCycle()).add("ShortCycle", shortCycle())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LongCycle":
            return Optional.ofNullable(clazz.cast(longCycle()));
        case "ShortCycle":
            return Optional.ofNullable(clazz.cast(shortCycle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LongCycle", LONG_CYCLE_FIELD);
        map.put("ShortCycle", SHORT_CYCLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationRestCycles, T> g) {
        return obj -> g.apply((WaypointOptimizationRestCycles) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationRestCycles> {
        /**
         * <p>
         * Long cycle for a driver work-rest schedule.
         * </p>
         * 
         * @param longCycle
         *        Long cycle for a driver work-rest schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longCycle(WaypointOptimizationRestCycleDurations longCycle);

        /**
         * <p>
         * Long cycle for a driver work-rest schedule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationRestCycleDurations.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationRestCycleDurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationRestCycleDurations.Builder#build()} is called
         * immediately and its result is passed to {@link #longCycle(WaypointOptimizationRestCycleDurations)}.
         * 
         * @param longCycle
         *        a consumer that will call methods on {@link WaypointOptimizationRestCycleDurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #longCycle(WaypointOptimizationRestCycleDurations)
         */
        default Builder longCycle(Consumer<WaypointOptimizationRestCycleDurations.Builder> longCycle) {
            return longCycle(WaypointOptimizationRestCycleDurations.builder().applyMutation(longCycle).build());
        }

        /**
         * <p>
         * Short cycle for a driver work-rest schedule
         * </p>
         * 
         * @param shortCycle
         *        Short cycle for a driver work-rest schedule
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortCycle(WaypointOptimizationRestCycleDurations shortCycle);

        /**
         * <p>
         * Short cycle for a driver work-rest schedule
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationRestCycleDurations.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationRestCycleDurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationRestCycleDurations.Builder#build()} is called
         * immediately and its result is passed to {@link #shortCycle(WaypointOptimizationRestCycleDurations)}.
         * 
         * @param shortCycle
         *        a consumer that will call methods on {@link WaypointOptimizationRestCycleDurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shortCycle(WaypointOptimizationRestCycleDurations)
         */
        default Builder shortCycle(Consumer<WaypointOptimizationRestCycleDurations.Builder> shortCycle) {
            return shortCycle(WaypointOptimizationRestCycleDurations.builder().applyMutation(shortCycle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WaypointOptimizationRestCycleDurations longCycle;

        private WaypointOptimizationRestCycleDurations shortCycle;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationRestCycles model) {
            longCycle(model.longCycle);
            shortCycle(model.shortCycle);
        }

        public final WaypointOptimizationRestCycleDurations.Builder getLongCycle() {
            return longCycle != null ? longCycle.toBuilder() : null;
        }

        public final void setLongCycle(WaypointOptimizationRestCycleDurations.BuilderImpl longCycle) {
            this.longCycle = longCycle != null ? longCycle.build() : null;
        }

        @Override
        public final Builder longCycle(WaypointOptimizationRestCycleDurations longCycle) {
            this.longCycle = longCycle;
            return this;
        }

        public final WaypointOptimizationRestCycleDurations.Builder getShortCycle() {
            return shortCycle != null ? shortCycle.toBuilder() : null;
        }

        public final void setShortCycle(WaypointOptimizationRestCycleDurations.BuilderImpl shortCycle) {
            this.shortCycle = shortCycle != null ? shortCycle.build() : null;
        }

        @Override
        public final Builder shortCycle(WaypointOptimizationRestCycleDurations shortCycle) {
            this.shortCycle = shortCycle;
            return this;
        }

        @Override
        public WaypointOptimizationRestCycles build() {
            return new WaypointOptimizationRestCycles(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
