/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * With the Amazon Location Routes API you can calculate routes and estimate travel time based on up-to-date road
 * network and live traffic information.
 * </p>
 * <p>
 * Calculate optimal travel routes and estimate travel times using up-to-date road network and traffic data. Key
 * features include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Point-to-point routing with estimated travel time, distance, and turn-by-turn directions
 * </p>
 * </li>
 * <li>
 * <p>
 * Multi-point route optimization to minimize travel time or distance
 * </p>
 * </li>
 * <li>
 * <p>
 * Route matrices for efficient multi-destination planning
 * </p>
 * </li>
 * <li>
 * <p>
 * Isoline calculations to determine reachable areas within specified time or distance thresholds
 * </p>
 * </li>
 * <li>
 * <p>
 * Map-matching to align GPS traces with the road network
 * </p>
 * </li>
 * </ul>
 */
package software.amazon.awssdk.services.georoutes;