/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Circle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Circle> {
    private static final SdkField<List<Double>> CENTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Center").getter(Circle.getter(Circle::center)).setter(Circle.setter(Builder::center)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Center").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Radius").getter(Circle.getter(Circle::radius)).setter(Circle.setter(Builder::radius)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Radius").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CENTER_FIELD, RADIUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Circle.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Double> center;
    private final Double radius;

    private Circle(BuilderImpl builder) {
        this.center = builder.center;
        this.radius = builder.radius;
    }

    public final boolean hasCenter() {
        return this.center != null && !(this.center instanceof SdkAutoConstructList);
    }

    public final List<Double> center() {
        return this.center;
    }

    public final Double radius() {
        return this.radius;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCenter() ? this.center() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.radius());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Circle)) {
            return false;
        }
        Circle other = (Circle)obj;
        return this.hasCenter() == other.hasCenter() && Objects.equals(this.center(), other.center()) && Objects.equals(this.radius(), other.radius());
    }

    public final String toString() {
        return ToString.builder((String)"Circle").add("Center", (Object)(this.center() == null ? null : "*** Sensitive Data Redacted ***")).add("Radius", (Object)(this.radius() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Center": {
                return Optional.ofNullable(clazz.cast(this.center()));
            }
            case "Radius": {
                return Optional.ofNullable(clazz.cast(this.radius()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Center", CENTER_FIELD);
        map.put("Radius", RADIUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Circle, T> g) {
        return obj -> g.apply((Circle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> center = DefaultSdkAutoConstructList.getInstance();
        private Double radius;

        private BuilderImpl() {
        }

        private BuilderImpl(Circle model) {
            this.center(model.center);
            this.radius(model.radius);
        }

        public final Collection<Double> getCenter() {
            if (this.center instanceof SdkAutoConstructList) {
                return null;
            }
            return this.center;
        }

        public final void setCenter(Collection<Double> center) {
            this.center = PositionCopier.copy(center);
        }

        @Override
        public final Builder center(Collection<Double> center) {
            this.center = PositionCopier.copy(center);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder center(Double ... center) {
            this.center(Arrays.asList(center));
            return this;
        }

        public final Double getRadius() {
            return this.radius;
        }

        public final void setRadius(Double radius) {
            this.radius = radius;
        }

        @Override
        public final Builder radius(Double radius) {
            this.radius = radius;
            return this;
        }

        public Circle build() {
            return new Circle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Circle> {
        public Builder center(Collection<Double> var1);

        public Builder center(Double ... var1);

        public Builder radius(Double var1);
    }
}

