/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.IsolineConnection;
import software.amazon.awssdk.services.georoutes.model.IsolineConnectionListCopier;
import software.amazon.awssdk.services.georoutes.model.IsolineShapeGeometry;
import software.amazon.awssdk.services.georoutes.model.IsolineShapeGeometryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Isoline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Isoline> {
    private static final SdkField<List<IsolineConnection>> CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Connections").getter(Isoline.getter(Isoline::connections)).setter(Isoline.setter(Builder::connections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IsolineConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> DISTANCE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DistanceThreshold").getter(Isoline.getter(Isoline::distanceThreshold)).setter(Isoline.setter(Builder::distanceThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceThreshold").build()}).build();
    private static final SdkField<List<IsolineShapeGeometry>> GEOMETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Geometries").getter(Isoline.getter(Isoline::geometries)).setter(Isoline.setter(Builder::geometries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IsolineShapeGeometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> TIME_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TimeThreshold").getter(Isoline.getter(Isoline::timeThreshold)).setter(Isoline.setter(Builder::timeThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIONS_FIELD, DISTANCE_THRESHOLD_FIELD, GEOMETRIES_FIELD, TIME_THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Isoline.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<IsolineConnection> connections;
    private final Long distanceThreshold;
    private final List<IsolineShapeGeometry> geometries;
    private final Long timeThreshold;

    private Isoline(BuilderImpl builder) {
        this.connections = builder.connections;
        this.distanceThreshold = builder.distanceThreshold;
        this.geometries = builder.geometries;
        this.timeThreshold = builder.timeThreshold;
    }

    public final boolean hasConnections() {
        return this.connections != null && !(this.connections instanceof SdkAutoConstructList);
    }

    public final List<IsolineConnection> connections() {
        return this.connections;
    }

    public final Long distanceThreshold() {
        return this.distanceThreshold;
    }

    public final boolean hasGeometries() {
        return this.geometries != null && !(this.geometries instanceof SdkAutoConstructList);
    }

    public final List<IsolineShapeGeometry> geometries() {
        return this.geometries;
    }

    public final Long timeThreshold() {
        return this.timeThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnections() ? this.connections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeometries() ? this.geometries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Isoline)) {
            return false;
        }
        Isoline other = (Isoline)obj;
        return this.hasConnections() == other.hasConnections() && Objects.equals(this.connections(), other.connections()) && Objects.equals(this.distanceThreshold(), other.distanceThreshold()) && this.hasGeometries() == other.hasGeometries() && Objects.equals(this.geometries(), other.geometries()) && Objects.equals(this.timeThreshold(), other.timeThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"Isoline").add("Connections", this.hasConnections() ? this.connections() : null).add("DistanceThreshold", (Object)(this.distanceThreshold() == null ? null : "*** Sensitive Data Redacted ***")).add("Geometries", this.hasGeometries() ? this.geometries() : null).add("TimeThreshold", (Object)(this.timeThreshold() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Connections": {
                return Optional.ofNullable(clazz.cast(this.connections()));
            }
            case "DistanceThreshold": {
                return Optional.ofNullable(clazz.cast(this.distanceThreshold()));
            }
            case "Geometries": {
                return Optional.ofNullable(clazz.cast(this.geometries()));
            }
            case "TimeThreshold": {
                return Optional.ofNullable(clazz.cast(this.timeThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Connections", CONNECTIONS_FIELD);
        map.put("DistanceThreshold", DISTANCE_THRESHOLD_FIELD);
        map.put("Geometries", GEOMETRIES_FIELD);
        map.put("TimeThreshold", TIME_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Isoline, T> g) {
        return obj -> g.apply((Isoline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<IsolineConnection> connections = DefaultSdkAutoConstructList.getInstance();
        private Long distanceThreshold;
        private List<IsolineShapeGeometry> geometries = DefaultSdkAutoConstructList.getInstance();
        private Long timeThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(Isoline model) {
            this.connections(model.connections);
            this.distanceThreshold(model.distanceThreshold);
            this.geometries(model.geometries);
            this.timeThreshold(model.timeThreshold);
        }

        public final List<IsolineConnection.Builder> getConnections() {
            List<IsolineConnection.Builder> result = IsolineConnectionListCopier.copyToBuilder(this.connections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnections(Collection<IsolineConnection.BuilderImpl> connections) {
            this.connections = IsolineConnectionListCopier.copyFromBuilder(connections);
        }

        @Override
        public final Builder connections(Collection<IsolineConnection> connections) {
            this.connections = IsolineConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(IsolineConnection ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Consumer<IsolineConnection.Builder> ... connections) {
            this.connections(Stream.of(connections).map(c -> (IsolineConnection)((IsolineConnection.Builder)IsolineConnection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getDistanceThreshold() {
            return this.distanceThreshold;
        }

        public final void setDistanceThreshold(Long distanceThreshold) {
            this.distanceThreshold = distanceThreshold;
        }

        @Override
        public final Builder distanceThreshold(Long distanceThreshold) {
            this.distanceThreshold = distanceThreshold;
            return this;
        }

        public final List<IsolineShapeGeometry.Builder> getGeometries() {
            List<IsolineShapeGeometry.Builder> result = IsolineShapeGeometryListCopier.copyToBuilder(this.geometries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeometries(Collection<IsolineShapeGeometry.BuilderImpl> geometries) {
            this.geometries = IsolineShapeGeometryListCopier.copyFromBuilder(geometries);
        }

        @Override
        public final Builder geometries(Collection<IsolineShapeGeometry> geometries) {
            this.geometries = IsolineShapeGeometryListCopier.copy(geometries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geometries(IsolineShapeGeometry ... geometries) {
            this.geometries(Arrays.asList(geometries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geometries(Consumer<IsolineShapeGeometry.Builder> ... geometries) {
            this.geometries(Stream.of(geometries).map(c -> (IsolineShapeGeometry)((IsolineShapeGeometry.Builder)IsolineShapeGeometry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getTimeThreshold() {
            return this.timeThreshold;
        }

        public final void setTimeThreshold(Long timeThreshold) {
            this.timeThreshold = timeThreshold;
        }

        @Override
        public final Builder timeThreshold(Long timeThreshold) {
            this.timeThreshold = timeThreshold;
            return this;
        }

        public Isoline build() {
            return new Isoline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Isoline> {
        public Builder connections(Collection<IsolineConnection> var1);

        public Builder connections(IsolineConnection ... var1);

        public Builder connections(Consumer<IsolineConnection.Builder> ... var1);

        public Builder distanceThreshold(Long var1);

        public Builder geometries(Collection<IsolineShapeGeometry> var1);

        public Builder geometries(IsolineShapeGeometry ... var1);

        public Builder geometries(Consumer<IsolineShapeGeometry.Builder> ... var1);

        public Builder timeThreshold(Long var1);
    }
}

