/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationAccessHours;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationSideOfStreetOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WaypointOptimizationDestinationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WaypointOptimizationDestinationOptions> {
    private static final SdkField<WaypointOptimizationAccessHours> ACCESS_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessHours").getter(WaypointOptimizationDestinationOptions.getter(WaypointOptimizationDestinationOptions::accessHours)).setter(WaypointOptimizationDestinationOptions.setter(Builder::accessHours)).constructor(WaypointOptimizationAccessHours::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessHours").build()}).build();
    private static final SdkField<String> APPOINTMENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppointmentTime").getter(WaypointOptimizationDestinationOptions.getter(WaypointOptimizationDestinationOptions::appointmentTime)).setter(WaypointOptimizationDestinationOptions.setter(Builder::appointmentTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppointmentTime").build()}).build();
    private static final SdkField<Double> HEADING_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Heading").getter(WaypointOptimizationDestinationOptions.getter(WaypointOptimizationDestinationOptions::heading)).setter(WaypointOptimizationDestinationOptions.setter(Builder::heading)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Heading").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(WaypointOptimizationDestinationOptions.getter(WaypointOptimizationDestinationOptions::id)).setter(WaypointOptimizationDestinationOptions.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Long> SERVICE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ServiceDuration").getter(WaypointOptimizationDestinationOptions.getter(WaypointOptimizationDestinationOptions::serviceDuration)).setter(WaypointOptimizationDestinationOptions.setter(Builder::serviceDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceDuration").build()}).build();
    private static final SdkField<WaypointOptimizationSideOfStreetOptions> SIDE_OF_STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SideOfStreet").getter(WaypointOptimizationDestinationOptions.getter(WaypointOptimizationDestinationOptions::sideOfStreet)).setter(WaypointOptimizationDestinationOptions.setter(Builder::sideOfStreet)).constructor(WaypointOptimizationSideOfStreetOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SideOfStreet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_HOURS_FIELD, APPOINTMENT_TIME_FIELD, HEADING_FIELD, ID_FIELD, SERVICE_DURATION_FIELD, SIDE_OF_STREET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WaypointOptimizationDestinationOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final WaypointOptimizationAccessHours accessHours;
    private final String appointmentTime;
    private final Double heading;
    private final String id;
    private final Long serviceDuration;
    private final WaypointOptimizationSideOfStreetOptions sideOfStreet;

    private WaypointOptimizationDestinationOptions(BuilderImpl builder) {
        this.accessHours = builder.accessHours;
        this.appointmentTime = builder.appointmentTime;
        this.heading = builder.heading;
        this.id = builder.id;
        this.serviceDuration = builder.serviceDuration;
        this.sideOfStreet = builder.sideOfStreet;
    }

    public final WaypointOptimizationAccessHours accessHours() {
        return this.accessHours;
    }

    public final String appointmentTime() {
        return this.appointmentTime;
    }

    public final Double heading() {
        return this.heading;
    }

    public final String id() {
        return this.id;
    }

    public final Long serviceDuration() {
        return this.serviceDuration;
    }

    public final WaypointOptimizationSideOfStreetOptions sideOfStreet() {
        return this.sideOfStreet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.appointmentTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.heading());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sideOfStreet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationDestinationOptions)) {
            return false;
        }
        WaypointOptimizationDestinationOptions other = (WaypointOptimizationDestinationOptions)obj;
        return Objects.equals(this.accessHours(), other.accessHours()) && Objects.equals(this.appointmentTime(), other.appointmentTime()) && Objects.equals(this.heading(), other.heading()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.serviceDuration(), other.serviceDuration()) && Objects.equals(this.sideOfStreet(), other.sideOfStreet());
    }

    public final String toString() {
        return ToString.builder((String)"WaypointOptimizationDestinationOptions").add("AccessHours", (Object)this.accessHours()).add("AppointmentTime", (Object)(this.appointmentTime() == null ? null : "*** Sensitive Data Redacted ***")).add("Heading", (Object)(this.heading() == null ? null : "*** Sensitive Data Redacted ***")).add("Id", (Object)this.id()).add("ServiceDuration", (Object)(this.serviceDuration() == null ? null : "*** Sensitive Data Redacted ***")).add("SideOfStreet", (Object)this.sideOfStreet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessHours": {
                return Optional.ofNullable(clazz.cast(this.accessHours()));
            }
            case "AppointmentTime": {
                return Optional.ofNullable(clazz.cast(this.appointmentTime()));
            }
            case "Heading": {
                return Optional.ofNullable(clazz.cast(this.heading()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ServiceDuration": {
                return Optional.ofNullable(clazz.cast(this.serviceDuration()));
            }
            case "SideOfStreet": {
                return Optional.ofNullable(clazz.cast(this.sideOfStreet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessHours", ACCESS_HOURS_FIELD);
        map.put("AppointmentTime", APPOINTMENT_TIME_FIELD);
        map.put("Heading", HEADING_FIELD);
        map.put("Id", ID_FIELD);
        map.put("ServiceDuration", SERVICE_DURATION_FIELD);
        map.put("SideOfStreet", SIDE_OF_STREET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationDestinationOptions, T> g) {
        return obj -> g.apply((WaypointOptimizationDestinationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WaypointOptimizationAccessHours accessHours;
        private String appointmentTime;
        private Double heading;
        private String id;
        private Long serviceDuration;
        private WaypointOptimizationSideOfStreetOptions sideOfStreet;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationDestinationOptions model) {
            this.accessHours(model.accessHours);
            this.appointmentTime(model.appointmentTime);
            this.heading(model.heading);
            this.id(model.id);
            this.serviceDuration(model.serviceDuration);
            this.sideOfStreet(model.sideOfStreet);
        }

        public final WaypointOptimizationAccessHours.Builder getAccessHours() {
            return this.accessHours != null ? this.accessHours.toBuilder() : null;
        }

        public final void setAccessHours(WaypointOptimizationAccessHours.BuilderImpl accessHours) {
            this.accessHours = accessHours != null ? accessHours.build() : null;
        }

        @Override
        public final Builder accessHours(WaypointOptimizationAccessHours accessHours) {
            this.accessHours = accessHours;
            return this;
        }

        public final String getAppointmentTime() {
            return this.appointmentTime;
        }

        public final void setAppointmentTime(String appointmentTime) {
            this.appointmentTime = appointmentTime;
        }

        @Override
        public final Builder appointmentTime(String appointmentTime) {
            this.appointmentTime = appointmentTime;
            return this;
        }

        public final Double getHeading() {
            return this.heading;
        }

        public final void setHeading(Double heading) {
            this.heading = heading;
        }

        @Override
        public final Builder heading(Double heading) {
            this.heading = heading;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Long getServiceDuration() {
            return this.serviceDuration;
        }

        public final void setServiceDuration(Long serviceDuration) {
            this.serviceDuration = serviceDuration;
        }

        @Override
        public final Builder serviceDuration(Long serviceDuration) {
            this.serviceDuration = serviceDuration;
            return this;
        }

        public final WaypointOptimizationSideOfStreetOptions.Builder getSideOfStreet() {
            return this.sideOfStreet != null ? this.sideOfStreet.toBuilder() : null;
        }

        public final void setSideOfStreet(WaypointOptimizationSideOfStreetOptions.BuilderImpl sideOfStreet) {
            this.sideOfStreet = sideOfStreet != null ? sideOfStreet.build() : null;
        }

        @Override
        public final Builder sideOfStreet(WaypointOptimizationSideOfStreetOptions sideOfStreet) {
            this.sideOfStreet = sideOfStreet;
            return this;
        }

        public WaypointOptimizationDestinationOptions build() {
            return new WaypointOptimizationDestinationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WaypointOptimizationDestinationOptions> {
        public Builder accessHours(WaypointOptimizationAccessHours var1);

        default public Builder accessHours(Consumer<WaypointOptimizationAccessHours.Builder> accessHours) {
            return this.accessHours((WaypointOptimizationAccessHours)((WaypointOptimizationAccessHours.Builder)WaypointOptimizationAccessHours.builder().applyMutation(accessHours)).build());
        }

        public Builder appointmentTime(String var1);

        public Builder heading(Double var1);

        public Builder id(String var1);

        public Builder serviceDuration(Long var1);

        public Builder sideOfStreet(WaypointOptimizationSideOfStreetOptions var1);

        default public Builder sideOfStreet(Consumer<WaypointOptimizationSideOfStreetOptions.Builder> sideOfStreet) {
            return this.sideOfStreet((WaypointOptimizationSideOfStreetOptions)((WaypointOptimizationSideOfStreetOptions.Builder)WaypointOptimizationSideOfStreetOptions.builder().applyMutation(sideOfStreet)).build());
        }
    }
}

