/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.BeforeWaypointsListCopier;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationAccessHours;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationSideOfStreetOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WaypointOptimizationWaypoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WaypointOptimizationWaypoint> {
    private static final SdkField<WaypointOptimizationAccessHours> ACCESS_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessHours").getter(WaypointOptimizationWaypoint.getter(WaypointOptimizationWaypoint::accessHours)).setter(WaypointOptimizationWaypoint.setter(Builder::accessHours)).constructor(WaypointOptimizationAccessHours::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessHours").build()}).build();
    private static final SdkField<String> APPOINTMENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppointmentTime").getter(WaypointOptimizationWaypoint.getter(WaypointOptimizationWaypoint::appointmentTime)).setter(WaypointOptimizationWaypoint.setter(Builder::appointmentTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppointmentTime").build()}).build();
    private static final SdkField<List<Integer>> BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Before").getter(WaypointOptimizationWaypoint.getter(WaypointOptimizationWaypoint::before)).setter(WaypointOptimizationWaypoint.setter(Builder::before)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Before").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> HEADING_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Heading").getter(WaypointOptimizationWaypoint.getter(WaypointOptimizationWaypoint::heading)).setter(WaypointOptimizationWaypoint.setter(Builder::heading)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Heading").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(WaypointOptimizationWaypoint.getter(WaypointOptimizationWaypoint::id)).setter(WaypointOptimizationWaypoint.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(WaypointOptimizationWaypoint.getter(WaypointOptimizationWaypoint::position)).setter(WaypointOptimizationWaypoint.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> SERVICE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ServiceDuration").getter(WaypointOptimizationWaypoint.getter(WaypointOptimizationWaypoint::serviceDuration)).setter(WaypointOptimizationWaypoint.setter(Builder::serviceDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceDuration").build()}).build();
    private static final SdkField<WaypointOptimizationSideOfStreetOptions> SIDE_OF_STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SideOfStreet").getter(WaypointOptimizationWaypoint.getter(WaypointOptimizationWaypoint::sideOfStreet)).setter(WaypointOptimizationWaypoint.setter(Builder::sideOfStreet)).constructor(WaypointOptimizationSideOfStreetOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SideOfStreet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_HOURS_FIELD, APPOINTMENT_TIME_FIELD, BEFORE_FIELD, HEADING_FIELD, ID_FIELD, POSITION_FIELD, SERVICE_DURATION_FIELD, SIDE_OF_STREET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WaypointOptimizationWaypoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final WaypointOptimizationAccessHours accessHours;
    private final String appointmentTime;
    private final List<Integer> before;
    private final Double heading;
    private final String id;
    private final List<Double> position;
    private final Long serviceDuration;
    private final WaypointOptimizationSideOfStreetOptions sideOfStreet;

    private WaypointOptimizationWaypoint(BuilderImpl builder) {
        this.accessHours = builder.accessHours;
        this.appointmentTime = builder.appointmentTime;
        this.before = builder.before;
        this.heading = builder.heading;
        this.id = builder.id;
        this.position = builder.position;
        this.serviceDuration = builder.serviceDuration;
        this.sideOfStreet = builder.sideOfStreet;
    }

    public final WaypointOptimizationAccessHours accessHours() {
        return this.accessHours;
    }

    public final String appointmentTime() {
        return this.appointmentTime;
    }

    public final boolean hasBefore() {
        return this.before != null && !(this.before instanceof SdkAutoConstructList);
    }

    public final List<Integer> before() {
        return this.before;
    }

    public final Double heading() {
        return this.heading;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final Long serviceDuration() {
        return this.serviceDuration;
    }

    public final WaypointOptimizationSideOfStreetOptions sideOfStreet() {
        return this.sideOfStreet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.appointmentTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBefore() ? this.before() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.heading());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sideOfStreet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationWaypoint)) {
            return false;
        }
        WaypointOptimizationWaypoint other = (WaypointOptimizationWaypoint)obj;
        return Objects.equals(this.accessHours(), other.accessHours()) && Objects.equals(this.appointmentTime(), other.appointmentTime()) && this.hasBefore() == other.hasBefore() && Objects.equals(this.before(), other.before()) && Objects.equals(this.heading(), other.heading()) && Objects.equals(this.id(), other.id()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.serviceDuration(), other.serviceDuration()) && Objects.equals(this.sideOfStreet(), other.sideOfStreet());
    }

    public final String toString() {
        return ToString.builder((String)"WaypointOptimizationWaypoint").add("AccessHours", (Object)this.accessHours()).add("AppointmentTime", (Object)(this.appointmentTime() == null ? null : "*** Sensitive Data Redacted ***")).add("Before", this.hasBefore() ? this.before() : null).add("Heading", (Object)(this.heading() == null ? null : "*** Sensitive Data Redacted ***")).add("Id", (Object)this.id()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("ServiceDuration", (Object)(this.serviceDuration() == null ? null : "*** Sensitive Data Redacted ***")).add("SideOfStreet", (Object)this.sideOfStreet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessHours": {
                return Optional.ofNullable(clazz.cast(this.accessHours()));
            }
            case "AppointmentTime": {
                return Optional.ofNullable(clazz.cast(this.appointmentTime()));
            }
            case "Before": {
                return Optional.ofNullable(clazz.cast(this.before()));
            }
            case "Heading": {
                return Optional.ofNullable(clazz.cast(this.heading()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "ServiceDuration": {
                return Optional.ofNullable(clazz.cast(this.serviceDuration()));
            }
            case "SideOfStreet": {
                return Optional.ofNullable(clazz.cast(this.sideOfStreet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessHours", ACCESS_HOURS_FIELD);
        map.put("AppointmentTime", APPOINTMENT_TIME_FIELD);
        map.put("Before", BEFORE_FIELD);
        map.put("Heading", HEADING_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("ServiceDuration", SERVICE_DURATION_FIELD);
        map.put("SideOfStreet", SIDE_OF_STREET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationWaypoint, T> g) {
        return obj -> g.apply((WaypointOptimizationWaypoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WaypointOptimizationAccessHours accessHours;
        private String appointmentTime;
        private List<Integer> before = DefaultSdkAutoConstructList.getInstance();
        private Double heading;
        private String id;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private Long serviceDuration;
        private WaypointOptimizationSideOfStreetOptions sideOfStreet;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationWaypoint model) {
            this.accessHours(model.accessHours);
            this.appointmentTime(model.appointmentTime);
            this.before(model.before);
            this.heading(model.heading);
            this.id(model.id);
            this.position(model.position);
            this.serviceDuration(model.serviceDuration);
            this.sideOfStreet(model.sideOfStreet);
        }

        public final WaypointOptimizationAccessHours.Builder getAccessHours() {
            return this.accessHours != null ? this.accessHours.toBuilder() : null;
        }

        public final void setAccessHours(WaypointOptimizationAccessHours.BuilderImpl accessHours) {
            this.accessHours = accessHours != null ? accessHours.build() : null;
        }

        @Override
        public final Builder accessHours(WaypointOptimizationAccessHours accessHours) {
            this.accessHours = accessHours;
            return this;
        }

        public final String getAppointmentTime() {
            return this.appointmentTime;
        }

        public final void setAppointmentTime(String appointmentTime) {
            this.appointmentTime = appointmentTime;
        }

        @Override
        public final Builder appointmentTime(String appointmentTime) {
            this.appointmentTime = appointmentTime;
            return this;
        }

        public final Collection<Integer> getBefore() {
            if (this.before instanceof SdkAutoConstructList) {
                return null;
            }
            return this.before;
        }

        public final void setBefore(Collection<Integer> before) {
            this.before = BeforeWaypointsListCopier.copy(before);
        }

        @Override
        public final Builder before(Collection<Integer> before) {
            this.before = BeforeWaypointsListCopier.copy(before);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder before(Integer ... before) {
            this.before(Arrays.asList(before));
            return this;
        }

        public final Double getHeading() {
            return this.heading;
        }

        public final void setHeading(Double heading) {
            this.heading = heading;
        }

        @Override
        public final Builder heading(Double heading) {
            this.heading = heading;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final Long getServiceDuration() {
            return this.serviceDuration;
        }

        public final void setServiceDuration(Long serviceDuration) {
            this.serviceDuration = serviceDuration;
        }

        @Override
        public final Builder serviceDuration(Long serviceDuration) {
            this.serviceDuration = serviceDuration;
            return this;
        }

        public final WaypointOptimizationSideOfStreetOptions.Builder getSideOfStreet() {
            return this.sideOfStreet != null ? this.sideOfStreet.toBuilder() : null;
        }

        public final void setSideOfStreet(WaypointOptimizationSideOfStreetOptions.BuilderImpl sideOfStreet) {
            this.sideOfStreet = sideOfStreet != null ? sideOfStreet.build() : null;
        }

        @Override
        public final Builder sideOfStreet(WaypointOptimizationSideOfStreetOptions sideOfStreet) {
            this.sideOfStreet = sideOfStreet;
            return this;
        }

        public WaypointOptimizationWaypoint build() {
            return new WaypointOptimizationWaypoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WaypointOptimizationWaypoint> {
        public Builder accessHours(WaypointOptimizationAccessHours var1);

        default public Builder accessHours(Consumer<WaypointOptimizationAccessHours.Builder> accessHours) {
            return this.accessHours((WaypointOptimizationAccessHours)((WaypointOptimizationAccessHours.Builder)WaypointOptimizationAccessHours.builder().applyMutation(accessHours)).build());
        }

        public Builder appointmentTime(String var1);

        public Builder before(Collection<Integer> var1);

        public Builder before(Integer ... var1);

        public Builder heading(Double var1);

        public Builder id(String var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder serviceDuration(Long var1);

        public Builder sideOfStreet(WaypointOptimizationSideOfStreetOptions var1);

        default public Builder sideOfStreet(Consumer<WaypointOptimizationSideOfStreetOptions.Builder> sideOfStreet) {
            return this.sideOfStreet((WaypointOptimizationSideOfStreetOptions)((WaypointOptimizationSideOfStreetOptions.Builder)WaypointOptimizationSideOfStreetOptions.builder().applyMutation(sideOfStreet)).build());
        }
    }
}

