/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 Glacier response to your request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVaultNotificationsResponse extends GlacierResponse implements
        ToCopyableBuilder<GetVaultNotificationsResponse.Builder, GetVaultNotificationsResponse> {
    private static final SdkField<VaultNotificationConfig> VAULT_NOTIFICATION_CONFIG_FIELD = SdkField
            .<VaultNotificationConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vaultNotificationConfig")
            .getter(getter(GetVaultNotificationsResponse::vaultNotificationConfig))
            .setter(setter(Builder::vaultNotificationConfig))
            .constructor(VaultNotificationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vaultNotificationConfig").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VAULT_NOTIFICATION_CONFIG_FIELD));

    private final VaultNotificationConfig vaultNotificationConfig;

    private GetVaultNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.vaultNotificationConfig = builder.vaultNotificationConfig;
    }

    /**
     * <p>
     * Returns the notification configuration set on the vault.
     * </p>
     * 
     * @return Returns the notification configuration set on the vault.
     */
    public final VaultNotificationConfig vaultNotificationConfig() {
        return vaultNotificationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vaultNotificationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVaultNotificationsResponse)) {
            return false;
        }
        GetVaultNotificationsResponse other = (GetVaultNotificationsResponse) obj;
        return Objects.equals(vaultNotificationConfig(), other.vaultNotificationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVaultNotificationsResponse").add("VaultNotificationConfig", vaultNotificationConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vaultNotificationConfig":
            return Optional.ofNullable(clazz.cast(vaultNotificationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVaultNotificationsResponse, T> g) {
        return obj -> g.apply((GetVaultNotificationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetVaultNotificationsResponse> {
        /**
         * <p>
         * Returns the notification configuration set on the vault.
         * </p>
         * 
         * @param vaultNotificationConfig
         *        Returns the notification configuration set on the vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultNotificationConfig(VaultNotificationConfig vaultNotificationConfig);

        /**
         * <p>
         * Returns the notification configuration set on the vault.
         * </p>
         * This is a convenience that creates an instance of the {@link VaultNotificationConfig.Builder} avoiding the
         * need to create one manually via {@link VaultNotificationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VaultNotificationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #vaultNotificationConfig(VaultNotificationConfig)}.
         * 
         * @param vaultNotificationConfig
         *        a consumer that will call methods on {@link VaultNotificationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vaultNotificationConfig(VaultNotificationConfig)
         */
        default Builder vaultNotificationConfig(Consumer<VaultNotificationConfig.Builder> vaultNotificationConfig) {
            return vaultNotificationConfig(VaultNotificationConfig.builder().applyMutation(vaultNotificationConfig).build());
        }
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private VaultNotificationConfig vaultNotificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVaultNotificationsResponse model) {
            super(model);
            vaultNotificationConfig(model.vaultNotificationConfig);
        }

        public final VaultNotificationConfig.Builder getVaultNotificationConfig() {
            return vaultNotificationConfig != null ? vaultNotificationConfig.toBuilder() : null;
        }

        @Override
        public final Builder vaultNotificationConfig(VaultNotificationConfig vaultNotificationConfig) {
            this.vaultNotificationConfig = vaultNotificationConfig;
            return this;
        }

        public final void setVaultNotificationConfig(VaultNotificationConfig.BuilderImpl vaultNotificationConfig) {
            this.vaultNotificationConfig = vaultNotificationConfig != null ? vaultNotificationConfig.build() : null;
        }

        @Override
        public GetVaultNotificationsResponse build() {
            return new GetVaultNotificationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
