/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 Glacier response to your request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPartsResponse extends GlacierResponse implements
        ToCopyableBuilder<ListPartsResponse.Builder, ListPartsResponse> {
    private static final SdkField<String> MULTIPART_UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultipartUploadId").getter(getter(ListPartsResponse::multipartUploadId))
            .setter(setter(Builder::multipartUploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultipartUploadId").build()).build();

    private static final SdkField<String> VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VaultARN").getter(getter(ListPartsResponse::vaultARN)).setter(setter(Builder::vaultARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultARN").build()).build();

    private static final SdkField<String> ARCHIVE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveDescription").getter(getter(ListPartsResponse::archiveDescription))
            .setter(setter(Builder::archiveDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveDescription").build())
            .build();

    private static final SdkField<Long> PART_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PartSizeInBytes").getter(getter(ListPartsResponse::partSizeInBytes))
            .setter(setter(Builder::partSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartSizeInBytes").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(ListPartsResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<List<PartListElement>> PARTS_FIELD = SdkField
            .<List<PartListElement>> builder(MarshallingType.LIST)
            .memberName("Parts")
            .getter(getter(ListPartsResponse::parts))
            .setter(setter(Builder::parts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartListElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartListElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListPartsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MULTIPART_UPLOAD_ID_FIELD, VAULT_ARN_FIELD, ARCHIVE_DESCRIPTION_FIELD,
                    PART_SIZE_IN_BYTES_FIELD, CREATION_DATE_FIELD, PARTS_FIELD, MARKER_FIELD));

    private final String multipartUploadId;

    private final String vaultARN;

    private final String archiveDescription;

    private final Long partSizeInBytes;

    private final String creationDate;

    private final List<PartListElement> parts;

    private final String marker;

    private ListPartsResponse(BuilderImpl builder) {
        super(builder);
        this.multipartUploadId = builder.multipartUploadId;
        this.vaultARN = builder.vaultARN;
        this.archiveDescription = builder.archiveDescription;
        this.partSizeInBytes = builder.partSizeInBytes;
        this.creationDate = builder.creationDate;
        this.parts = builder.parts;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The ID of the upload to which the parts are associated.
     * </p>
     * 
     * @return The ID of the upload to which the parts are associated.
     */
    public final String multipartUploadId() {
        return multipartUploadId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vault to which the multipart upload was initiated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vault to which the multipart upload was initiated.
     */
    public final String vaultARN() {
        return vaultARN;
    }

    /**
     * <p>
     * The description of the archive that was specified in the Initiate Multipart Upload request.
     * </p>
     * 
     * @return The description of the archive that was specified in the Initiate Multipart Upload request.
     */
    public final String archiveDescription() {
        return archiveDescription;
    }

    /**
     * <p>
     * The part size in bytes. This is the same value that you specified in the Initiate Multipart Upload request.
     * </p>
     * 
     * @return The part size in bytes. This is the same value that you specified in the Initiate Multipart Upload
     *         request.
     */
    public final Long partSizeInBytes() {
        return partSizeInBytes;
    }

    /**
     * <p>
     * The UTC time at which the multipart upload was initiated.
     * </p>
     * 
     * @return The UTC time at which the multipart upload was initiated.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parts property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasParts() {
        return parts != null && !(parts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the part sizes of the multipart upload. Each object in the array contains a <code>RangeBytes</code> and
     * <code>sha256-tree-hash</code> name/value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParts} method.
     * </p>
     * 
     * @return A list of the part sizes of the multipart upload. Each object in the array contains a
     *         <code>RangeBytes</code> and <code>sha256-tree-hash</code> name/value pair.
     */
    public final List<PartListElement> parts() {
        return parts;
    }

    /**
     * <p>
     * An opaque string that represents where to continue pagination of the results. You use the marker in a new List
     * Parts request to obtain more jobs in the list. If there are no more parts, this value is <code>null</code>.
     * </p>
     * 
     * @return An opaque string that represents where to continue pagination of the results. You use the marker in a new
     *         List Parts request to obtain more jobs in the list. If there are no more parts, this value is
     *         <code>null</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multipartUploadId());
        hashCode = 31 * hashCode + Objects.hashCode(vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(archiveDescription());
        hashCode = 31 * hashCode + Objects.hashCode(partSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasParts() ? parts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartsResponse)) {
            return false;
        }
        ListPartsResponse other = (ListPartsResponse) obj;
        return Objects.equals(multipartUploadId(), other.multipartUploadId()) && Objects.equals(vaultARN(), other.vaultARN())
                && Objects.equals(archiveDescription(), other.archiveDescription())
                && Objects.equals(partSizeInBytes(), other.partSizeInBytes())
                && Objects.equals(creationDate(), other.creationDate()) && hasParts() == other.hasParts()
                && Objects.equals(parts(), other.parts()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPartsResponse").add("MultipartUploadId", multipartUploadId()).add("VaultARN", vaultARN())
                .add("ArchiveDescription", archiveDescription()).add("PartSizeInBytes", partSizeInBytes())
                .add("CreationDate", creationDate()).add("Parts", hasParts() ? parts() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultipartUploadId":
            return Optional.ofNullable(clazz.cast(multipartUploadId()));
        case "VaultARN":
            return Optional.ofNullable(clazz.cast(vaultARN()));
        case "ArchiveDescription":
            return Optional.ofNullable(clazz.cast(archiveDescription()));
        case "PartSizeInBytes":
            return Optional.ofNullable(clazz.cast(partSizeInBytes()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Parts":
            return Optional.ofNullable(clazz.cast(parts()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPartsResponse, T> g) {
        return obj -> g.apply((ListPartsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPartsResponse> {
        /**
         * <p>
         * The ID of the upload to which the parts are associated.
         * </p>
         * 
         * @param multipartUploadId
         *        The ID of the upload to which the parts are associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multipartUploadId(String multipartUploadId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vault to which the multipart upload was initiated.
         * </p>
         * 
         * @param vaultARN
         *        The Amazon Resource Name (ARN) of the vault to which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultARN(String vaultARN);

        /**
         * <p>
         * The description of the archive that was specified in the Initiate Multipart Upload request.
         * </p>
         * 
         * @param archiveDescription
         *        The description of the archive that was specified in the Initiate Multipart Upload request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveDescription(String archiveDescription);

        /**
         * <p>
         * The part size in bytes. This is the same value that you specified in the Initiate Multipart Upload request.
         * </p>
         * 
         * @param partSizeInBytes
         *        The part size in bytes. This is the same value that you specified in the Initiate Multipart Upload
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partSizeInBytes(Long partSizeInBytes);

        /**
         * <p>
         * The UTC time at which the multipart upload was initiated.
         * </p>
         * 
         * @param creationDate
         *        The UTC time at which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * A list of the part sizes of the multipart upload. Each object in the array contains a <code>RangeBytes</code>
         * and <code>sha256-tree-hash</code> name/value pair.
         * </p>
         * 
         * @param parts
         *        A list of the part sizes of the multipart upload. Each object in the array contains a
         *        <code>RangeBytes</code> and <code>sha256-tree-hash</code> name/value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(Collection<PartListElement> parts);

        /**
         * <p>
         * A list of the part sizes of the multipart upload. Each object in the array contains a <code>RangeBytes</code>
         * and <code>sha256-tree-hash</code> name/value pair.
         * </p>
         * 
         * @param parts
         *        A list of the part sizes of the multipart upload. Each object in the array contains a
         *        <code>RangeBytes</code> and <code>sha256-tree-hash</code> name/value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(PartListElement... parts);

        /**
         * <p>
         * A list of the part sizes of the multipart upload. Each object in the array contains a <code>RangeBytes</code>
         * and <code>sha256-tree-hash</code> name/value pair.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PartListElement>.Builder} avoiding the need
         * to create one manually via {@link List<PartListElement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PartListElement>.Builder#build()} is called immediately and
         * its result is passed to {@link #parts(List<PartListElement>)}.
         * 
         * @param parts
         *        a consumer that will call methods on {@link List<PartListElement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parts(List<PartListElement>)
         */
        Builder parts(Consumer<PartListElement.Builder>... parts);

        /**
         * <p>
         * An opaque string that represents where to continue pagination of the results. You use the marker in a new
         * List Parts request to obtain more jobs in the list. If there are no more parts, this value is
         * <code>null</code>.
         * </p>
         * 
         * @param marker
         *        An opaque string that represents where to continue pagination of the results. You use the marker in a
         *        new List Parts request to obtain more jobs in the list. If there are no more parts, this value is
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private String multipartUploadId;

        private String vaultARN;

        private String archiveDescription;

        private Long partSizeInBytes;

        private String creationDate;

        private List<PartListElement> parts = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartsResponse model) {
            super(model);
            multipartUploadId(model.multipartUploadId);
            vaultARN(model.vaultARN);
            archiveDescription(model.archiveDescription);
            partSizeInBytes(model.partSizeInBytes);
            creationDate(model.creationDate);
            parts(model.parts);
            marker(model.marker);
        }

        public final String getMultipartUploadId() {
            return multipartUploadId;
        }

        public final void setMultipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
        }

        @Override
        @Transient
        public final Builder multipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
            return this;
        }

        public final String getVaultARN() {
            return vaultARN;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        @Override
        @Transient
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final String getArchiveDescription() {
            return archiveDescription;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        @Override
        @Transient
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final Long getPartSizeInBytes() {
            return partSizeInBytes;
        }

        public final void setPartSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
        }

        @Override
        @Transient
        public final Builder partSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final List<PartListElement.Builder> getParts() {
            List<PartListElement.Builder> result = PartListCopier.copyToBuilder(this.parts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParts(Collection<PartListElement.BuilderImpl> parts) {
            this.parts = PartListCopier.copyFromBuilder(parts);
        }

        @Override
        @Transient
        public final Builder parts(Collection<PartListElement> parts) {
            this.parts = PartListCopier.copy(parts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parts(PartListElement... parts) {
            parts(Arrays.asList(parts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parts(Consumer<PartListElement.Builder>... parts) {
            parts(Stream.of(parts).map(c -> PartListElement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListPartsResponse build() {
            return new ListPartsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
