/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 Glacier response to your request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMultipartUploadsResponse extends GlacierResponse implements
        ToCopyableBuilder<ListMultipartUploadsResponse.Builder, ListMultipartUploadsResponse> {
    private static final SdkField<List<UploadListElement>> UPLOADS_LIST_FIELD = SdkField
            .<List<UploadListElement>> builder(MarshallingType.LIST)
            .memberName("UploadsList")
            .getter(getter(ListMultipartUploadsResponse::uploadsList))
            .setter(setter(Builder::uploadsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UploadListElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(UploadListElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListMultipartUploadsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOADS_LIST_FIELD,
            MARKER_FIELD));

    private final List<UploadListElement> uploadsList;

    private final String marker;

    private ListMultipartUploadsResponse(BuilderImpl builder) {
        super(builder);
        this.uploadsList = builder.uploadsList;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the UploadsList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUploadsList() {
        return uploadsList != null && !(uploadsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of in-progress multipart uploads.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUploadsList} method.
     * </p>
     * 
     * @return A list of in-progress multipart uploads.
     */
    public final List<UploadListElement> uploadsList() {
        return uploadsList;
    }

    /**
     * <p>
     * An opaque string that represents where to continue pagination of the results. You use the marker in a new List
     * Multipart Uploads request to obtain more uploads in the list. If there are no more uploads, this value is
     * <code>null</code>.
     * </p>
     * 
     * @return An opaque string that represents where to continue pagination of the results. You use the marker in a new
     *         List Multipart Uploads request to obtain more uploads in the list. If there are no more uploads, this
     *         value is <code>null</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUploadsList() ? uploadsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsResponse)) {
            return false;
        }
        ListMultipartUploadsResponse other = (ListMultipartUploadsResponse) obj;
        return hasUploadsList() == other.hasUploadsList() && Objects.equals(uploadsList(), other.uploadsList())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMultipartUploadsResponse").add("UploadsList", hasUploadsList() ? uploadsList() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UploadsList":
            return Optional.ofNullable(clazz.cast(uploadsList()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMultipartUploadsResponse, T> g) {
        return obj -> g.apply((ListMultipartUploadsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMultipartUploadsResponse> {
        /**
         * <p>
         * A list of in-progress multipart uploads.
         * </p>
         * 
         * @param uploadsList
         *        A list of in-progress multipart uploads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadsList(Collection<UploadListElement> uploadsList);

        /**
         * <p>
         * A list of in-progress multipart uploads.
         * </p>
         * 
         * @param uploadsList
         *        A list of in-progress multipart uploads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadsList(UploadListElement... uploadsList);

        /**
         * <p>
         * A list of in-progress multipart uploads.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UploadListElement>.Builder} avoiding
         * the need to create one manually via {@link List<UploadListElement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UploadListElement>.Builder#build()} is called immediately
         * and its result is passed to {@link #uploadsList(List<UploadListElement>)}.
         * 
         * @param uploadsList
         *        a consumer that will call methods on {@link List<UploadListElement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploadsList(List<UploadListElement>)
         */
        Builder uploadsList(Consumer<UploadListElement.Builder>... uploadsList);

        /**
         * <p>
         * An opaque string that represents where to continue pagination of the results. You use the marker in a new
         * List Multipart Uploads request to obtain more uploads in the list. If there are no more uploads, this value
         * is <code>null</code>.
         * </p>
         * 
         * @param marker
         *        An opaque string that represents where to continue pagination of the results. You use the marker in a
         *        new List Multipart Uploads request to obtain more uploads in the list. If there are no more uploads,
         *        this value is <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private List<UploadListElement> uploadsList = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultipartUploadsResponse model) {
            super(model);
            uploadsList(model.uploadsList);
            marker(model.marker);
        }

        public final List<UploadListElement.Builder> getUploadsList() {
            List<UploadListElement.Builder> result = UploadsListCopier.copyToBuilder(this.uploadsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUploadsList(Collection<UploadListElement.BuilderImpl> uploadsList) {
            this.uploadsList = UploadsListCopier.copyFromBuilder(uploadsList);
        }

        @Override
        public final Builder uploadsList(Collection<UploadListElement> uploadsList) {
            this.uploadsList = UploadsListCopier.copy(uploadsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadsList(UploadListElement... uploadsList) {
            uploadsList(Arrays.asList(uploadsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadsList(Consumer<UploadListElement.Builder>... uploadsList) {
            uploadsList(Stream.of(uploadsList).map(c -> UploadListElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListMultipartUploadsResponse build() {
            return new ListMultipartUploadsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
