/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data retrieval policy rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataRetrievalRule implements SdkPojo, Serializable,
        ToCopyableBuilder<DataRetrievalRule.Builder, DataRetrievalRule> {
    private static final SdkField<String> STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Strategy").getter(getter(DataRetrievalRule::strategy)).setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()).build();

    private static final SdkField<Long> BYTES_PER_HOUR_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BytesPerHour").getter(getter(DataRetrievalRule::bytesPerHour)).setter(setter(Builder::bytesPerHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesPerHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_FIELD,
            BYTES_PER_HOUR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String strategy;

    private final Long bytesPerHour;

    private DataRetrievalRule(BuilderImpl builder) {
        this.strategy = builder.strategy;
        this.bytesPerHour = builder.bytesPerHour;
    }

    /**
     * <p>
     * The type of data retrieval policy to set.
     * </p>
     * <p>
     * Valid values: BytesPerHour|FreeTier|None
     * </p>
     * 
     * @return The type of data retrieval policy to set.</p>
     *         <p>
     *         Valid values: BytesPerHour|FreeTier|None
     */
    public final String strategy() {
        return strategy;
    }

    /**
     * <p>
     * The maximum number of bytes that can be retrieved in an hour.
     * </p>
     * <p>
     * This field is required only if the value of the Strategy field is <code>BytesPerHour</code>. Your PUT operation
     * will be rejected if the Strategy field is not set to <code>BytesPerHour</code> and you set this field.
     * </p>
     * 
     * @return The maximum number of bytes that can be retrieved in an hour.</p>
     *         <p>
     *         This field is required only if the value of the Strategy field is <code>BytesPerHour</code>. Your PUT
     *         operation will be rejected if the Strategy field is not set to <code>BytesPerHour</code> and you set this
     *         field.
     */
    public final Long bytesPerHour() {
        return bytesPerHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(strategy());
        hashCode = 31 * hashCode + Objects.hashCode(bytesPerHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRetrievalRule)) {
            return false;
        }
        DataRetrievalRule other = (DataRetrievalRule) obj;
        return Objects.equals(strategy(), other.strategy()) && Objects.equals(bytesPerHour(), other.bytesPerHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataRetrievalRule").add("Strategy", strategy()).add("BytesPerHour", bytesPerHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Strategy":
            return Optional.ofNullable(clazz.cast(strategy()));
        case "BytesPerHour":
            return Optional.ofNullable(clazz.cast(bytesPerHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataRetrievalRule, T> g) {
        return obj -> g.apply((DataRetrievalRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataRetrievalRule> {
        /**
         * <p>
         * The type of data retrieval policy to set.
         * </p>
         * <p>
         * Valid values: BytesPerHour|FreeTier|None
         * </p>
         * 
         * @param strategy
         *        The type of data retrieval policy to set.</p>
         *        <p>
         *        Valid values: BytesPerHour|FreeTier|None
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The maximum number of bytes that can be retrieved in an hour.
         * </p>
         * <p>
         * This field is required only if the value of the Strategy field is <code>BytesPerHour</code>. Your PUT
         * operation will be rejected if the Strategy field is not set to <code>BytesPerHour</code> and you set this
         * field.
         * </p>
         * 
         * @param bytesPerHour
         *        The maximum number of bytes that can be retrieved in an hour.</p>
         *        <p>
         *        This field is required only if the value of the Strategy field is <code>BytesPerHour</code>. Your PUT
         *        operation will be rejected if the Strategy field is not set to <code>BytesPerHour</code> and you set
         *        this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesPerHour(Long bytesPerHour);
    }

    static final class BuilderImpl implements Builder {
        private String strategy;

        private Long bytesPerHour;

        private BuilderImpl() {
        }

        private BuilderImpl(DataRetrievalRule model) {
            strategy(model.strategy);
            bytesPerHour(model.bytesPerHour);
        }

        public final String getStrategy() {
            return strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        @Transient
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        public final Long getBytesPerHour() {
            return bytesPerHour;
        }

        public final void setBytesPerHour(Long bytesPerHour) {
            this.bytesPerHour = bytesPerHour;
        }

        @Override
        @Transient
        public final Builder bytesPerHour(Long bytesPerHour) {
            this.bytesPerHour = bytesPerHour;
            return this;
        }

        @Override
        public DataRetrievalRule build() {
            return new DataRetrievalRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
