/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 Glacier response to your request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVaultLockResponse extends GlacierResponse implements
        ToCopyableBuilder<GetVaultLockResponse.Builder, GetVaultLockResponse> {
    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(GetVaultLockResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(GetVaultLockResponse::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> EXPIRATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpirationDate").getter(getter(GetVaultLockResponse::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(GetVaultLockResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, STATE_FIELD,
            EXPIRATION_DATE_FIELD, CREATION_DATE_FIELD));

    private final String policy;

    private final String state;

    private final String expirationDate;

    private final String creationDate;

    private GetVaultLockResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.state = builder.state;
        this.expirationDate = builder.expirationDate;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The vault lock policy as a JSON string, which uses "\" as an escape character.
     * </p>
     * 
     * @return The vault lock policy as a JSON string, which uses "\" as an escape character.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * The state of the vault lock. <code>InProgress</code> or <code>Locked</code>.
     * </p>
     * 
     * @return The state of the vault lock. <code>InProgress</code> or <code>Locked</code>.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The UTC date and time at which the lock ID expires. This value can be <code>null</code> if the vault lock is in a
     * <code>Locked</code> state.
     * </p>
     * 
     * @return The UTC date and time at which the lock ID expires. This value can be <code>null</code> if the vault lock
     *         is in a <code>Locked</code> state.
     */
    public final String expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * The UTC date and time at which the vault lock was put into the <code>InProgress</code> state.
     * </p>
     * 
     * @return The UTC date and time at which the vault lock was put into the <code>InProgress</code> state.
     */
    public final String creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVaultLockResponse)) {
            return false;
        }
        GetVaultLockResponse other = (GetVaultLockResponse) obj;
        return Objects.equals(policy(), other.policy()) && Objects.equals(state(), other.state())
                && Objects.equals(expirationDate(), other.expirationDate())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVaultLockResponse").add("Policy", policy()).add("State", state())
                .add("ExpirationDate", expirationDate()).add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVaultLockResponse, T> g) {
        return obj -> g.apply((GetVaultLockResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetVaultLockResponse> {
        /**
         * <p>
         * The vault lock policy as a JSON string, which uses "\" as an escape character.
         * </p>
         * 
         * @param policy
         *        The vault lock policy as a JSON string, which uses "\" as an escape character.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The state of the vault lock. <code>InProgress</code> or <code>Locked</code>.
         * </p>
         * 
         * @param state
         *        The state of the vault lock. <code>InProgress</code> or <code>Locked</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The UTC date and time at which the lock ID expires. This value can be <code>null</code> if the vault lock is
         * in a <code>Locked</code> state.
         * </p>
         * 
         * @param expirationDate
         *        The UTC date and time at which the lock ID expires. This value can be <code>null</code> if the vault
         *        lock is in a <code>Locked</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(String expirationDate);

        /**
         * <p>
         * The UTC date and time at which the vault lock was put into the <code>InProgress</code> state.
         * </p>
         * 
         * @param creationDate
         *        The UTC date and time at which the vault lock was put into the <code>InProgress</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private String policy;

        private String state;

        private String expirationDate;

        private String creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVaultLockResponse model) {
            super(model);
            policy(model.policy);
            state(model.state);
            expirationDate(model.expirationDate);
            creationDate(model.creationDate);
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        @Transient
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        @Transient
        public final Builder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public GetVaultLockResponse build() {
            return new GetVaultLockResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
