/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 Glacier response to your request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVaultsResponse extends GlacierResponse implements
        ToCopyableBuilder<ListVaultsResponse.Builder, ListVaultsResponse> {
    private static final SdkField<List<DescribeVaultOutput>> VAULT_LIST_FIELD = SdkField
            .<List<DescribeVaultOutput>> builder(MarshallingType.LIST)
            .memberName("VaultList")
            .getter(getter(ListVaultsResponse::vaultList))
            .setter(setter(Builder::vaultList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DescribeVaultOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(DescribeVaultOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListVaultsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VAULT_LIST_FIELD, MARKER_FIELD));

    private final List<DescribeVaultOutput> vaultList;

    private final String marker;

    private ListVaultsResponse(BuilderImpl builder) {
        super(builder);
        this.vaultList = builder.vaultList;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the VaultList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVaultList() {
        return vaultList != null && !(vaultList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of vaults.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVaultList} method.
     * </p>
     * 
     * @return List of vaults.
     */
    public final List<DescribeVaultOutput> vaultList() {
        return vaultList;
    }

    /**
     * <p>
     * The vault ARN at which to continue pagination of the results. You use the marker in another List Vaults request
     * to obtain more vaults in the list.
     * </p>
     * 
     * @return The vault ARN at which to continue pagination of the results. You use the marker in another List Vaults
     *         request to obtain more vaults in the list.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVaultList() ? vaultList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVaultsResponse)) {
            return false;
        }
        ListVaultsResponse other = (ListVaultsResponse) obj;
        return hasVaultList() == other.hasVaultList() && Objects.equals(vaultList(), other.vaultList())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVaultsResponse").add("VaultList", hasVaultList() ? vaultList() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VaultList":
            return Optional.ofNullable(clazz.cast(vaultList()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVaultsResponse, T> g) {
        return obj -> g.apply((ListVaultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVaultsResponse> {
        /**
         * <p>
         * List of vaults.
         * </p>
         * 
         * @param vaultList
         *        List of vaults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultList(Collection<DescribeVaultOutput> vaultList);

        /**
         * <p>
         * List of vaults.
         * </p>
         * 
         * @param vaultList
         *        List of vaults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultList(DescribeVaultOutput... vaultList);

        /**
         * <p>
         * List of vaults.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DescribeVaultOutput>.Builder} avoiding the
         * need to create one manually via {@link List<DescribeVaultOutput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DescribeVaultOutput>.Builder#build()} is called immediately
         * and its result is passed to {@link #vaultList(List<DescribeVaultOutput>)}.
         * 
         * @param vaultList
         *        a consumer that will call methods on {@link List<DescribeVaultOutput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vaultList(List<DescribeVaultOutput>)
         */
        Builder vaultList(Consumer<DescribeVaultOutput.Builder>... vaultList);

        /**
         * <p>
         * The vault ARN at which to continue pagination of the results. You use the marker in another List Vaults
         * request to obtain more vaults in the list.
         * </p>
         * 
         * @param marker
         *        The vault ARN at which to continue pagination of the results. You use the marker in another List
         *        Vaults request to obtain more vaults in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private List<DescribeVaultOutput> vaultList = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVaultsResponse model) {
            super(model);
            vaultList(model.vaultList);
            marker(model.marker);
        }

        public final List<DescribeVaultOutput.Builder> getVaultList() {
            List<DescribeVaultOutput.Builder> result = VaultListCopier.copyToBuilder(this.vaultList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVaultList(Collection<DescribeVaultOutput.BuilderImpl> vaultList) {
            this.vaultList = VaultListCopier.copyFromBuilder(vaultList);
        }

        @Override
        @Transient
        public final Builder vaultList(Collection<DescribeVaultOutput> vaultList) {
            this.vaultList = VaultListCopier.copy(vaultList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vaultList(DescribeVaultOutput... vaultList) {
            vaultList(Arrays.asList(vaultList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vaultList(Consumer<DescribeVaultOutput.Builder>... vaultList) {
            vaultList(Stream.of(vaultList).map(c -> DescribeVaultOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListVaultsResponse build() {
            return new ListVaultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
