/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * SetDataRetrievalPolicy input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetDataRetrievalPolicyRequest extends GlacierRequest implements
        ToCopyableBuilder<SetDataRetrievalPolicyRequest.Builder, SetDataRetrievalPolicyRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("accountId")
            .getter(getter(SetDataRetrievalPolicyRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build(),
                    DefaultValueTrait.create(DefaultAccountIdSupplier.getInstance())).build();

    private static final SdkField<DataRetrievalPolicy> POLICY_FIELD = SdkField
            .<DataRetrievalPolicy> builder(MarshallingType.SDK_POJO).memberName("Policy")
            .getter(getter(SetDataRetrievalPolicyRequest::policy)).setter(setter(Builder::policy))
            .constructor(DataRetrievalPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACCOUNT_ID_FIELD, POLICY_FIELD));

    private final String accountId;

    private final DataRetrievalPolicy policy;

    private SetDataRetrievalPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * The <code>AccountId</code> value is the AWS account ID. This value must match the AWS account ID associated with
     * the credentials used to sign the request. You can either specify an AWS account ID or optionally a single '
     * <code>-</code>' (hyphen), in which case Amazon Glacier uses the AWS account ID associated with the credentials
     * used to sign the request. If you specify your account ID, do not include any hyphens ('-') in the ID.
     * </p>
     * 
     * @return The <code>AccountId</code> value is the AWS account ID. This value must match the AWS account ID
     *         associated with the credentials used to sign the request. You can either specify an AWS account ID or
     *         optionally a single '<code>-</code>' (hyphen), in which case Amazon Glacier uses the AWS account ID
     *         associated with the credentials used to sign the request. If you specify your account ID, do not include
     *         any hyphens ('-') in the ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The data retrieval policy in JSON format.
     * </p>
     * 
     * @return The data retrieval policy in JSON format.
     */
    public final DataRetrievalPolicy policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDataRetrievalPolicyRequest)) {
            return false;
        }
        SetDataRetrievalPolicyRequest other = (SetDataRetrievalPolicyRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetDataRetrievalPolicyRequest").add("AccountId", accountId()).add("Policy", policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetDataRetrievalPolicyRequest, T> g) {
        return obj -> g.apply((SetDataRetrievalPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetDataRetrievalPolicyRequest> {
        /**
         * <p>
         * The <code>AccountId</code> value is the AWS account ID. This value must match the AWS account ID associated
         * with the credentials used to sign the request. You can either specify an AWS account ID or optionally a
         * single '<code>-</code>' (hyphen), in which case Amazon Glacier uses the AWS account ID associated with the
         * credentials used to sign the request. If you specify your account ID, do not include any hyphens ('-') in the
         * ID.
         * </p>
         * 
         * @param accountId
         *        The <code>AccountId</code> value is the AWS account ID. This value must match the AWS account ID
         *        associated with the credentials used to sign the request. You can either specify an AWS account ID or
         *        optionally a single '<code>-</code>' (hyphen), in which case Amazon Glacier uses the AWS account ID
         *        associated with the credentials used to sign the request. If you specify your account ID, do not
         *        include any hyphens ('-') in the ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The data retrieval policy in JSON format.
         * </p>
         * 
         * @param policy
         *        The data retrieval policy in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(DataRetrievalPolicy policy);

        /**
         * <p>
         * The data retrieval policy in JSON format.
         * </p>
         * This is a convenience that creates an instance of the {@link DataRetrievalPolicy.Builder} avoiding the need
         * to create one manually via {@link DataRetrievalPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataRetrievalPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #policy(DataRetrievalPolicy)}.
         * 
         * @param policy
         *        a consumer that will call methods on {@link DataRetrievalPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policy(DataRetrievalPolicy)
         */
        default Builder policy(Consumer<DataRetrievalPolicy.Builder> policy) {
            return policy(DataRetrievalPolicy.builder().applyMutation(policy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlacierRequest.BuilderImpl implements Builder {
        private String accountId;

        private DataRetrievalPolicy policy;

        private BuilderImpl() {
        }

        private BuilderImpl(SetDataRetrievalPolicyRequest model) {
            super(model);
            accountId(model.accountId);
            policy(model.policy);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final DataRetrievalPolicy.Builder getPolicy() {
            return policy != null ? policy.toBuilder() : null;
        }

        public final void setPolicy(DataRetrievalPolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        @Transient
        public final Builder policy(DataRetrievalPolicy policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetDataRetrievalPolicyRequest build() {
            return new SetDataRetrievalPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
