/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultResponse;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.CreateVaultRequest;
import software.amazon.awssdk.services.glacier.model.CreateVaultResponse;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultResponse;
import software.amazon.awssdk.services.glacier.model.DescribeJobRequest;
import software.amazon.awssdk.services.glacier.model.DescribeJobResponse;
import software.amazon.awssdk.services.glacier.model.DescribeVaultRequest;
import software.amazon.awssdk.services.glacier.model.DescribeVaultResponse;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetJobOutputRequest;
import software.amazon.awssdk.services.glacier.model.GetJobOutputResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.InitiateJobRequest;
import software.amazon.awssdk.services.glacier.model.InitiateJobResponse;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.ListJobsRequest;
import software.amazon.awssdk.services.glacier.model.ListJobsResponse;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.ListPartsRequest;
import software.amazon.awssdk.services.glacier.model.ListPartsResponse;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse;
import software.amazon.awssdk.services.glacier.model.ListVaultsRequest;
import software.amazon.awssdk.services.glacier.model.ListVaultsResponse;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultResponse;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.UploadArchiveRequest;
import software.amazon.awssdk.services.glacier.model.UploadArchiveResponse;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse;
import software.amazon.awssdk.services.glacier.paginators.ListJobsPublisher;
import software.amazon.awssdk.services.glacier.paginators.ListMultipartUploadsPublisher;
import software.amazon.awssdk.services.glacier.paginators.ListPartsPublisher;
import software.amazon.awssdk.services.glacier.paginators.ListVaultsPublisher;
import software.amazon.awssdk.services.glacier.waiters.GlacierAsyncWaiter;

/**
 * Service client for accessing Amazon Glacier asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon S3 Glacier (Glacier) is a storage solution for "cold data."
 * </p>
 * <p>
 * Glacier is an extremely low-cost storage service that provides secure, durable, and easy-to-use storage for data
 * backup and archival. With Glacier, customers can store their data cost effectively for months, years, or decades.
 * Glacier also enables customers to offload the administrative burdens of operating and scaling storage to AWS, so they
 * don't have to worry about capacity planning, hardware provisioning, data replication, hardware failure and recovery,
 * or time-consuming hardware migrations.
 * </p>
 * <p>
 * Glacier is a great storage choice when low storage cost is paramount and your data is rarely retrieved. If your
 * application requires fast or frequent access to your data, consider using Amazon S3. For more information, see <a
 * href="http://aws.amazon.com/s3/">Amazon Simple Storage Service (Amazon S3)</a>.
 * </p>
 * <p>
 * You can store any kind of data in any format. There is no maximum limit on the total amount of data you can store in
 * Glacier.
 * </p>
 * <p>
 * If you are a first-time user of Glacier, we recommend that you begin by reading the following sections in the
 * <i>Amazon S3 Glacier Developer Guide</i>:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/introduction.html">What is Amazon S3 Glacier</a> - This
 * section of the Developer Guide describes the underlying data model, the operations it supports, and the AWS SDKs that
 * you can use to interact with the service.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/amazon-glacier-getting-started.html">Getting Started
 * with Amazon S3 Glacier</a> - The Getting Started section walks you through the process of creating a vault, uploading
 * archives, creating jobs to download archives, retrieving the job output, and deleting archives.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GlacierAsyncClient extends AwsClient {
    String SERVICE_NAME = "glacier";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "glacier";

    /**
     * <p>
     * This operation aborts a multipart upload identified by the upload ID.
     * </p>
     * <p>
     * After the Abort Multipart Upload request succeeds, you cannot upload any more parts to the multipart upload or
     * complete the multipart upload. Aborting a completed upload fails. However, aborting an already-aborted upload
     * will succeed, for a short time. For more information about uploading a part and completing a multipart upload,
     * see <a>UploadMultipartPart</a> and <a>CompleteMultipartUpload</a>.
     * </p>
     * <p>
     * This operation is idempotent.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
     * Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html">Abort Multipart
     * Upload</a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param abortMultipartUploadRequest
     *        Provides options to abort a multipart upload identified by the upload ID.</p>
     *        <p>
     *        For information about the underlying REST API, see <a
     *        href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html">Abort
     *        Multipart Upload</a>. For conceptual information, see <a
     *        href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with
     *        Archives in Amazon S3 Glacier</a>.
     * @return A Java Future containing the result of the AbortMultipartUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li> <li>InvalidParameterValueException Returned if a parameter of the request is
     *         incorrectly specified.</li> <li>MissingParameterValueException Returned if a required header or parameter
     *         is missing from the request.</li> <li>ServiceUnavailableException Returned if the service cannot complete
     *         the request.</li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both
     *         service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side
     *         error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>GlacierException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     *         </li>
     *         </ul>
     * @sample GlacierAsyncClient.AbortMultipartUpload
     */
    default CompletableFuture<AbortMultipartUploadResponse> abortMultipartUpload(
            AbortMultipartUploadRequest abortMultipartUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation aborts a multipart upload identified by the upload ID.
     * </p>
     * <p>
     * After the Abort Multipart Upload request succeeds, you cannot upload any more parts to the multipart upload or
     * complete the multipart upload. Aborting a completed upload fails. However, aborting an already-aborted upload
     * will succeed, for a short time. For more information about uploading a part and completing a multipart upload,
     * see <a>UploadMultipartPart</a> and <a>CompleteMultipartUpload</a>.
     * </p>
     * <p>
     * This operation is idempotent.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
     * Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html">Abort Multipart
     * Upload</a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AbortMultipartUploadRequest.Builder} avoiding the
     * need to create one manually via {@link AbortMultipartUploadRequest#builder()}
     * </p>
     *
     * @param abortMultipartUploadRequest
     *        A {@link Consumer} that will call methods on {@link AbortMultipartUploadInput.Builder} to create a
     *        request. Provides options to abort a multipart upload identified by the upload ID.</p>
     *        <p>
     *        For information about the underlying REST API, see <a
     *        href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html">Abort
     *        Multipart Upload</a>. For conceptual information, see <a
     *        href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with
     *        Archives in Amazon S3 Glacier</a>.
     * @return A Java Future containing the result of the AbortMultipartUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li> <li>InvalidParameterValueException Returned if a parameter of the request is
     *         incorrectly specified.</li> <li>MissingParameterValueException Returned if a required header or parameter
     *         is missing from the request.</li> <li>ServiceUnavailableException Returned if the service cannot complete
     *         the request.</li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both
     *         service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side
     *         error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>GlacierException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     *         </li>
     *         </ul>
     * @sample GlacierAsyncClient.AbortMultipartUpload
     */
    default CompletableFuture<AbortMultipartUploadResponse> abortMultipartUpload(
            Consumer<AbortMultipartUploadRequest.Builder> abortMultipartUploadRequest) {
        return abortMultipartUpload(AbortMultipartUploadRequest.builder().applyMutation(abortMultipartUploadRequest).build());
    }

    /**
     * <p>
     * This operation aborts the vault locking process if the vault lock is not in the <code>Locked</code> state. If the
     * vault lock is in the <code>Locked</code> state when this operation is requested, the operation returns an
     * <code>AccessDeniedException</code> error. Aborting the vault locking process removes the vault lock policy from
     * the specified vault.
     * </p>
     * <p>
     * A vault lock is put into the <code>InProgress</code> state by calling <a>InitiateVaultLock</a>. A vault lock is
     * put into the <code>Locked</code> state by calling <a>CompleteVaultLock</a>. You can get the state of a vault lock
     * by calling <a>GetVaultLock</a>. For more information about the vault locking process, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier Vault Lock</a>. For
     * more information about vault lock policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html">Amazon Glacier Access Control
     * with Vault Lock Policies</a>.
     * </p>
     * <p>
     * This operation is idempotent. You can successfully invoke this operation multiple times, if the vault lock is in
     * the <code>InProgress</code> state or if there is no policy associated with the vault.
     * </p>
     *
     * @param abortVaultLockRequest
     *        The input values for <code>AbortVaultLock</code>.
     * @return A Java Future containing the result of the AbortVaultLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.AbortVaultLock
     */
    default CompletableFuture<AbortVaultLockResponse> abortVaultLock(AbortVaultLockRequest abortVaultLockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation aborts the vault locking process if the vault lock is not in the <code>Locked</code> state. If the
     * vault lock is in the <code>Locked</code> state when this operation is requested, the operation returns an
     * <code>AccessDeniedException</code> error. Aborting the vault locking process removes the vault lock policy from
     * the specified vault.
     * </p>
     * <p>
     * A vault lock is put into the <code>InProgress</code> state by calling <a>InitiateVaultLock</a>. A vault lock is
     * put into the <code>Locked</code> state by calling <a>CompleteVaultLock</a>. You can get the state of a vault lock
     * by calling <a>GetVaultLock</a>. For more information about the vault locking process, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier Vault Lock</a>. For
     * more information about vault lock policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html">Amazon Glacier Access Control
     * with Vault Lock Policies</a>.
     * </p>
     * <p>
     * This operation is idempotent. You can successfully invoke this operation multiple times, if the vault lock is in
     * the <code>InProgress</code> state or if there is no policy associated with the vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AbortVaultLockRequest.Builder} avoiding the need to
     * create one manually via {@link AbortVaultLockRequest#builder()}
     * </p>
     *
     * @param abortVaultLockRequest
     *        A {@link Consumer} that will call methods on {@link AbortVaultLockInput.Builder} to create a request. The
     *        input values for <code>AbortVaultLock</code>.
     * @return A Java Future containing the result of the AbortVaultLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.AbortVaultLock
     */
    default CompletableFuture<AbortVaultLockResponse> abortVaultLock(Consumer<AbortVaultLockRequest.Builder> abortVaultLockRequest) {
        return abortVaultLock(AbortVaultLockRequest.builder().applyMutation(abortVaultLockRequest).build());
    }

    /**
     * <p>
     * This operation adds the specified tags to a vault. Each tag is composed of a key and a value. Each vault can have
     * up to 10 tags. If your request would cause the tag limit for the vault to be exceeded, the operation throws the
     * <code>LimitExceededException</code> error. If a tag already exists on the vault under a specified key, the
     * existing key value will be overwritten. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html">Tagging Amazon S3 Glacier Resources</a>.
     * </p>
     *
     * @param addTagsToVaultRequest
     *        The input values for <code>AddTagsToVault</code>.
     * @return A Java Future containing the result of the AddTagsToVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>LimitExceededException Returned if the request results in a vault or account limit being exceeded.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.AddTagsToVault
     */
    default CompletableFuture<AddTagsToVaultResponse> addTagsToVault(AddTagsToVaultRequest addTagsToVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation adds the specified tags to a vault. Each tag is composed of a key and a value. Each vault can have
     * up to 10 tags. If your request would cause the tag limit for the vault to be exceeded, the operation throws the
     * <code>LimitExceededException</code> error. If a tag already exists on the vault under a specified key, the
     * existing key value will be overwritten. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html">Tagging Amazon S3 Glacier Resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToVaultRequest.Builder} avoiding the need to
     * create one manually via {@link AddTagsToVaultRequest#builder()}
     * </p>
     *
     * @param addTagsToVaultRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToVaultInput.Builder} to create a request. The
     *        input values for <code>AddTagsToVault</code>.
     * @return A Java Future containing the result of the AddTagsToVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>LimitExceededException Returned if the request results in a vault or account limit being exceeded.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.AddTagsToVault
     */
    default CompletableFuture<AddTagsToVaultResponse> addTagsToVault(Consumer<AddTagsToVaultRequest.Builder> addTagsToVaultRequest) {
        return addTagsToVault(AddTagsToVaultRequest.builder().applyMutation(addTagsToVaultRequest).build());
    }

    /**
     * <p>
     * You call this operation to inform Amazon S3 Glacier (Glacier) that all the archive parts have been uploaded and
     * that Glacier can now assemble the archive from the uploaded parts. After assembling and saving the archive to the
     * vault, Glacier returns the URI path of the newly created archive resource. Using the URI path, you can then
     * access the archive. After you upload an archive, you should save the archive ID returned to retrieve the archive
     * at a later point. You can also get the vault inventory to obtain a list of archive IDs in a vault. For more
     * information, see <a>InitiateJob</a>.
     * </p>
     * <p>
     * In the request, you must include the computed SHA256 tree hash of the entire archive you have uploaded. For
     * information about computing a SHA256 tree hash, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing Checksums</a>.
     * On the server side, Glacier also constructs the SHA256 tree hash of the assembled archive. If the values match,
     * Glacier saves the archive to the vault; otherwise, it returns an error, and the operation fails. The
     * <a>ListParts</a> operation returns a list of parts uploaded for a specific multipart upload. It includes checksum
     * information for each uploaded part that can be used to debug a bad checksum issue.
     * </p>
     * <p>
     * Additionally, Glacier also checks for any missing content ranges when assembling the archive, if missing content
     * ranges are found, Glacier returns an error and the operation fails.
     * </p>
     * <p>
     * Complete Multipart Upload is an idempotent operation. After your first successful complete multipart upload, if
     * you call the operation again within a short period, the operation will succeed and return the same archive ID.
     * This is useful in the event you experience a network issue that causes an aborted connection or receive a 500
     * server error, in which case you can repeat your Complete Multipart Upload request and get the same archive ID
     * without creating duplicate archives. Note, however, that after the multipart upload completes, you cannot call
     * the List Parts operation and the multipart upload will not appear in List Multipart Uploads response, even if
     * idempotent complete is possible.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html">Uploading Large Archives
     * in Parts (Multipart Upload)</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-complete-upload.html">Complete Multipart
     * Upload</a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param completeMultipartUploadRequest
     *        Provides options to complete a multipart upload operation. This informs Amazon Glacier that all the
     *        archive parts have been uploaded and Amazon S3 Glacier (Glacier) can now assemble the archive from the
     *        uploaded parts. After assembling and saving the archive to the vault, Glacier returns the URI path of the
     *        newly created archive resource.
     * @return A Java Future containing the result of the CompleteMultipartUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.CompleteMultipartUpload
     */
    default CompletableFuture<CompleteMultipartUploadResponse> completeMultipartUpload(
            CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You call this operation to inform Amazon S3 Glacier (Glacier) that all the archive parts have been uploaded and
     * that Glacier can now assemble the archive from the uploaded parts. After assembling and saving the archive to the
     * vault, Glacier returns the URI path of the newly created archive resource. Using the URI path, you can then
     * access the archive. After you upload an archive, you should save the archive ID returned to retrieve the archive
     * at a later point. You can also get the vault inventory to obtain a list of archive IDs in a vault. For more
     * information, see <a>InitiateJob</a>.
     * </p>
     * <p>
     * In the request, you must include the computed SHA256 tree hash of the entire archive you have uploaded. For
     * information about computing a SHA256 tree hash, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing Checksums</a>.
     * On the server side, Glacier also constructs the SHA256 tree hash of the assembled archive. If the values match,
     * Glacier saves the archive to the vault; otherwise, it returns an error, and the operation fails. The
     * <a>ListParts</a> operation returns a list of parts uploaded for a specific multipart upload. It includes checksum
     * information for each uploaded part that can be used to debug a bad checksum issue.
     * </p>
     * <p>
     * Additionally, Glacier also checks for any missing content ranges when assembling the archive, if missing content
     * ranges are found, Glacier returns an error and the operation fails.
     * </p>
     * <p>
     * Complete Multipart Upload is an idempotent operation. After your first successful complete multipart upload, if
     * you call the operation again within a short period, the operation will succeed and return the same archive ID.
     * This is useful in the event you experience a network issue that causes an aborted connection or receive a 500
     * server error, in which case you can repeat your Complete Multipart Upload request and get the same archive ID
     * without creating duplicate archives. Note, however, that after the multipart upload completes, you cannot call
     * the List Parts operation and the multipart upload will not appear in List Multipart Uploads response, even if
     * idempotent complete is possible.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html">Uploading Large Archives
     * in Parts (Multipart Upload)</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-complete-upload.html">Complete Multipart
     * Upload</a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteMultipartUploadRequest.Builder} avoiding
     * the need to create one manually via {@link CompleteMultipartUploadRequest#builder()}
     * </p>
     *
     * @param completeMultipartUploadRequest
     *        A {@link Consumer} that will call methods on {@link CompleteMultipartUploadInput.Builder} to create a
     *        request. Provides options to complete a multipart upload operation. This informs Amazon Glacier that all
     *        the archive parts have been uploaded and Amazon S3 Glacier (Glacier) can now assemble the archive from the
     *        uploaded parts. After assembling and saving the archive to the vault, Glacier returns the URI path of the
     *        newly created archive resource.
     * @return A Java Future containing the result of the CompleteMultipartUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.CompleteMultipartUpload
     */
    default CompletableFuture<CompleteMultipartUploadResponse> completeMultipartUpload(
            Consumer<CompleteMultipartUploadRequest.Builder> completeMultipartUploadRequest) {
        return completeMultipartUpload(CompleteMultipartUploadRequest.builder().applyMutation(completeMultipartUploadRequest)
                .build());
    }

    /**
     * <p>
     * This operation completes the vault locking process by transitioning the vault lock from the
     * <code>InProgress</code> state to the <code>Locked</code> state, which causes the vault lock policy to become
     * unchangeable. A vault lock is put into the <code>InProgress</code> state by calling <a>InitiateVaultLock</a>. You
     * can obtain the state of the vault lock by calling <a>GetVaultLock</a>. For more information about the vault
     * locking process, <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier
     * Vault Lock</a>.
     * </p>
     * <p>
     * This operation is idempotent. This request is always successful if the vault lock is in the <code>Locked</code>
     * state and the provided lock ID matches the lock ID originally used to lock the vault.
     * </p>
     * <p>
     * If an invalid lock ID is passed in the request when the vault lock is in the <code>Locked</code> state, the
     * operation returns an <code>AccessDeniedException</code> error. If an invalid lock ID is passed in the request
     * when the vault lock is in the <code>InProgress</code> state, the operation throws an
     * <code>InvalidParameter</code> error.
     * </p>
     *
     * @param completeVaultLockRequest
     *        The input values for <code>CompleteVaultLock</code>.
     * @return A Java Future containing the result of the CompleteVaultLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.CompleteVaultLock
     */
    default CompletableFuture<CompleteVaultLockResponse> completeVaultLock(CompleteVaultLockRequest completeVaultLockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation completes the vault locking process by transitioning the vault lock from the
     * <code>InProgress</code> state to the <code>Locked</code> state, which causes the vault lock policy to become
     * unchangeable. A vault lock is put into the <code>InProgress</code> state by calling <a>InitiateVaultLock</a>. You
     * can obtain the state of the vault lock by calling <a>GetVaultLock</a>. For more information about the vault
     * locking process, <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier
     * Vault Lock</a>.
     * </p>
     * <p>
     * This operation is idempotent. This request is always successful if the vault lock is in the <code>Locked</code>
     * state and the provided lock ID matches the lock ID originally used to lock the vault.
     * </p>
     * <p>
     * If an invalid lock ID is passed in the request when the vault lock is in the <code>Locked</code> state, the
     * operation returns an <code>AccessDeniedException</code> error. If an invalid lock ID is passed in the request
     * when the vault lock is in the <code>InProgress</code> state, the operation throws an
     * <code>InvalidParameter</code> error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteVaultLockRequest.Builder} avoiding the need
     * to create one manually via {@link CompleteVaultLockRequest#builder()}
     * </p>
     *
     * @param completeVaultLockRequest
     *        A {@link Consumer} that will call methods on {@link CompleteVaultLockInput.Builder} to create a request.
     *        The input values for <code>CompleteVaultLock</code>.
     * @return A Java Future containing the result of the CompleteVaultLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.CompleteVaultLock
     */
    default CompletableFuture<CompleteVaultLockResponse> completeVaultLock(
            Consumer<CompleteVaultLockRequest.Builder> completeVaultLockRequest) {
        return completeVaultLock(CompleteVaultLockRequest.builder().applyMutation(completeVaultLockRequest).build());
    }

    /**
     * <p>
     * This operation creates a new vault with the specified name. The name of the vault must be unique within a region
     * for an AWS account. You can create up to 1,000 vaults per account. If you need to create more vaults, contact
     * Amazon S3 Glacier.
     * </p>
     * <p>
     * You must use the following guidelines when naming a vault.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Names can be between 1 and 255 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), and '.' (period).
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/creating-vaults.html">Creating a Vault in Amazon
     * Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-put.html">Create Vault
     * </a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param createVaultRequest
     *        Provides options to create a vault.
     * @return A Java Future containing the result of the CreateVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>LimitExceededException Returned if the request results in a vault or account limit being exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.CreateVault
     */
    default CompletableFuture<CreateVaultResponse> createVault(CreateVaultRequest createVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation creates a new vault with the specified name. The name of the vault must be unique within a region
     * for an AWS account. You can create up to 1,000 vaults per account. If you need to create more vaults, contact
     * Amazon S3 Glacier.
     * </p>
     * <p>
     * You must use the following guidelines when naming a vault.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Names can be between 1 and 255 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), and '.' (period).
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/creating-vaults.html">Creating a Vault in Amazon
     * Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-put.html">Create Vault
     * </a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVaultRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVaultRequest#builder()}
     * </p>
     *
     * @param createVaultRequest
     *        A {@link Consumer} that will call methods on {@link CreateVaultInput.Builder} to create a request.
     *        Provides options to create a vault.
     * @return A Java Future containing the result of the CreateVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>LimitExceededException Returned if the request results in a vault or account limit being exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.CreateVault
     */
    default CompletableFuture<CreateVaultResponse> createVault(Consumer<CreateVaultRequest.Builder> createVaultRequest) {
        return createVault(CreateVaultRequest.builder().applyMutation(createVaultRequest).build());
    }

    /**
     * <p>
     * This operation deletes an archive from a vault. Subsequent requests to initiate a retrieval of this archive will
     * fail. Archive retrievals that are in progress for this archive ID may or may not succeed according to the
     * following scenarios:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the archive retrieval job is actively preparing the data for download when Amazon S3 Glacier receives the
     * delete archive request, the archival retrieval operation might fail.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the archive retrieval job has successfully prepared the archive for download when Amazon S3 Glacier receives
     * the delete archive request, you will be able to download the output.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent. Attempting to delete an already-deleted archive does not result in an error.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-an-archive.html">Deleting an Archive in
     * Amazon Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html">Delete Archive</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param deleteArchiveRequest
     *        Provides options for deleting an archive from an Amazon S3 Glacier vault.
     * @return A Java Future containing the result of the DeleteArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DeleteArchive
     */
    default CompletableFuture<DeleteArchiveResponse> deleteArchive(DeleteArchiveRequest deleteArchiveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes an archive from a vault. Subsequent requests to initiate a retrieval of this archive will
     * fail. Archive retrievals that are in progress for this archive ID may or may not succeed according to the
     * following scenarios:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the archive retrieval job is actively preparing the data for download when Amazon S3 Glacier receives the
     * delete archive request, the archival retrieval operation might fail.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the archive retrieval job has successfully prepared the archive for download when Amazon S3 Glacier receives
     * the delete archive request, you will be able to download the output.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent. Attempting to delete an already-deleted archive does not result in an error.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-an-archive.html">Deleting an Archive in
     * Amazon Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html">Delete Archive</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteArchiveRequest#builder()}
     * </p>
     *
     * @param deleteArchiveRequest
     *        A {@link Consumer} that will call methods on {@link DeleteArchiveInput.Builder} to create a request.
     *        Provides options for deleting an archive from an Amazon S3 Glacier vault.
     * @return A Java Future containing the result of the DeleteArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DeleteArchive
     */
    default CompletableFuture<DeleteArchiveResponse> deleteArchive(Consumer<DeleteArchiveRequest.Builder> deleteArchiveRequest) {
        return deleteArchive(DeleteArchiveRequest.builder().applyMutation(deleteArchiveRequest).build());
    }

    /**
     * <p>
     * This operation deletes a vault. Amazon S3 Glacier will delete a vault only if there are no archives in the vault
     * as of the last inventory and there have been no writes to the vault since the last inventory. If either of these
     * conditions is not satisfied, the vault deletion fails (that is, the vault is not removed) and Amazon S3 Glacier
     * returns an error. You can use <a>DescribeVault</a> to return the number of archives in a vault, and you can use
     * <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html">Initiate a Job (POST
     * jobs)</a> to initiate a new inventory retrieval for a vault. The inventory contains the archive IDs you use to
     * delete archives using <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html">Delete Archive (DELETE
     * archive)</a>.
     * </p>
     * <p>
     * This operation is idempotent.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-vaults.html">Deleting a Vault in Amazon
     * Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-delete.html">Delete Vault
     * </a> in the <i>Amazon S3 Glacier Developer Guide</i>.
     * </p>
     *
     * @param deleteVaultRequest
     *        Provides options for deleting a vault from Amazon S3 Glacier.
     * @return A Java Future containing the result of the DeleteVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DeleteVault
     */
    default CompletableFuture<DeleteVaultResponse> deleteVault(DeleteVaultRequest deleteVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes a vault. Amazon S3 Glacier will delete a vault only if there are no archives in the vault
     * as of the last inventory and there have been no writes to the vault since the last inventory. If either of these
     * conditions is not satisfied, the vault deletion fails (that is, the vault is not removed) and Amazon S3 Glacier
     * returns an error. You can use <a>DescribeVault</a> to return the number of archives in a vault, and you can use
     * <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html">Initiate a Job (POST
     * jobs)</a> to initiate a new inventory retrieval for a vault. The inventory contains the archive IDs you use to
     * delete archives using <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html">Delete Archive (DELETE
     * archive)</a>.
     * </p>
     * <p>
     * This operation is idempotent.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-vaults.html">Deleting a Vault in Amazon
     * Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-delete.html">Delete Vault
     * </a> in the <i>Amazon S3 Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVaultRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVaultRequest#builder()}
     * </p>
     *
     * @param deleteVaultRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVaultInput.Builder} to create a request.
     *        Provides options for deleting a vault from Amazon S3 Glacier.
     * @return A Java Future containing the result of the DeleteVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DeleteVault
     */
    default CompletableFuture<DeleteVaultResponse> deleteVault(Consumer<DeleteVaultRequest.Builder> deleteVaultRequest) {
        return deleteVault(DeleteVaultRequest.builder().applyMutation(deleteVaultRequest).build());
    }

    /**
     * <p>
     * This operation deletes the access policy associated with the specified vault. The operation is eventually
     * consistent; that is, it might take some time for Amazon S3 Glacier to completely remove the access policy, and
     * you might still see the effect of the policy for a short time after you send the delete request.
     * </p>
     * <p>
     * This operation is idempotent. You can invoke delete multiple times, even if there is no policy associated with
     * the vault. For more information about vault access policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html">Amazon Glacier Access
     * Control with Vault Access Policies</a>.
     * </p>
     *
     * @param deleteVaultAccessPolicyRequest
     *        DeleteVaultAccessPolicy input.
     * @return A Java Future containing the result of the DeleteVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DeleteVaultAccessPolicy
     */
    default CompletableFuture<DeleteVaultAccessPolicyResponse> deleteVaultAccessPolicy(
            DeleteVaultAccessPolicyRequest deleteVaultAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes the access policy associated with the specified vault. The operation is eventually
     * consistent; that is, it might take some time for Amazon S3 Glacier to completely remove the access policy, and
     * you might still see the effect of the policy for a short time after you send the delete request.
     * </p>
     * <p>
     * This operation is idempotent. You can invoke delete multiple times, even if there is no policy associated with
     * the vault. For more information about vault access policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html">Amazon Glacier Access
     * Control with Vault Access Policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVaultAccessPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param deleteVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVaultAccessPolicyInput.Builder} to create a
     *        request. DeleteVaultAccessPolicy input.
     * @return A Java Future containing the result of the DeleteVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DeleteVaultAccessPolicy
     */
    default CompletableFuture<DeleteVaultAccessPolicyResponse> deleteVaultAccessPolicy(
            Consumer<DeleteVaultAccessPolicyRequest.Builder> deleteVaultAccessPolicyRequest) {
        return deleteVaultAccessPolicy(DeleteVaultAccessPolicyRequest.builder().applyMutation(deleteVaultAccessPolicyRequest)
                .build());
    }

    /**
     * <p>
     * This operation deletes the notification configuration set for a vault. The operation is eventually consistent;
     * that is, it might take some time for Amazon S3 Glacier to completely disable the notifications and you might
     * still receive some notifications for a short time after you send the delete request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault
     * Notifications in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-delete.html">Delete Vault
     * Notification Configuration </a> in the Amazon S3 Glacier Developer Guide.
     * </p>
     *
     * @param deleteVaultNotificationsRequest
     *        Provides options for deleting a vault notification configuration from an Amazon Glacier vault.
     * @return A Java Future containing the result of the DeleteVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DeleteVaultNotifications
     */
    default CompletableFuture<DeleteVaultNotificationsResponse> deleteVaultNotifications(
            DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes the notification configuration set for a vault. The operation is eventually consistent;
     * that is, it might take some time for Amazon S3 Glacier to completely disable the notifications and you might
     * still receive some notifications for a short time after you send the delete request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault
     * Notifications in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-delete.html">Delete Vault
     * Notification Configuration </a> in the Amazon S3 Glacier Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVaultNotificationsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param deleteVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVaultNotificationsInput.Builder} to create a
     *        request. Provides options for deleting a vault notification configuration from an Amazon Glacier vault.
     * @return A Java Future containing the result of the DeleteVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DeleteVaultNotifications
     */
    default CompletableFuture<DeleteVaultNotificationsResponse> deleteVaultNotifications(
            Consumer<DeleteVaultNotificationsRequest.Builder> deleteVaultNotificationsRequest) {
        return deleteVaultNotifications(DeleteVaultNotificationsRequest.builder().applyMutation(deleteVaultNotificationsRequest)
                .build());
    }

    /**
     * <p>
     * This operation returns information about a job you previously initiated, including the job initiation date, the
     * user who initiated the job, the job status code/message and the Amazon SNS topic to notify after Amazon S3
     * Glacier (Glacier) completes the job. For more information about initiating a job, see <a>InitiateJob</a>.
     * </p>
     * <note>
     * <p>
     * This operation enables you to check the status of your job. However, it is strongly recommended that you set up
     * an Amazon SNS topic and specify it in your initiate job request so that Glacier can notify the topic after it
     * completes the job.
     * </p>
     * </note>
     * <p>
     * A job ID will not expire for at least 24 hours after Glacier completes the job.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For more information about using this operation, see the documentation for the underlying REST API <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-describe-job-get.html">Describe Job</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param describeJobRequest
     *        Provides options for retrieving a job description.
     * @return A Java Future containing the result of the DescribeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DescribeJob
     */
    default CompletableFuture<DescribeJobResponse> describeJob(DescribeJobRequest describeJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns information about a job you previously initiated, including the job initiation date, the
     * user who initiated the job, the job status code/message and the Amazon SNS topic to notify after Amazon S3
     * Glacier (Glacier) completes the job. For more information about initiating a job, see <a>InitiateJob</a>.
     * </p>
     * <note>
     * <p>
     * This operation enables you to check the status of your job. However, it is strongly recommended that you set up
     * an Amazon SNS topic and specify it in your initiate job request so that Glacier can notify the topic after it
     * completes the job.
     * </p>
     * </note>
     * <p>
     * A job ID will not expire for at least 24 hours after Glacier completes the job.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For more information about using this operation, see the documentation for the underlying REST API <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-describe-job-get.html">Describe Job</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobRequest#builder()}
     * </p>
     *
     * @param describeJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobInput.Builder} to create a request.
     *        Provides options for retrieving a job description.
     * @return A Java Future containing the result of the DescribeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DescribeJob
     */
    default CompletableFuture<DescribeJobResponse> describeJob(Consumer<DescribeJobRequest.Builder> describeJobRequest) {
        return describeJob(DescribeJobRequest.builder().applyMutation(describeJobRequest).build());
    }

    /**
     * <p>
     * This operation returns information about a vault, including the vault's Amazon Resource Name (ARN), the date the
     * vault was created, the number of archives it contains, and the total size of all the archives in the vault. The
     * number of archives and their total size are as of the last inventory generation. This means that if you add or
     * remove an archive from a vault, and then immediately use Describe Vault, the change in contents will not be
     * immediately reflected. If you want to retrieve the latest inventory of the vault, use <a>InitiateJob</a>. Amazon
     * S3 Glacier generates vault inventories approximately daily. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html">Downloading a Vault Inventory in
     * Amazon S3 Glacier</a>.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html">Retrieving Vault Metadata
     * in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-get.html">Describe Vault </a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param describeVaultRequest
     *        Provides options for retrieving metadata for a specific vault in Amazon Glacier.
     * @return A Java Future containing the result of the DescribeVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DescribeVault
     */
    default CompletableFuture<DescribeVaultResponse> describeVault(DescribeVaultRequest describeVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns information about a vault, including the vault's Amazon Resource Name (ARN), the date the
     * vault was created, the number of archives it contains, and the total size of all the archives in the vault. The
     * number of archives and their total size are as of the last inventory generation. This means that if you add or
     * remove an archive from a vault, and then immediately use Describe Vault, the change in contents will not be
     * immediately reflected. If you want to retrieve the latest inventory of the vault, use <a>InitiateJob</a>. Amazon
     * S3 Glacier generates vault inventories approximately daily. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html">Downloading a Vault Inventory in
     * Amazon S3 Glacier</a>.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html">Retrieving Vault Metadata
     * in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-get.html">Describe Vault </a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVaultRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeVaultRequest#builder()}
     * </p>
     *
     * @param describeVaultRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVaultInput.Builder} to create a request.
     *        Provides options for retrieving metadata for a specific vault in Amazon Glacier.
     * @return A Java Future containing the result of the DescribeVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.DescribeVault
     */
    default CompletableFuture<DescribeVaultResponse> describeVault(Consumer<DescribeVaultRequest.Builder> describeVaultRequest) {
        return describeVault(DescribeVaultRequest.builder().applyMutation(describeVaultRequest).build());
    }

    /**
     * <p>
     * This operation returns the current data retrieval policy for the account and region specified in the GET request.
     * For more information about data retrieval policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html">Amazon Glacier Data
     * Retrieval Policies</a>.
     * </p>
     *
     * @param getDataRetrievalPolicyRequest
     *        Input for GetDataRetrievalPolicy.
     * @return A Java Future containing the result of the GetDataRetrievalPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetDataRetrievalPolicy
     */
    default CompletableFuture<GetDataRetrievalPolicyResponse> getDataRetrievalPolicy(
            GetDataRetrievalPolicyRequest getDataRetrievalPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns the current data retrieval policy for the account and region specified in the GET request.
     * For more information about data retrieval policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html">Amazon Glacier Data
     * Retrieval Policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataRetrievalPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataRetrievalPolicyRequest#builder()}
     * </p>
     *
     * @param getDataRetrievalPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetDataRetrievalPolicyInput.Builder} to create a
     *        request. Input for GetDataRetrievalPolicy.
     * @return A Java Future containing the result of the GetDataRetrievalPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetDataRetrievalPolicy
     */
    default CompletableFuture<GetDataRetrievalPolicyResponse> getDataRetrievalPolicy(
            Consumer<GetDataRetrievalPolicyRequest.Builder> getDataRetrievalPolicyRequest) {
        return getDataRetrievalPolicy(GetDataRetrievalPolicyRequest.builder().applyMutation(getDataRetrievalPolicyRequest)
                .build());
    }

    /**
     * <p>
     * This operation returns the current data retrieval policy for the account and region specified in the GET request.
     * For more information about data retrieval policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html">Amazon Glacier Data
     * Retrieval Policies</a>.
     * </p>
     *
     * @return A Java Future containing the result of the GetDataRetrievalPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetDataRetrievalPolicy
     */
    default CompletableFuture<GetDataRetrievalPolicyResponse> getDataRetrievalPolicy() {
        return getDataRetrievalPolicy(GetDataRetrievalPolicyRequest.builder().build());
    }

    /**
     * <p>
     * This operation downloads the output of the job you initiated using <a>InitiateJob</a>. Depending on the job type
     * you specified when you initiated the job, the output will be either the content of an archive or a vault
     * inventory.
     * </p>
     * <p>
     * You can download all the job output or download a portion of the output by specifying a byte range. In the case
     * of an archive retrieval job, depending on the byte range you specify, Amazon S3 Glacier (Glacier) returns the
     * checksum for the portion of the data. You can compute the checksum on the client and verify that the values match
     * to ensure the portion you downloaded is the correct data.
     * </p>
     * <p>
     * A job ID will not expire for at least 24 hours after Glacier completes the job. That a byte range. For both
     * archive and inventory retrieval jobs, you should verify the downloaded size against the size returned in the
     * headers from the <b>Get Job Output</b> response.
     * </p>
     * <p>
     * For archive retrieval jobs, you should also verify that the size is what you expected. If you download a portion
     * of the output, the expected size is based on the range of bytes you specified. For example, if you specify a
     * range of <code>bytes=0-1048575</code>, you should verify your download size is 1,048,576 bytes. If you download
     * an entire archive, the expected size is the size of the archive when you uploaded it to Amazon S3 Glacier The
     * expected size is also returned in the headers from the <b>Get Job Output</b> response.
     * </p>
     * <p>
     * In the case of an archive retrieval job, depending on the byte range you specify, Glacier returns the checksum
     * for the portion of the data. To ensure the portion you downloaded is the correct data, compute the checksum on
     * the client, verify that the values match, and verify that the size is what you expected.
     * </p>
     * <p>
     * A job ID does not expire for at least 24 hours after Glacier completes the job. That is, you can download the job
     * output within the 24 hours period after Amazon Glacier completes the job.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html">Downloading a Vault
     * Inventory</a>, <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/downloading-an-archive.html">Downloading an
     * Archive</a>, and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-job-output-get.html">Get Job
     * Output </a>
     * </p>
     *
     * @param getJobOutputRequest
     *        Provides options for downloading output of an Amazon S3 Glacier job.
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The job data, either archive data or inventory data.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetJobOutput
     */
    default <ReturnT> CompletableFuture<ReturnT> getJobOutput(GetJobOutputRequest getJobOutputRequest,
            AsyncResponseTransformer<GetJobOutputResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation downloads the output of the job you initiated using <a>InitiateJob</a>. Depending on the job type
     * you specified when you initiated the job, the output will be either the content of an archive or a vault
     * inventory.
     * </p>
     * <p>
     * You can download all the job output or download a portion of the output by specifying a byte range. In the case
     * of an archive retrieval job, depending on the byte range you specify, Amazon S3 Glacier (Glacier) returns the
     * checksum for the portion of the data. You can compute the checksum on the client and verify that the values match
     * to ensure the portion you downloaded is the correct data.
     * </p>
     * <p>
     * A job ID will not expire for at least 24 hours after Glacier completes the job. That a byte range. For both
     * archive and inventory retrieval jobs, you should verify the downloaded size against the size returned in the
     * headers from the <b>Get Job Output</b> response.
     * </p>
     * <p>
     * For archive retrieval jobs, you should also verify that the size is what you expected. If you download a portion
     * of the output, the expected size is based on the range of bytes you specified. For example, if you specify a
     * range of <code>bytes=0-1048575</code>, you should verify your download size is 1,048,576 bytes. If you download
     * an entire archive, the expected size is the size of the archive when you uploaded it to Amazon S3 Glacier The
     * expected size is also returned in the headers from the <b>Get Job Output</b> response.
     * </p>
     * <p>
     * In the case of an archive retrieval job, depending on the byte range you specify, Glacier returns the checksum
     * for the portion of the data. To ensure the portion you downloaded is the correct data, compute the checksum on
     * the client, verify that the values match, and verify that the size is what you expected.
     * </p>
     * <p>
     * A job ID does not expire for at least 24 hours after Glacier completes the job. That is, you can download the job
     * output within the 24 hours period after Amazon Glacier completes the job.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html">Downloading a Vault
     * Inventory</a>, <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/downloading-an-archive.html">Downloading an
     * Archive</a>, and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-job-output-get.html">Get Job
     * Output </a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobOutputRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobOutputRequest#builder()}
     * </p>
     *
     * @param getJobOutputRequest
     *        A {@link Consumer} that will call methods on {@link GetJobOutputInput.Builder} to create a request.
     *        Provides options for downloading output of an Amazon S3 Glacier job.
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The job data, either archive data or inventory data.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetJobOutput
     */
    default <ReturnT> CompletableFuture<ReturnT> getJobOutput(Consumer<GetJobOutputRequest.Builder> getJobOutputRequest,
            AsyncResponseTransformer<GetJobOutputResponse, ReturnT> asyncResponseTransformer) {
        return getJobOutput(GetJobOutputRequest.builder().applyMutation(getJobOutputRequest).build(), asyncResponseTransformer);
    }

    /**
     * <p>
     * This operation downloads the output of the job you initiated using <a>InitiateJob</a>. Depending on the job type
     * you specified when you initiated the job, the output will be either the content of an archive or a vault
     * inventory.
     * </p>
     * <p>
     * You can download all the job output or download a portion of the output by specifying a byte range. In the case
     * of an archive retrieval job, depending on the byte range you specify, Amazon S3 Glacier (Glacier) returns the
     * checksum for the portion of the data. You can compute the checksum on the client and verify that the values match
     * to ensure the portion you downloaded is the correct data.
     * </p>
     * <p>
     * A job ID will not expire for at least 24 hours after Glacier completes the job. That a byte range. For both
     * archive and inventory retrieval jobs, you should verify the downloaded size against the size returned in the
     * headers from the <b>Get Job Output</b> response.
     * </p>
     * <p>
     * For archive retrieval jobs, you should also verify that the size is what you expected. If you download a portion
     * of the output, the expected size is based on the range of bytes you specified. For example, if you specify a
     * range of <code>bytes=0-1048575</code>, you should verify your download size is 1,048,576 bytes. If you download
     * an entire archive, the expected size is the size of the archive when you uploaded it to Amazon S3 Glacier The
     * expected size is also returned in the headers from the <b>Get Job Output</b> response.
     * </p>
     * <p>
     * In the case of an archive retrieval job, depending on the byte range you specify, Glacier returns the checksum
     * for the portion of the data. To ensure the portion you downloaded is the correct data, compute the checksum on
     * the client, verify that the values match, and verify that the size is what you expected.
     * </p>
     * <p>
     * A job ID does not expire for at least 24 hours after Glacier completes the job. That is, you can download the job
     * output within the 24 hours period after Amazon Glacier completes the job.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html">Downloading a Vault
     * Inventory</a>, <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/downloading-an-archive.html">Downloading an
     * Archive</a>, and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-job-output-get.html">Get Job
     * Output </a>
     * </p>
     *
     * @param getJobOutputRequest
     *        Provides options for downloading output of an Amazon S3 Glacier job.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The job data, either archive data or inventory data.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetJobOutput
     */
    default CompletableFuture<GetJobOutputResponse> getJobOutput(GetJobOutputRequest getJobOutputRequest, Path destinationPath) {
        return getJobOutput(getJobOutputRequest, AsyncResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * This operation downloads the output of the job you initiated using <a>InitiateJob</a>. Depending on the job type
     * you specified when you initiated the job, the output will be either the content of an archive or a vault
     * inventory.
     * </p>
     * <p>
     * You can download all the job output or download a portion of the output by specifying a byte range. In the case
     * of an archive retrieval job, depending on the byte range you specify, Amazon S3 Glacier (Glacier) returns the
     * checksum for the portion of the data. You can compute the checksum on the client and verify that the values match
     * to ensure the portion you downloaded is the correct data.
     * </p>
     * <p>
     * A job ID will not expire for at least 24 hours after Glacier completes the job. That a byte range. For both
     * archive and inventory retrieval jobs, you should verify the downloaded size against the size returned in the
     * headers from the <b>Get Job Output</b> response.
     * </p>
     * <p>
     * For archive retrieval jobs, you should also verify that the size is what you expected. If you download a portion
     * of the output, the expected size is based on the range of bytes you specified. For example, if you specify a
     * range of <code>bytes=0-1048575</code>, you should verify your download size is 1,048,576 bytes. If you download
     * an entire archive, the expected size is the size of the archive when you uploaded it to Amazon S3 Glacier The
     * expected size is also returned in the headers from the <b>Get Job Output</b> response.
     * </p>
     * <p>
     * In the case of an archive retrieval job, depending on the byte range you specify, Glacier returns the checksum
     * for the portion of the data. To ensure the portion you downloaded is the correct data, compute the checksum on
     * the client, verify that the values match, and verify that the size is what you expected.
     * </p>
     * <p>
     * A job ID does not expire for at least 24 hours after Glacier completes the job. That is, you can download the job
     * output within the 24 hours period after Amazon Glacier completes the job.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html">Downloading a Vault
     * Inventory</a>, <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/downloading-an-archive.html">Downloading an
     * Archive</a>, and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-job-output-get.html">Get Job
     * Output </a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobOutputRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobOutputRequest#builder()}
     * </p>
     *
     * @param getJobOutputRequest
     *        A {@link Consumer} that will call methods on {@link GetJobOutputInput.Builder} to create a request.
     *        Provides options for downloading output of an Amazon S3 Glacier job.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The job data, either archive data or inventory data.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetJobOutput
     */
    default CompletableFuture<GetJobOutputResponse> getJobOutput(Consumer<GetJobOutputRequest.Builder> getJobOutputRequest,
            Path destinationPath) {
        return getJobOutput(GetJobOutputRequest.builder().applyMutation(getJobOutputRequest).build(), destinationPath);
    }

    /**
     * <p>
     * This operation retrieves the <code>access-policy</code> subresource set on the vault; for more information on
     * setting this subresource, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetVaultAccessPolicy.html">Set Vault Access Policy
     * (PUT access-policy)</a>. If there is no access policy set on the vault, the operation returns a
     * <code>404 Not found</code> error. For more information about vault access policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html">Amazon Glacier Access
     * Control with Vault Access Policies</a>.
     * </p>
     *
     * @param getVaultAccessPolicyRequest
     *        Input for GetVaultAccessPolicy.
     * @return A Java Future containing the result of the GetVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetVaultAccessPolicy
     */
    default CompletableFuture<GetVaultAccessPolicyResponse> getVaultAccessPolicy(
            GetVaultAccessPolicyRequest getVaultAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation retrieves the <code>access-policy</code> subresource set on the vault; for more information on
     * setting this subresource, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetVaultAccessPolicy.html">Set Vault Access Policy
     * (PUT access-policy)</a>. If there is no access policy set on the vault, the operation returns a
     * <code>404 Not found</code> error. For more information about vault access policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html">Amazon Glacier Access
     * Control with Vault Access Policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVaultAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param getVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetVaultAccessPolicyInput.Builder} to create a
     *        request. Input for GetVaultAccessPolicy.
     * @return A Java Future containing the result of the GetVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetVaultAccessPolicy
     */
    default CompletableFuture<GetVaultAccessPolicyResponse> getVaultAccessPolicy(
            Consumer<GetVaultAccessPolicyRequest.Builder> getVaultAccessPolicyRequest) {
        return getVaultAccessPolicy(GetVaultAccessPolicyRequest.builder().applyMutation(getVaultAccessPolicyRequest).build());
    }

    /**
     * <p>
     * This operation retrieves the following attributes from the <code>lock-policy</code> subresource set on the
     * specified vault:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The vault lock policy set on the vault.
     * </p>
     * </li>
     * <li>
     * <p>
     * The state of the vault lock, which is either <code>InProgess</code> or <code>Locked</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * When the lock ID expires. The lock ID is used to complete the vault locking process.
     * </p>
     * </li>
     * <li>
     * <p>
     * When the vault lock was initiated and put into the <code>InProgress</code> state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A vault lock is put into the <code>InProgress</code> state by calling <a>InitiateVaultLock</a>. A vault lock is
     * put into the <code>Locked</code> state by calling <a>CompleteVaultLock</a>. You can abort the vault locking
     * process by calling <a>AbortVaultLock</a>. For more information about the vault locking process, <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier Vault Lock</a>.
     * </p>
     * <p>
     * If there is no vault lock policy set on the vault, the operation returns a <code>404 Not found</code> error. For
     * more information about vault lock policies, <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html">Amazon Glacier Access Control
     * with Vault Lock Policies</a>.
     * </p>
     *
     * @param getVaultLockRequest
     *        The input values for <code>GetVaultLock</code>.
     * @return A Java Future containing the result of the GetVaultLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetVaultLock
     */
    default CompletableFuture<GetVaultLockResponse> getVaultLock(GetVaultLockRequest getVaultLockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation retrieves the following attributes from the <code>lock-policy</code> subresource set on the
     * specified vault:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The vault lock policy set on the vault.
     * </p>
     * </li>
     * <li>
     * <p>
     * The state of the vault lock, which is either <code>InProgess</code> or <code>Locked</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * When the lock ID expires. The lock ID is used to complete the vault locking process.
     * </p>
     * </li>
     * <li>
     * <p>
     * When the vault lock was initiated and put into the <code>InProgress</code> state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A vault lock is put into the <code>InProgress</code> state by calling <a>InitiateVaultLock</a>. A vault lock is
     * put into the <code>Locked</code> state by calling <a>CompleteVaultLock</a>. You can abort the vault locking
     * process by calling <a>AbortVaultLock</a>. For more information about the vault locking process, <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier Vault Lock</a>.
     * </p>
     * <p>
     * If there is no vault lock policy set on the vault, the operation returns a <code>404 Not found</code> error. For
     * more information about vault lock policies, <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html">Amazon Glacier Access Control
     * with Vault Lock Policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVaultLockRequest.Builder} avoiding the need to
     * create one manually via {@link GetVaultLockRequest#builder()}
     * </p>
     *
     * @param getVaultLockRequest
     *        A {@link Consumer} that will call methods on {@link GetVaultLockInput.Builder} to create a request. The
     *        input values for <code>GetVaultLock</code>.
     * @return A Java Future containing the result of the GetVaultLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetVaultLock
     */
    default CompletableFuture<GetVaultLockResponse> getVaultLock(Consumer<GetVaultLockRequest.Builder> getVaultLockRequest) {
        return getVaultLock(GetVaultLockRequest.builder().applyMutation(getVaultLockRequest).build());
    }

    /**
     * <p>
     * This operation retrieves the <code>notification-configuration</code> subresource of the specified vault.
     * </p>
     * <p>
     * For information about setting a notification configuration on a vault, see <a>SetVaultNotifications</a>. If a
     * notification configuration for a vault is not set, the operation returns a <code>404 Not Found</code> error. For
     * more information about vault notifications, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault
     * Notifications in Amazon S3 Glacier</a>.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault
     * Notifications in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-get.html">Get Vault
     * Notification Configuration </a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param getVaultNotificationsRequest
     *        Provides options for retrieving the notification configuration set on an Amazon Glacier vault.
     * @return A Java Future containing the result of the GetVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetVaultNotifications
     */
    default CompletableFuture<GetVaultNotificationsResponse> getVaultNotifications(
            GetVaultNotificationsRequest getVaultNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation retrieves the <code>notification-configuration</code> subresource of the specified vault.
     * </p>
     * <p>
     * For information about setting a notification configuration on a vault, see <a>SetVaultNotifications</a>. If a
     * notification configuration for a vault is not set, the operation returns a <code>404 Not Found</code> error. For
     * more information about vault notifications, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault
     * Notifications in Amazon S3 Glacier</a>.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault
     * Notifications in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-get.html">Get Vault
     * Notification Configuration </a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVaultNotificationsRequest.Builder} avoiding the
     * need to create one manually via {@link GetVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param getVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on {@link GetVaultNotificationsInput.Builder} to create a
     *        request. Provides options for retrieving the notification configuration set on an Amazon Glacier vault.
     * @return A Java Future containing the result of the GetVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.GetVaultNotifications
     */
    default CompletableFuture<GetVaultNotificationsResponse> getVaultNotifications(
            Consumer<GetVaultNotificationsRequest.Builder> getVaultNotificationsRequest) {
        return getVaultNotifications(GetVaultNotificationsRequest.builder().applyMutation(getVaultNotificationsRequest).build());
    }

    /**
     * <p>
     * This operation initiates a job of the specified type, which can be a select, an archival retrieval, or a vault
     * retrieval. For more information about using this operation, see the documentation for the underlying REST API <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html">Initiate a Job</a>.
     * </p>
     *
     * @param initiateJobRequest
     *        Provides options for initiating an Amazon S3 Glacier job.
     * @return A Java Future containing the result of the InitiateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>PolicyEnforcedException Returned if a retrieval job would exceed the current data policy's retrieval
     *         rate limit. For more information about data retrieval policies,</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>InsufficientCapacityException Returned if there is insufficient capacity to process this expedited
     *         request. This error only applies to expedited retrievals and not to standard or bulk retrievals.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.InitiateJob
     */
    default CompletableFuture<InitiateJobResponse> initiateJob(InitiateJobRequest initiateJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation initiates a job of the specified type, which can be a select, an archival retrieval, or a vault
     * retrieval. For more information about using this operation, see the documentation for the underlying REST API <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html">Initiate a Job</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateJobRequest.Builder} avoiding the need to
     * create one manually via {@link InitiateJobRequest#builder()}
     * </p>
     *
     * @param initiateJobRequest
     *        A {@link Consumer} that will call methods on {@link InitiateJobInput.Builder} to create a request.
     *        Provides options for initiating an Amazon S3 Glacier job.
     * @return A Java Future containing the result of the InitiateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>PolicyEnforcedException Returned if a retrieval job would exceed the current data policy's retrieval
     *         rate limit. For more information about data retrieval policies,</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>InsufficientCapacityException Returned if there is insufficient capacity to process this expedited
     *         request. This error only applies to expedited retrievals and not to standard or bulk retrievals.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.InitiateJob
     */
    default CompletableFuture<InitiateJobResponse> initiateJob(Consumer<InitiateJobRequest.Builder> initiateJobRequest) {
        return initiateJob(InitiateJobRequest.builder().applyMutation(initiateJobRequest).build());
    }

    /**
     * <p>
     * This operation initiates a multipart upload. Amazon S3 Glacier creates a multipart upload resource and returns
     * its ID in the response. The multipart upload ID is used in subsequent requests to upload parts of an archive (see
     * <a>UploadMultipartPart</a>).
     * </p>
     * <p>
     * When you initiate a multipart upload, you specify the part size in number of bytes. The part size must be a
     * megabyte (1024 KB) multiplied by a power of 2-for example, 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB),
     * 8388608 (8 MB), and so on. The minimum allowable part size is 1 MB, and the maximum is 4 GB.
     * </p>
     * <p>
     * Every part you upload to this resource (see <a>UploadMultipartPart</a>), except the last one, must have the same
     * size. The last one can be the same size or smaller. For example, suppose you want to upload a 16.2 MB file. If
     * you initiate the multipart upload with a part size of 4 MB, you will upload four parts of 4 MB each and one part
     * of 0.2 MB.
     * </p>
     * <note>
     * <p>
     * You don't need to know the size of the archive when you start a multipart upload because Amazon S3 Glacier does
     * not require you to specify the overall archive size.
     * </p>
     * </note>
     * <p>
     * After you complete the multipart upload, Amazon S3 Glacier (Glacier) removes the multipart upload resource
     * referenced by the ID. Glacier also removes the multipart upload resource if you cancel the multipart upload or it
     * may be removed if there is no activity for a period of 24 hours.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html">Uploading Large Archives
     * in Parts (Multipart Upload)</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-initiate-upload.html">Initiate Multipart
     * Upload</a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param initiateMultipartUploadRequest
     *        Provides options for initiating a multipart upload to an Amazon S3 Glacier vault.
     * @return A Java Future containing the result of the InitiateMultipartUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.InitiateMultipartUpload
     */
    default CompletableFuture<InitiateMultipartUploadResponse> initiateMultipartUpload(
            InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation initiates a multipart upload. Amazon S3 Glacier creates a multipart upload resource and returns
     * its ID in the response. The multipart upload ID is used in subsequent requests to upload parts of an archive (see
     * <a>UploadMultipartPart</a>).
     * </p>
     * <p>
     * When you initiate a multipart upload, you specify the part size in number of bytes. The part size must be a
     * megabyte (1024 KB) multiplied by a power of 2-for example, 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB),
     * 8388608 (8 MB), and so on. The minimum allowable part size is 1 MB, and the maximum is 4 GB.
     * </p>
     * <p>
     * Every part you upload to this resource (see <a>UploadMultipartPart</a>), except the last one, must have the same
     * size. The last one can be the same size or smaller. For example, suppose you want to upload a 16.2 MB file. If
     * you initiate the multipart upload with a part size of 4 MB, you will upload four parts of 4 MB each and one part
     * of 0.2 MB.
     * </p>
     * <note>
     * <p>
     * You don't need to know the size of the archive when you start a multipart upload because Amazon S3 Glacier does
     * not require you to specify the overall archive size.
     * </p>
     * </note>
     * <p>
     * After you complete the multipart upload, Amazon S3 Glacier (Glacier) removes the multipart upload resource
     * referenced by the ID. Glacier also removes the multipart upload resource if you cancel the multipart upload or it
     * may be removed if there is no activity for a period of 24 hours.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html">Uploading Large Archives
     * in Parts (Multipart Upload)</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-initiate-upload.html">Initiate Multipart
     * Upload</a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateMultipartUploadRequest.Builder} avoiding
     * the need to create one manually via {@link InitiateMultipartUploadRequest#builder()}
     * </p>
     *
     * @param initiateMultipartUploadRequest
     *        A {@link Consumer} that will call methods on {@link InitiateMultipartUploadInput.Builder} to create a
     *        request. Provides options for initiating a multipart upload to an Amazon S3 Glacier vault.
     * @return A Java Future containing the result of the InitiateMultipartUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.InitiateMultipartUpload
     */
    default CompletableFuture<InitiateMultipartUploadResponse> initiateMultipartUpload(
            Consumer<InitiateMultipartUploadRequest.Builder> initiateMultipartUploadRequest) {
        return initiateMultipartUpload(InitiateMultipartUploadRequest.builder().applyMutation(initiateMultipartUploadRequest)
                .build());
    }

    /**
     * <p>
     * This operation initiates the vault locking process by doing the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Installing a vault lock policy on the specified vault.
     * </p>
     * </li>
     * <li>
     * <p>
     * Setting the lock state of vault lock to <code>InProgress</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Returning a lock ID, which is used to complete the vault locking process.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can set one vault lock policy for each vault and this policy can be up to 20 KB in size. For more information
     * about vault lock policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html">Amazon Glacier Access Control
     * with Vault Lock Policies</a>.
     * </p>
     * <p>
     * You must complete the vault locking process within 24 hours after the vault lock enters the
     * <code>InProgress</code> state. After the 24 hour window ends, the lock ID expires, the vault automatically exits
     * the <code>InProgress</code> state, and the vault lock policy is removed from the vault. You call
     * <a>CompleteVaultLock</a> to complete the vault locking process by setting the state of the vault lock to
     * <code>Locked</code>.
     * </p>
     * <p>
     * After a vault lock is in the <code>Locked</code> state, you cannot initiate a new vault lock for the vault.
     * </p>
     * <p>
     * You can abort the vault locking process by calling <a>AbortVaultLock</a>. You can get the state of the vault lock
     * by calling <a>GetVaultLock</a>. For more information about the vault locking process, <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier Vault Lock</a>.
     * </p>
     * <p>
     * If this operation is called when the vault lock is in the <code>InProgress</code> state, the operation returns an
     * <code>AccessDeniedException</code> error. When the vault lock is in the <code>InProgress</code> state you must
     * call <a>AbortVaultLock</a> before you can initiate a new vault lock policy.
     * </p>
     *
     * @param initiateVaultLockRequest
     *        The input values for <code>InitiateVaultLock</code>.
     * @return A Java Future containing the result of the InitiateVaultLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.InitiateVaultLock
     */
    default CompletableFuture<InitiateVaultLockResponse> initiateVaultLock(InitiateVaultLockRequest initiateVaultLockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation initiates the vault locking process by doing the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Installing a vault lock policy on the specified vault.
     * </p>
     * </li>
     * <li>
     * <p>
     * Setting the lock state of vault lock to <code>InProgress</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Returning a lock ID, which is used to complete the vault locking process.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can set one vault lock policy for each vault and this policy can be up to 20 KB in size. For more information
     * about vault lock policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html">Amazon Glacier Access Control
     * with Vault Lock Policies</a>.
     * </p>
     * <p>
     * You must complete the vault locking process within 24 hours after the vault lock enters the
     * <code>InProgress</code> state. After the 24 hour window ends, the lock ID expires, the vault automatically exits
     * the <code>InProgress</code> state, and the vault lock policy is removed from the vault. You call
     * <a>CompleteVaultLock</a> to complete the vault locking process by setting the state of the vault lock to
     * <code>Locked</code>.
     * </p>
     * <p>
     * After a vault lock is in the <code>Locked</code> state, you cannot initiate a new vault lock for the vault.
     * </p>
     * <p>
     * You can abort the vault locking process by calling <a>AbortVaultLock</a>. You can get the state of the vault lock
     * by calling <a>GetVaultLock</a>. For more information about the vault locking process, <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier Vault Lock</a>.
     * </p>
     * <p>
     * If this operation is called when the vault lock is in the <code>InProgress</code> state, the operation returns an
     * <code>AccessDeniedException</code> error. When the vault lock is in the <code>InProgress</code> state you must
     * call <a>AbortVaultLock</a> before you can initiate a new vault lock policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateVaultLockRequest.Builder} avoiding the need
     * to create one manually via {@link InitiateVaultLockRequest#builder()}
     * </p>
     *
     * @param initiateVaultLockRequest
     *        A {@link Consumer} that will call methods on {@link InitiateVaultLockInput.Builder} to create a request.
     *        The input values for <code>InitiateVaultLock</code>.
     * @return A Java Future containing the result of the InitiateVaultLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.InitiateVaultLock
     */
    default CompletableFuture<InitiateVaultLockResponse> initiateVaultLock(
            Consumer<InitiateVaultLockRequest.Builder> initiateVaultLockRequest) {
        return initiateVaultLock(InitiateVaultLockRequest.builder().applyMutation(initiateVaultLockRequest).build());
    }

    /**
     * <p>
     * This operation lists jobs for a vault, including jobs that are in-progress and jobs that have recently finished.
     * The List Job operation returns a list of these jobs sorted by job initiation time.
     * </p>
     * <note>
     * <p>
     * Amazon Glacier retains recently completed jobs for a period before deleting them; however, it eventually removes
     * completed jobs. The output of completed jobs can be retrieved. Retaining completed jobs for a period of time
     * after they have completed enables you to get a job output in the event you miss the job completion notification
     * or your first attempt to download it fails. For example, suppose you start an archive retrieval job to download
     * an archive. After the job completes, you start to download the archive but encounter a network error. In this
     * scenario, you can retry and download the archive while the job exists.
     * </p>
     * </note>
     * <p>
     * The List Jobs operation supports pagination. You should always check the response <code>Marker</code> field. If
     * there are no more jobs to list, the <code>Marker</code> field is set to <code>null</code>. If there are more jobs
     * to list, the <code>Marker</code> field is set to a non-null value, which you can use to continue the pagination
     * of the list. To return a list of jobs that begins at a specific job, set the marker request parameter to the
     * <code>Marker</code> value for that job that you obtained from a previous List Jobs request.
     * </p>
     * <p>
     * You can set a maximum limit for the number of jobs returned in the response by specifying the <code>limit</code>
     * parameter in the request. The default limit is 50. The number of jobs returned might be fewer than the limit, but
     * the number of returned jobs never exceeds the limit.
     * </p>
     * <p>
     * Additionally, you can filter the jobs list returned by specifying the optional <code>statuscode</code> parameter
     * or <code>completed</code> parameter, or both. Using the <code>statuscode</code> parameter, you can specify to
     * return only jobs that match either the <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>
     * status. Using the <code>completed</code> parameter, you can specify to return only jobs that were completed (
     * <code>true</code>) or jobs that were not completed (<code>false</code>).
     * </p>
     * <p>
     * For more information about using this operation, see the documentation for the underlying REST API <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html">List Jobs</a>.
     * </p>
     *
     * @param listJobsRequest
     *        Provides options for retrieving a job list for an Amazon S3 Glacier vault.
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListJobs
     */
    default CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists jobs for a vault, including jobs that are in-progress and jobs that have recently finished.
     * The List Job operation returns a list of these jobs sorted by job initiation time.
     * </p>
     * <note>
     * <p>
     * Amazon Glacier retains recently completed jobs for a period before deleting them; however, it eventually removes
     * completed jobs. The output of completed jobs can be retrieved. Retaining completed jobs for a period of time
     * after they have completed enables you to get a job output in the event you miss the job completion notification
     * or your first attempt to download it fails. For example, suppose you start an archive retrieval job to download
     * an archive. After the job completes, you start to download the archive but encounter a network error. In this
     * scenario, you can retry and download the archive while the job exists.
     * </p>
     * </note>
     * <p>
     * The List Jobs operation supports pagination. You should always check the response <code>Marker</code> field. If
     * there are no more jobs to list, the <code>Marker</code> field is set to <code>null</code>. If there are more jobs
     * to list, the <code>Marker</code> field is set to a non-null value, which you can use to continue the pagination
     * of the list. To return a list of jobs that begins at a specific job, set the marker request parameter to the
     * <code>Marker</code> value for that job that you obtained from a previous List Jobs request.
     * </p>
     * <p>
     * You can set a maximum limit for the number of jobs returned in the response by specifying the <code>limit</code>
     * parameter in the request. The default limit is 50. The number of jobs returned might be fewer than the limit, but
     * the number of returned jobs never exceeds the limit.
     * </p>
     * <p>
     * Additionally, you can filter the jobs list returned by specifying the optional <code>statuscode</code> parameter
     * or <code>completed</code> parameter, or both. Using the <code>statuscode</code> parameter, you can specify to
     * return only jobs that match either the <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>
     * status. Using the <code>completed</code> parameter, you can specify to return only jobs that were completed (
     * <code>true</code>) or jobs that were not completed (<code>false</code>).
     * </p>
     * <p>
     * For more information about using this operation, see the documentation for the underlying REST API <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html">List Jobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsInput.Builder} to create a request. Provides
     *        options for retrieving a job list for an Amazon S3 Glacier vault.
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListJobs
     */
    default CompletableFuture<ListJobsResponse> listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * This operation lists jobs for a vault, including jobs that are in-progress and jobs that have recently finished.
     * The List Job operation returns a list of these jobs sorted by job initiation time.
     * </p>
     * <note>
     * <p>
     * Amazon Glacier retains recently completed jobs for a period before deleting them; however, it eventually removes
     * completed jobs. The output of completed jobs can be retrieved. Retaining completed jobs for a period of time
     * after they have completed enables you to get a job output in the event you miss the job completion notification
     * or your first attempt to download it fails. For example, suppose you start an archive retrieval job to download
     * an archive. After the job completes, you start to download the archive but encounter a network error. In this
     * scenario, you can retry and download the archive while the job exists.
     * </p>
     * </note>
     * <p>
     * The List Jobs operation supports pagination. You should always check the response <code>Marker</code> field. If
     * there are no more jobs to list, the <code>Marker</code> field is set to <code>null</code>. If there are more jobs
     * to list, the <code>Marker</code> field is set to a non-null value, which you can use to continue the pagination
     * of the list. To return a list of jobs that begins at a specific job, set the marker request parameter to the
     * <code>Marker</code> value for that job that you obtained from a previous List Jobs request.
     * </p>
     * <p>
     * You can set a maximum limit for the number of jobs returned in the response by specifying the <code>limit</code>
     * parameter in the request. The default limit is 50. The number of jobs returned might be fewer than the limit, but
     * the number of returned jobs never exceeds the limit.
     * </p>
     * <p>
     * Additionally, you can filter the jobs list returned by specifying the optional <code>statuscode</code> parameter
     * or <code>completed</code> parameter, or both. Using the <code>statuscode</code> parameter, you can specify to
     * return only jobs that match either the <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>
     * status. Using the <code>completed</code> parameter, you can specify to return only jobs that were completed (
     * <code>true</code>) or jobs that were not completed (<code>false</code>).
     * </p>
     * <p>
     * For more information about using this operation, see the documentation for the underlying REST API <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html">List Jobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.glacier.model.ListJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glacier.model.ListJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glacier.model.ListJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.glacier.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     *        Provides options for retrieving a job list for an Amazon S3 Glacier vault.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListJobs
     */
    default ListJobsPublisher listJobsPaginator(ListJobsRequest listJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists jobs for a vault, including jobs that are in-progress and jobs that have recently finished.
     * The List Job operation returns a list of these jobs sorted by job initiation time.
     * </p>
     * <note>
     * <p>
     * Amazon Glacier retains recently completed jobs for a period before deleting them; however, it eventually removes
     * completed jobs. The output of completed jobs can be retrieved. Retaining completed jobs for a period of time
     * after they have completed enables you to get a job output in the event you miss the job completion notification
     * or your first attempt to download it fails. For example, suppose you start an archive retrieval job to download
     * an archive. After the job completes, you start to download the archive but encounter a network error. In this
     * scenario, you can retry and download the archive while the job exists.
     * </p>
     * </note>
     * <p>
     * The List Jobs operation supports pagination. You should always check the response <code>Marker</code> field. If
     * there are no more jobs to list, the <code>Marker</code> field is set to <code>null</code>. If there are more jobs
     * to list, the <code>Marker</code> field is set to a non-null value, which you can use to continue the pagination
     * of the list. To return a list of jobs that begins at a specific job, set the marker request parameter to the
     * <code>Marker</code> value for that job that you obtained from a previous List Jobs request.
     * </p>
     * <p>
     * You can set a maximum limit for the number of jobs returned in the response by specifying the <code>limit</code>
     * parameter in the request. The default limit is 50. The number of jobs returned might be fewer than the limit, but
     * the number of returned jobs never exceeds the limit.
     * </p>
     * <p>
     * Additionally, you can filter the jobs list returned by specifying the optional <code>statuscode</code> parameter
     * or <code>completed</code> parameter, or both. Using the <code>statuscode</code> parameter, you can specify to
     * return only jobs that match either the <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>
     * status. Using the <code>completed</code> parameter, you can specify to return only jobs that were completed (
     * <code>true</code>) or jobs that were not completed (<code>false</code>).
     * </p>
     * <p>
     * For more information about using this operation, see the documentation for the underlying REST API <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html">List Jobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.glacier.model.ListJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glacier.model.ListJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glacier.model.ListJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.glacier.model.ListJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsInput.Builder} to create a request. Provides
     *        options for retrieving a job list for an Amazon S3 Glacier vault.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListJobs
     */
    default ListJobsPublisher listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return listJobsPaginator(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * This operation lists in-progress multipart uploads for the specified vault. An in-progress multipart upload is a
     * multipart upload that has been initiated by an <a>InitiateMultipartUpload</a> request, but has not yet been
     * completed or aborted. The list returned in the List Multipart Upload response has no guaranteed order.
     * </p>
     * <p>
     * The List Multipart Uploads operation supports pagination. By default, this operation returns up to 50 multipart
     * uploads in the response. You should always check the response for a <code>marker</code> at which to continue the
     * list; if there are no more items the <code>marker</code> is <code>null</code>. To return a list of multipart
     * uploads that begins at a specific upload, set the <code>marker</code> request parameter to the value you obtained
     * from a previous List Multipart Upload request. You can also limit the number of uploads returned in the response
     * by specifying the <code>limit</code> parameter in the request.
     * </p>
     * <p>
     * Note the difference between this operation and listing parts (<a>ListParts</a>). The List Multipart Uploads
     * operation lists all multipart uploads for a vault and does not require a multipart upload ID. The List Parts
     * operation requires a multipart upload ID since parts are associated with a single upload.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
     * Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html">List Multipart
     * Uploads </a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param listMultipartUploadsRequest
     *        Provides options for retrieving list of in-progress multipart uploads for an Amazon Glacier vault.
     * @return A Java Future containing the result of the ListMultipartUploads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListMultipartUploads
     */
    default CompletableFuture<ListMultipartUploadsResponse> listMultipartUploads(
            ListMultipartUploadsRequest listMultipartUploadsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists in-progress multipart uploads for the specified vault. An in-progress multipart upload is a
     * multipart upload that has been initiated by an <a>InitiateMultipartUpload</a> request, but has not yet been
     * completed or aborted. The list returned in the List Multipart Upload response has no guaranteed order.
     * </p>
     * <p>
     * The List Multipart Uploads operation supports pagination. By default, this operation returns up to 50 multipart
     * uploads in the response. You should always check the response for a <code>marker</code> at which to continue the
     * list; if there are no more items the <code>marker</code> is <code>null</code>. To return a list of multipart
     * uploads that begins at a specific upload, set the <code>marker</code> request parameter to the value you obtained
     * from a previous List Multipart Upload request. You can also limit the number of uploads returned in the response
     * by specifying the <code>limit</code> parameter in the request.
     * </p>
     * <p>
     * Note the difference between this operation and listing parts (<a>ListParts</a>). The List Multipart Uploads
     * operation lists all multipart uploads for a vault and does not require a multipart upload ID. The List Parts
     * operation requires a multipart upload ID since parts are associated with a single upload.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
     * Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html">List Multipart
     * Uploads </a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultipartUploadsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultipartUploadsRequest#builder()}
     * </p>
     *
     * @param listMultipartUploadsRequest
     *        A {@link Consumer} that will call methods on {@link ListMultipartUploadsInput.Builder} to create a
     *        request. Provides options for retrieving list of in-progress multipart uploads for an Amazon Glacier
     *        vault.
     * @return A Java Future containing the result of the ListMultipartUploads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListMultipartUploads
     */
    default CompletableFuture<ListMultipartUploadsResponse> listMultipartUploads(
            Consumer<ListMultipartUploadsRequest.Builder> listMultipartUploadsRequest) {
        return listMultipartUploads(ListMultipartUploadsRequest.builder().applyMutation(listMultipartUploadsRequest).build());
    }

    /**
     * <p>
     * This operation lists in-progress multipart uploads for the specified vault. An in-progress multipart upload is a
     * multipart upload that has been initiated by an <a>InitiateMultipartUpload</a> request, but has not yet been
     * completed or aborted. The list returned in the List Multipart Upload response has no guaranteed order.
     * </p>
     * <p>
     * The List Multipart Uploads operation supports pagination. By default, this operation returns up to 50 multipart
     * uploads in the response. You should always check the response for a <code>marker</code> at which to continue the
     * list; if there are no more items the <code>marker</code> is <code>null</code>. To return a list of multipart
     * uploads that begins at a specific upload, set the <code>marker</code> request parameter to the value you obtained
     * from a previous List Multipart Upload request. You can also limit the number of uploads returned in the response
     * by specifying the <code>limit</code> parameter in the request.
     * </p>
     * <p>
     * Note the difference between this operation and listing parts (<a>ListParts</a>). The List Multipart Uploads
     * operation lists all multipart uploads for a vault and does not require a multipart upload ID. The List Parts
     * operation requires a multipart upload ID since parts are associated with a single upload.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
     * Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html">List Multipart
     * Uploads </a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMultipartUploads(software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListMultipartUploadsPublisher publisher = client.listMultipartUploadsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListMultipartUploadsPublisher publisher = client.listMultipartUploadsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultipartUploads(software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMultipartUploadsRequest
     *        Provides options for retrieving list of in-progress multipart uploads for an Amazon Glacier vault.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListMultipartUploads
     */
    default ListMultipartUploadsPublisher listMultipartUploadsPaginator(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists in-progress multipart uploads for the specified vault. An in-progress multipart upload is a
     * multipart upload that has been initiated by an <a>InitiateMultipartUpload</a> request, but has not yet been
     * completed or aborted. The list returned in the List Multipart Upload response has no guaranteed order.
     * </p>
     * <p>
     * The List Multipart Uploads operation supports pagination. By default, this operation returns up to 50 multipart
     * uploads in the response. You should always check the response for a <code>marker</code> at which to continue the
     * list; if there are no more items the <code>marker</code> is <code>null</code>. To return a list of multipart
     * uploads that begins at a specific upload, set the <code>marker</code> request parameter to the value you obtained
     * from a previous List Multipart Upload request. You can also limit the number of uploads returned in the response
     * by specifying the <code>limit</code> parameter in the request.
     * </p>
     * <p>
     * Note the difference between this operation and listing parts (<a>ListParts</a>). The List Multipart Uploads
     * operation lists all multipart uploads for a vault and does not require a multipart upload ID. The List Parts
     * operation requires a multipart upload ID since parts are associated with a single upload.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
     * Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html">List Multipart
     * Uploads </a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMultipartUploads(software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListMultipartUploadsPublisher publisher = client.listMultipartUploadsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListMultipartUploadsPublisher publisher = client.listMultipartUploadsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultipartUploads(software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultipartUploadsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultipartUploadsRequest#builder()}
     * </p>
     *
     * @param listMultipartUploadsRequest
     *        A {@link Consumer} that will call methods on {@link ListMultipartUploadsInput.Builder} to create a
     *        request. Provides options for retrieving list of in-progress multipart uploads for an Amazon Glacier
     *        vault.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListMultipartUploads
     */
    default ListMultipartUploadsPublisher listMultipartUploadsPaginator(
            Consumer<ListMultipartUploadsRequest.Builder> listMultipartUploadsRequest) {
        return listMultipartUploadsPaginator(ListMultipartUploadsRequest.builder().applyMutation(listMultipartUploadsRequest)
                .build());
    }

    /**
     * <p>
     * This operation lists the parts of an archive that have been uploaded in a specific multipart upload. You can make
     * this request at any time during an in-progress multipart upload before you complete the upload (see
     * <a>CompleteMultipartUpload</a>. List Parts returns an error for completed uploads. The list returned in the List
     * Parts response is sorted by part range.
     * </p>
     * <p>
     * The List Parts operation supports pagination. By default, this operation returns up to 50 uploaded parts in the
     * response. You should always check the response for a <code>marker</code> at which to continue the list; if there
     * are no more items the <code>marker</code> is <code>null</code>. To return a list of parts that begins at a
     * specific part, set the <code>marker</code> request parameter to the value you obtained from a previous List Parts
     * request. You can also limit the number of parts returned in the response by specifying the <code>limit</code>
     * parameter in the request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
     * Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html">List Parts</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param listPartsRequest
     *        Provides options for retrieving a list of parts of an archive that have been uploaded in a specific
     *        multipart upload.
     * @return A Java Future containing the result of the ListParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListParts
     */
    default CompletableFuture<ListPartsResponse> listParts(ListPartsRequest listPartsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists the parts of an archive that have been uploaded in a specific multipart upload. You can make
     * this request at any time during an in-progress multipart upload before you complete the upload (see
     * <a>CompleteMultipartUpload</a>. List Parts returns an error for completed uploads. The list returned in the List
     * Parts response is sorted by part range.
     * </p>
     * <p>
     * The List Parts operation supports pagination. By default, this operation returns up to 50 uploaded parts in the
     * response. You should always check the response for a <code>marker</code> at which to continue the list; if there
     * are no more items the <code>marker</code> is <code>null</code>. To return a list of parts that begins at a
     * specific part, set the <code>marker</code> request parameter to the value you obtained from a previous List Parts
     * request. You can also limit the number of parts returned in the response by specifying the <code>limit</code>
     * parameter in the request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
     * Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html">List Parts</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPartsRequest#builder()}
     * </p>
     *
     * @param listPartsRequest
     *        A {@link Consumer} that will call methods on {@link ListPartsInput.Builder} to create a request. Provides
     *        options for retrieving a list of parts of an archive that have been uploaded in a specific multipart
     *        upload.
     * @return A Java Future containing the result of the ListParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListParts
     */
    default CompletableFuture<ListPartsResponse> listParts(Consumer<ListPartsRequest.Builder> listPartsRequest) {
        return listParts(ListPartsRequest.builder().applyMutation(listPartsRequest).build());
    }

    /**
     * <p>
     * This operation lists the parts of an archive that have been uploaded in a specific multipart upload. You can make
     * this request at any time during an in-progress multipart upload before you complete the upload (see
     * <a>CompleteMultipartUpload</a>. List Parts returns an error for completed uploads. The list returned in the List
     * Parts response is sorted by part range.
     * </p>
     * <p>
     * The List Parts operation supports pagination. By default, this operation returns up to 50 uploaded parts in the
     * response. You should always check the response for a <code>marker</code> at which to continue the list; if there
     * are no more items the <code>marker</code> is <code>null</code>. To return a list of parts that begins at a
     * specific part, set the <code>marker</code> request parameter to the value you obtained from a previous List Parts
     * request. You can also limit the number of parts returned in the response by specifying the <code>limit</code>
     * parameter in the request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
     * Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html">List Parts</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listParts(software.amazon.awssdk.services.glacier.model.ListPartsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListPartsPublisher publisher = client.listPartsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListPartsPublisher publisher = client.listPartsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glacier.model.ListPartsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glacier.model.ListPartsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParts(software.amazon.awssdk.services.glacier.model.ListPartsRequest)} operation.</b>
     * </p>
     *
     * @param listPartsRequest
     *        Provides options for retrieving a list of parts of an archive that have been uploaded in a specific
     *        multipart upload.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListParts
     */
    default ListPartsPublisher listPartsPaginator(ListPartsRequest listPartsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists the parts of an archive that have been uploaded in a specific multipart upload. You can make
     * this request at any time during an in-progress multipart upload before you complete the upload (see
     * <a>CompleteMultipartUpload</a>. List Parts returns an error for completed uploads. The list returned in the List
     * Parts response is sorted by part range.
     * </p>
     * <p>
     * The List Parts operation supports pagination. By default, this operation returns up to 50 uploaded parts in the
     * response. You should always check the response for a <code>marker</code> at which to continue the list; if there
     * are no more items the <code>marker</code> is <code>null</code>. To return a list of parts that begins at a
     * specific part, set the <code>marker</code> request parameter to the value you obtained from a previous List Parts
     * request. You can also limit the number of parts returned in the response by specifying the <code>limit</code>
     * parameter in the request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and the underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
     * Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html">List Parts</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listParts(software.amazon.awssdk.services.glacier.model.ListPartsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListPartsPublisher publisher = client.listPartsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListPartsPublisher publisher = client.listPartsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glacier.model.ListPartsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glacier.model.ListPartsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParts(software.amazon.awssdk.services.glacier.model.ListPartsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPartsRequest#builder()}
     * </p>
     *
     * @param listPartsRequest
     *        A {@link Consumer} that will call methods on {@link ListPartsInput.Builder} to create a request. Provides
     *        options for retrieving a list of parts of an archive that have been uploaded in a specific multipart
     *        upload.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListParts
     */
    default ListPartsPublisher listPartsPaginator(Consumer<ListPartsRequest.Builder> listPartsRequest) {
        return listPartsPaginator(ListPartsRequest.builder().applyMutation(listPartsRequest).build());
    }

    /**
     * <p>
     * This operation lists the provisioned capacity units for the specified AWS account.
     * </p>
     *
     * @param listProvisionedCapacityRequest
     * @return A Java Future containing the result of the ListProvisionedCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListProvisionedCapacity
     */
    default CompletableFuture<ListProvisionedCapacityResponse> listProvisionedCapacity(
            ListProvisionedCapacityRequest listProvisionedCapacityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists the provisioned capacity units for the specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisionedCapacityRequest.Builder} avoiding
     * the need to create one manually via {@link ListProvisionedCapacityRequest#builder()}
     * </p>
     *
     * @param listProvisionedCapacityRequest
     *        A {@link Consumer} that will call methods on {@link ListProvisionedCapacityInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProvisionedCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListProvisionedCapacity
     */
    default CompletableFuture<ListProvisionedCapacityResponse> listProvisionedCapacity(
            Consumer<ListProvisionedCapacityRequest.Builder> listProvisionedCapacityRequest) {
        return listProvisionedCapacity(ListProvisionedCapacityRequest.builder().applyMutation(listProvisionedCapacityRequest)
                .build());
    }

    /**
     * <p>
     * This operation lists the provisioned capacity units for the specified AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListProvisionedCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListProvisionedCapacity
     */
    default CompletableFuture<ListProvisionedCapacityResponse> listProvisionedCapacity() {
        return listProvisionedCapacity(ListProvisionedCapacityRequest.builder().build());
    }

    /**
     * <p>
     * This operation lists all the tags attached to a vault. The operation returns an empty map if there are no tags.
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html">Tagging Amazon S3 Glacier Resources</a>.
     * </p>
     *
     * @param listTagsForVaultRequest
     *        The input value for <code>ListTagsForVaultInput</code>.
     * @return A Java Future containing the result of the ListTagsForVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListTagsForVault
     */
    default CompletableFuture<ListTagsForVaultResponse> listTagsForVault(ListTagsForVaultRequest listTagsForVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists all the tags attached to a vault. The operation returns an empty map if there are no tags.
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html">Tagging Amazon S3 Glacier Resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForVaultRequest.Builder} avoiding the need
     * to create one manually via {@link ListTagsForVaultRequest#builder()}
     * </p>
     *
     * @param listTagsForVaultRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForVaultInput.Builder} to create a request.
     *        The input value for <code>ListTagsForVaultInput</code>.
     * @return A Java Future containing the result of the ListTagsForVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListTagsForVault
     */
    default CompletableFuture<ListTagsForVaultResponse> listTagsForVault(
            Consumer<ListTagsForVaultRequest.Builder> listTagsForVaultRequest) {
        return listTagsForVault(ListTagsForVaultRequest.builder().applyMutation(listTagsForVaultRequest).build());
    }

    /**
     * <p>
     * This operation lists all vaults owned by the calling user's account. The list returned in the response is
     * ASCII-sorted by vault name.
     * </p>
     * <p>
     * By default, this operation returns up to 10 items. If there are more vaults to list, the response
     * <code>marker</code> field contains the vault Amazon Resource Name (ARN) at which to continue the list with a new
     * List Vaults request; otherwise, the <code>marker</code> field is <code>null</code>. To return a list of vaults
     * that begins at a specific vault, set the <code>marker</code> request parameter to the vault ARN you obtained from
     * a previous List Vaults request. You can also limit the number of vaults returned in the response by specifying
     * the <code>limit</code> parameter in the request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html">Retrieving Vault Metadata
     * in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html">List Vaults </a> in the <i>Amazon
     * Glacier Developer Guide</i>.
     * </p>
     *
     * @param listVaultsRequest
     *        Provides options to retrieve the vault list owned by the calling user's account. The list provides
     *        metadata information for each vault.
     * @return A Java Future containing the result of the ListVaults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListVaults
     */
    default CompletableFuture<ListVaultsResponse> listVaults(ListVaultsRequest listVaultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists all vaults owned by the calling user's account. The list returned in the response is
     * ASCII-sorted by vault name.
     * </p>
     * <p>
     * By default, this operation returns up to 10 items. If there are more vaults to list, the response
     * <code>marker</code> field contains the vault Amazon Resource Name (ARN) at which to continue the list with a new
     * List Vaults request; otherwise, the <code>marker</code> field is <code>null</code>. To return a list of vaults
     * that begins at a specific vault, set the <code>marker</code> request parameter to the vault ARN you obtained from
     * a previous List Vaults request. You can also limit the number of vaults returned in the response by specifying
     * the <code>limit</code> parameter in the request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html">Retrieving Vault Metadata
     * in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html">List Vaults </a> in the <i>Amazon
     * Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVaultsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVaultsRequest#builder()}
     * </p>
     *
     * @param listVaultsRequest
     *        A {@link Consumer} that will call methods on {@link ListVaultsInput.Builder} to create a request. Provides
     *        options to retrieve the vault list owned by the calling user's account. The list provides metadata
     *        information for each vault.
     * @return A Java Future containing the result of the ListVaults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListVaults
     */
    default CompletableFuture<ListVaultsResponse> listVaults(Consumer<ListVaultsRequest.Builder> listVaultsRequest) {
        return listVaults(ListVaultsRequest.builder().applyMutation(listVaultsRequest).build());
    }

    /**
     * <p>
     * This operation lists all vaults owned by the calling user's account. The list returned in the response is
     * ASCII-sorted by vault name.
     * </p>
     * <p>
     * By default, this operation returns up to 10 items. If there are more vaults to list, the response
     * <code>marker</code> field contains the vault Amazon Resource Name (ARN) at which to continue the list with a new
     * List Vaults request; otherwise, the <code>marker</code> field is <code>null</code>. To return a list of vaults
     * that begins at a specific vault, set the <code>marker</code> request parameter to the vault ARN you obtained from
     * a previous List Vaults request. You can also limit the number of vaults returned in the response by specifying
     * the <code>limit</code> parameter in the request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html">Retrieving Vault Metadata
     * in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html">List Vaults </a> in the <i>Amazon
     * Glacier Developer Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the ListVaults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListVaults
     */
    default CompletableFuture<ListVaultsResponse> listVaults() {
        return listVaults(ListVaultsRequest.builder().build());
    }

    /**
     * <p>
     * This operation lists all vaults owned by the calling user's account. The list returned in the response is
     * ASCII-sorted by vault name.
     * </p>
     * <p>
     * By default, this operation returns up to 10 items. If there are more vaults to list, the response
     * <code>marker</code> field contains the vault Amazon Resource Name (ARN) at which to continue the list with a new
     * List Vaults request; otherwise, the <code>marker</code> field is <code>null</code>. To return a list of vaults
     * that begins at a specific vault, set the <code>marker</code> request parameter to the vault ARN you obtained from
     * a previous List Vaults request. You can also limit the number of vaults returned in the response by specifying
     * the <code>limit</code> parameter in the request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html">Retrieving Vault Metadata
     * in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html">List Vaults </a> in the <i>Amazon
     * Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listVaults(software.amazon.awssdk.services.glacier.model.ListVaultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListVaultsPublisher publisher = client.listVaultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListVaultsPublisher publisher = client.listVaultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glacier.model.ListVaultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glacier.model.ListVaultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVaults(software.amazon.awssdk.services.glacier.model.ListVaultsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListVaults
     */
    default ListVaultsPublisher listVaultsPaginator() {
        return listVaultsPaginator(ListVaultsRequest.builder().build());
    }

    /**
     * <p>
     * This operation lists all vaults owned by the calling user's account. The list returned in the response is
     * ASCII-sorted by vault name.
     * </p>
     * <p>
     * By default, this operation returns up to 10 items. If there are more vaults to list, the response
     * <code>marker</code> field contains the vault Amazon Resource Name (ARN) at which to continue the list with a new
     * List Vaults request; otherwise, the <code>marker</code> field is <code>null</code>. To return a list of vaults
     * that begins at a specific vault, set the <code>marker</code> request parameter to the vault ARN you obtained from
     * a previous List Vaults request. You can also limit the number of vaults returned in the response by specifying
     * the <code>limit</code> parameter in the request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html">Retrieving Vault Metadata
     * in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html">List Vaults </a> in the <i>Amazon
     * Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listVaults(software.amazon.awssdk.services.glacier.model.ListVaultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListVaultsPublisher publisher = client.listVaultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListVaultsPublisher publisher = client.listVaultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glacier.model.ListVaultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glacier.model.ListVaultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVaults(software.amazon.awssdk.services.glacier.model.ListVaultsRequest)} operation.</b>
     * </p>
     *
     * @param listVaultsRequest
     *        Provides options to retrieve the vault list owned by the calling user's account. The list provides
     *        metadata information for each vault.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListVaults
     */
    default ListVaultsPublisher listVaultsPaginator(ListVaultsRequest listVaultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists all vaults owned by the calling user's account. The list returned in the response is
     * ASCII-sorted by vault name.
     * </p>
     * <p>
     * By default, this operation returns up to 10 items. If there are more vaults to list, the response
     * <code>marker</code> field contains the vault Amazon Resource Name (ARN) at which to continue the list with a new
     * List Vaults request; otherwise, the <code>marker</code> field is <code>null</code>. To return a list of vaults
     * that begins at a specific vault, set the <code>marker</code> request parameter to the vault ARN you obtained from
     * a previous List Vaults request. You can also limit the number of vaults returned in the response by specifying
     * the <code>limit</code> parameter in the request.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html">Retrieving Vault Metadata
     * in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html">List Vaults </a> in the <i>Amazon
     * Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listVaults(software.amazon.awssdk.services.glacier.model.ListVaultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListVaultsPublisher publisher = client.listVaultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glacier.paginators.ListVaultsPublisher publisher = client.listVaultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glacier.model.ListVaultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glacier.model.ListVaultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVaults(software.amazon.awssdk.services.glacier.model.ListVaultsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVaultsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVaultsRequest#builder()}
     * </p>
     *
     * @param listVaultsRequest
     *        A {@link Consumer} that will call methods on {@link ListVaultsInput.Builder} to create a request. Provides
     *        options to retrieve the vault list owned by the calling user's account. The list provides metadata
     *        information for each vault.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.ListVaults
     */
    default ListVaultsPublisher listVaultsPaginator(Consumer<ListVaultsRequest.Builder> listVaultsRequest) {
        return listVaultsPaginator(ListVaultsRequest.builder().applyMutation(listVaultsRequest).build());
    }

    /**
     * <p>
     * This operation purchases a provisioned capacity unit for an AWS account.
     * </p>
     *
     * @param purchaseProvisionedCapacityRequest
     * @return A Java Future containing the result of the PurchaseProvisionedCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>LimitExceededException Returned if the request results in a vault or account limit being exceeded.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.PurchaseProvisionedCapacity
     */
    default CompletableFuture<PurchaseProvisionedCapacityResponse> purchaseProvisionedCapacity(
            PurchaseProvisionedCapacityRequest purchaseProvisionedCapacityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation purchases a provisioned capacity unit for an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseProvisionedCapacityRequest.Builder}
     * avoiding the need to create one manually via {@link PurchaseProvisionedCapacityRequest#builder()}
     * </p>
     *
     * @param purchaseProvisionedCapacityRequest
     *        A {@link Consumer} that will call methods on {@link PurchaseProvisionedCapacityInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PurchaseProvisionedCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>LimitExceededException Returned if the request results in a vault or account limit being exceeded.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.PurchaseProvisionedCapacity
     */
    default CompletableFuture<PurchaseProvisionedCapacityResponse> purchaseProvisionedCapacity(
            Consumer<PurchaseProvisionedCapacityRequest.Builder> purchaseProvisionedCapacityRequest) {
        return purchaseProvisionedCapacity(PurchaseProvisionedCapacityRequest.builder()
                .applyMutation(purchaseProvisionedCapacityRequest).build());
    }

    /**
     * <p>
     * This operation purchases a provisioned capacity unit for an AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the PurchaseProvisionedCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>LimitExceededException Returned if the request results in a vault or account limit being exceeded.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.PurchaseProvisionedCapacity
     */
    default CompletableFuture<PurchaseProvisionedCapacityResponse> purchaseProvisionedCapacity() {
        return purchaseProvisionedCapacity(PurchaseProvisionedCapacityRequest.builder().build());
    }

    /**
     * <p>
     * This operation removes one or more tags from the set of tags attached to a vault. For more information about
     * tags, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html">Tagging Amazon S3 Glacier
     * Resources</a>. This operation is idempotent. The operation will be successful, even if there are no tags attached
     * to the vault.
     * </p>
     *
     * @param removeTagsFromVaultRequest
     *        The input value for <code>RemoveTagsFromVaultInput</code>.
     * @return A Java Future containing the result of the RemoveTagsFromVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.RemoveTagsFromVault
     */
    default CompletableFuture<RemoveTagsFromVaultResponse> removeTagsFromVault(
            RemoveTagsFromVaultRequest removeTagsFromVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation removes one or more tags from the set of tags attached to a vault. For more information about
     * tags, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html">Tagging Amazon S3 Glacier
     * Resources</a>. This operation is idempotent. The operation will be successful, even if there are no tags attached
     * to the vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromVaultRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromVaultRequest#builder()}
     * </p>
     *
     * @param removeTagsFromVaultRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsFromVaultInput.Builder} to create a request.
     *        The input value for <code>RemoveTagsFromVaultInput</code>.
     * @return A Java Future containing the result of the RemoveTagsFromVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.RemoveTagsFromVault
     */
    default CompletableFuture<RemoveTagsFromVaultResponse> removeTagsFromVault(
            Consumer<RemoveTagsFromVaultRequest.Builder> removeTagsFromVaultRequest) {
        return removeTagsFromVault(RemoveTagsFromVaultRequest.builder().applyMutation(removeTagsFromVaultRequest).build());
    }

    /**
     * <p>
     * This operation sets and then enacts a data retrieval policy in the region specified in the PUT request. You can
     * set one policy per region for an AWS account. The policy is enacted within a few minutes of a successful PUT
     * operation.
     * </p>
     * <p>
     * The set policy operation does not affect retrieval jobs that were in progress before the policy was enacted. For
     * more information about data retrieval policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html">Amazon Glacier Data
     * Retrieval Policies</a>.
     * </p>
     *
     * @param setDataRetrievalPolicyRequest
     *        SetDataRetrievalPolicy input.
     * @return A Java Future containing the result of the SetDataRetrievalPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.SetDataRetrievalPolicy
     */
    default CompletableFuture<SetDataRetrievalPolicyResponse> setDataRetrievalPolicy(
            SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation sets and then enacts a data retrieval policy in the region specified in the PUT request. You can
     * set one policy per region for an AWS account. The policy is enacted within a few minutes of a successful PUT
     * operation.
     * </p>
     * <p>
     * The set policy operation does not affect retrieval jobs that were in progress before the policy was enacted. For
     * more information about data retrieval policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html">Amazon Glacier Data
     * Retrieval Policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetDataRetrievalPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link SetDataRetrievalPolicyRequest#builder()}
     * </p>
     *
     * @param setDataRetrievalPolicyRequest
     *        A {@link Consumer} that will call methods on {@link SetDataRetrievalPolicyInput.Builder} to create a
     *        request. SetDataRetrievalPolicy input.
     * @return A Java Future containing the result of the SetDataRetrievalPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.SetDataRetrievalPolicy
     */
    default CompletableFuture<SetDataRetrievalPolicyResponse> setDataRetrievalPolicy(
            Consumer<SetDataRetrievalPolicyRequest.Builder> setDataRetrievalPolicyRequest) {
        return setDataRetrievalPolicy(SetDataRetrievalPolicyRequest.builder().applyMutation(setDataRetrievalPolicyRequest)
                .build());
    }

    /**
     * <p>
     * This operation configures an access policy for a vault and will overwrite an existing policy. To configure a
     * vault access policy, send a PUT request to the <code>access-policy</code> subresource of the vault. An access
     * policy is specific to a vault and is also called a vault subresource. You can set one access policy per vault and
     * the policy can be up to 20 KB in size. For more information about vault access policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html">Amazon Glacier Access
     * Control with Vault Access Policies</a>.
     * </p>
     *
     * @param setVaultAccessPolicyRequest
     *        SetVaultAccessPolicy input.
     * @return A Java Future containing the result of the SetVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.SetVaultAccessPolicy
     */
    default CompletableFuture<SetVaultAccessPolicyResponse> setVaultAccessPolicy(
            SetVaultAccessPolicyRequest setVaultAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation configures an access policy for a vault and will overwrite an existing policy. To configure a
     * vault access policy, send a PUT request to the <code>access-policy</code> subresource of the vault. An access
     * policy is specific to a vault and is also called a vault subresource. You can set one access policy per vault and
     * the policy can be up to 20 KB in size. For more information about vault access policies, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html">Amazon Glacier Access
     * Control with Vault Access Policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetVaultAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link SetVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param setVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on {@link SetVaultAccessPolicyInput.Builder} to create a
     *        request. SetVaultAccessPolicy input.
     * @return A Java Future containing the result of the SetVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.SetVaultAccessPolicy
     */
    default CompletableFuture<SetVaultAccessPolicyResponse> setVaultAccessPolicy(
            Consumer<SetVaultAccessPolicyRequest.Builder> setVaultAccessPolicyRequest) {
        return setVaultAccessPolicy(SetVaultAccessPolicyRequest.builder().applyMutation(setVaultAccessPolicyRequest).build());
    }

    /**
     * <p>
     * This operation configures notifications that will be sent when specific events happen to a vault. By default, you
     * don't get any notifications.
     * </p>
     * <p>
     * To configure vault notifications, send a PUT request to the <code>notification-configuration</code> subresource
     * of the vault. The request should include a JSON document that provides an Amazon SNS topic and specific events
     * for which you want Amazon S3 Glacier to send notifications to the topic.
     * </p>
     * <p>
     * Amazon SNS topics must grant permission to the vault to be allowed to publish notifications to the topic. You can
     * configure a vault to publish a notification for the following vault events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ArchiveRetrievalCompleted</b> This event occurs when a job that was initiated for an archive retrieval is
     * completed (<a>InitiateJob</a>). The status of the completed job can be "Succeeded" or "Failed". The notification
     * sent to the SNS topic is the same output as returned from <a>DescribeJob</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>InventoryRetrievalCompleted</b> This event occurs when a job that was initiated for an inventory retrieval is
     * completed (<a>InitiateJob</a>). The status of the completed job can be "Succeeded" or "Failed". The notification
     * sent to the SNS topic is the same output as returned from <a>DescribeJob</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault
     * Notifications in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-put.html">Set Vault
     * Notification Configuration </a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param setVaultNotificationsRequest
     *        Provides options to configure notifications that will be sent when specific events happen to a vault.
     * @return A Java Future containing the result of the SetVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.SetVaultNotifications
     */
    default CompletableFuture<SetVaultNotificationsResponse> setVaultNotifications(
            SetVaultNotificationsRequest setVaultNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation configures notifications that will be sent when specific events happen to a vault. By default, you
     * don't get any notifications.
     * </p>
     * <p>
     * To configure vault notifications, send a PUT request to the <code>notification-configuration</code> subresource
     * of the vault. The request should include a JSON document that provides an Amazon SNS topic and specific events
     * for which you want Amazon S3 Glacier to send notifications to the topic.
     * </p>
     * <p>
     * Amazon SNS topics must grant permission to the vault to be allowed to publish notifications to the topic. You can
     * configure a vault to publish a notification for the following vault events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ArchiveRetrievalCompleted</b> This event occurs when a job that was initiated for an archive retrieval is
     * completed (<a>InitiateJob</a>). The status of the completed job can be "Succeeded" or "Failed". The notification
     * sent to the SNS topic is the same output as returned from <a>DescribeJob</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>InventoryRetrievalCompleted</b> This event occurs when a job that was initiated for an inventory retrieval is
     * completed (<a>InitiateJob</a>). The status of the completed job can be "Succeeded" or "Failed". The notification
     * sent to the SNS topic is the same output as returned from <a>DescribeJob</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault
     * Notifications in Amazon S3 Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-put.html">Set Vault
     * Notification Configuration </a> in the <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetVaultNotificationsRequest.Builder} avoiding the
     * need to create one manually via {@link SetVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param setVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on {@link SetVaultNotificationsInput.Builder} to create a
     *        request. Provides options to configure notifications that will be sent when specific events happen to a
     *        vault.
     * @return A Java Future containing the result of the SetVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.SetVaultNotifications
     */
    default CompletableFuture<SetVaultNotificationsResponse> setVaultNotifications(
            Consumer<SetVaultNotificationsRequest.Builder> setVaultNotificationsRequest) {
        return setVaultNotifications(SetVaultNotificationsRequest.builder().applyMutation(setVaultNotificationsRequest).build());
    }

    /**
     * <p>
     * This operation adds an archive to a vault. This is a synchronous operation, and for a successful upload, your
     * data is durably persisted. Amazon S3 Glacier returns the archive ID in the <code>x-amz-archive-id</code> header
     * of the response.
     * </p>
     * <p>
     * You must use the archive ID to access your data in Amazon S3 Glacier. After you upload an archive, you should
     * save the archive ID returned so that you can retrieve or delete the archive later. Besides saving the archive ID,
     * you can also index it and give it a friendly name to allow for better searching. You can also use the optional
     * archive description field to specify how the archive is referred to in an external index of archives, such as you
     * might create in Amazon DynamoDB. You can also get the vault inventory to obtain a list of archive IDs in a vault.
     * For more information, see <a>InitiateJob</a>.
     * </p>
     * <p>
     * You must provide a SHA256 tree hash of the data you are uploading. For information about computing a SHA256 tree
     * hash, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing
     * Checksums</a>.
     * </p>
     * <p>
     * You can optionally specify an archive description of up to 1,024 printable ASCII characters. You can get the
     * archive description when you either retrieve the archive or get the vault inventory. For more information, see
     * <a>InitiateJob</a>. Amazon Glacier does not interpret the description in any way. An archive description does not
     * need to be unique. You cannot use the description to retrieve or sort the archive list.
     * </p>
     * <p>
     * Archives are immutable. After you upload an archive, you cannot edit the archive or its description.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-an-archive.html">Uploading an Archive in
     * Amazon Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html">Upload Archive</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param uploadArchiveRequest
     *        Provides options to add an archive to a vault.
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows '
     *        <p>
     *        The data to upload.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>RequestTimeoutException Returned if, when uploading an archive, Amazon S3 Glacier times out while
     *         receiving the upload.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.UploadArchive
     */
    default CompletableFuture<UploadArchiveResponse> uploadArchive(UploadArchiveRequest uploadArchiveRequest,
            AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation adds an archive to a vault. This is a synchronous operation, and for a successful upload, your
     * data is durably persisted. Amazon S3 Glacier returns the archive ID in the <code>x-amz-archive-id</code> header
     * of the response.
     * </p>
     * <p>
     * You must use the archive ID to access your data in Amazon S3 Glacier. After you upload an archive, you should
     * save the archive ID returned so that you can retrieve or delete the archive later. Besides saving the archive ID,
     * you can also index it and give it a friendly name to allow for better searching. You can also use the optional
     * archive description field to specify how the archive is referred to in an external index of archives, such as you
     * might create in Amazon DynamoDB. You can also get the vault inventory to obtain a list of archive IDs in a vault.
     * For more information, see <a>InitiateJob</a>.
     * </p>
     * <p>
     * You must provide a SHA256 tree hash of the data you are uploading. For information about computing a SHA256 tree
     * hash, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing
     * Checksums</a>.
     * </p>
     * <p>
     * You can optionally specify an archive description of up to 1,024 printable ASCII characters. You can get the
     * archive description when you either retrieve the archive or get the vault inventory. For more information, see
     * <a>InitiateJob</a>. Amazon Glacier does not interpret the description in any way. An archive description does not
     * need to be unique. You cannot use the description to retrieve or sort the archive list.
     * </p>
     * <p>
     * Archives are immutable. After you upload an archive, you cannot edit the archive or its description.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-an-archive.html">Uploading an Archive in
     * Amazon Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html">Upload Archive</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link UploadArchiveRequest#builder()}
     * </p>
     *
     * @param uploadArchiveRequest
     *        A {@link Consumer} that will call methods on {@link UploadArchiveInput.Builder} to create a request.
     *        Provides options to add an archive to a vault.
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows '
     *        <p>
     *        The data to upload.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>RequestTimeoutException Returned if, when uploading an archive, Amazon S3 Glacier times out while
     *         receiving the upload.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.UploadArchive
     */
    default CompletableFuture<UploadArchiveResponse> uploadArchive(Consumer<UploadArchiveRequest.Builder> uploadArchiveRequest,
            AsyncRequestBody requestBody) {
        return uploadArchive(UploadArchiveRequest.builder().applyMutation(uploadArchiveRequest).build(), requestBody);
    }

    /**
     * <p>
     * This operation adds an archive to a vault. This is a synchronous operation, and for a successful upload, your
     * data is durably persisted. Amazon S3 Glacier returns the archive ID in the <code>x-amz-archive-id</code> header
     * of the response.
     * </p>
     * <p>
     * You must use the archive ID to access your data in Amazon S3 Glacier. After you upload an archive, you should
     * save the archive ID returned so that you can retrieve or delete the archive later. Besides saving the archive ID,
     * you can also index it and give it a friendly name to allow for better searching. You can also use the optional
     * archive description field to specify how the archive is referred to in an external index of archives, such as you
     * might create in Amazon DynamoDB. You can also get the vault inventory to obtain a list of archive IDs in a vault.
     * For more information, see <a>InitiateJob</a>.
     * </p>
     * <p>
     * You must provide a SHA256 tree hash of the data you are uploading. For information about computing a SHA256 tree
     * hash, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing
     * Checksums</a>.
     * </p>
     * <p>
     * You can optionally specify an archive description of up to 1,024 printable ASCII characters. You can get the
     * archive description when you either retrieve the archive or get the vault inventory. For more information, see
     * <a>InitiateJob</a>. Amazon Glacier does not interpret the description in any way. An archive description does not
     * need to be unique. You cannot use the description to retrieve or sort the archive list.
     * </p>
     * <p>
     * Archives are immutable. After you upload an archive, you cannot edit the archive or its description.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-an-archive.html">Uploading an Archive in
     * Amazon Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html">Upload Archive</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param uploadArchiveRequest
     *        Provides options to add an archive to a vault.
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows '
     *        <p>
     *        The data to upload.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>RequestTimeoutException Returned if, when uploading an archive, Amazon S3 Glacier times out while
     *         receiving the upload.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.UploadArchive
     */
    default CompletableFuture<UploadArchiveResponse> uploadArchive(UploadArchiveRequest uploadArchiveRequest, Path sourcePath) {
        return uploadArchive(uploadArchiveRequest, AsyncRequestBody.fromFile(sourcePath));
    }

    /**
     * <p>
     * This operation adds an archive to a vault. This is a synchronous operation, and for a successful upload, your
     * data is durably persisted. Amazon S3 Glacier returns the archive ID in the <code>x-amz-archive-id</code> header
     * of the response.
     * </p>
     * <p>
     * You must use the archive ID to access your data in Amazon S3 Glacier. After you upload an archive, you should
     * save the archive ID returned so that you can retrieve or delete the archive later. Besides saving the archive ID,
     * you can also index it and give it a friendly name to allow for better searching. You can also use the optional
     * archive description field to specify how the archive is referred to in an external index of archives, such as you
     * might create in Amazon DynamoDB. You can also get the vault inventory to obtain a list of archive IDs in a vault.
     * For more information, see <a>InitiateJob</a>.
     * </p>
     * <p>
     * You must provide a SHA256 tree hash of the data you are uploading. For information about computing a SHA256 tree
     * hash, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing
     * Checksums</a>.
     * </p>
     * <p>
     * You can optionally specify an archive description of up to 1,024 printable ASCII characters. You can get the
     * archive description when you either retrieve the archive or get the vault inventory. For more information, see
     * <a>InitiateJob</a>. Amazon Glacier does not interpret the description in any way. An archive description does not
     * need to be unique. You cannot use the description to retrieve or sort the archive list.
     * </p>
     * <p>
     * Archives are immutable. After you upload an archive, you cannot edit the archive or its description.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-an-archive.html">Uploading an Archive in
     * Amazon Glacier</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html">Upload Archive</a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link UploadArchiveRequest#builder()}
     * </p>
     *
     * @param uploadArchiveRequest
     *        A {@link Consumer} that will call methods on {@link UploadArchiveInput.Builder} to create a request.
     *        Provides options to add an archive to a vault.
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows '
     *        <p>
     *        The data to upload.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>RequestTimeoutException Returned if, when uploading an archive, Amazon S3 Glacier times out while
     *         receiving the upload.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.UploadArchive
     */
    default CompletableFuture<UploadArchiveResponse> uploadArchive(Consumer<UploadArchiveRequest.Builder> uploadArchiveRequest,
            Path sourcePath) {
        return uploadArchive(UploadArchiveRequest.builder().applyMutation(uploadArchiveRequest).build(), sourcePath);
    }

    /**
     * <p>
     * This operation uploads a part of an archive. You can upload archive parts in any order. You can also upload them
     * in parallel. You can upload up to 10,000 parts for a multipart upload.
     * </p>
     * <p>
     * Amazon Glacier rejects your upload part request if any of the following conditions is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SHA256 tree hash does not match</b>To ensure that part data is not corrupted in transmission, you compute a
     * SHA256 tree hash of the part and include it in your request. Upon receiving the part data, Amazon S3 Glacier also
     * computes a SHA256 tree hash. If these hash values don't match, the operation fails. For information about
     * computing a SHA256 tree hash, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing Checksums</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Part size does not match</b>The size of each part except the last must match the size specified in the
     * corresponding <a>InitiateMultipartUpload</a> request. The size of the last part must be the same size as, or
     * smaller than, the specified size.
     * </p>
     * <note>
     * <p>
     * If you upload a part whose size is smaller than the part size you specified in your initiate multipart upload
     * request and that part is not the last part, then the upload part request will succeed. However, the subsequent
     * Complete Multipart Upload request will fail.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b>Range does not align</b>The byte range value in the request does not align with the part size specified in the
     * corresponding initiate request. For example, if you specify a part size of 4194304 bytes (4 MB), then 0 to
     * 4194303 bytes (4 MB - 1) and 4194304 (4 MB) to 8388607 (8 MB - 1) are valid part ranges. However, if you set a
     * range value of 2 MB to 6 MB, the range does not align with the part size and the upload will fail.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent. If you upload the same part multiple times, the data included in the most recent
     * request overwrites the previously uploaded data.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html">Uploading Large Archives
     * in Parts (Multipart Upload)</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-upload-part.html">Upload Part </a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param uploadMultipartPartRequest
     *        Provides options to upload a part of an archive in a multipart upload operation.
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows '
     *        <p>
     *        The data to upload.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadMultipartPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>RequestTimeoutException Returned if, when uploading an archive, Amazon S3 Glacier times out while
     *         receiving the upload.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.UploadMultipartPart
     */
    default CompletableFuture<UploadMultipartPartResponse> uploadMultipartPart(
            UploadMultipartPartRequest uploadMultipartPartRequest, AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation uploads a part of an archive. You can upload archive parts in any order. You can also upload them
     * in parallel. You can upload up to 10,000 parts for a multipart upload.
     * </p>
     * <p>
     * Amazon Glacier rejects your upload part request if any of the following conditions is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SHA256 tree hash does not match</b>To ensure that part data is not corrupted in transmission, you compute a
     * SHA256 tree hash of the part and include it in your request. Upon receiving the part data, Amazon S3 Glacier also
     * computes a SHA256 tree hash. If these hash values don't match, the operation fails. For information about
     * computing a SHA256 tree hash, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing Checksums</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Part size does not match</b>The size of each part except the last must match the size specified in the
     * corresponding <a>InitiateMultipartUpload</a> request. The size of the last part must be the same size as, or
     * smaller than, the specified size.
     * </p>
     * <note>
     * <p>
     * If you upload a part whose size is smaller than the part size you specified in your initiate multipart upload
     * request and that part is not the last part, then the upload part request will succeed. However, the subsequent
     * Complete Multipart Upload request will fail.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b>Range does not align</b>The byte range value in the request does not align with the part size specified in the
     * corresponding initiate request. For example, if you specify a part size of 4194304 bytes (4 MB), then 0 to
     * 4194303 bytes (4 MB - 1) and 4194304 (4 MB) to 8388607 (8 MB - 1) are valid part ranges. However, if you set a
     * range value of 2 MB to 6 MB, the range does not align with the part size and the upload will fail.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent. If you upload the same part multiple times, the data included in the most recent
     * request overwrites the previously uploaded data.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html">Uploading Large Archives
     * in Parts (Multipart Upload)</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-upload-part.html">Upload Part </a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadMultipartPartRequest.Builder} avoiding the
     * need to create one manually via {@link UploadMultipartPartRequest#builder()}
     * </p>
     *
     * @param uploadMultipartPartRequest
     *        A {@link Consumer} that will call methods on {@link UploadMultipartPartInput.Builder} to create a request.
     *        Provides options to upload a part of an archive in a multipart upload operation.
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows '
     *        <p>
     *        The data to upload.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadMultipartPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>RequestTimeoutException Returned if, when uploading an archive, Amazon S3 Glacier times out while
     *         receiving the upload.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.UploadMultipartPart
     */
    default CompletableFuture<UploadMultipartPartResponse> uploadMultipartPart(
            Consumer<UploadMultipartPartRequest.Builder> uploadMultipartPartRequest, AsyncRequestBody requestBody) {
        return uploadMultipartPart(UploadMultipartPartRequest.builder().applyMutation(uploadMultipartPartRequest).build(),
                requestBody);
    }

    /**
     * <p>
     * This operation uploads a part of an archive. You can upload archive parts in any order. You can also upload them
     * in parallel. You can upload up to 10,000 parts for a multipart upload.
     * </p>
     * <p>
     * Amazon Glacier rejects your upload part request if any of the following conditions is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SHA256 tree hash does not match</b>To ensure that part data is not corrupted in transmission, you compute a
     * SHA256 tree hash of the part and include it in your request. Upon receiving the part data, Amazon S3 Glacier also
     * computes a SHA256 tree hash. If these hash values don't match, the operation fails. For information about
     * computing a SHA256 tree hash, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing Checksums</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Part size does not match</b>The size of each part except the last must match the size specified in the
     * corresponding <a>InitiateMultipartUpload</a> request. The size of the last part must be the same size as, or
     * smaller than, the specified size.
     * </p>
     * <note>
     * <p>
     * If you upload a part whose size is smaller than the part size you specified in your initiate multipart upload
     * request and that part is not the last part, then the upload part request will succeed. However, the subsequent
     * Complete Multipart Upload request will fail.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b>Range does not align</b>The byte range value in the request does not align with the part size specified in the
     * corresponding initiate request. For example, if you specify a part size of 4194304 bytes (4 MB), then 0 to
     * 4194303 bytes (4 MB - 1) and 4194304 (4 MB) to 8388607 (8 MB - 1) are valid part ranges. However, if you set a
     * range value of 2 MB to 6 MB, the range does not align with the part size and the upload will fail.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent. If you upload the same part multiple times, the data included in the most recent
     * request overwrites the previously uploaded data.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html">Uploading Large Archives
     * in Parts (Multipart Upload)</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-upload-part.html">Upload Part </a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     *
     * @param uploadMultipartPartRequest
     *        Provides options to upload a part of an archive in a multipart upload operation.
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows '
     *        <p>
     *        The data to upload.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadMultipartPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>RequestTimeoutException Returned if, when uploading an archive, Amazon S3 Glacier times out while
     *         receiving the upload.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.UploadMultipartPart
     */
    default CompletableFuture<UploadMultipartPartResponse> uploadMultipartPart(
            UploadMultipartPartRequest uploadMultipartPartRequest, Path sourcePath) {
        return uploadMultipartPart(uploadMultipartPartRequest, AsyncRequestBody.fromFile(sourcePath));
    }

    /**
     * <p>
     * This operation uploads a part of an archive. You can upload archive parts in any order. You can also upload them
     * in parallel. You can upload up to 10,000 parts for a multipart upload.
     * </p>
     * <p>
     * Amazon Glacier rejects your upload part request if any of the following conditions is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SHA256 tree hash does not match</b>To ensure that part data is not corrupted in transmission, you compute a
     * SHA256 tree hash of the part and include it in your request. Upon receiving the part data, Amazon S3 Glacier also
     * computes a SHA256 tree hash. If these hash values don't match, the operation fails. For information about
     * computing a SHA256 tree hash, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing Checksums</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Part size does not match</b>The size of each part except the last must match the size specified in the
     * corresponding <a>InitiateMultipartUpload</a> request. The size of the last part must be the same size as, or
     * smaller than, the specified size.
     * </p>
     * <note>
     * <p>
     * If you upload a part whose size is smaller than the part size you specified in your initiate multipart upload
     * request and that part is not the last part, then the upload part request will succeed. However, the subsequent
     * Complete Multipart Upload request will fail.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b>Range does not align</b>The byte range value in the request does not align with the part size specified in the
     * corresponding initiate request. For example, if you specify a part size of 4194304 bytes (4 MB), then 0 to
     * 4194303 bytes (4 MB - 1) and 4194304 (4 MB) to 8388607 (8 MB - 1) are valid part ranges. However, if you set a
     * range value of 2 MB to 6 MB, the range does not align with the part size and the upload will fail.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent. If you upload the same part multiple times, the data included in the most recent
     * request overwrites the previously uploaded data.
     * </p>
     * <p>
     * An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access
     * Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform
     * specific actions. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control
     * Using AWS Identity and Access Management (IAM)</a>.
     * </p>
     * <p>
     * For conceptual information and underlying REST API, see <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html">Uploading Large Archives
     * in Parts (Multipart Upload)</a> and <a
     * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-upload-part.html">Upload Part </a> in the
     * <i>Amazon Glacier Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadMultipartPartRequest.Builder} avoiding the
     * need to create one manually via {@link UploadMultipartPartRequest#builder()}
     * </p>
     *
     * @param uploadMultipartPartRequest
     *        A {@link Consumer} that will call methods on {@link UploadMultipartPartInput.Builder} to create a request.
     *        Provides options to upload a part of an archive in a multipart upload operation.
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows '
     *        <p>
     *        The data to upload.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadMultipartPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned if the specified resource (such as a vault, upload ID, or job ID)
     *         doesn't exist.</li>
     *         <li>InvalidParameterValueException Returned if a parameter of the request is incorrectly specified.</li>
     *         <li>MissingParameterValueException Returned if a required header or parameter is missing from the
     *         request.</li>
     *         <li>RequestTimeoutException Returned if, when uploading an archive, Amazon S3 Glacier times out while
     *         receiving the upload.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlacierException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GlacierAsyncClient.UploadMultipartPart
     */
    default CompletableFuture<UploadMultipartPartResponse> uploadMultipartPart(
            Consumer<UploadMultipartPartRequest.Builder> uploadMultipartPartRequest, Path sourcePath) {
        return uploadMultipartPart(UploadMultipartPartRequest.builder().applyMutation(uploadMultipartPartRequest).build(),
                sourcePath);
    }

    /**
     * Create an instance of {@link GlacierAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link GlacierAsyncWaiter}
     */
    default GlacierAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default GlacierServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link GlacierAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GlacierAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GlacierAsyncClient}.
     */
    static GlacierAsyncClientBuilder builder() {
        return new DefaultGlacierAsyncClientBuilder();
    }
}
