/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides options for retrieving a job list for an Amazon S3 Glacier vault.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsRequest extends GlacierRequest implements ToCopyableBuilder<ListJobsRequest.Builder, ListJobsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("accountId")
            .getter(getter(ListJobsRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build(),
                    DefaultValueTrait.create(DefaultAccountIdSupplier.getInstance())).build();

    private static final SdkField<String> VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vaultName").getter(getter(ListJobsRequest::vaultName)).setter(setter(Builder::vaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("vaultName").build()).build();

    private static final SdkField<String> LIMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("limit")
            .getter(getter(ListJobsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("marker")
            .getter(getter(ListJobsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()).build();

    private static final SdkField<String> STATUSCODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statuscode").getter(getter(ListJobsRequest::statuscode)).setter(setter(Builder::statuscode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("statuscode").build()).build();

    private static final SdkField<String> COMPLETED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("completed").getter(getter(ListJobsRequest::completed)).setter(setter(Builder::completed))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("completed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            VAULT_NAME_FIELD, LIMIT_FIELD, MARKER_FIELD, STATUSCODE_FIELD, COMPLETED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String vaultName;

    private final String limit;

    private final String marker;

    private final String statuscode;

    private final String completed;

    private ListJobsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.statuscode = builder.statuscode;
        this.completed = builder.completed;
    }

    /**
     * <p>
     * The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify
     * an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3 Glacier uses the AWS
     * account ID associated with the credentials used to sign the request. If you use an account ID, do not include any
     * hyphens ('-') in the ID.
     * </p>
     * 
     * @return The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either
     *         specify an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3
     *         Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an
     *         account ID, do not include any hyphens ('-') in the ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the vault.
     * </p>
     * 
     * @return The name of the vault.
     */
    public final String vaultName() {
        return vaultName;
    }

    /**
     * <p>
     * The maximum number of jobs to be returned. The default limit is 50. The number of jobs returned might be fewer
     * than the specified limit, but the number of returned jobs never exceeds the limit.
     * </p>
     * 
     * @return The maximum number of jobs to be returned. The default limit is 50. The number of jobs returned might be
     *         fewer than the specified limit, but the number of returned jobs never exceeds the limit.
     */
    public final String limit() {
        return limit;
    }

    /**
     * <p>
     * An opaque string used for pagination. This value specifies the job at which the listing of jobs should begin. Get
     * the marker value from a previous List Jobs response. You only need to include the marker if you are continuing
     * the pagination of results started in a previous List Jobs request.
     * </p>
     * 
     * @return An opaque string used for pagination. This value specifies the job at which the listing of jobs should
     *         begin. Get the marker value from a previous List Jobs response. You only need to include the marker if
     *         you are continuing the pagination of results started in a previous List Jobs request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The type of job status to return. You can specify the following values: <code>InProgress</code>,
     * <code>Succeeded</code>, or <code>Failed</code>.
     * </p>
     * 
     * @return The type of job status to return. You can specify the following values: <code>InProgress</code>,
     *         <code>Succeeded</code>, or <code>Failed</code>.
     */
    public final String statuscode() {
        return statuscode;
    }

    /**
     * <p>
     * The state of the jobs to return. You can specify <code>true</code> or <code>false</code>.
     * </p>
     * 
     * @return The state of the jobs to return. You can specify <code>true</code> or <code>false</code>.
     */
    public final String completed() {
        return completed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(statuscode());
        hashCode = 31 * hashCode + Objects.hashCode(completed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(vaultName(), other.vaultName())
                && Objects.equals(limit(), other.limit()) && Objects.equals(marker(), other.marker())
                && Objects.equals(statuscode(), other.statuscode()) && Objects.equals(completed(), other.completed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobsRequest").add("AccountId", accountId()).add("VaultName", vaultName())
                .add("Limit", limit()).add("Marker", marker()).add("Statuscode", statuscode()).add("Completed", completed())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "vaultName":
            return Optional.ofNullable(clazz.cast(vaultName()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "statuscode":
            return Optional.ofNullable(clazz.cast(statuscode()));
        case "completed":
            return Optional.ofNullable(clazz.cast(completed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("vaultName", VAULT_NAME_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("marker", MARKER_FIELD);
        map.put("statuscode", STATUSCODE_FIELD);
        map.put("completed", COMPLETED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListJobsRequest, T> g) {
        return obj -> g.apply((ListJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListJobsRequest> {
        /**
         * <p>
         * The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either
         * specify an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3 Glacier
         * uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID,
         * do not include any hyphens ('-') in the ID.
         * </p>
         * 
         * @param accountId
         *        The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can
         *        either specify an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case
         *        Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If
         *        you use an account ID, do not include any hyphens ('-') in the ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the vault.
         * </p>
         * 
         * @param vaultName
         *        The name of the vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultName(String vaultName);

        /**
         * <p>
         * The maximum number of jobs to be returned. The default limit is 50. The number of jobs returned might be
         * fewer than the specified limit, but the number of returned jobs never exceeds the limit.
         * </p>
         * 
         * @param limit
         *        The maximum number of jobs to be returned. The default limit is 50. The number of jobs returned might
         *        be fewer than the specified limit, but the number of returned jobs never exceeds the limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(String limit);

        /**
         * <p>
         * An opaque string used for pagination. This value specifies the job at which the listing of jobs should begin.
         * Get the marker value from a previous List Jobs response. You only need to include the marker if you are
         * continuing the pagination of results started in a previous List Jobs request.
         * </p>
         * 
         * @param marker
         *        An opaque string used for pagination. This value specifies the job at which the listing of jobs should
         *        begin. Get the marker value from a previous List Jobs response. You only need to include the marker if
         *        you are continuing the pagination of results started in a previous List Jobs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The type of job status to return. You can specify the following values: <code>InProgress</code>,
         * <code>Succeeded</code>, or <code>Failed</code>.
         * </p>
         * 
         * @param statuscode
         *        The type of job status to return. You can specify the following values: <code>InProgress</code>,
         *        <code>Succeeded</code>, or <code>Failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuscode(String statuscode);

        /**
         * <p>
         * The state of the jobs to return. You can specify <code>true</code> or <code>false</code>.
         * </p>
         * 
         * @param completed
         *        The state of the jobs to return. You can specify <code>true</code> or <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completed(String completed);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlacierRequest.BuilderImpl implements Builder {
        private String accountId;

        private String vaultName;

        private String limit;

        private String marker;

        private String statuscode;

        private String completed;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsRequest model) {
            super(model);
            accountId(model.accountId);
            vaultName(model.vaultName);
            limit(model.limit);
            marker(model.marker);
            statuscode(model.statuscode);
            completed(model.completed);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getVaultName() {
            return vaultName;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final String getLimit() {
            return limit;
        }

        public final void setLimit(String limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(String limit) {
            this.limit = limit;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getStatuscode() {
            return statuscode;
        }

        public final void setStatuscode(String statuscode) {
            this.statuscode = statuscode;
        }

        @Override
        public final Builder statuscode(String statuscode) {
            this.statuscode = statuscode;
            return this;
        }

        public final String getCompleted() {
            return completed;
        }

        public final void setCompleted(String completed) {
            this.completed = completed;
        }

        @Override
        public final Builder completed(String completed) {
            this.completed = completed;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobsRequest build() {
            return new ListJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
