/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.UploadListElement;
import software.amazon.awssdk.services.glacier.model.UploadsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMultipartUploadsResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, ListMultipartUploadsResponse> {
    private static final SdkField<List<UploadListElement>> UPLOADS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UploadsList").getter(ListMultipartUploadsResponse.getter(ListMultipartUploadsResponse::uploadsList)).setter(ListMultipartUploadsResponse.setter(Builder::uploadsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UploadListElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListMultipartUploadsResponse.getter(ListMultipartUploadsResponse::marker)).setter(ListMultipartUploadsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOADS_LIST_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMultipartUploadsResponse.memberNameToFieldInitializer();
    private final List<UploadListElement> uploadsList;
    private final String marker;

    private ListMultipartUploadsResponse(BuilderImpl builder) {
        super(builder);
        this.uploadsList = builder.uploadsList;
        this.marker = builder.marker;
    }

    public final boolean hasUploadsList() {
        return this.uploadsList != null && !(this.uploadsList instanceof SdkAutoConstructList);
    }

    public final List<UploadListElement> uploadsList() {
        return this.uploadsList;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUploadsList() ? this.uploadsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsResponse)) {
            return false;
        }
        ListMultipartUploadsResponse other = (ListMultipartUploadsResponse)((Object)obj);
        return this.hasUploadsList() == other.hasUploadsList() && Objects.equals(this.uploadsList(), other.uploadsList()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListMultipartUploadsResponse").add("UploadsList", this.hasUploadsList() ? this.uploadsList() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UploadsList": {
                return Optional.ofNullable(clazz.cast(this.uploadsList()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UploadsList", UPLOADS_LIST_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMultipartUploadsResponse, T> g) {
        return obj -> g.apply((ListMultipartUploadsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private List<UploadListElement> uploadsList = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultipartUploadsResponse model) {
            super(model);
            this.uploadsList(model.uploadsList);
            this.marker(model.marker);
        }

        public final List<UploadListElement.Builder> getUploadsList() {
            List<UploadListElement.Builder> result = UploadsListCopier.copyToBuilder(this.uploadsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUploadsList(Collection<UploadListElement.BuilderImpl> uploadsList) {
            this.uploadsList = UploadsListCopier.copyFromBuilder(uploadsList);
        }

        @Override
        public final Builder uploadsList(Collection<UploadListElement> uploadsList) {
            this.uploadsList = UploadsListCopier.copy(uploadsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadsList(UploadListElement ... uploadsList) {
            this.uploadsList(Arrays.asList(uploadsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadsList(Consumer<UploadListElement.Builder> ... uploadsList) {
            this.uploadsList(Stream.of(uploadsList).map(c -> (UploadListElement)((UploadListElement.Builder)UploadListElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListMultipartUploadsResponse build() {
            return new ListMultipartUploadsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMultipartUploadsResponse> {
        public Builder uploadsList(Collection<UploadListElement> var1);

        public Builder uploadsList(UploadListElement ... var1);

        public Builder uploadsList(Consumer<UploadListElement.Builder> ... var1);

        public Builder marker(String var1);
    }
}

