/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointConfigurationsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEndpointGroupRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, UpdateEndpointGroupRequest> {
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateEndpointGroupRequest.getter(UpdateEndpointGroupRequest::endpointGroupArn)).setter(UpdateEndpointGroupRequest.setter(Builder::endpointGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()}).build();
    private static final SdkField<List<EndpointConfiguration>> ENDPOINT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateEndpointGroupRequest.getter(UpdateEndpointGroupRequest::endpointConfigurations)).setter(UpdateEndpointGroupRequest.setter(Builder::endpointConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> TRAFFIC_DIAL_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(UpdateEndpointGroupRequest.getter(UpdateEndpointGroupRequest::trafficDialPercentage)).setter(UpdateEndpointGroupRequest.setter(Builder::trafficDialPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDialPercentage").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateEndpointGroupRequest.getter(UpdateEndpointGroupRequest::healthCheckPort)).setter(UpdateEndpointGroupRequest.setter(Builder::healthCheckPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPort").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateEndpointGroupRequest.getter(UpdateEndpointGroupRequest::healthCheckProtocolAsString)).setter(UpdateEndpointGroupRequest.setter(Builder::healthCheckProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckProtocol").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateEndpointGroupRequest.getter(UpdateEndpointGroupRequest::healthCheckPath)).setter(UpdateEndpointGroupRequest.setter(Builder::healthCheckPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPath").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateEndpointGroupRequest.getter(UpdateEndpointGroupRequest::healthCheckIntervalSeconds)).setter(UpdateEndpointGroupRequest.setter(Builder::healthCheckIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckIntervalSeconds").build()}).build();
    private static final SdkField<Integer> THRESHOLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateEndpointGroupRequest.getter(UpdateEndpointGroupRequest::thresholdCount)).setter(UpdateEndpointGroupRequest.setter(Builder::thresholdCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUP_ARN_FIELD, ENDPOINT_CONFIGURATIONS_FIELD, TRAFFIC_DIAL_PERCENTAGE_FIELD, HEALTH_CHECK_PORT_FIELD, HEALTH_CHECK_PROTOCOL_FIELD, HEALTH_CHECK_PATH_FIELD, HEALTH_CHECK_INTERVAL_SECONDS_FIELD, THRESHOLD_COUNT_FIELD));
    private final String endpointGroupArn;
    private final List<EndpointConfiguration> endpointConfigurations;
    private final Float trafficDialPercentage;
    private final Integer healthCheckPort;
    private final String healthCheckProtocol;
    private final String healthCheckPath;
    private final Integer healthCheckIntervalSeconds;
    private final Integer thresholdCount;

    private UpdateEndpointGroupRequest(BuilderImpl builder) {
        super(builder);
        this.endpointGroupArn = builder.endpointGroupArn;
        this.endpointConfigurations = builder.endpointConfigurations;
        this.trafficDialPercentage = builder.trafficDialPercentage;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPath = builder.healthCheckPath;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.thresholdCount = builder.thresholdCount;
    }

    public String endpointGroupArn() {
        return this.endpointGroupArn;
    }

    public List<EndpointConfiguration> endpointConfigurations() {
        return this.endpointConfigurations;
    }

    public Float trafficDialPercentage() {
        return this.trafficDialPercentage;
    }

    public Integer healthCheckPort() {
        return this.healthCheckPort;
    }

    public HealthCheckProtocol healthCheckProtocol() {
        return HealthCheckProtocol.fromValue(this.healthCheckProtocol);
    }

    public String healthCheckProtocolAsString() {
        return this.healthCheckProtocol;
    }

    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    public Integer healthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public Integer thresholdCount() {
        return this.thresholdCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficDialPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointGroupRequest)) {
            return false;
        }
        UpdateEndpointGroupRequest other = (UpdateEndpointGroupRequest)((Object)obj);
        return Objects.equals(this.endpointGroupArn(), other.endpointGroupArn()) && Objects.equals(this.endpointConfigurations(), other.endpointConfigurations()) && Objects.equals(this.trafficDialPercentage(), other.trafficDialPercentage()) && Objects.equals(this.healthCheckPort(), other.healthCheckPort()) && Objects.equals(this.healthCheckProtocolAsString(), other.healthCheckProtocolAsString()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds()) && Objects.equals(this.thresholdCount(), other.thresholdCount());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEndpointGroupRequest").add("EndpointGroupArn", (Object)this.endpointGroupArn()).add("EndpointConfigurations", this.endpointConfigurations()).add("TrafficDialPercentage", (Object)this.trafficDialPercentage()).add("HealthCheckPort", (Object)this.healthCheckPort()).add("HealthCheckProtocol", (Object)this.healthCheckProtocolAsString()).add("HealthCheckPath", (Object)this.healthCheckPath()).add("HealthCheckIntervalSeconds", (Object)this.healthCheckIntervalSeconds()).add("ThresholdCount", (Object)this.thresholdCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointGroupArn": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupArn()));
            }
            case "EndpointConfigurations": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigurations()));
            }
            case "TrafficDialPercentage": {
                return Optional.ofNullable(clazz.cast(this.trafficDialPercentage()));
            }
            case "HealthCheckPort": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPort()));
            }
            case "HealthCheckProtocol": {
                return Optional.ofNullable(clazz.cast(this.healthCheckProtocolAsString()));
            }
            case "HealthCheckPath": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPath()));
            }
            case "HealthCheckIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckIntervalSeconds()));
            }
            case "ThresholdCount": {
                return Optional.ofNullable(clazz.cast(this.thresholdCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointGroupRequest, T> g) {
        return obj -> g.apply((UpdateEndpointGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private String endpointGroupArn;
        private List<EndpointConfiguration> endpointConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Float trafficDialPercentage;
        private Integer healthCheckPort;
        private String healthCheckProtocol;
        private String healthCheckPath;
        private Integer healthCheckIntervalSeconds;
        private Integer thresholdCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointGroupRequest model) {
            super(model);
            this.endpointGroupArn(model.endpointGroupArn);
            this.endpointConfigurations(model.endpointConfigurations);
            this.trafficDialPercentage(model.trafficDialPercentage);
            this.healthCheckPort(model.healthCheckPort);
            this.healthCheckProtocol(model.healthCheckProtocol);
            this.healthCheckPath(model.healthCheckPath);
            this.healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            this.thresholdCount(model.thresholdCount);
        }

        public final String getEndpointGroupArn() {
            return this.endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        public final Collection<EndpointConfiguration.Builder> getEndpointConfigurations() {
            return this.endpointConfigurations != null ? (Collection)this.endpointConfigurations.stream().map(EndpointConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpointConfigurations(Collection<EndpointConfiguration> endpointConfigurations) {
            this.endpointConfigurations = EndpointConfigurationsCopier.copy(endpointConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigurations(EndpointConfiguration ... endpointConfigurations) {
            this.endpointConfigurations(Arrays.asList(endpointConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigurations(Consumer<EndpointConfiguration.Builder> ... endpointConfigurations) {
            this.endpointConfigurations(Stream.of(endpointConfigurations).map(c -> (EndpointConfiguration)((EndpointConfiguration.Builder)EndpointConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointConfigurations(Collection<EndpointConfiguration.BuilderImpl> endpointConfigurations) {
            this.endpointConfigurations = EndpointConfigurationsCopier.copyFromBuilder(endpointConfigurations);
        }

        public final Float getTrafficDialPercentage() {
            return this.trafficDialPercentage;
        }

        @Override
        public final Builder trafficDialPercentage(Float trafficDialPercentage) {
            this.trafficDialPercentage = trafficDialPercentage;
            return this;
        }

        public final void setTrafficDialPercentage(Float trafficDialPercentage) {
            this.trafficDialPercentage = trafficDialPercentage;
        }

        public final Integer getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(Integer healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(Integer healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final String getHealthCheckProtocolAsString() {
            return this.healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(HealthCheckProtocol healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol == null ? null : healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getThresholdCount() {
            return this.thresholdCount;
        }

        @Override
        public final Builder thresholdCount(Integer thresholdCount) {
            this.thresholdCount = thresholdCount;
            return this;
        }

        public final void setThresholdCount(Integer thresholdCount) {
            this.thresholdCount = thresholdCount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointGroupRequest build() {
            return new UpdateEndpointGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEndpointGroupRequest> {
        public Builder endpointGroupArn(String var1);

        public Builder endpointConfigurations(Collection<EndpointConfiguration> var1);

        public Builder endpointConfigurations(EndpointConfiguration ... var1);

        public Builder endpointConfigurations(Consumer<EndpointConfiguration.Builder> ... var1);

        public Builder trafficDialPercentage(Float var1);

        public Builder healthCheckPort(Integer var1);

        public Builder healthCheckProtocol(String var1);

        public Builder healthCheckProtocol(HealthCheckProtocol var1);

        public Builder healthCheckPath(String var1);

        public Builder healthCheckIntervalSeconds(Integer var1);

        public Builder thresholdCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

